import { Construct } from "constructs";
export interface TerraformAssetConfig {
    readonly path: string;
    readonly type?: AssetType;
    readonly assetHash?: string;
}
export declare enum AssetType {
    FILE = 0,
    DIRECTORY = 1,
    ARCHIVE = 2
}
export declare class TerraformAsset extends Construct {
    private stack;
    private sourcePath;
    assetHash: string;
    type: AssetType;
    /**
     * A Terraform Asset takes a file or directory outside of the CDK for Terraform context and moves it into it.
     * Assets copy referenced files into the stacks context for further usage in other resources.
     * @param scope
     * @param id
     * @param config
     */
    constructor(scope: Construct, id: string, config: TerraformAssetConfig);
    private get namedFolder();
    /**
     * The path relative to the root of the terraform directory in posix format
     * Use this property to reference the asset
     */
    get path(): string;
    /**
     * Name of the asset
     */
    get fileName(): string;
    private _onSynthesize;
}
