import { Construct } from "constructs";
import { TerraformRemoteState } from "./terraform-remote-state";
import { TerraformElement } from "./terraform-element";
export declare abstract class TerraformBackend extends TerraformElement {
    protected readonly name: string;
    constructor(scope: Construct, id: string, name: string);
    static isBackend(x: any): x is TerraformBackend;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    /**
     * Creates a TerraformRemoteState resource that accesses this backend.
     */
    abstract getRemoteStateDataSource(scope: Construct, name: string, fromStack: string): TerraformRemoteState;
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform(): any;
    toMetadata(): any;
}
