"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const BACKEND_SYMBOL = Symbol.for("cdktf/TerraformBackend");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformBackend extends terraform_element_1.TerraformElement {
    constructor(scope, id, name) {
        super(scope, id);
        this.name = name;
        Object.defineProperty(this, BACKEND_SYMBOL, { value: true });
    }
    static isBackend(x) {
        return x !== null && typeof x === "object" && BACKEND_SYMBOL in x;
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        return {
            terraform: {
                backend: {
                    [this.name]: (0, util_1.deepMerge)(this.synthesizeAttributes(), this.rawOverrides),
                },
            },
        };
    }
    toMetadata() {
        return {
            backend: this.name,
            ...(Object.keys(this.rawOverrides).length > 0
                ? { overrides: { backend: Object.keys(this.rawOverrides) } }
                : {}),
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
TerraformBackend[_a] = { fqn: "cdktf.TerraformBackend", version: "0.17.0-pre.18" };
exports.TerraformBackend = TerraformBackend;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVycmFmb3JtLWJhY2tlbmQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXJyYWZvcm0tYmFja2VuZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUlBLDJEQUF1RDtBQUN2RCxpQ0FBbUM7QUFFbkMsTUFBTSxjQUFjLEdBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0FBRTVELCtDQUErQztBQUMvQyxNQUFzQixnQkFBaUIsU0FBUSxvQ0FBZ0I7SUFDN0QsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBcUIsSUFBWTtRQUN2RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRDBDLFNBQUksR0FBSixJQUFJLENBQVE7UUFFdkUsTUFBTSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFLEVBQUUsS0FBSyxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7SUFDL0QsQ0FBQztJQUVNLE1BQU0sQ0FBQyxTQUFTLENBQUMsQ0FBTTtRQUM1QixPQUFPLENBQUMsS0FBSyxJQUFJLElBQUksT0FBTyxDQUFDLEtBQUssUUFBUSxJQUFJLGNBQWMsSUFBSSxDQUFDLENBQUM7SUFDcEUsQ0FBQztJQUVELHNDQUFzQztJQUM1QixvQkFBb0I7UUFDNUIsT0FBTyxFQUFFLENBQUM7SUFDWixDQUFDO0lBV0Q7O09BRUc7SUFDSSxXQUFXO1FBQ2hCLE9BQU87WUFDTCxTQUFTLEVBQUU7Z0JBQ1QsT0FBTyxFQUFFO29CQUNQLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUEsZ0JBQVMsRUFDcEIsSUFBSSxDQUFDLG9CQUFvQixFQUFFLEVBQzNCLElBQUksQ0FBQyxZQUFZLENBQ2xCO2lCQUNGO2FBQ0Y7U0FDRixDQUFDO0lBQ0osQ0FBQztJQUVNLFVBQVU7UUFDZixPQUFPO1lBQ0wsT0FBTyxFQUFFLElBQUksQ0FBQyxJQUFJO1lBQ2xCLEdBQUcsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQyxNQUFNLEdBQUcsQ0FBQztnQkFDM0MsQ0FBQyxDQUFDLEVBQUUsU0FBUyxFQUFFLEVBQUUsT0FBTyxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLEVBQUU7Z0JBQzVELENBQUMsQ0FBQyxFQUFFLENBQUM7U0FDUixDQUFDO0lBQ0osQ0FBQzs7OztBQS9DbUIsNENBQWdCIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluY1xuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1QTC0yLjBcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBUZXJyYWZvcm1SZW1vdGVTdGF0ZSB9IGZyb20gXCIuL3RlcnJhZm9ybS1yZW1vdGUtc3RhdGVcIjtcbmltcG9ydCB7IFRlcnJhZm9ybUVsZW1lbnQgfSBmcm9tIFwiLi90ZXJyYWZvcm0tZWxlbWVudFwiO1xuaW1wb3J0IHsgZGVlcE1lcmdlIH0gZnJvbSBcIi4vdXRpbFwiO1xuXG5jb25zdCBCQUNLRU5EX1NZTUJPTCA9IFN5bWJvbC5mb3IoXCJjZGt0Zi9UZXJyYWZvcm1CYWNrZW5kXCIpO1xuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUganNkb2MvcmVxdWlyZS1qc2RvY1xuZXhwb3J0IGFic3RyYWN0IGNsYXNzIFRlcnJhZm9ybUJhY2tlbmQgZXh0ZW5kcyBUZXJyYWZvcm1FbGVtZW50IHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvdGVjdGVkIHJlYWRvbmx5IG5hbWU6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG4gICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KHRoaXMsIEJBQ0tFTkRfU1lNQk9MLCB7IHZhbHVlOiB0cnVlIH0pO1xuICB9XG5cbiAgcHVibGljIHN0YXRpYyBpc0JhY2tlbmQoeDogYW55KTogeCBpcyBUZXJyYWZvcm1CYWNrZW5kIHtcbiAgICByZXR1cm4geCAhPT0gbnVsbCAmJiB0eXBlb2YgeCA9PT0gXCJvYmplY3RcIiAmJiBCQUNLRU5EX1NZTUJPTCBpbiB4O1xuICB9XG5cbiAgLy8ganNpaSBjYW4ndCBoYW5kbGUgYWJzdHJhY3QgY2xhc3Nlcz9cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge307XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBhIFRlcnJhZm9ybVJlbW90ZVN0YXRlIHJlc291cmNlIHRoYXQgYWNjZXNzZXMgdGhpcyBiYWNrZW5kLlxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IGdldFJlbW90ZVN0YXRlRGF0YVNvdXJjZShcbiAgICBzY29wZTogQ29uc3RydWN0LFxuICAgIG5hbWU6IHN0cmluZyxcbiAgICBmcm9tU3RhY2s6IHN0cmluZ1xuICApOiBUZXJyYWZvcm1SZW1vdGVTdGF0ZTtcblxuICAvKipcbiAgICogQWRkcyB0aGlzIHJlc291cmNlIHRvIHRoZSB0ZXJyYWZvcm0gSlNPTiBvdXRwdXQuXG4gICAqL1xuICBwdWJsaWMgdG9UZXJyYWZvcm0oKTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgdGVycmFmb3JtOiB7XG4gICAgICAgIGJhY2tlbmQ6IHtcbiAgICAgICAgICBbdGhpcy5uYW1lXTogZGVlcE1lcmdlKFxuICAgICAgICAgICAgdGhpcy5zeW50aGVzaXplQXR0cmlidXRlcygpLFxuICAgICAgICAgICAgdGhpcy5yYXdPdmVycmlkZXNcbiAgICAgICAgICApLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9O1xuICB9XG5cbiAgcHVibGljIHRvTWV0YWRhdGEoKTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgYmFja2VuZDogdGhpcy5uYW1lLFxuICAgICAgLi4uKE9iamVjdC5rZXlzKHRoaXMucmF3T3ZlcnJpZGVzKS5sZW5ndGggPiAwXG4gICAgICAgID8geyBvdmVycmlkZXM6IHsgYmFja2VuZDogT2JqZWN0LmtleXModGhpcy5yYXdPdmVycmlkZXMpIH0gfVxuICAgICAgICA6IHt9KSxcbiAgICB9O1xuICB9XG59XG4iXX0=