"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformCount = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const tfExpression_1 = require("./tfExpression");
const tokens_1 = require("./tokens");
const COUNT_SYMBOL = Symbol.for("cdktf/TerraformCount");
/**
 * Iterator for the Terraform count property
 */
class TerraformCount {
    static of(count) {
        return new TerraformCount(count);
    }
    static isTerraformCount(x) {
        return x !== null && typeof x === "object" && COUNT_SYMBOL in x;
    }
    constructor(count) {
        this.count = count;
        Object.defineProperty(this, COUNT_SYMBOL, { value: true });
    }
    get index() {
        return tokens_1.Token.asNumber((0, tfExpression_1.ref)("count.index"));
    }
    toTerraform() {
        return this.count;
    }
    toString() {
        return this.count.toString();
    }
}
_a = JSII_RTTI_SYMBOL_1;
TerraformCount[_a] = { fqn: "cdktf.TerraformCount", version: "0.17.0-pre.18" };
exports.TerraformCount = TerraformCount;
//# sourceMappingURL=data:application/json;base64,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