"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformDataSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const tfExpression_1 = require("./tfExpression");
const terraform_count_1 = require("./terraform-count");
const assert = require("assert");
const TERRAFORM_DATA_SOURCE_SYMBOL = Symbol.for("cdktf/TerraformDataSource");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformDataSource extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id, `data.${config.terraformResourceType}`);
        Object.defineProperty(this, TERRAFORM_DATA_SOURCE_SYMBOL, { value: true });
        this.terraformResourceType = config.terraformResourceType;
        this.terraformGeneratorMetadata = config.terraformGeneratorMetadata;
        if (Array.isArray(config.dependsOn)) {
            this.dependsOn = config.dependsOn.map((dependency) => (0, tfExpression_1.dependable)(dependency));
        }
        this.count = config.count;
        this.provider = config.provider;
        this.lifecycle = config.lifecycle;
        this.forEach = config.forEach;
    }
    static isTerraformDataSource(x) {
        return (x !== null && typeof x === "object" && TERRAFORM_DATA_SOURCE_SYMBOL in x);
    }
    getStringAttribute(terraformAttribute) {
        return tokens_1.Token.asString(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberAttribute(terraformAttribute) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(terraformAttribute));
    }
    getListAttribute(terraformAttribute) {
        return tokens_1.Token.asList(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanAttribute(terraformAttribute) {
        return this.interpolationForAttribute(terraformAttribute);
    }
    getNumberListAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberList(this.interpolationForAttribute(terraformAttribute));
    }
    getStringMapAttribute(terraformAttribute) {
        return tokens_1.Token.asStringMap(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberMapAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberMap(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanMapAttribute(terraformAttribute) {
        return tokens_1.Token.asBooleanMap(this.interpolationForAttribute(terraformAttribute));
    }
    getAnyMapAttribute(terraformAttribute) {
        return tokens_1.Token.asAnyMap(this.interpolationForAttribute(terraformAttribute));
    }
    get terraformMetaArguments() {
        assert(!this.forEach || typeof this.count === "undefined", `forEach and count are both set, but they are mutually exclusive. You can only use either of them. Check the data source at path: ${this.node.path}`);
        return {
            dependsOn: this.dependsOn,
            count: terraform_count_1.TerraformCount.isTerraformCount(this.count)
                ? this.count.toTerraform()
                : this.count,
            provider: this.provider?.fqn,
            lifecycle: this.lifecycle,
            forEach: this.forEach?._getForEachExpression(),
        };
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        const attributes = (0, util_1.deepMerge)((0, util_1.processDynamicAttributes)(this.synthesizeAttributes()), (0, util_1.keysToSnakeCase)(this.terraformMetaArguments), this.rawOverrides);
        attributes["//"] = this.constructNodeMetadata;
        return {
            data: {
                [this.terraformResourceType]: {
                    [this.friendlyUniqueId]: attributes,
                },
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [this.terraformResourceType]: Object.keys(this.rawOverrides),
            },
        };
    }
    interpolationForAttribute(terraformAttribute) {
        return (0, tfExpression_1.ref)(`data.${this.terraformResourceType}.${this.friendlyUniqueId}${this.forEach ? ".*" : ""}.${terraformAttribute}`, this.cdktfStack);
    }
}
_a = JSII_RTTI_SYMBOL_1;
TerraformDataSource[_a] = { fqn: "cdktf.TerraformDataSource", version: "0.17.0-pre.18" };
exports.TerraformDataSource = TerraformDataSource;
//# sourceMappingURL=data:application/json;base64,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