"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformElement = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const assert_1 = require("assert");
const constructs_1 = require("constructs");
const _1 = require(".");
const terraform_stack_1 = require("./terraform-stack");
const tfExpression_1 = require("./tfExpression");
const TERRAFORM_ELEMENT_SYMBOL = Symbol.for("cdktf/TerraformElement");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformElement extends constructs_1.Construct {
    constructor(scope, id, elementType) {
        super(scope, id);
        this.rawOverrides = {};
        Object.defineProperty(this, TERRAFORM_ELEMENT_SYMBOL, { value: true });
        this._elementType = elementType;
        if (_1.Token.isUnresolved(id)) {
            throw new Error("You cannot use a Token (e.g. a reference to an attribute) as the id of a construct");
        }
        this.node.addMetadata("stacktrace", "trace");
    }
    get cdktfStack() {
        return terraform_stack_1.TerraformStack.of(this);
    }
    static isTerraformElement(x) {
        return x !== null && typeof x === "object" && TERRAFORM_ELEMENT_SYMBOL in x;
    }
    toTerraform() {
        return {};
    }
    toMetadata() {
        return {};
    }
    get fqn() {
        if (!this._fqnToken) {
            (0, assert_1.ok)(!!this._elementType, "Element type not set");
            this._fqnToken = _1.Token.asString((0, tfExpression_1.ref)(`${this._elementType}.${this.friendlyUniqueId}`, this.cdktfStack));
        }
        return this._fqnToken;
    }
    get friendlyUniqueId() {
        if (!this._friendlyUniqueId) {
            if (this._logicalIdOverride) {
                this._friendlyUniqueId = this._logicalIdOverride;
            }
            else {
                this._friendlyUniqueId = this.cdktfStack.getLogicalId(this);
            }
        }
        return this._friendlyUniqueId;
    }
    /**
     * Overrides the auto-generated logical ID with a specific ID.
     * @param newLogicalId The new logical ID to use for this stack element.
     */
    overrideLogicalId(newLogicalId) {
        (0, assert_1.ok)(!this._fqnToken, "Logical ID may not be overridden once .fqn has been requested. Make sure to override the id before passing the construct to other constructs.");
        this._logicalIdOverride = newLogicalId;
    }
    /**
     * Resets a previously passed logical Id to use the auto-generated logical id again
     */
    resetOverrideLogicalId() {
        (0, assert_1.ok)(!this._fqnToken, "Logical ID may not be overridden once .fqn has been requested. You can only reset the override before you pass the construct to other constructs.");
        this._logicalIdOverride = undefined;
    }
    addOverride(path, value) {
        const parts = path.split(".");
        let curr = this.rawOverrides;
        while (parts.length > 1) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const key = parts.shift();
            // if we can't recurse further or the previous value is not an
            // object overwrite it with an object.
            const isObject = curr[key] != null &&
                typeof curr[key] === "object" &&
                !Array.isArray(curr[key]);
            if (!isObject) {
                curr[key] = {};
            }
            curr = curr[key];
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const lastKey = parts.shift();
        curr[lastKey] = value;
    }
    get constructNodeMetadata() {
        return {
            metadata: {
                path: this.node.path,
                uniqueId: this.friendlyUniqueId,
                stackTrace: this.node.metadata.find((e) => e.type === "stacktrace")
                    ?.trace,
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
TerraformElement[_a] = { fqn: "cdktf.TerraformElement", version: "0.17.0-pre.18" };
exports.TerraformElement = TerraformElement;
//# sourceMappingURL=data:application/json;base64,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