"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Fn = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const _1 = require(".");
const terraform_functions_generated_1 = require("./functions/terraform-functions.generated");
// eslint-disable-next-line jsdoc/require-jsdoc
class Fn extends terraform_functions_generated_1.FnGenerated {
    /**
     * {@link /terraform/docs/language/functions/bcrypt.html bcrypt} computes a hash of the given string using the Blowfish cipher, returning a string in [the _Modular Crypt Format_](https://passlib.readthedocs.io/en/stable/modular_crypt_format.html) usually expected in the shadow password file on many Unix systems.
     * @param {string} str
     * @param {number} [cost]
     */
    static bcrypt(str, cost) {
        // overwritten because bcrypt() only supports a single variadic parameter and not multiple
        // There is currently nothing in the schema that represents this runtime check:
        // https://github.com/hashicorp/terraform/blob/6ab3faf5f65a90ae1e5bd0625fa9e83c0b34c5e1/internal/lang/funcs/crypto.go#L115-L117
        return Fn._bcrypt(str, cost ? [cost] : []);
    }
    /**
     * {@link /terraform/docs/language/functions/lookup.html lookup} retrieves the value of a single element from a map, given its key. If the given key does not exist, the given default value is returned instead.
     * @param {any} inputMap
     * @param {string} key
     * @param {Array<any>} defaultValue
     */
    static lookup(inputMap, key, defaultValue) {
        // overwritten because lookup() uses a variadic argument for its optional defaultValue
        // we don't model it as optional since not passing it is deprecated in favor of the native Terraform expression "inputMap[key]"
        return Fn._lookup(inputMap, key, [defaultValue]);
    }
    /**
     * {@link /terraform/docs/language/functions/join.html join} produces a string by concatenating together all elements of a given list of strings with the given delimiter.
     * @param {string} separator
     * @param {Array<string>} list
     */
    static join(separator, list) {
        // overwritten because join() supports passing multiple lists to it e.g. join(sep, listA, listB)
        // which we can't model as JSII does not support variadic arguments
        return Fn._join(separator, [list]);
    }
    /**
     * {@link /terraform/docs/language/functions/range.html range} generates a list of numbers using a start value, a limit value, and a step value.
     * @param {number} start
     * @param {number} limit
     * @param {number} [step=1]
     */
    static range(start, limit, step = 1) {
        // overwritten because the step param in range() is optional which
        // the Terraform functions schema represents as a single variadic argument
        return Fn._range([start, limit, step]);
    }
    /**
     * Use this function to wrap a string and escape it properly for the use in Terraform
     * This is only needed in certain scenarios (e.g., if you have unescaped double quotes in the string)
     * @param {String} str
     */
    static rawString(str) {
        return _1.Token.asString((0, _1.rawString)(str));
    }
}
_a = JSII_RTTI_SYMBOL_1;
Fn[_a] = { fqn: "cdktf.Fn", version: "0.17.0-pre.18" };
exports.Fn = Fn;
//# sourceMappingURL=data:application/json;base64,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