"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformHclModule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_module_1 = require("./terraform-module");
const tokens_1 = require("./tokens");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformHclModule extends terraform_module_1.TerraformModule {
    constructor(scope, id, options) {
        super(scope, id, options);
        this._variables = options.variables;
    }
    get variables() {
        return this._variables;
    }
    set(variable, value) {
        if (!this._variables) {
            this._variables = {};
        }
        this._variables[variable] = value;
    }
    get(output) {
        return tokens_1.Token.asAny(this.interpolationForOutput(output));
    }
    getNumber(output) {
        return tokens_1.Token.asNumber(this.interpolationForOutput(output));
    }
    getBoolean(output) {
        return this.interpolationForOutput(output);
    }
    getList(output) {
        return tokens_1.Token.asList(this.interpolationForOutput(output));
    }
    synthesizeAttributes() {
        return { ...this.variables };
    }
}
_a = JSII_RTTI_SYMBOL_1;
TerraformHclModule[_a] = { fqn: "cdktf.TerraformHclModule", version: "0.17.0-pre.18" };
exports.TerraformHclModule = TerraformHclModule;
//# sourceMappingURL=data:application/json;base64,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