"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformLocal = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const tokens_1 = require("./tokens");
const tfExpression_1 = require("./tfExpression");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformLocal extends terraform_element_1.TerraformElement {
    constructor(scope, id, expression) {
        super(scope, id, "local");
        this._expression = expression;
    }
    set expression(value) {
        this._expression = value;
    }
    get expression() {
        return tokens_1.Token.asAny(this.interpolation());
    }
    get asString() {
        return tokens_1.Token.asString(this.interpolation());
    }
    get asNumber() {
        return tokens_1.Token.asNumber(this.interpolation());
    }
    get asList() {
        return tokens_1.Token.asList(this.interpolation());
    }
    get asStringMap() {
        return tokens_1.Token.asStringMap(this.interpolation());
    }
    get asNumberMap() {
        return tokens_1.Token.asNumberMap(this.interpolation());
    }
    get asBooleanMap() {
        return tokens_1.Token.asBooleanMap(this.interpolation());
    }
    get asAnyMap() {
        return tokens_1.Token.asAnyMap(this.interpolation());
    }
    get asBoolean() {
        return this.interpolation();
    }
    interpolation() {
        return (0, tfExpression_1.ref)(`local.${this.friendlyUniqueId}`, this.cdktfStack);
    }
    toTerraform() {
        return {
            locals: {
                [this.friendlyUniqueId]: this._expression,
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                local: Object.keys(this.rawOverrides),
            },
        };
    }
    /**
     * @returns a string token referencing the value of this local
     */
    toString() {
        return this.asString;
    }
}
_a = JSII_RTTI_SYMBOL_1;
TerraformLocal[_a] = { fqn: "cdktf.TerraformLocal", version: "0.17.0-pre.18" };
exports.TerraformLocal = TerraformLocal;
//# sourceMappingURL=data:application/json;base64,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