"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformModule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const terraform_provider_1 = require("./terraform-provider");
const util_1 = require("./util");
const tokens_1 = require("./tokens");
const tfExpression_1 = require("./tfExpression");
const terraform_asset_1 = require("./terraform-asset");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformModule extends terraform_element_1.TerraformElement {
    constructor(scope, id, options) {
        super(scope, id, "module");
        this.source = options.source;
        if (!options.skipAssetCreationFromLocalModules) {
            if (options.source.startsWith("./") || options.source.startsWith("../")) {
                // Create an asset for the local module for better TFC support
                const asset = new terraform_asset_1.TerraformAsset(scope, `local-module-${id}`, {
                    path: options.source,
                });
                // Despite being a relative path already, further indicate it as such for Terraform handling
                this.source = `./${asset.path}`;
            }
        }
        this.version = options.version;
        this._providers = options.providers;
        this.validateIfProvidersHaveUniqueKeys();
        if (Array.isArray(options.dependsOn)) {
            this.dependsOn = options.dependsOn.map((dependency) => (0, tfExpression_1.dependable)(dependency));
        }
        this.forEach = options.forEach;
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    interpolationForOutput(moduleOutput) {
        return (0, tfExpression_1.ref)(`module.${this.friendlyUniqueId}${this.forEach ? ".*" : ""}.${moduleOutput}`, this.cdktfStack);
    }
    getString(output) {
        return tokens_1.Token.asString(this.interpolationForOutput(output));
    }
    get providers() {
        return this._providers;
    }
    addProvider(provider) {
        if (!this._providers) {
            this._providers = [];
        }
        this._providers.push(provider);
        this.validateIfProvidersHaveUniqueKeys();
    }
    toTerraform() {
        const attributes = (0, util_1.deepMerge)({
            ...this.synthesizeAttributes(),
            source: this.source,
            version: this.version,
            providers: this._providers?.reduce((a, p) => {
                if (terraform_provider_1.TerraformProvider.isTerraformProvider(p)) {
                    return { ...a, [p.terraformResourceType]: p.fqn };
                }
                else {
                    return {
                        ...a,
                        [`${p.provider.terraformResourceType}.${p.moduleAlias}`]: p.provider.fqn,
                    };
                }
            }, {}),
            depends_on: this.dependsOn,
            for_each: this.forEach?._getForEachExpression(),
        }, this.rawOverrides);
        attributes["//"] = this.constructNodeMetadata;
        return {
            module: {
                [this.friendlyUniqueId]: attributes,
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [`module.${this.source}`]: Object.keys(this.rawOverrides),
            },
        };
    }
    validateIfProvidersHaveUniqueKeys() {
        const moduleAliases = this._providers?.map((p) => {
            if (terraform_provider_1.TerraformProvider.isTerraformProvider(p)) {
                return p.terraformResourceType;
            }
            else {
                return `${p.provider.terraformResourceType}.${p.moduleAlias}`;
            }
        });
        const uniqueModuleAliases = new Set();
        moduleAliases?.forEach((alias) => {
            if (uniqueModuleAliases.has(alias)) {
                throw new Error(`Error: Multiple providers have the same alias: "${alias}"`);
            }
            uniqueModuleAliases.add(alias);
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
TerraformModule[_a] = { fqn: "cdktf.TerraformModule", version: "0.17.0-pre.18" };
exports.TerraformModule = TerraformModule;
//# sourceMappingURL=data:application/json;base64,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