"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Op = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
const tfExpression_1 = require("./tfExpression");
/**
 * This class contains static functions for all arithmetical and logical operators
 * in the Terraform configutation language.
 */
class Op {
    /**
     * Renders !expression
     */
    static not(expression) {
        return new tfExpression_1.OperatorExpression("!", expression);
    }
    /**
     * Renders -expression
     */
    static negate(expression) {
        return new tfExpression_1.OperatorExpression("-", expression);
    }
    /**
     * Renders left * right
     */
    static mul(left, right) {
        return new tfExpression_1.OperatorExpression("*", left, right);
    }
    /**
     * Renders left / right
     */
    static div(left, right) {
        return new tfExpression_1.OperatorExpression("/", left, right);
    }
    /**
     * Renders left % right
     */
    static mod(left, right) {
        return new tfExpression_1.OperatorExpression("%", left, right);
    }
    /**
     * Renders left + right
     */
    static add(left, right) {
        return new tfExpression_1.OperatorExpression("+", left, right);
    }
    /**
     * Renders left - right
     */
    static sub(left, right) {
        return new tfExpression_1.OperatorExpression("-", left, right);
    }
    /**
     * Renders left > right
     */
    static gt(left, right) {
        return new tfExpression_1.OperatorExpression(">", left, right);
    }
    /**
     * Renders left >= right
     */
    static gte(left, right) {
        return new tfExpression_1.OperatorExpression(">=", left, right);
    }
    /**
     * Renders left < right
     */
    static lt(left, right) {
        return new tfExpression_1.OperatorExpression("<", left, right);
    }
    /**
     * Renders left <= right
     */
    static lte(left, right) {
        return new tfExpression_1.OperatorExpression("<=", left, right);
    }
    /**
     * Renders left == right
     */
    static eq(left, right) {
        return new tfExpression_1.OperatorExpression("==", left, right);
    }
    /**
     * Renders left != right
     */
    static neq(left, right) {
        return new tfExpression_1.OperatorExpression("!=", left, right);
    }
    /**
     * Renders left && right
     */
    static and(left, right) {
        return new tfExpression_1.OperatorExpression("&&", left, right);
    }
    /**
     * Renders left || right
     */
    static or(left, right) {
        return new tfExpression_1.OperatorExpression("||", left, right);
    }
}
_a = JSII_RTTI_SYMBOL_1;
Op[_a] = { fqn: "cdktf.Op", version: "0.17.0-pre.18" };
exports.Op = Op;
//# sourceMappingURL=data:application/json;base64,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