import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { ITerraformDependable } from "./terraform-dependable";
import { Expression } from ".";
import { ITerraformAddressable } from "./terraform-addressable";
import { Precondition } from "./terraform-conditions";
export interface TerraformOutputConfig {
    readonly value: Expression | ITerraformDependable;
    readonly description?: string;
    readonly sensitive?: boolean;
    readonly dependsOn?: ITerraformDependable[];
    /**
     * If set to true the synthesized Terraform Output will be named after the `id`
     * passed to the constructor instead of the default (TerraformOutput.friendlyUniqueId)
     *
     * @default false
     */
    readonly staticId?: boolean;
    readonly precondition?: Precondition;
}
export declare class TerraformOutput extends TerraformElement {
    value: Expression | ITerraformAddressable;
    description?: string;
    sensitive?: boolean;
    dependsOn?: ITerraformDependable[];
    precondition?: Precondition;
    constructor(scope: Construct, id: string, config: TerraformOutputConfig);
    static isTerraformOutput(x: any): x is TerraformOutput;
    set staticId(staticId: boolean);
    get staticId(): boolean;
    private isITerraformAddressable;
    private synthesizeValue;
    protected synthesizeAttributes(): {
        [key: string]: any;
    };
    toTerraform(): any;
    toMetadata(): any;
}
