"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformOutput = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const util_2 = require("util");
const tokens_1 = require("./tokens");
const TERRAFORM_OUTPUT_SYMBOL = Symbol.for("cdktf/TerraformOutput");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformOutput extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id);
        this.value = config.value;
        this.description = config.description;
        this.sensitive = config.sensitive;
        this.dependsOn = config.dependsOn;
        this.staticId = config.staticId || false;
        this.precondition = config.precondition;
        Object.defineProperty(this, TERRAFORM_OUTPUT_SYMBOL, { value: true });
    }
    static isTerraformOutput(x) {
        return x !== null && typeof x === "object" && TERRAFORM_OUTPUT_SYMBOL in x;
    }
    set staticId(staticId) {
        if (staticId)
            this.overrideLogicalId(this.node.id);
        else
            this.resetOverrideLogicalId();
    }
    get staticId() {
        return this.friendlyUniqueId === this.node.id;
    }
    isITerraformAddressable(object) {
        return (object &&
            typeof object === "object" &&
            !(0, util_2.isArray)(object) &&
            "fqn" in object);
    }
    synthesizeValue(arg) {
        if (tokens_1.Token.isUnresolved(arg)) {
            return arg;
        }
        if (this.isITerraformAddressable(arg)) {
            return arg.fqn;
        }
        if (Array.isArray(arg)) {
            return arg.map((innerArg) => this.synthesizeValue(innerArg));
        }
        if (typeof arg === "object") {
            return Object.keys(arg).reduce((result, key) => {
                result[key] = this.synthesizeValue(arg[key]);
                return result;
            }, {});
        }
        return arg;
    }
    synthesizeAttributes() {
        return {
            value: this.synthesizeValue(this.value),
            description: this.description,
            sensitive: this.sensitive,
            depends_on: this.dependsOn?.map((resource) => resource.fqn),
        };
    }
    toTerraform() {
        return {
            output: {
                [this.friendlyUniqueId]: (0, util_1.deepMerge)(this.synthesizeAttributes(), this.rawOverrides),
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                output: Object.keys(this.rawOverrides),
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
TerraformOutput[_a] = { fqn: "cdktf.TerraformOutput", version: "0.17.0-pre.18" };
exports.TerraformOutput = TerraformOutput;
//# sourceMappingURL=data:application/json;base64,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