"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const TERRAFORM_PROVIDER_SYMBOL = Symbol.for("cdktf/TerraformProvider");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformProvider extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id);
        Object.defineProperty(this, TERRAFORM_PROVIDER_SYMBOL, { value: true });
        this.terraformResourceType = config.terraformResourceType;
        this.terraformGeneratorMetadata = config.terraformGeneratorMetadata;
        this.terraformProviderSource = config.terraformProviderSource;
    }
    static isTerraformProvider(x) {
        return (x !== null && typeof x === "object" && TERRAFORM_PROVIDER_SYMBOL in x);
    }
    get alias() {
        // This is always* being overridden currently
        return undefined;
    }
    set alias(_value) {
        // This is always* being overridden currently
    }
    get fqn() {
        return this.alias !== undefined
            ? tokens_1.Token.asString(`${this.terraformResourceType}.${this.alias}`)
            : tokens_1.Token.asString(`${this.terraformResourceType}`);
    }
    get metaAttributes() {
        return this.alias !== undefined ? { alias: this.alias } : {};
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        return {
            terraform: {
                required_providers: {
                    [this.terraformResourceType]: {
                        version: this.terraformGeneratorMetadata?.providerVersion ||
                            this.terraformGeneratorMetadata?.providerVersionConstraint,
                        source: this.terraformProviderSource,
                    },
                },
            },
            provider: {
                [this.terraformResourceType]: [
                    (0, util_1.deepMerge)((0, util_1.keysToSnakeCase)((0, util_1.processDynamicAttributes)(this.synthesizeAttributes())), this.rawOverrides, this.metaAttributes),
                ],
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [this.terraformResourceType]: Object.keys(this.rawOverrides),
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
TerraformProvider[_a] = { fqn: "cdktf.TerraformProvider", version: "0.17.0-pre.18" };
exports.TerraformProvider = TerraformProvider;
//# sourceMappingURL=data:application/json;base64,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