"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformSelf = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const tfExpression_1 = require("./tfExpression");
const token_1 = require("./tokens/token");
const util_1 = require("./util");
/**
 * Expressions in connection blocks cannot refer to their parent resource by name.
 * References create dependencies, and referring to a resource by name within its own block would create a dependency cycle.
 * Instead, expressions can use the self object, which represents the connection's parent resource and has all of that resource's attributes.
 * For example, use self.public_ip to reference an aws_instance's public_ip attribute.
 */
class TerraformSelf {
    static getInterpolation(key) {
        return `self.${(0, util_1.snakeCase)(key)}`;
    }
    /**
     * Only usable within a connection block to reference the connections parent resource.
     * Access a property on the resource like this: `getString("publicIp")`
     */
    static getString(key) {
        return token_1.Token.asString((0, tfExpression_1.ref)(TerraformSelf.getInterpolation(key)));
    }
    /**
     * Only usable within a connection block to reference the connections parent resource.
     * Access a property on the resource like this: `getNumber("hostPort")`
     */
    static getNumber(key) {
        return token_1.Token.asNumber((0, tfExpression_1.ref)(TerraformSelf.getInterpolation(key)));
    }
    /**
     * Only usable within a connection block to reference the connections parent resource.
     * Access a property on the resource like this: `getAny("hostPort")`
     */
    static getAny(key) {
        return token_1.Token.asAny((0, tfExpression_1.ref)(TerraformSelf.getInterpolation(key)));
    }
}
_a = JSII_RTTI_SYMBOL_1;
TerraformSelf[_a] = { fqn: "cdktf.TerraformSelf", version: "0.17.0-pre.18" };
exports.TerraformSelf = TerraformSelf;
//# sourceMappingURL=data:application/json;base64,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