import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { IResolvable } from "./tokens/resolvable";
import { ITerraformAddressable } from "./terraform-addressable";
export interface DataTerraformRemoteStateConfig {
    readonly workspace?: string;
    readonly defaults?: {
        [key: string]: any;
    };
}
export declare abstract class TerraformRemoteState extends TerraformElement implements ITerraformAddressable {
    private readonly backend;
    private readonly config;
    static readonly tfResourceType = "terraform_remote_state";
    constructor(scope: Construct, id: string, backend: string, config: DataTerraformRemoteStateConfig);
    getString(output: string): string;
    getNumber(output: string): number;
    getList(output: string): string[];
    getBoolean(output: string): IResolvable;
    get(output: string): IResolvable;
    private interpolationForAttribute;
    private extractConfig;
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform(): any;
    toMetadata(): any;
}
