"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformRemoteState = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const tokens_1 = require("./tokens");
const util_1 = require("./util");
const tfExpression_1 = require("./tfExpression");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformRemoteState extends terraform_element_1.TerraformElement {
    constructor(scope, id, backend, config) {
        super(scope, id, "data.terraform_remote_state");
        this.backend = backend;
        this.config = config;
    }
    getString(output) {
        return tokens_1.Token.asString(this.interpolationForAttribute(output));
    }
    getNumber(output) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(output));
    }
    getList(output) {
        return tokens_1.Token.asList(this.interpolationForAttribute(output));
    }
    getBoolean(output) {
        return this.interpolationForAttribute(output);
    }
    get(output) {
        return this.interpolationForAttribute(output);
    }
    interpolationForAttribute(terraformAttribute) {
        return (0, tfExpression_1.ref)(`data.terraform_remote_state.${this.friendlyUniqueId}.outputs.${terraformAttribute}`, this.cdktfStack);
    }
    extractConfig() {
        const configObj = (0, util_1.keysToSnakeCase)({ ...this.config });
        delete configObj.workspace;
        delete configObj.defaults;
        return configObj;
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        return {
            data: {
                terraform_remote_state: {
                    [this.friendlyUniqueId]: (0, util_1.deepMerge)({
                        backend: this.backend,
                        workspace: this.config.workspace,
                        defaults: this.config.defaults,
                        config: this.extractConfig(),
                    }, this.rawOverrides),
                },
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                terraform_remote_state: Object.keys(this.rawOverrides),
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
TerraformRemoteState[_a] = { fqn: "cdktf.TerraformRemoteState", version: "0.17.0-pre.18" };
TerraformRemoteState.tfResourceType = "terraform_remote_state";
exports.TerraformRemoteState = TerraformRemoteState;
//# sourceMappingURL=data:application/json;base64,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