import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { TerraformProvider } from "./terraform-provider";
import { ITerraformDependable } from "./terraform-dependable";
import { IResolvable } from "./tokens/resolvable";
import { IInterpolatingParent } from "./terraform-addressable";
import { ITerraformIterator } from "./terraform-iterator";
import { Precondition, Postcondition } from "./terraform-conditions";
import { TerraformCount } from "./terraform-count";
import { SSHProvisionerConnection, WinrmProvisionerConnection } from "./terraform-provisioner";
import { FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner } from "./terraform-provisioner";
export interface ITerraformResource {
    readonly terraformResourceType: string;
    readonly fqn: string;
    readonly friendlyUniqueId: string;
    dependsOn?: string[];
    count?: number | TerraformCount;
    provider?: TerraformProvider;
    lifecycle?: TerraformResourceLifecycle;
    forEach?: ITerraformIterator;
    interpolationForAttribute(terraformAttribute: string): IResolvable;
}
export interface TerraformResourceLifecycle {
    readonly createBeforeDestroy?: boolean;
    readonly preventDestroy?: boolean;
    readonly ignoreChanges?: string[] | "all";
    readonly replaceTriggeredBy?: Array<ITerraformDependable | string>;
    readonly precondition?: Precondition[];
    readonly postcondition?: Postcondition[];
}
export interface TerraformMetaArguments {
    readonly dependsOn?: ITerraformDependable[];
    readonly count?: number | TerraformCount;
    readonly provider?: TerraformProvider;
    readonly lifecycle?: TerraformResourceLifecycle;
    readonly forEach?: ITerraformIterator;
    readonly provisioners?: Array<FileProvisioner | LocalExecProvisioner | RemoteExecProvisioner>;
    readonly connection?: SSHProvisionerConnection | WinrmProvisionerConnection;
}
export interface TerraformProviderGeneratorMetadata {
    readonly providerName: string;
    readonly providerVersionConstraint?: string;
    readonly providerVersion?: string;
}
export interface TerraformResourceConfig extends TerraformMetaArguments {
    readonly terraformResourceType: string;
    readonly terraformGeneratorMetadata?: TerraformProviderGeneratorMetadata;
}
export declare class TerraformResource extends TerraformElement implements ITerraformResource, ITerraformDependable, IInterpolatingParent {
    readonly terraformResourceType: string;
    readonly terraformGeneratorMetadata?: TerraformProviderGeneratorMetadata;
    dependsOn?: string[];
    count?: number | TerraformCount;
    provider?: TerraformProvider;
    lifecycle?: TerraformResourceLifecycle;
    forEach?: ITerraformIterator;
    connection?: SSHProvisionerConnection | WinrmProvisionerConnection;
    provisioners?: Array<FileProvisioner | LocalExecProvisioner | RemoteExecProvisioner>;
    constructor(scope: Construct, id: string, config: TerraformResourceConfig);
    static isTerraformResource(x: any): x is TerraformResource;
    getStringAttribute(terraformAttribute: string): string;
    getNumberAttribute(terraformAttribute: string): number;
    getListAttribute(terraformAttribute: string): string[];
    getBooleanAttribute(terraformAttribute: string): IResolvable;
    getNumberListAttribute(terraformAttribute: string): number[];
    getStringMapAttribute(terraformAttribute: string): {
        [key: string]: string;
    };
    getNumberMapAttribute(terraformAttribute: string): {
        [key: string]: number;
    };
    getBooleanMapAttribute(terraformAttribute: string): {
        [key: string]: boolean;
    };
    getAnyMapAttribute(terraformAttribute: string): {
        [key: string]: any;
    };
    get terraformMetaArguments(): {
        [name: string]: any;
    };
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform(): any;
    toMetadata(): any;
    interpolationForAttribute(terraformAttribute: string): IResolvable;
}
