"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const tfExpression_1 = require("./tfExpression");
const terraform_count_1 = require("./terraform-count");
const assert = require("assert");
const TERRAFORM_RESOURCE_SYMBOL = Symbol.for("cdktf/TerraformResource");
// eslint-disable-next-line jsdoc/require-jsdoc
class TerraformResource extends terraform_element_1.TerraformElement {
    constructor(scope, id, config) {
        super(scope, id, config.terraformResourceType);
        Object.defineProperty(this, TERRAFORM_RESOURCE_SYMBOL, { value: true });
        this.terraformResourceType = config.terraformResourceType;
        this.terraformGeneratorMetadata = config.terraformGeneratorMetadata;
        if (Array.isArray(config.dependsOn)) {
            this.dependsOn = config.dependsOn.map((dependency) => (0, tfExpression_1.dependable)(dependency));
        }
        this.count = config.count;
        this.provider = config.provider;
        this.lifecycle = config.lifecycle;
        this.forEach = config.forEach;
        this.provisioners = config.provisioners;
        this.connection = config.connection;
    }
    static isTerraformResource(x) {
        return (x !== null && typeof x === "object" && TERRAFORM_RESOURCE_SYMBOL in x);
    }
    getStringAttribute(terraformAttribute) {
        return tokens_1.Token.asString(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberAttribute(terraformAttribute) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(terraformAttribute));
    }
    getListAttribute(terraformAttribute) {
        return tokens_1.Token.asList(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanAttribute(terraformAttribute) {
        return this.interpolationForAttribute(terraformAttribute);
    }
    getNumberListAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberList(this.interpolationForAttribute(terraformAttribute));
    }
    getStringMapAttribute(terraformAttribute) {
        return tokens_1.Token.asStringMap(this.interpolationForAttribute(terraformAttribute));
    }
    getNumberMapAttribute(terraformAttribute) {
        return tokens_1.Token.asNumberMap(this.interpolationForAttribute(terraformAttribute));
    }
    getBooleanMapAttribute(terraformAttribute) {
        return tokens_1.Token.asBooleanMap(this.interpolationForAttribute(terraformAttribute));
    }
    getAnyMapAttribute(terraformAttribute) {
        return tokens_1.Token.asAnyMap(this.interpolationForAttribute(terraformAttribute));
    }
    // TODO: enable this change once we want to release the next major version
    // https://github.com/hashicorp/terraform-cdk/issues/2532
    // Changing APIs like this is a breaking change in python
    // public getComputedStringMapAttribute(terraformAttribute: string) {
    //   return new StringMap(this, terraformAttribute);
    // }
    // public getComputedNumberMapAttribute(terraformAttribute: string) {
    //   return new NumberMap(this, terraformAttribute);
    // }
    // public getComputedBooleanMapAttribute(terraformAttribute: string) {
    //   return new BooleanMap(this, terraformAttribute);
    // }
    // public getComputedAnyMapAttribute(terraformAttribute: string) {
    //   return new AnyMap(this, terraformAttribute);
    // }
    get terraformMetaArguments() {
        assert(!this.forEach || typeof this.count === "undefined", `forEach and count are both set, but they are mutually exclusive. You can only use either of them. Check the resource at path: ${this.node.path}`);
        return {
            dependsOn: this.dependsOn,
            count: terraform_count_1.TerraformCount.isTerraformCount(this.count)
                ? this.count.toTerraform()
                : this.count,
            provider: this.provider?.fqn,
            lifecycle: this.lifecycle,
            forEach: this.forEach?._getForEachExpression(),
            connection: this.connection,
        };
    }
    // jsii can't handle abstract classes?
    synthesizeAttributes() {
        return {};
    }
    /**
     * Adds this resource to the terraform JSON output.
     */
    toTerraform() {
        const attributes = (0, util_1.deepMerge)((0, util_1.processDynamicAttributes)(this.synthesizeAttributes()), (0, util_1.keysToSnakeCase)(this.terraformMetaArguments), {
            provisioner: this.provisioners?.map(({ type, ...props }) => ({
                [type]: (0, util_1.keysToSnakeCase)(props),
            })),
        }, this.rawOverrides);
        attributes["//"] = {
            ...(attributes["//"] ?? {}),
            ...this.constructNodeMetadata,
        };
        return {
            resource: {
                [this.terraformResourceType]: {
                    [this.friendlyUniqueId]: attributes,
                },
            },
        };
    }
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [this.terraformResourceType]: Object.keys(this.rawOverrides),
            },
        };
    }
    interpolationForAttribute(terraformAttribute) {
        return (0, tfExpression_1.ref)(`${this.terraformResourceType}.${this.friendlyUniqueId}${this.forEach ? ".*" : ""}.${terraformAttribute}`, this.cdktfStack);
    }
}
_a = JSII_RTTI_SYMBOL_1;
TerraformResource[_a] = { fqn: "cdktf.TerraformResource", version: "0.17.0-pre.18" };
exports.TerraformResource = TerraformResource;
//# sourceMappingURL=data:application/json;base64,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