import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { IResolvable } from "./tokens/resolvable";
import { ITerraformAddressable } from "./terraform-addressable";
import { TerraformVariableValidationConfig } from "./terraform-conditions";
export declare abstract class VariableType {
    static readonly STRING = "string";
    static readonly NUMBER = "number";
    static readonly BOOL = "bool";
    static readonly ANY = "any";
    static readonly LIST = "list";
    static readonly MAP = "map";
    static readonly SET = "set";
    static readonly LIST_STRING = "list(string)";
    static readonly LIST_NUMBER = "list(number)";
    static readonly LIST_BOOL = "list(bool)";
    static readonly MAP_STRING = "map(string)";
    static readonly MAP_NUMBER = "map(number)";
    static readonly MAP_BOOL = "map(bool)";
    static readonly SET_STRING = "set(string)";
    static readonly SET_NUMBER = "set(number)";
    static readonly SET_BOOL = "set(bool)";
    static list(type: string): string;
    static map(type: string): string;
    static set(type: string): string;
    static tuple(...elements: string[]): string;
    static object(attributes: {
        [key: string]: string;
    }): string;
}
export interface TerraformVariableConfig {
    readonly default?: any;
    readonly description?: string;
    /**
     * The type argument in a variable block allows you to restrict the type of value that will be accepted as the value for a variable. If no type constraint is set then a value of any type is accepted.
     *
     * While type constraints are optional, we recommend specifying them; they serve as easy reminders for users of the module, and allow Terraform to return a helpful error message if the wrong type is used.
     *
     * Type constraints are created from a mixture of type keywords and type constructors. The supported type keywords are:
     *
     * - string
     * - number
     * - bool
     *
     * The type constructors allow you to specify complex types such as collections:
     *
     * - list(\<TYPE\>)
     * - set(\<TYPE\>)
     * - map(\<TYPE\>)
     * - object({\<ATTR NAME\> = \<TYPE\>, ... })
     * - tuple([\<TYPE\>, ...])
     *
     * The keyword any may be used to indicate that any type is acceptable. For more information on the meaning and behavior of these different types, as well as detailed information about automatic conversion of complex types, refer to {@link https://developer.hashicorp.com/terraform/language/expressions/type-constraints Type Constraints}.
     *
     * If both the type and default arguments are specified, the given default value must be convertible to the specified type.
     */
    readonly type?: string;
    readonly sensitive?: boolean;
    readonly nullable?: boolean;
    /**
     * Specify arbitrary custom validation rules for a particular variable using a validation block nested within the corresponding variable block
     */
    readonly validation?: TerraformVariableValidationConfig[];
}
export declare class TerraformVariable extends TerraformElement implements ITerraformAddressable {
    readonly default?: any;
    readonly description?: string;
    readonly type?: string;
    readonly sensitive?: boolean;
    readonly nullable?: boolean;
    private _validation?;
    constructor(scope: Construct, id: string, config: TerraformVariableConfig);
    get stringValue(): string;
    get numberValue(): number;
    get listValue(): string[];
    get booleanValue(): IResolvable;
    get value(): any;
    get validation(): TerraformVariableValidationConfig[] | undefined;
    addValidation(validation: TerraformVariableValidationConfig): void;
    private interpolation;
    synthesizeAttributes(): {
        [key: string]: any;
    };
    toTerraform(): any;
    /**
     * @returns a string token referencing the value of this variable
     */
    toString(): string;
}
