"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupJest = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const matchers_1 = require("../matchers");
const matchers_2 = require("../matchers");
// Jest supports asymetric matchers (https://github.com/facebook/jest/blob/main/packages/expect/src/asymmetricMatchers.ts)
// These matchers are great in expressing partial equality in a deeply nested way
// As we want to support more than one testing framework we can not use them everywhere
function jestPassEvaluation(items, assertedProperties) {
    if (Object.entries(assertedProperties).length === 0) {
        return items.length > 0;
    }
    else {
        if (global.expect) {
            const expect = global.expect;
            return expect
                .arrayContaining([expect.objectContaining(assertedProperties)])
                .asymmetricMatch(items);
        }
        else {
            throw new Error("expect is not defined, jest was not propely instantiated");
        }
    }
}
function setupJest() {
    if (!("expect" in global)) {
        throw new Error("setupJest called, but expect is not globally accessible");
    }
    const expect = global.expect;
    expect.extend({
        toHaveResource(received, resourceConstructor) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_2.getToHaveResourceWithProperties)(jestPassEvaluation)(received, resourceConstructor, {}));
        },
        toHaveResourceWithProperties(received, resourceConstructor, properties) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_2.getToHaveResourceWithProperties)(jestPassEvaluation)(received, resourceConstructor, properties));
        },
        toHaveDataSource(received, dataSourceConstructor) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_1.getToHaveDataSourceWithProperties)(jestPassEvaluation)(received, dataSourceConstructor, {}));
        },
        toHaveDataSourceWithProperties(received, dataSourceConstructor, properties) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_1.getToHaveDataSourceWithProperties)(jestPassEvaluation)(received, dataSourceConstructor, properties));
        },
        toHaveProvider(received, providerConstructor) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_2.getToHaveProviderWithProperties)(jestPassEvaluation)(received, providerConstructor, {}));
        },
        toHaveProviderWithProperties(received, providerConstructor, properties) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_2.getToHaveProviderWithProperties)(jestPassEvaluation)(received, providerConstructor, properties));
        },
        toBeValidTerraform(received) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_1.toBeValidTerraform)(received));
        },
        toPlanSuccessfully(received) {
            return (0, matchers_2.returnMatcherToJest)((0, matchers_1.toPlanSuccessfully)(received));
        },
    });
}
exports.setupJest = setupJest;
//# sourceMappingURL=data:application/json;base64,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