"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LazyBase = exports.Lazy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
// Copied from https://github.com/aws/constructs/blob/e01e47f78ef1e9b600efcd23ff7705aa8d384017/lib/lazy.ts
const stack_trace_1 = require("./private/stack-trace");
const token_1 = require("./token");
/**
 * Lazily produce a value
 *
 * Can be used to return a string, list or numeric value whose actual value
 * will only be calculated later, during synthesis.
 */
class Lazy {
    /**
     * Returns a stringified token for a lazy value.
     * @param producer The producer
     * @param options Options
     */
    static stringValue(producer, options = {}) {
        return token_1.Token.asString(new LazyString(producer), options);
    }
    /**
     * Returns a numberified token for a lazy value.
     * @param producer The producer
     */
    static numberValue(producer) {
        return token_1.Token.asNumber(new LazyNumber(producer));
    }
    /**
     * Returns a list-ified token for a lazy value.
     * @param producer The producer
     * @param options Options
     */
    static listValue(producer, options = {}) {
        return token_1.Token.asList(new LazyList(producer, options), options);
    }
    /**
     * Produces a lazy token from an untyped value.
     * @param producer The lazy producer
     * @param options Options
     */
    static anyValue(producer, options = {}) {
        return new LazyAny(producer, options);
    }
}
_a = JSII_RTTI_SYMBOL_1;
Lazy[_a] = { fqn: "cdktf.Lazy", version: "0.17.0-pre.18" };
exports.Lazy = Lazy;
// eslint-disable-next-line jsdoc/require-jsdoc
class LazyBase {
    constructor() {
        this.postProcessors = [];
        this.creationStack = (0, stack_trace_1.captureStackTrace)();
    }
    resolve(context) {
        return this.postProcessors.reduce((val, pp) => pp.postProcess(val, context), this.resolveLazy(context));
    }
    toString() {
        return token_1.Token.asString(this);
    }
    // will be invoked when this Lazy's resolve() method is called
    addPostProcessor(postProcessor) {
        this.postProcessors.push(postProcessor);
    }
    /**
     * Turn this Token into JSON
     *
     * Called automatically when JSON.stringify() is called on a Token.
     */
    toJSON() {
        return "<unresolved-lazy>";
    }
}
_b = JSII_RTTI_SYMBOL_1;
LazyBase[_b] = { fqn: "cdktf.LazyBase", version: "0.17.0-pre.18" };
exports.LazyBase = LazyBase;
// eslint-disable-next-line jsdoc/require-jsdoc
class LazyString extends LazyBase {
    constructor(producer) {
        super();
        this.producer = producer;
    }
    resolveLazy(context) {
        return this.producer.produce(context);
    }
}
// eslint-disable-next-line jsdoc/require-jsdoc
class LazyNumber extends LazyBase {
    constructor(producer) {
        super();
        this.producer = producer;
    }
    resolveLazy(context) {
        return this.producer.produce(context);
    }
}
// eslint-disable-next-line jsdoc/require-jsdoc
class LazyList extends LazyBase {
    constructor(producer, options = {}) {
        super();
        this.producer = producer;
        this.options = options;
    }
    resolveLazy(context) {
        const ret = this.producer.produce(context);
        if (ret !== undefined && ret.length === 0 && this.options.omitEmpty) {
            return undefined;
        }
        return ret;
    }
}
// eslint-disable-next-line jsdoc/require-jsdoc
class LazyAny extends LazyBase {
    constructor(producer, options = {}) {
        super();
        this.producer = producer;
        this.options = options;
    }
    resolveLazy(context) {
        const ret = this.producer.produce(context);
        if (Array.isArray(ret) && ret.length === 0 && this.options.omitEmptyArray) {
            return undefined;
        }
        return ret;
    }
}
//# sourceMappingURL=data:application/json;base64,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