"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Intrinsic = void 0;
const token_1 = require("../token");
const stack_trace_1 = require("./stack-trace");
/**
 * Token subclass that represents values intrinsic to the target document language
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @experimental
 * @internal
 */
class Intrinsic {
    constructor(value) {
        if (isFunction(value)) {
            throw new Error(`Argument to Intrinsic must be a plain value object, got ${value}`);
        }
        this.creationStack = (0, stack_trace_1.captureStackTrace)();
        this.value = value;
    }
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    resolve(_context) {
        return this.value;
    }
    /**
     * Convert an instance of this Token to a string
     *
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a string. We treat it the same as an explicit
     * stringification.
     */
    toString() {
        return token_1.Token.asString(this);
    }
    /**
     * Turn this Token into JSON
     *
     * Called automatically when JSON.stringify() is called on a Token.
     */
    toJSON() {
        // We can't do the right work here because in case we contain a function, we
        // won't know the type of value that function represents (in the simplest
        // case, string or number), and we can't know that without an
        // IResolveContext to actually do the resolution, which we don't have.
        // We used to throw an error, but since JSON.stringify() is often used in
        // error messages to produce a readable representation of an object, if we
        // throw here we'll obfuscate that descriptive error with something worse.
        // So return a string representation that indicates this thing is a token
        // and needs resolving.
        return `<unresolved-token>`;
    }
    /**
     * Creates a throwable Error object that contains the token creation stack trace.
     * @param message Error message
     */
    newError(message) {
        return new Error(`${message}\nToken created:\n    at ${this.creationStack.join("\n    at ")}\nError thrown:`);
    }
}
exports.Intrinsic = Intrinsic;
/**
 * Returns true if x is a function
 */
function isFunction(x) {
    return typeof x === "function";
}
//# sourceMappingURL=data:application/json;base64,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