"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultTokenResolver = exports.StringConcat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const encoding_1 = require("./private/encoding");
const token_map_1 = require("./private/token-map");
/**
 * Converts all fragments to strings and concats those
 *
 * Drops 'undefined's.
 */
class StringConcat {
    /**
     * Concatenates string fragments
     */
    join(left, right) {
        if (left === undefined) {
            return right !== undefined ? `${right}` : undefined;
        }
        if (right === undefined) {
            return `${left}`;
        }
        return `${left}${right}`;
    }
}
_a = JSII_RTTI_SYMBOL_1;
StringConcat[_a] = { fqn: "cdktf.StringConcat", version: "0.17.0-pre.18" };
exports.StringConcat = StringConcat;
/**
 * Default resolver implementation
 *
 * @experimental
 */
class DefaultTokenResolver {
    /**
     * Resolves tokens
     */
    constructor(concat) {
        this.concat = concat;
    }
    /**
     * Default Token resolution
     *
     * Resolve the Token, recurse into whatever it returns,
     * then finally post-process it.
     */
    resolveToken(t, context, postProcessor) {
        try {
            let resolved = t.resolve(context);
            // The token might have returned more values that need resolving, recurse
            resolved = context.resolve(resolved);
            resolved = postProcessor.postProcess(resolved, context);
            return resolved;
        }
        catch (e) {
            const err = e;
            let message = `Resolution error: ${err.message}.`;
            if (t.creationStack && t.creationStack.length > 0) {
                message += `\nObject creation stack:\n  at ${t.creationStack.join("\n  at ")}`;
            }
            err.message = message;
            throw err;
        }
    }
    /**
     * Resolve string fragments to Tokens
     */
    resolveString(fragments, context) {
        return fragments.mapTokens(context).join(this.concat);
    }
    /**
     * Resolves a list of string
     */
    resolveList(xs, context) {
        // Must be a singleton list token, because concatenation is not allowed.
        if (xs.length !== 1) {
            throw new Error(`Cannot add elements to list token, got: ${xs}. You tried to add a value to a referenced list, instead use Fn.concat([yourReferencedList, ["my", "new", "items"]]).`);
        }
        const str = encoding_1.TokenString.forListToken(xs[0]);
        const tokenMap = token_map_1.TokenMap.instance();
        const fragments = str.split(tokenMap.lookupToken.bind(tokenMap));
        if (fragments.length !== 1) {
            throw new Error(`Cannot concatenate strings in a tokenized string array, got: ${xs[0]}`);
        }
        return fragments.mapTokens(context).firstValue;
    }
    /**
     * Resolves a list of numbers
     */
    resolveNumberList(xs, context) {
        // Must be a singleton list token, because concatenation is not allowed.
        if (xs.length !== 1) {
            throw new Error(`Cannot add elements to list token, got: ${xs}. You tried to add a value to a referenced list, instead use Fn.concat([yourReferencedList, [42, 43, 44]]).`);
        }
        const token = token_map_1.TokenMap.instance().lookupNumberList(xs);
        if (token === undefined) {
            return xs;
        }
        return context.resolve(token);
    }
    /**
     * Resolves a map token
     */
    resolveMap(xs, context) {
        const keys = Object.keys(xs);
        if (keys.length !== 1) {
            throw new Error(`Cannot add elements to map token, got: ${JSON.stringify(xs)}. You tried to add a value to a referenced map, instead use Fn.mergeMaps([yourReferencedMap, { your: 'value' }]).`);
        }
        const str = encoding_1.TokenString.forMapToken(keys[0]);
        const tokenMap = token_map_1.TokenMap.instance();
        const fragments = str.split(tokenMap.lookupToken.bind(tokenMap));
        if (fragments.length !== 1) {
            throw new Error(`Cannot concatenate strings in a tokenized map, got: ${xs[0]}`);
        }
        return fragments.mapTokens(context).firstValue;
    }
}
_b = JSII_RTTI_SYMBOL_1;
DefaultTokenResolver[_b] = { fqn: "cdktf.DefaultTokenResolver", version: "0.17.0-pre.18" };
exports.DefaultTokenResolver = DefaultTokenResolver;
//# sourceMappingURL=data:application/json;base64,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