import { IFragmentConcatenator, IResolvable, IResolveContext } from "./resolvable";
/**
 * Fragments of a concatenated string containing stringified Tokens
 * @experimental
 */
export declare class TokenizedStringFragments {
    /**
     * Fragments in the tokenized string
     */
    private readonly fragments;
    /**
     * Returns the first token.
     */
    get firstToken(): IResolvable | undefined;
    /**
     * Returns the first value.
     */
    get firstValue(): any;
    /**
     * Returns the number of fragments.
     */
    get length(): number;
    /**
     * Adds a literal fragment
     * @param lit the literal to add
     */
    addLiteral(lit: any): void;
    /**
     * Adds a token fragment
     * @param token the token to add
     */
    addToken(token: IResolvable): void;
    /**
     * Adds an intrinsic fragment
     * @param value the intrinsic value to add
     */
    addIntrinsic(value: any): void;
    addEscape(kind: "open" | "close"): void;
    concat(other: TokenizedStringFragments): void;
    /**
     * Return all Tokens from this string
     */
    get tokens(): IResolvable[];
    /**
     * Return all literals from this string
     */
    get literals(): IResolvable[];
    /**
     * Return all intrinsic fragments from this string
     */
    get intrinsic(): IResolvable[];
    /**
     * Return all escape fragments from this string
     */
    get escapes(): IResolvable[];
    /**
     * Apply a transformation function to all tokens in the string
     */
    mapTokens(context: IResolveContext): TokenizedStringFragments;
    /**
     * Combine the string fragments using the given joiner.
     *
     * If there are any
     */
    join(concat: IFragmentConcatenator): any;
}
/**
 * Interface to apply operation to tokens in a string
 *
 * Interface so it can be exported via jsii.
 */
export interface ITokenMapper {
    /**
     * Replace a single token
     */
    mapToken(t: IResolvable): any;
}
