"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateEnvironment = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const constructs_1 = require("constructs");
/**
 * fails early if the environment contains e.g. invalid version combinations
 */
function validateEnvironment() {
    validateConstructsIsV10();
}
exports.validateEnvironment = validateEnvironment;
/**
 * fails early if the environment contains e.g. invalid version combinations
 * for constructs
 */
function validateConstructsIsV10() {
    const construct = new constructs_1.Construct(null, "test");
    // construct.node was added in v10
    if (typeof construct.node === "undefined") {
        throw new Error(`Version mismatch! The constructs depedency appears to be lower than v10 which is required as of cdktf version 0.6.
    Your current constructs version is missing Construct.node which was added in v10.
    Please update your constructs dependency: https://cdk.tf/upgrade-constructs-v10
`);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsaWRhdGVFbnZpcm9ubWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInZhbGlkYXRlRW52aXJvbm1lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0JBQStCO0FBQy9CLG1DQUFtQztBQUNuQywyQ0FBdUM7QUFFdkM7O0dBRUc7QUFDSCxTQUFnQixtQkFBbUI7SUFDakMsdUJBQXVCLEVBQUUsQ0FBQztBQUM1QixDQUFDO0FBRkQsa0RBRUM7QUFFRDs7O0dBR0c7QUFDSCxTQUFTLHVCQUF1QjtJQUM5QixNQUFNLFNBQVMsR0FBRyxJQUFJLHNCQUFTLENBQUMsSUFBVyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0lBQ3JELGtDQUFrQztJQUNsQyxJQUFJLE9BQU8sU0FBUyxDQUFDLElBQUksS0FBSyxXQUFXLEVBQUU7UUFDekMsTUFBTSxJQUFJLEtBQUssQ0FBQzs7O0NBR25CLENBQUMsQ0FBQztLQUNBO0FBQ0gsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAoYykgSGFzaGlDb3JwLCBJbmNcbi8vIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBNUEwtMi4wXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tIFwiY29uc3RydWN0c1wiO1xuXG4vKipcbiAqIGZhaWxzIGVhcmx5IGlmIHRoZSBlbnZpcm9ubWVudCBjb250YWlucyBlLmcuIGludmFsaWQgdmVyc2lvbiBjb21iaW5hdGlvbnNcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHZhbGlkYXRlRW52aXJvbm1lbnQoKSB7XG4gIHZhbGlkYXRlQ29uc3RydWN0c0lzVjEwKCk7XG59XG5cbi8qKlxuICogZmFpbHMgZWFybHkgaWYgdGhlIGVudmlyb25tZW50IGNvbnRhaW5zIGUuZy4gaW52YWxpZCB2ZXJzaW9uIGNvbWJpbmF0aW9uc1xuICogZm9yIGNvbnN0cnVjdHNcbiAqL1xuZnVuY3Rpb24gdmFsaWRhdGVDb25zdHJ1Y3RzSXNWMTAoKSB7XG4gIGNvbnN0IGNvbnN0cnVjdCA9IG5ldyBDb25zdHJ1Y3QobnVsbCBhcyBhbnksIFwidGVzdFwiKTtcbiAgLy8gY29uc3RydWN0Lm5vZGUgd2FzIGFkZGVkIGluIHYxMFxuICBpZiAodHlwZW9mIGNvbnN0cnVjdC5ub2RlID09PSBcInVuZGVmaW5lZFwiKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKGBWZXJzaW9uIG1pc21hdGNoISBUaGUgY29uc3RydWN0cyBkZXBlZGVuY3kgYXBwZWFycyB0byBiZSBsb3dlciB0aGFuIHYxMCB3aGljaCBpcyByZXF1aXJlZCBhcyBvZiBjZGt0ZiB2ZXJzaW9uIDAuNi5cbiAgICBZb3VyIGN1cnJlbnQgY29uc3RydWN0cyB2ZXJzaW9uIGlzIG1pc3NpbmcgQ29uc3RydWN0Lm5vZGUgd2hpY2ggd2FzIGFkZGVkIGluIHYxMC5cbiAgICBQbGVhc2UgdXBkYXRlIHlvdXIgY29uc3RydWN0cyBkZXBlbmRlbmN5OiBodHRwczovL2Nkay50Zi91cGdyYWRlLWNvbnN0cnVjdHMtdjEwXG5gKTtcbiAgfVxufVxuIl19