'''
# cdktf

cdktf is a framework for defining cloud infrastructure using Terraform providers and modules. It allows for
users to define infrastructure resources using higher-level programming languages.

## Build

Install dependencies

```bash
yarn install
```

Build the package

```bash
yarn build
```

[Learn More](https://cdk.tf/docs)
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from ._jsii import *

import constructs as _constructs_77d1e7e8


@jsii.enum(jsii_type="cdktf.AnnotationMetadataEntryType")
class AnnotationMetadataEntryType(enum.Enum):
    '''
    :stability: experimental
    '''

    INFO = "INFO"
    '''
    :stability: experimental
    '''
    WARN = "WARN"
    '''
    :stability: experimental
    '''
    ERROR = "ERROR"
    '''
    :stability: experimental
    '''


class Annotations(metaclass=jsii.JSIIMeta, jsii_type="cdktf.Annotations"):
    '''(experimental) Includes API for attaching annotations such as warning messages to constructs.

    :stability: experimental
    '''

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(cls, scope: _constructs_77d1e7e8.IConstruct) -> "Annotations":
        '''(experimental) Returns the annotations API for a construct scope.

        :param scope: The scope.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e701cae4130a3745962520d0c53918596ce19ab5b078c59b1cac8984bcef61da)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        return typing.cast("Annotations", jsii.sinvoke(cls, "of", [scope]))

    @jsii.member(jsii_name="addError")
    def add_error(self, message: builtins.str) -> None:
        '''(experimental) Adds an { "error":  } metadata entry to this construct.

        The toolkit will fail synthesis when errors are reported.

        :param message: The error message.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__db3486565f19867290997b36352586e1934b2a904a217faebfe2a1edb51fa62f)
            check_type(argname="argument message", value=message, expected_type=type_hints["message"])
        return typing.cast(None, jsii.invoke(self, "addError", [message]))

    @jsii.member(jsii_name="addInfo")
    def add_info(self, message: builtins.str) -> None:
        '''(experimental) Adds an info metadata entry to this construct.

        The CLI will display the info message when apps are synthesized.

        :param message: The info message.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1d9d707b73144551e8bb54e0d1629588f777f29c498be13cd6c57ea4c72b2777)
            check_type(argname="argument message", value=message, expected_type=type_hints["message"])
        return typing.cast(None, jsii.invoke(self, "addInfo", [message]))

    @jsii.member(jsii_name="addWarning")
    def add_warning(self, message: builtins.str) -> None:
        '''(experimental) Adds a warning metadata entry to this construct.

        The CLI will display the warning when an app is synthesized.
        In a future release the CLI might introduce a --strict flag which
        will then fail the synthesis if it encounters a warning.

        :param message: The warning message.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3f06e11a62167afae00733f71282c5483a302151cac27c92441529c36dc2f62d)
            check_type(argname="argument message", value=message, expected_type=type_hints["message"])
        return typing.cast(None, jsii.invoke(self, "addWarning", [message]))


class App(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.App",
):
    '''(experimental) Represents a cdktf application.

    :stability: experimental
    '''

    def __init__(
        self,
        *,
        context: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        outdir: typing.Optional[builtins.str] = None,
        skip_validation: typing.Optional[builtins.bool] = None,
        stack_traces: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Defines an app.

        :param context: (experimental) Additional context values for the application. Context set by the CLI or the ``context`` key in ``cdktf.json`` has precedence. Context can be read from any construct using ``node.getContext(key)``. Default: - no additional context
        :param outdir: (experimental) The directory to output Terraform resources. Default: - CDKTF_OUTDIR if defined, otherwise "cdktf.out"
        :param skip_validation: (experimental) Whether to skip the validation during synthesis of the app. Default: - false
        :param stack_traces: 

        :stability: experimental
        '''
        config = AppConfig(
            context=context,
            outdir=outdir,
            skip_validation=skip_validation,
            stack_traces=stack_traces,
        )

        jsii.create(self.__class__, self, [config])

    @jsii.member(jsii_name="isApp")
    @builtins.classmethod
    def is_app(cls, x: typing.Any) -> builtins.bool:
        '''
        :param x: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__64b93211fd803f507f625f2f8d86fddde1317b37a1507eaece5cda462b91093c)
            check_type(argname="argument x", value=x, expected_type=type_hints["x"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "isApp", [x]))

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(cls, construct: _constructs_77d1e7e8.IConstruct) -> "App":
        '''
        :param construct: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aab08be9c9e7f60d1e084a389ebb4a879b0cc2fa41f42df912ea79692b9d504a)
            check_type(argname="argument construct", value=construct, expected_type=type_hints["construct"])
        return typing.cast("App", jsii.sinvoke(cls, "of", [construct]))

    @jsii.member(jsii_name="crossStackReference")
    def cross_stack_reference(
        self,
        from_stack: "TerraformStack",
        to_stack: "TerraformStack",
        identifier: builtins.str,
    ) -> builtins.str:
        '''(experimental) Creates a reference from one stack to another, invoked on prepareStack since it creates extra resources.

        :param from_stack: -
        :param to_stack: -
        :param identifier: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78555980fb968e04e9e7aa15f5749bd932ce294236f50e50e57e981c1ef7e09f)
            check_type(argname="argument from_stack", value=from_stack, expected_type=type_hints["from_stack"])
            check_type(argname="argument to_stack", value=to_stack, expected_type=type_hints["to_stack"])
            check_type(argname="argument identifier", value=identifier, expected_type=type_hints["identifier"])
        return typing.cast(builtins.str, jsii.invoke(self, "crossStackReference", [from_stack, to_stack, identifier]))

    @jsii.member(jsii_name="synth")
    def synth(self) -> None:
        '''(experimental) Synthesizes all resources to the output directory.

        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "synth", []))

    @builtins.property
    @jsii.member(jsii_name="manifest")
    def manifest(self) -> "Manifest":
        '''
        :stability: experimental
        '''
        return typing.cast("Manifest", jsii.get(self, "manifest"))

    @builtins.property
    @jsii.member(jsii_name="outdir")
    def outdir(self) -> builtins.str:
        '''(experimental) The output directory into which resources will be synthesized.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "outdir"))

    @builtins.property
    @jsii.member(jsii_name="skipValidation")
    def skip_validation(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Whether to skip the validation during synthesis of the app.

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "skipValidation"))

    @builtins.property
    @jsii.member(jsii_name="targetStackId")
    def target_stack_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) The stack which will be synthesized.

        If not set, all stacks will be synthesized.

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "targetStackId"))


@jsii.data_type(
    jsii_type="cdktf.AppConfig",
    jsii_struct_bases=[],
    name_mapping={
        "context": "context",
        "outdir": "outdir",
        "skip_validation": "skipValidation",
        "stack_traces": "stackTraces",
    },
)
class AppConfig:
    def __init__(
        self,
        *,
        context: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        outdir: typing.Optional[builtins.str] = None,
        skip_validation: typing.Optional[builtins.bool] = None,
        stack_traces: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param context: (experimental) Additional context values for the application. Context set by the CLI or the ``context`` key in ``cdktf.json`` has precedence. Context can be read from any construct using ``node.getContext(key)``. Default: - no additional context
        :param outdir: (experimental) The directory to output Terraform resources. Default: - CDKTF_OUTDIR if defined, otherwise "cdktf.out"
        :param skip_validation: (experimental) Whether to skip the validation during synthesis of the app. Default: - false
        :param stack_traces: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c43059e037af6899f6ce85db8d6150f1c6a694e5d18c4f10dcf5e2d81532ea4)
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
            check_type(argname="argument outdir", value=outdir, expected_type=type_hints["outdir"])
            check_type(argname="argument skip_validation", value=skip_validation, expected_type=type_hints["skip_validation"])
            check_type(argname="argument stack_traces", value=stack_traces, expected_type=type_hints["stack_traces"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if context is not None:
            self._values["context"] = context
        if outdir is not None:
            self._values["outdir"] = outdir
        if skip_validation is not None:
            self._values["skip_validation"] = skip_validation
        if stack_traces is not None:
            self._values["stack_traces"] = stack_traces

    @builtins.property
    def context(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) Additional context values for the application.

        Context set by the CLI or the ``context`` key in ``cdktf.json`` has precedence.

        Context can be read from any construct using ``node.getContext(key)``.

        :default: - no additional context

        :stability: experimental
        '''
        result = self._values.get("context")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def outdir(self) -> typing.Optional[builtins.str]:
        '''(experimental) The directory to output Terraform resources.

        :default: - CDKTF_OUTDIR if defined, otherwise "cdktf.out"

        :stability: experimental
        '''
        result = self._values.get("outdir")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def skip_validation(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Whether to skip the validation during synthesis of the app.

        :default: - false

        :stability: experimental
        '''
        result = self._values.get("skip_validation")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def stack_traces(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("stack_traces")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.ArtifactoryBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "password": "password",
        "repo": "repo",
        "subpath": "subpath",
        "url": "url",
        "username": "username",
    },
)
class ArtifactoryBackendConfig:
    def __init__(
        self,
        *,
        password: builtins.str,
        repo: builtins.str,
        subpath: builtins.str,
        url: builtins.str,
        username: builtins.str,
    ) -> None:
        '''(deprecated) Stores the state as an artifact in a given repository in Artifactory.

        Generic HTTP repositories are supported, and state from different configurations
        may be kept at different subpaths within the repository.

        Note: The URL must include the path to the Artifactory installation.
        It will likely end in /artifactory.

        This backend does not support state locking.

        Read more about this backend in the Terraform docs:
        https://developer.hashicorp.com/terraform/language/v1.2.x/settings/backends/artifactory

        :param password: (deprecated) (Required) - The password.
        :param repo: (deprecated) (Required) - The repository name.
        :param subpath: (deprecated) (Required) - Path within the repository.
        :param url: (deprecated) (Required) - The URL. Note that this is the base url to artifactory not the full repo and subpath.
        :param username: (deprecated) (Required) - The username.

        :deprecated: CDK for Terraform no longer supports the artifactory backend. Terraform deprecated artifactory in v1.2.3 and removed it in v1.3.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__37fdc8b46385ac0f6dd5a98160428b42837588005128e8cbfca0849cd5711985)
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument repo", value=repo, expected_type=type_hints["repo"])
            check_type(argname="argument subpath", value=subpath, expected_type=type_hints["subpath"])
            check_type(argname="argument url", value=url, expected_type=type_hints["url"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "password": password,
            "repo": repo,
            "subpath": subpath,
            "url": url,
            "username": username,
        }

    @builtins.property
    def password(self) -> builtins.str:
        '''(deprecated) (Required) - The password.

        :stability: deprecated
        '''
        result = self._values.get("password")
        assert result is not None, "Required property 'password' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def repo(self) -> builtins.str:
        '''(deprecated) (Required) - The repository name.

        :stability: deprecated
        '''
        result = self._values.get("repo")
        assert result is not None, "Required property 'repo' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def subpath(self) -> builtins.str:
        '''(deprecated) (Required) - Path within the repository.

        :stability: deprecated
        '''
        result = self._values.get("subpath")
        assert result is not None, "Required property 'subpath' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def url(self) -> builtins.str:
        '''(deprecated) (Required) - The URL.

        Note that this is the base url to artifactory not the full repo and subpath.

        :stability: deprecated
        '''
        result = self._values.get("url")
        assert result is not None, "Required property 'url' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def username(self) -> builtins.str:
        '''(deprecated) (Required) - The username.

        :stability: deprecated
        '''
        result = self._values.get("username")
        assert result is not None, "Required property 'username' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ArtifactoryBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Aspects(metaclass=jsii.JSIIMeta, jsii_type="cdktf.Aspects"):
    '''(experimental) Aspects can be applied to CDK tree scopes and can operate on the tree before synthesis.

    :stability: experimental
    '''

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(cls, scope: _constructs_77d1e7e8.IConstruct) -> "Aspects":
        '''(experimental) Returns the ``Aspects`` object associated with a construct scope.

        :param scope: The scope for which these aspects will apply.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c04f6f4128babe2b6d6f0b9d86d932bfb29d998ab1989f5656e9c5138e88f513)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        return typing.cast("Aspects", jsii.sinvoke(cls, "of", [scope]))

    @jsii.member(jsii_name="add")
    def add(self, aspect: "IAspect") -> None:
        '''(experimental) Adds an aspect to apply this scope before synthesis.

        :param aspect: The aspect to add.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__177aeec0804ad4e1d513262e1b9d909687423ebbc30f00b727c103b5affffdbd)
            check_type(argname="argument aspect", value=aspect, expected_type=type_hints["aspect"])
        return typing.cast(None, jsii.invoke(self, "add", [aspect]))

    @builtins.property
    @jsii.member(jsii_name="all")
    def all(self) -> typing.List["IAspect"]:
        '''(experimental) The list of aspects which were directly applied on this scope.

        :stability: experimental
        '''
        return typing.cast(typing.List["IAspect"], jsii.get(self, "all"))


@jsii.enum(jsii_type="cdktf.AssetType")
class AssetType(enum.Enum):
    '''
    :stability: experimental
    '''

    FILE = "FILE"
    '''
    :stability: experimental
    '''
    DIRECTORY = "DIRECTORY"
    '''
    :stability: experimental
    '''
    ARCHIVE = "ARCHIVE"
    '''
    :stability: experimental
    '''


@jsii.data_type(
    jsii_type="cdktf.AzurermBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "container_name": "containerName",
        "key": "key",
        "storage_account_name": "storageAccountName",
        "access_key": "accessKey",
        "client_certificate_password": "clientCertificatePassword",
        "client_certificate_path": "clientCertificatePath",
        "client_id": "clientId",
        "client_secret": "clientSecret",
        "endpoint": "endpoint",
        "environment": "environment",
        "msi_endpoint": "msiEndpoint",
        "oidc_request_token": "oidcRequestToken",
        "oidc_request_url": "oidcRequestUrl",
        "resource_group_name": "resourceGroupName",
        "sas_token": "sasToken",
        "snapshot": "snapshot",
        "subscription_id": "subscriptionId",
        "tenant_id": "tenantId",
        "use_azuread_auth": "useAzureadAuth",
        "use_microsoft_graph": "useMicrosoftGraph",
        "use_msi": "useMsi",
        "use_oidc": "useOidc",
    },
)
class AzurermBackendConfig:
    def __init__(
        self,
        *,
        container_name: builtins.str,
        key: builtins.str,
        storage_account_name: builtins.str,
        access_key: typing.Optional[builtins.str] = None,
        client_certificate_password: typing.Optional[builtins.str] = None,
        client_certificate_path: typing.Optional[builtins.str] = None,
        client_id: typing.Optional[builtins.str] = None,
        client_secret: typing.Optional[builtins.str] = None,
        endpoint: typing.Optional[builtins.str] = None,
        environment: typing.Optional[builtins.str] = None,
        msi_endpoint: typing.Optional[builtins.str] = None,
        oidc_request_token: typing.Optional[builtins.str] = None,
        oidc_request_url: typing.Optional[builtins.str] = None,
        resource_group_name: typing.Optional[builtins.str] = None,
        sas_token: typing.Optional[builtins.str] = None,
        snapshot: typing.Optional[builtins.bool] = None,
        subscription_id: typing.Optional[builtins.str] = None,
        tenant_id: typing.Optional[builtins.str] = None,
        use_azuread_auth: typing.Optional[builtins.bool] = None,
        use_microsoft_graph: typing.Optional[builtins.bool] = None,
        use_msi: typing.Optional[builtins.bool] = None,
        use_oidc: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Stores the state as a Blob with the given Key within the Blob Container within the Blob Storage Account.

        This backend supports state locking and consistency checking
        with Azure Blob Storage native capabilities.

        Note: By default the Azure Backend uses ADAL for authentication which is deprecated
        in favour of MSAL - MSAL can be used by setting use_microsoft_graph to true.
        The default for this will change in Terraform 1.2,
        so that MSAL authentication is used by default.

        Read more about this backend in the Terraform docs:
        https://developer.hashicorp.com/terraform/language/settings/backends/azurerm

        :param container_name: (experimental) (Required) The Name of the Storage Container within the Storage Account.
        :param key: (experimental) (Required) The name of the Blob used to retrieve/store Terraform's State file inside the Storage Container.
        :param storage_account_name: (experimental) (Required) The Name of the Storage Account.
        :param access_key: (experimental) access_key - (Optional) The Access Key used to access the Blob Storage Account. This can also be sourced from the ARM_ACCESS_KEY environment variable.
        :param client_certificate_password: (experimental) (Optional) The password associated with the Client Certificate specified in client_certificate_path. This can also be sourced from the ARM_CLIENT_CERTIFICATE_PASSWORD environment variable.
        :param client_certificate_path: (experimental) (Optional) The path to the PFX file used as the Client Certificate when authenticating as a Service Principal. This can also be sourced from the ARM_CLIENT_CERTIFICATE_PATH environment variable.
        :param client_id: (experimental) (Optional) The Client ID of the Service Principal. This can also be sourced from the ARM_CLIENT_ID environment variable.
        :param client_secret: (experimental) (Optional) The Client Secret of the Service Principal. This can also be sourced from the ARM_CLIENT_SECRET environment variable.
        :param endpoint: (experimental) (Optional) The Custom Endpoint for Azure Resource Manager. This can also be sourced from the ARM_ENDPOINT environment variable. NOTE: An endpoint should only be configured when using Azure Stack.
        :param environment: (experimental) (Optional) The Azure Environment which should be used. This can also be sourced from the ARM_ENVIRONMENT environment variable. Possible values are public, china, german, stack and usgovernment. Defaults to public.
        :param msi_endpoint: (experimental) (Optional) The path to a custom Managed Service Identity endpoint which is automatically determined if not specified. This can also be sourced from the ARM_MSI_ENDPOINT environment variable.
        :param oidc_request_token: (experimental) (Optional) The bearer token for the request to the OIDC provider. This can also be sourced from the ARM_OIDC_REQUEST_TOKEN or ACTIONS_ID_TOKEN_REQUEST_TOKEN environment variables.
        :param oidc_request_url: (experimental) (Optional) The URL for the OIDC provider from which to request an ID token. This can also be sourced from the ARM_OIDC_REQUEST_URL or ACTIONS_ID_TOKEN_REQUEST_URL environment variables.
        :param resource_group_name: (experimental) (Required) The Name of the Resource Group in which the Storage Account exists.
        :param sas_token: (experimental) (Optional) The SAS Token used to access the Blob Storage Account. This can also be sourced from the ARM_SAS_TOKEN environment variable.
        :param snapshot: (experimental) (Optional) Should the Blob used to store the Terraform Statefile be snapshotted before use? Defaults to false. This value can also be sourced from the ARM_SNAPSHOT environment variable.
        :param subscription_id: (experimental) (Optional) The Subscription ID in which the Storage Account exists. This can also be sourced from the ARM_SUBSCRIPTION_ID environment variable.
        :param tenant_id: (experimental) (Optional) The Tenant ID in which the Subscription exists. This can also be sourced from the ARM_TENANT_ID environment variable.
        :param use_azuread_auth: (experimental) (Optional) Should AzureAD Authentication be used to access the Blob Storage Account. This can also be sourced from the ARM_USE_AZUREAD environment variable. Note: When using AzureAD for Authentication to Storage you also need to ensure the Storage Blob Data Owner role is assigned.
        :param use_microsoft_graph: (experimental) (Optional) Should MSAL be used for authentication instead of ADAL, and should Microsoft Graph be used instead of Azure Active Directory Graph? Defaults to true. Note: In Terraform 1.2 the Azure Backend uses MSAL (and Microsoft Graph) rather than ADAL (and Azure Active Directory Graph) for authentication by default - you can disable this by setting use_microsoft_graph to false. This setting will be removed in Terraform 1.3, due to Microsoft's deprecation of ADAL.
        :param use_msi: (experimental) (Optional) Should Managed Service Identity authentication be used? This can also be sourced from the ARM_USE_MSI environment variable.
        :param use_oidc: (experimental) (Optional) Should OIDC authentication be used? This can also be sourced from the ARM_USE_OIDC environment variable. Note: When using OIDC for authentication, use_microsoft_graph must be set to true (which is the default).

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__77262a18b3950e537486a340889b34dd8a72e72a418979e07a8cf9704f737d77)
            check_type(argname="argument container_name", value=container_name, expected_type=type_hints["container_name"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument storage_account_name", value=storage_account_name, expected_type=type_hints["storage_account_name"])
            check_type(argname="argument access_key", value=access_key, expected_type=type_hints["access_key"])
            check_type(argname="argument client_certificate_password", value=client_certificate_password, expected_type=type_hints["client_certificate_password"])
            check_type(argname="argument client_certificate_path", value=client_certificate_path, expected_type=type_hints["client_certificate_path"])
            check_type(argname="argument client_id", value=client_id, expected_type=type_hints["client_id"])
            check_type(argname="argument client_secret", value=client_secret, expected_type=type_hints["client_secret"])
            check_type(argname="argument endpoint", value=endpoint, expected_type=type_hints["endpoint"])
            check_type(argname="argument environment", value=environment, expected_type=type_hints["environment"])
            check_type(argname="argument msi_endpoint", value=msi_endpoint, expected_type=type_hints["msi_endpoint"])
            check_type(argname="argument oidc_request_token", value=oidc_request_token, expected_type=type_hints["oidc_request_token"])
            check_type(argname="argument oidc_request_url", value=oidc_request_url, expected_type=type_hints["oidc_request_url"])
            check_type(argname="argument resource_group_name", value=resource_group_name, expected_type=type_hints["resource_group_name"])
            check_type(argname="argument sas_token", value=sas_token, expected_type=type_hints["sas_token"])
            check_type(argname="argument snapshot", value=snapshot, expected_type=type_hints["snapshot"])
            check_type(argname="argument subscription_id", value=subscription_id, expected_type=type_hints["subscription_id"])
            check_type(argname="argument tenant_id", value=tenant_id, expected_type=type_hints["tenant_id"])
            check_type(argname="argument use_azuread_auth", value=use_azuread_auth, expected_type=type_hints["use_azuread_auth"])
            check_type(argname="argument use_microsoft_graph", value=use_microsoft_graph, expected_type=type_hints["use_microsoft_graph"])
            check_type(argname="argument use_msi", value=use_msi, expected_type=type_hints["use_msi"])
            check_type(argname="argument use_oidc", value=use_oidc, expected_type=type_hints["use_oidc"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container_name": container_name,
            "key": key,
            "storage_account_name": storage_account_name,
        }
        if access_key is not None:
            self._values["access_key"] = access_key
        if client_certificate_password is not None:
            self._values["client_certificate_password"] = client_certificate_password
        if client_certificate_path is not None:
            self._values["client_certificate_path"] = client_certificate_path
        if client_id is not None:
            self._values["client_id"] = client_id
        if client_secret is not None:
            self._values["client_secret"] = client_secret
        if endpoint is not None:
            self._values["endpoint"] = endpoint
        if environment is not None:
            self._values["environment"] = environment
        if msi_endpoint is not None:
            self._values["msi_endpoint"] = msi_endpoint
        if oidc_request_token is not None:
            self._values["oidc_request_token"] = oidc_request_token
        if oidc_request_url is not None:
            self._values["oidc_request_url"] = oidc_request_url
        if resource_group_name is not None:
            self._values["resource_group_name"] = resource_group_name
        if sas_token is not None:
            self._values["sas_token"] = sas_token
        if snapshot is not None:
            self._values["snapshot"] = snapshot
        if subscription_id is not None:
            self._values["subscription_id"] = subscription_id
        if tenant_id is not None:
            self._values["tenant_id"] = tenant_id
        if use_azuread_auth is not None:
            self._values["use_azuread_auth"] = use_azuread_auth
        if use_microsoft_graph is not None:
            self._values["use_microsoft_graph"] = use_microsoft_graph
        if use_msi is not None:
            self._values["use_msi"] = use_msi
        if use_oidc is not None:
            self._values["use_oidc"] = use_oidc

    @builtins.property
    def container_name(self) -> builtins.str:
        '''(experimental) (Required) The Name of the Storage Container within the Storage Account.

        :stability: experimental
        '''
        result = self._values.get("container_name")
        assert result is not None, "Required property 'container_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def key(self) -> builtins.str:
        '''(experimental) (Required) The name of the Blob used to retrieve/store Terraform's State file inside the Storage Container.

        :stability: experimental
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def storage_account_name(self) -> builtins.str:
        '''(experimental) (Required) The Name of the Storage Account.

        :stability: experimental
        '''
        result = self._values.get("storage_account_name")
        assert result is not None, "Required property 'storage_account_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def access_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) access_key - (Optional) The Access Key used to access the Blob Storage Account.

        This can also be sourced from the ARM_ACCESS_KEY environment variable.

        :stability: experimental
        '''
        result = self._values.get("access_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def client_certificate_password(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The password associated with the Client Certificate specified in client_certificate_path.

        This can also be sourced from the
        ARM_CLIENT_CERTIFICATE_PASSWORD environment variable.

        :stability: experimental
        '''
        result = self._values.get("client_certificate_password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def client_certificate_path(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The path to the PFX file used as the Client Certificate when authenticating as a Service Principal.

        This can also be sourced from the
        ARM_CLIENT_CERTIFICATE_PATH environment variable.

        :stability: experimental
        '''
        result = self._values.get("client_certificate_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def client_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The Client ID of the Service Principal.

        This can also be sourced from the ARM_CLIENT_ID environment variable.

        :stability: experimental
        '''
        result = self._values.get("client_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def client_secret(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The Client Secret of the Service Principal.

        This can also be sourced from the ARM_CLIENT_SECRET environment variable.

        :stability: experimental
        '''
        result = self._values.get("client_secret")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def endpoint(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The Custom Endpoint for Azure Resource Manager. This can also be sourced from the ARM_ENDPOINT environment variable.

        NOTE: An endpoint should only be configured when using Azure Stack.

        :stability: experimental
        '''
        result = self._values.get("endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def environment(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The Azure Environment which should be used.

        This can also be sourced from the ARM_ENVIRONMENT environment variable.
        Possible values are public, china, german, stack and usgovernment. Defaults to public.

        :stability: experimental
        '''
        result = self._values.get("environment")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def msi_endpoint(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The path to a custom Managed Service Identity endpoint which is automatically determined if not specified.

        This can also be sourced from the ARM_MSI_ENDPOINT environment variable.

        :stability: experimental
        '''
        result = self._values.get("msi_endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def oidc_request_token(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The bearer token for the request to the OIDC provider.

        This can
        also be sourced from the ARM_OIDC_REQUEST_TOKEN or
        ACTIONS_ID_TOKEN_REQUEST_TOKEN environment variables.

        :stability: experimental
        '''
        result = self._values.get("oidc_request_token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def oidc_request_url(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The URL for the OIDC provider from which to request an ID token.

        This can also be sourced from the ARM_OIDC_REQUEST_URL or
        ACTIONS_ID_TOKEN_REQUEST_URL environment variables.

        :stability: experimental
        '''
        result = self._values.get("oidc_request_url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def resource_group_name(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Required) The Name of the Resource Group in which the Storage Account exists.

        :stability: experimental
        '''
        result = self._values.get("resource_group_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sas_token(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The SAS Token used to access the Blob Storage Account.

        This can also be sourced from the ARM_SAS_TOKEN environment variable.

        :stability: experimental
        '''
        result = self._values.get("sas_token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def snapshot(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Should the Blob used to store the Terraform Statefile be snapshotted before use?

        Defaults to false. This value can also be sourced
        from the ARM_SNAPSHOT environment variable.

        :stability: experimental
        '''
        result = self._values.get("snapshot")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def subscription_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The Subscription ID in which the Storage Account exists.

        This can also be sourced from the ARM_SUBSCRIPTION_ID environment variable.

        :stability: experimental
        '''
        result = self._values.get("subscription_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tenant_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The Tenant ID in which the Subscription exists.

        This can also be sourced from the ARM_TENANT_ID environment variable.

        :stability: experimental
        '''
        result = self._values.get("tenant_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def use_azuread_auth(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Should AzureAD Authentication be used to access the Blob Storage Account.

        This can also be sourced from the ARM_USE_AZUREAD environment
        variable.

        Note: When using AzureAD for Authentication to Storage you also need to
        ensure the Storage Blob Data Owner role is assigned.

        :stability: experimental
        '''
        result = self._values.get("use_azuread_auth")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def use_microsoft_graph(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Should MSAL be used for authentication instead of ADAL, and should Microsoft Graph be used instead of Azure Active Directory Graph?

        Defaults to true.

        Note: In Terraform 1.2 the Azure Backend uses MSAL (and Microsoft Graph)
        rather than ADAL (and Azure Active Directory Graph) for authentication by
        default - you can disable this by setting use_microsoft_graph to false.
        This setting will be removed in Terraform 1.3, due to Microsoft's
        deprecation of ADAL.

        :stability: experimental
        '''
        result = self._values.get("use_microsoft_graph")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def use_msi(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Should Managed Service Identity authentication be used?

        This can also be sourced from the ARM_USE_MSI environment variable.

        :stability: experimental
        '''
        result = self._values.get("use_msi")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def use_oidc(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Should OIDC authentication be used? This can also be sourced from the ARM_USE_OIDC environment variable.

        Note: When using OIDC for authentication, use_microsoft_graph
        must be set to true (which is the default).

        :stability: experimental
        '''
        result = self._values.get("use_oidc")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AzurermBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.CloudBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "organization": "organization",
        "workspaces": "workspaces",
        "hostname": "hostname",
        "token": "token",
    },
)
class CloudBackendConfig:
    def __init__(
        self,
        *,
        organization: builtins.str,
        workspaces: typing.Union["NamedCloudWorkspace", "TaggedCloudWorkspaces"],
        hostname: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) The Cloud Backend synthesizes a {@link https://developer.hashicorp.com/terraform/cli/cloud/settings#the-cloud-block cloud block}. The cloud block is a nested block within the top-level terraform settings block. It specifies which Terraform Cloud workspaces to use for the current working directory. The cloud block only affects Terraform CLI's behavior. When Terraform Cloud uses a configuration that contains a cloud block - for example, when a workspace is configured to use a VCS provider directly - it ignores the block and behaves according to its own workspace settings.

        https://developer.hashicorp.com/terraform/cli/cloud/settings#arguments

        :param organization: (experimental) The name of the organization containing the workspace(s) the current configuration should use.
        :param workspaces: (experimental) A nested block that specifies which remote Terraform Cloud workspaces to use for the current configuration. The workspaces block must contain exactly one of the following arguments, each denoting a strategy for how workspaces should be mapped:
        :param hostname: (experimental) The hostname of a Terraform Enterprise installation, if using Terraform Enterprise. Default: app.terraform.io
        :param token: (experimental) The token used to authenticate with Terraform Cloud. We recommend omitting the token from the configuration, and instead using terraform login or manually configuring credentials in the CLI config file.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__126f3a916f614a1a32443bdbbde886438028e2dca9a6a87b18ea581e0c84c974)
            check_type(argname="argument organization", value=organization, expected_type=type_hints["organization"])
            check_type(argname="argument workspaces", value=workspaces, expected_type=type_hints["workspaces"])
            check_type(argname="argument hostname", value=hostname, expected_type=type_hints["hostname"])
            check_type(argname="argument token", value=token, expected_type=type_hints["token"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "organization": organization,
            "workspaces": workspaces,
        }
        if hostname is not None:
            self._values["hostname"] = hostname
        if token is not None:
            self._values["token"] = token

    @builtins.property
    def organization(self) -> builtins.str:
        '''(experimental) The name of the organization containing the workspace(s) the current configuration should use.

        :stability: experimental
        '''
        result = self._values.get("organization")
        assert result is not None, "Required property 'organization' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def workspaces(
        self,
    ) -> typing.Union["NamedCloudWorkspace", "TaggedCloudWorkspaces"]:
        '''(experimental) A nested block that specifies which remote Terraform Cloud workspaces to use for the current configuration.

        The workspaces block must contain exactly one of the following arguments, each denoting a strategy for how workspaces should be mapped:

        :stability: experimental
        '''
        result = self._values.get("workspaces")
        assert result is not None, "Required property 'workspaces' is missing"
        return typing.cast(typing.Union["NamedCloudWorkspace", "TaggedCloudWorkspaces"], result)

    @builtins.property
    def hostname(self) -> typing.Optional[builtins.str]:
        '''(experimental) The hostname of a Terraform Enterprise installation, if using Terraform Enterprise.

        :default: app.terraform.io

        :stability: experimental
        '''
        result = self._values.get("hostname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def token(self) -> typing.Optional[builtins.str]:
        '''(experimental) The token used to authenticate with Terraform Cloud.

        We recommend omitting the token from the configuration, and instead using terraform login or manually configuring credentials in the CLI config file.

        :stability: experimental
        '''
        result = self._values.get("token")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CloudBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class CloudWorkspace(
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdktf.CloudWorkspace",
):
    '''(experimental) A cloud workspace can either be a single named workspace, or a list of tagged workspaces.

    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="toTerraform")
    @abc.abstractmethod
    def to_terraform(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        ...


class _CloudWorkspaceProxy(CloudWorkspace):
    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, CloudWorkspace).__jsii_proxy_class__ = lambda : _CloudWorkspaceProxy


@jsii.data_type(
    jsii_type="cdktf.ConsulBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "access_token": "accessToken",
        "path": "path",
        "address": "address",
        "ca_file": "caFile",
        "cert_file": "certFile",
        "datacenter": "datacenter",
        "gzip": "gzip",
        "http_auth": "httpAuth",
        "key_file": "keyFile",
        "lock": "lock",
        "scheme": "scheme",
    },
)
class ConsulBackendConfig:
    def __init__(
        self,
        *,
        access_token: builtins.str,
        path: builtins.str,
        address: typing.Optional[builtins.str] = None,
        ca_file: typing.Optional[builtins.str] = None,
        cert_file: typing.Optional[builtins.str] = None,
        datacenter: typing.Optional[builtins.str] = None,
        gzip: typing.Optional[builtins.bool] = None,
        http_auth: typing.Optional[builtins.str] = None,
        key_file: typing.Optional[builtins.str] = None,
        lock: typing.Optional[builtins.bool] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Stores the state in the Consul KV store at a given path. This backend supports state locking.

        Read more about this backend in the Terraform docs:
        https://developer.hashicorp.com/terraform/language/settings/backends/consul

        :param access_token: (experimental) (Required) Access token.
        :param path: (experimental) (Required) Path in the Consul KV store.
        :param address: (experimental) (Optional) DNS name and port of your Consul endpoint specified in the format dnsname:port. Defaults to the local agent HTTP listener.
        :param ca_file: (experimental) (Optional) A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param cert_file: (experimental) (Optional) A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file.
        :param datacenter: (experimental) (Optional) The datacenter to use. Defaults to that of the agent.
        :param gzip: (experimental) (Optional) true to compress the state data using gzip, or false (the default) to leave it uncompressed.
        :param http_auth: (experimental) (Optional) HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either user or user:pass.
        :param key_file: (experimental) (Optional) A path to a PEM-encoded private key, required if cert_file is specified.
        :param lock: (experimental) (Optional) false to disable locking. This defaults to true, but will require session permissions with Consul and at least kv write permissions on $path/.lock to perform locking.
        :param scheme: (experimental) (Optional) Specifies what protocol to use when talking to the given address,either http or https. SSL support can also be triggered by setting then environment variable CONSUL_HTTP_SSL to true.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4b16b43404f878572b6cd921e2dc2a3813634828cb2435b8e2dcfa2db02fc5f8)
            check_type(argname="argument access_token", value=access_token, expected_type=type_hints["access_token"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument address", value=address, expected_type=type_hints["address"])
            check_type(argname="argument ca_file", value=ca_file, expected_type=type_hints["ca_file"])
            check_type(argname="argument cert_file", value=cert_file, expected_type=type_hints["cert_file"])
            check_type(argname="argument datacenter", value=datacenter, expected_type=type_hints["datacenter"])
            check_type(argname="argument gzip", value=gzip, expected_type=type_hints["gzip"])
            check_type(argname="argument http_auth", value=http_auth, expected_type=type_hints["http_auth"])
            check_type(argname="argument key_file", value=key_file, expected_type=type_hints["key_file"])
            check_type(argname="argument lock", value=lock, expected_type=type_hints["lock"])
            check_type(argname="argument scheme", value=scheme, expected_type=type_hints["scheme"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "access_token": access_token,
            "path": path,
        }
        if address is not None:
            self._values["address"] = address
        if ca_file is not None:
            self._values["ca_file"] = ca_file
        if cert_file is not None:
            self._values["cert_file"] = cert_file
        if datacenter is not None:
            self._values["datacenter"] = datacenter
        if gzip is not None:
            self._values["gzip"] = gzip
        if http_auth is not None:
            self._values["http_auth"] = http_auth
        if key_file is not None:
            self._values["key_file"] = key_file
        if lock is not None:
            self._values["lock"] = lock
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def access_token(self) -> builtins.str:
        '''(experimental) (Required) Access token.

        :stability: experimental
        '''
        result = self._values.get("access_token")
        assert result is not None, "Required property 'access_token' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''(experimental) (Required) Path in the Consul KV store.

        :stability: experimental
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def address(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) DNS name and port of your Consul endpoint specified in the format dnsname:port.

        Defaults to the local agent HTTP listener.

        :stability: experimental
        '''
        result = self._values.get("address")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ca_file(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.

        :stability: experimental
        '''
        result = self._values.get("ca_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cert_file(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) A path to a PEM-encoded certificate provided to the remote agent;

        requires use of key_file.

        :stability: experimental
        '''
        result = self._values.get("cert_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def datacenter(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The datacenter to use.

        Defaults to that of the agent.

        :stability: experimental
        '''
        result = self._values.get("datacenter")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def gzip(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) true to compress the state data using gzip, or false (the default) to leave it uncompressed.

        :stability: experimental
        '''
        result = self._values.get("gzip")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def http_auth(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either user or user:pass.

        :stability: experimental
        '''
        result = self._values.get("http_auth")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key_file(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) A path to a PEM-encoded private key, required if cert_file is specified.

        :stability: experimental
        '''
        result = self._values.get("key_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lock(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) false to disable locking.

        This defaults to true, but will require session permissions with Consul and
        at least kv write permissions on $path/.lock to perform locking.

        :stability: experimental
        '''
        result = self._values.get("lock")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def scheme(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Specifies what protocol to use when talking to the given address,either http or https.

        SSL support can also be triggered by setting then environment variable CONSUL_HTTP_SSL to true.

        :stability: experimental
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ConsulBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.CosBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "bucket": "bucket",
        "acl": "acl",
        "encrypt": "encrypt",
        "key": "key",
        "prefix": "prefix",
        "region": "region",
        "secret_id": "secretId",
        "secret_key": "secretKey",
    },
)
class CosBackendConfig:
    def __init__(
        self,
        *,
        bucket: builtins.str,
        acl: typing.Optional[builtins.str] = None,
        encrypt: typing.Optional[builtins.bool] = None,
        key: typing.Optional[builtins.str] = None,
        prefix: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        secret_id: typing.Optional[builtins.str] = None,
        secret_key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Stores the state as an object in a configurable prefix in a given bucket on Tencent Cloud Object Storage (COS).

        This backend supports state locking.

        Warning! It is highly recommended that you enable Object Versioning on the COS bucket to allow for state recovery in the case of accidental deletions and human error.

        Read more about this backend in the Terraform docs:
        https://developer.hashicorp.com/terraform/language/settings/backends/cos

        :param bucket: (experimental) (Required) The name of the COS bucket. You shall manually create it first.
        :param acl: (experimental) (Optional) Object ACL to be applied to the state file, allows private and public-read. Defaults to private.
        :param encrypt: (experimental) (Optional) Whether to enable server side encryption of the state file. If it is true, COS will use 'AES256' encryption algorithm to encrypt state file.
        :param key: (experimental) (Optional) The path for saving the state file in bucket. Defaults to terraform.tfstate.
        :param prefix: (experimental) (Optional) The directory for saving the state file in bucket. Default to "env:".
        :param region: (experimental) (Optional) The region of the COS bucket. It supports environment variables TENCENTCLOUD_REGION.
        :param secret_id: (experimental) (Optional) Secret id of Tencent Cloud. It supports environment variables TENCENTCLOUD_SECRET_ID.
        :param secret_key: (experimental) (Optional) Secret key of Tencent Cloud. It supports environment variables TENCENTCLOUD_SECRET_KEY.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f08d163c54469a487caba1d03b4195c003841660a6e5079bfca3999d4584c191)
            check_type(argname="argument bucket", value=bucket, expected_type=type_hints["bucket"])
            check_type(argname="argument acl", value=acl, expected_type=type_hints["acl"])
            check_type(argname="argument encrypt", value=encrypt, expected_type=type_hints["encrypt"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument secret_id", value=secret_id, expected_type=type_hints["secret_id"])
            check_type(argname="argument secret_key", value=secret_key, expected_type=type_hints["secret_key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "bucket": bucket,
        }
        if acl is not None:
            self._values["acl"] = acl
        if encrypt is not None:
            self._values["encrypt"] = encrypt
        if key is not None:
            self._values["key"] = key
        if prefix is not None:
            self._values["prefix"] = prefix
        if region is not None:
            self._values["region"] = region
        if secret_id is not None:
            self._values["secret_id"] = secret_id
        if secret_key is not None:
            self._values["secret_key"] = secret_key

    @builtins.property
    def bucket(self) -> builtins.str:
        '''(experimental) (Required) The name of the COS bucket.

        You shall manually create it first.

        :stability: experimental
        '''
        result = self._values.get("bucket")
        assert result is not None, "Required property 'bucket' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def acl(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Object ACL to be applied to the state file, allows private and public-read.

        Defaults to private.

        :stability: experimental
        '''
        result = self._values.get("acl")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def encrypt(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Whether to enable server side encryption of the state file.

        If it is true, COS will use 'AES256' encryption algorithm to encrypt state file.

        :stability: experimental
        '''
        result = self._values.get("encrypt")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The path for saving the state file in bucket.

        Defaults to terraform.tfstate.

        :stability: experimental
        '''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The directory for saving the state file in bucket.

        Default to "env:".

        :stability: experimental
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The region of the COS bucket.

        It supports environment variables TENCENTCLOUD_REGION.

        :stability: experimental
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Secret id of Tencent Cloud.

        It supports environment variables TENCENTCLOUD_SECRET_ID.

        :stability: experimental
        '''
        result = self._values.get("secret_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Secret key of Tencent Cloud.

        It supports environment variables TENCENTCLOUD_SECRET_KEY.

        :stability: experimental
        '''
        result = self._values.get("secret_key")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CosBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateConfig",
    jsii_struct_bases=[],
    name_mapping={"defaults": "defaults", "workspace": "workspace"},
)
class DataTerraformRemoteStateConfig:
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__842bfd666c2ba3d4f8eb0bc253c32b2515e0b1b56810f07f65b15797ee1cfee6)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateConsulConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, ConsulBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "access_token": "accessToken",
        "path": "path",
        "address": "address",
        "ca_file": "caFile",
        "cert_file": "certFile",
        "datacenter": "datacenter",
        "gzip": "gzip",
        "http_auth": "httpAuth",
        "key_file": "keyFile",
        "lock": "lock",
        "scheme": "scheme",
    },
)
class DataTerraformRemoteStateConsulConfig(
    DataTerraformRemoteStateConfig,
    ConsulBackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        access_token: builtins.str,
        path: builtins.str,
        address: typing.Optional[builtins.str] = None,
        ca_file: typing.Optional[builtins.str] = None,
        cert_file: typing.Optional[builtins.str] = None,
        datacenter: typing.Optional[builtins.str] = None,
        gzip: typing.Optional[builtins.bool] = None,
        http_auth: typing.Optional[builtins.str] = None,
        key_file: typing.Optional[builtins.str] = None,
        lock: typing.Optional[builtins.bool] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param access_token: (experimental) (Required) Access token.
        :param path: (experimental) (Required) Path in the Consul KV store.
        :param address: (experimental) (Optional) DNS name and port of your Consul endpoint specified in the format dnsname:port. Defaults to the local agent HTTP listener.
        :param ca_file: (experimental) (Optional) A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param cert_file: (experimental) (Optional) A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file.
        :param datacenter: (experimental) (Optional) The datacenter to use. Defaults to that of the agent.
        :param gzip: (experimental) (Optional) true to compress the state data using gzip, or false (the default) to leave it uncompressed.
        :param http_auth: (experimental) (Optional) HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either user or user:pass.
        :param key_file: (experimental) (Optional) A path to a PEM-encoded private key, required if cert_file is specified.
        :param lock: (experimental) (Optional) false to disable locking. This defaults to true, but will require session permissions with Consul and at least kv write permissions on $path/.lock to perform locking.
        :param scheme: (experimental) (Optional) Specifies what protocol to use when talking to the given address,either http or https. SSL support can also be triggered by setting then environment variable CONSUL_HTTP_SSL to true.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__eb170447c667189692b753fc01c2bcce62511626ea8ef0b467f9437a7d012ad5)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument access_token", value=access_token, expected_type=type_hints["access_token"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument address", value=address, expected_type=type_hints["address"])
            check_type(argname="argument ca_file", value=ca_file, expected_type=type_hints["ca_file"])
            check_type(argname="argument cert_file", value=cert_file, expected_type=type_hints["cert_file"])
            check_type(argname="argument datacenter", value=datacenter, expected_type=type_hints["datacenter"])
            check_type(argname="argument gzip", value=gzip, expected_type=type_hints["gzip"])
            check_type(argname="argument http_auth", value=http_auth, expected_type=type_hints["http_auth"])
            check_type(argname="argument key_file", value=key_file, expected_type=type_hints["key_file"])
            check_type(argname="argument lock", value=lock, expected_type=type_hints["lock"])
            check_type(argname="argument scheme", value=scheme, expected_type=type_hints["scheme"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "access_token": access_token,
            "path": path,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if address is not None:
            self._values["address"] = address
        if ca_file is not None:
            self._values["ca_file"] = ca_file
        if cert_file is not None:
            self._values["cert_file"] = cert_file
        if datacenter is not None:
            self._values["datacenter"] = datacenter
        if gzip is not None:
            self._values["gzip"] = gzip
        if http_auth is not None:
            self._values["http_auth"] = http_auth
        if key_file is not None:
            self._values["key_file"] = key_file
        if lock is not None:
            self._values["lock"] = lock
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def access_token(self) -> builtins.str:
        '''(experimental) (Required) Access token.

        :stability: experimental
        '''
        result = self._values.get("access_token")
        assert result is not None, "Required property 'access_token' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''(experimental) (Required) Path in the Consul KV store.

        :stability: experimental
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def address(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) DNS name and port of your Consul endpoint specified in the format dnsname:port.

        Defaults to the local agent HTTP listener.

        :stability: experimental
        '''
        result = self._values.get("address")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def ca_file(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.

        :stability: experimental
        '''
        result = self._values.get("ca_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cert_file(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) A path to a PEM-encoded certificate provided to the remote agent;

        requires use of key_file.

        :stability: experimental
        '''
        result = self._values.get("cert_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def datacenter(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The datacenter to use.

        Defaults to that of the agent.

        :stability: experimental
        '''
        result = self._values.get("datacenter")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def gzip(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) true to compress the state data using gzip, or false (the default) to leave it uncompressed.

        :stability: experimental
        '''
        result = self._values.get("gzip")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def http_auth(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either user or user:pass.

        :stability: experimental
        '''
        result = self._values.get("http_auth")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key_file(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) A path to a PEM-encoded private key, required if cert_file is specified.

        :stability: experimental
        '''
        result = self._values.get("key_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lock(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) false to disable locking.

        This defaults to true, but will require session permissions with Consul and
        at least kv write permissions on $path/.lock to perform locking.

        :stability: experimental
        '''
        result = self._values.get("lock")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def scheme(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Specifies what protocol to use when talking to the given address,either http or https.

        SSL support can also be triggered by setting then environment variable CONSUL_HTTP_SSL to true.

        :stability: experimental
        '''
        result = self._values.get("scheme")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateConsulConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateCosConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, CosBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "bucket": "bucket",
        "acl": "acl",
        "encrypt": "encrypt",
        "key": "key",
        "prefix": "prefix",
        "region": "region",
        "secret_id": "secretId",
        "secret_key": "secretKey",
    },
)
class DataTerraformRemoteStateCosConfig(
    DataTerraformRemoteStateConfig,
    CosBackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        bucket: builtins.str,
        acl: typing.Optional[builtins.str] = None,
        encrypt: typing.Optional[builtins.bool] = None,
        key: typing.Optional[builtins.str] = None,
        prefix: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        secret_id: typing.Optional[builtins.str] = None,
        secret_key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param bucket: (experimental) (Required) The name of the COS bucket. You shall manually create it first.
        :param acl: (experimental) (Optional) Object ACL to be applied to the state file, allows private and public-read. Defaults to private.
        :param encrypt: (experimental) (Optional) Whether to enable server side encryption of the state file. If it is true, COS will use 'AES256' encryption algorithm to encrypt state file.
        :param key: (experimental) (Optional) The path for saving the state file in bucket. Defaults to terraform.tfstate.
        :param prefix: (experimental) (Optional) The directory for saving the state file in bucket. Default to "env:".
        :param region: (experimental) (Optional) The region of the COS bucket. It supports environment variables TENCENTCLOUD_REGION.
        :param secret_id: (experimental) (Optional) Secret id of Tencent Cloud. It supports environment variables TENCENTCLOUD_SECRET_ID.
        :param secret_key: (experimental) (Optional) Secret key of Tencent Cloud. It supports environment variables TENCENTCLOUD_SECRET_KEY.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a85fe63e201ec18da12614581d98ac086db48d60040ae9a42cb2690811e25b5)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument bucket", value=bucket, expected_type=type_hints["bucket"])
            check_type(argname="argument acl", value=acl, expected_type=type_hints["acl"])
            check_type(argname="argument encrypt", value=encrypt, expected_type=type_hints["encrypt"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument secret_id", value=secret_id, expected_type=type_hints["secret_id"])
            check_type(argname="argument secret_key", value=secret_key, expected_type=type_hints["secret_key"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "bucket": bucket,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if acl is not None:
            self._values["acl"] = acl
        if encrypt is not None:
            self._values["encrypt"] = encrypt
        if key is not None:
            self._values["key"] = key
        if prefix is not None:
            self._values["prefix"] = prefix
        if region is not None:
            self._values["region"] = region
        if secret_id is not None:
            self._values["secret_id"] = secret_id
        if secret_key is not None:
            self._values["secret_key"] = secret_key

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def bucket(self) -> builtins.str:
        '''(experimental) (Required) The name of the COS bucket.

        You shall manually create it first.

        :stability: experimental
        '''
        result = self._values.get("bucket")
        assert result is not None, "Required property 'bucket' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def acl(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Object ACL to be applied to the state file, allows private and public-read.

        Defaults to private.

        :stability: experimental
        '''
        result = self._values.get("acl")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def encrypt(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Whether to enable server side encryption of the state file.

        If it is true, COS will use 'AES256' encryption algorithm to encrypt state file.

        :stability: experimental
        '''
        result = self._values.get("encrypt")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The path for saving the state file in bucket.

        Defaults to terraform.tfstate.

        :stability: experimental
        '''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The directory for saving the state file in bucket.

        Default to "env:".

        :stability: experimental
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The region of the COS bucket.

        It supports environment variables TENCENTCLOUD_REGION.

        :stability: experimental
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Secret id of Tencent Cloud.

        It supports environment variables TENCENTCLOUD_SECRET_ID.

        :stability: experimental
        '''
        result = self._values.get("secret_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Secret key of Tencent Cloud.

        It supports environment variables TENCENTCLOUD_SECRET_KEY.

        :stability: experimental
        '''
        result = self._values.get("secret_key")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateCosConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.EncodingOptions",
    jsii_struct_bases=[],
    name_mapping={"display_hint": "displayHint"},
)
class EncodingOptions:
    def __init__(self, *, display_hint: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Properties to string encodings.

        :param display_hint: (experimental) A hint for the Token's purpose when stringifying it. Default: - no display hint

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__59ed5e815df5620742c38b29e7e13db3dda0944085d6d39468d822dd1ac82e00)
            check_type(argname="argument display_hint", value=display_hint, expected_type=type_hints["display_hint"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if display_hint is not None:
            self._values["display_hint"] = display_hint

    @builtins.property
    def display_hint(self) -> typing.Optional[builtins.str]:
        '''(experimental) A hint for the Token's purpose when stringifying it.

        :default: - no display hint

        :stability: experimental
        '''
        result = self._values.get("display_hint")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EncodingOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.EtcdBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "endpoints": "endpoints",
        "path": "path",
        "password": "password",
        "username": "username",
    },
)
class EtcdBackendConfig:
    def __init__(
        self,
        *,
        endpoints: builtins.str,
        path: builtins.str,
        password: typing.Optional[builtins.str] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(deprecated) Stores the state in etcd 2.x at a given path.

        This backend does not support state locking.

        Read more about this backend in the Terraform docs:
        https://developer.hashicorp.com/terraform/language/v1.2.x/settings/backends/etcd

        :param endpoints: (deprecated) (Required) A space-separated list of the etcd endpoints.
        :param path: (deprecated) (Required) The path where to store the state.
        :param password: (deprecated) (Optional) The password.
        :param username: (deprecated) (Optional) The username.

        :deprecated: CDK for Terraform no longer supports the etcd backend. Terraform deprecated etcd in v1.2.3 and removed it in v1.3.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ae4a2d7f9760a5340e82d73a000e755be100a04118398c69dcc1648f3a9895a)
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoints": endpoints,
            "path": path,
        }
        if password is not None:
            self._values["password"] = password
        if username is not None:
            self._values["username"] = username

    @builtins.property
    def endpoints(self) -> builtins.str:
        '''(deprecated) (Required) A space-separated list of the etcd endpoints.

        :stability: deprecated
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''(deprecated) (Required) The path where to store the state.

        :stability: deprecated
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) The password.

        :stability: deprecated
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def username(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) The username.

        :stability: deprecated
        '''
        result = self._values.get("username")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EtcdBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.EtcdV3BackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "endpoints": "endpoints",
        "cacert_path": "cacertPath",
        "cert_path": "certPath",
        "key_path": "keyPath",
        "lock": "lock",
        "password": "password",
        "prefix": "prefix",
        "username": "username",
    },
)
class EtcdV3BackendConfig:
    def __init__(
        self,
        *,
        endpoints: typing.Sequence[builtins.str],
        cacert_path: typing.Optional[builtins.str] = None,
        cert_path: typing.Optional[builtins.str] = None,
        key_path: typing.Optional[builtins.str] = None,
        lock: typing.Optional[builtins.bool] = None,
        password: typing.Optional[builtins.str] = None,
        prefix: typing.Optional[builtins.str] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(deprecated) Stores the state in the etcd KV store with a given prefix.

        This backend supports state locking.

        Read more about this backend in the Terraform docs:
        https://developer.hashicorp.com/terraform/language/v1.2.x/settings/backends/etcdv3

        :param endpoints: (deprecated) (Required) The list of 'etcd' endpoints which to connect to.
        :param cacert_path: (deprecated) (Optional) The path to a PEM-encoded CA bundle with which to verify certificates of TLS-enabled etcd servers.
        :param cert_path: (deprecated) (Optional) The path to a PEM-encoded certificate to provide to etcd for secure client identification.
        :param key_path: (deprecated) (Optional) The path to a PEM-encoded key to provide to etcd for secure client identification.
        :param lock: (deprecated) (Optional) Whether to lock state access. Defaults to true.
        :param password: (deprecated) (Optional) Password used to connect to the etcd cluster.
        :param prefix: (deprecated) (Optional) An optional prefix to be added to keys when to storing state in etcd. Defaults to "".
        :param username: (deprecated) (Optional) Username used to connect to the etcd cluster.

        :deprecated: CDK for Terraform no longer supports the etcdv3 backend. Terraform deprecated etcdv3 in v1.2.3 and removed it in v1.3.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b717149837a040d676c60f3868d1980f18011883e256a4e8e2d24b0e28e46dfb)
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument cacert_path", value=cacert_path, expected_type=type_hints["cacert_path"])
            check_type(argname="argument cert_path", value=cert_path, expected_type=type_hints["cert_path"])
            check_type(argname="argument key_path", value=key_path, expected_type=type_hints["key_path"])
            check_type(argname="argument lock", value=lock, expected_type=type_hints["lock"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoints": endpoints,
        }
        if cacert_path is not None:
            self._values["cacert_path"] = cacert_path
        if cert_path is not None:
            self._values["cert_path"] = cert_path
        if key_path is not None:
            self._values["key_path"] = key_path
        if lock is not None:
            self._values["lock"] = lock
        if password is not None:
            self._values["password"] = password
        if prefix is not None:
            self._values["prefix"] = prefix
        if username is not None:
            self._values["username"] = username

    @builtins.property
    def endpoints(self) -> typing.List[builtins.str]:
        '''(deprecated) (Required) The list of 'etcd' endpoints which to connect to.

        :stability: deprecated
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def cacert_path(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) The path to a PEM-encoded CA bundle with which to verify certificates of TLS-enabled etcd servers.

        :stability: deprecated
        '''
        result = self._values.get("cacert_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cert_path(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) The path to a PEM-encoded certificate to provide to etcd for secure client identification.

        :stability: deprecated
        '''
        result = self._values.get("cert_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key_path(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) The path to a PEM-encoded key to provide to etcd for secure client identification.

        :stability: deprecated
        '''
        result = self._values.get("key_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lock(self) -> typing.Optional[builtins.bool]:
        '''(deprecated) (Optional) Whether to lock state access.

        Defaults to true.

        :stability: deprecated
        '''
        result = self._values.get("lock")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) Password used to connect to the etcd cluster.

        :stability: deprecated
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) An optional prefix to be added to keys when to storing state in etcd.

        Defaults to "".

        :stability: deprecated
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def username(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) Username used to connect to the etcd cluster.

        :stability: deprecated
        '''
        result = self._values.get("username")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EtcdV3BackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.FileProvisioner",
    jsii_struct_bases=[],
    name_mapping={
        "destination": "destination",
        "type": "type",
        "connection": "connection",
        "content": "content",
        "source": "source",
    },
)
class FileProvisioner:
    def __init__(
        self,
        *,
        destination: builtins.str,
        type: builtins.str,
        connection: typing.Optional[typing.Union[typing.Union["SSHProvisionerConnection", typing.Dict[builtins.str, typing.Any]], typing.Union["WinrmProvisionerConnection", typing.Dict[builtins.str, typing.Any]]]] = None,
        content: typing.Optional[builtins.str] = None,
        source: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) The file provisioner copies files or directories from the machine running Terraform to the newly created resource.

        The file provisioner supports both ssh and winrm type connections.

        See {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/file file}

        :param destination: (experimental) The source file or directory. Specify it either relative to the current working directory or as an absolute path. This argument cannot be combined with content.
        :param type: 
        :param connection: (experimental) Most provisioners require access to the remote resource via SSH or WinRM and expect a nested connection block with details about how to connect.
        :param content: (experimental) The destination path to write to on the remote system. See Destination Paths below for more information.
        :param source: (experimental) The direct content to copy on the destination. If destination is a file, the content will be written on that file. In case of a directory, a file named tf-file-content is created inside that directory. We recommend using a file as the destination when using content. This argument cannot be combined with source.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__23897bf257f6d92166531a7f69c73ef2684498f3c07cc7fdf79bef26aab05ac6)
            check_type(argname="argument destination", value=destination, expected_type=type_hints["destination"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument content", value=content, expected_type=type_hints["content"])
            check_type(argname="argument source", value=source, expected_type=type_hints["source"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "destination": destination,
            "type": type,
        }
        if connection is not None:
            self._values["connection"] = connection
        if content is not None:
            self._values["content"] = content
        if source is not None:
            self._values["source"] = source

    @builtins.property
    def destination(self) -> builtins.str:
        '''(experimental) The source file or directory.

        Specify it either relative to the current working directory or as an absolute path.
        This argument cannot be combined with content.

        :stability: experimental
        '''
        result = self._values.get("destination")
        assert result is not None, "Required property 'destination' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union["SSHProvisionerConnection", "WinrmProvisionerConnection"]]:
        '''(experimental) Most provisioners require access to the remote resource via SSH or WinRM and expect a nested connection block with details about how to connect.

        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union["SSHProvisionerConnection", "WinrmProvisionerConnection"]], result)

    @builtins.property
    def content(self) -> typing.Optional[builtins.str]:
        '''(experimental) The destination path to write to on the remote system.

        See Destination Paths below for more information.

        :stability: experimental
        '''
        result = self._values.get("content")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def source(self) -> typing.Optional[builtins.str]:
        '''(experimental) The direct content to copy on the destination.

        If destination is a file, the content will be written on that file.
        In case of a directory, a file named tf-file-content is created inside that directory.
        We recommend using a file as the destination when using content.
        This argument cannot be combined with source.

        :stability: experimental
        '''
        result = self._values.get("source")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FileProvisioner(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class FnGenerated(metaclass=jsii.JSIIMeta, jsii_type="cdktf.FnGenerated"):
    '''
    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="abs")
    @builtins.classmethod
    def abs(cls, num: jsii.Number) -> jsii.Number:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/abs abs} returns the absolute value of the given number. In other words, if the number is zero or positive then it is returned as-is, but if it is negative then it is multiplied by -1 to make it positive before returning it.

        :param num: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0a5e338ddfc8f6092e227bc84446fc36655b173aaabe24f2684eac2c7d578a86)
            check_type(argname="argument num", value=num, expected_type=type_hints["num"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "abs", [num]))

    @jsii.member(jsii_name="abspath")
    @builtins.classmethod
    def abspath(cls, path: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/abspath abspath} takes a string containing a filesystem path and converts it to an absolute path. That is, if the path is not absolute, it will be joined with the current working directory.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7f987a0f635fbce1f3f93317b2fe8830f10da70fd049c78585a2a8e49c980f01)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "abspath", [path]))

    @jsii.member(jsii_name="alltrue")
    @builtins.classmethod
    def alltrue(cls, list: typing.Sequence[typing.Any]) -> "IResolvable":
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/alltrue alltrue} returns ``true`` if all elements in a given collection are ``true`` or ``&#34;true&#34;``. It also returns ``true`` if the collection is empty.

        :param list: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__38502226513ec8183b49532653c656a944ff0946a4dbd6c057644977e7f39ffe)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
        return typing.cast("IResolvable", jsii.sinvoke(cls, "alltrue", [list]))

    @jsii.member(jsii_name="anytrue")
    @builtins.classmethod
    def anytrue(cls, list: typing.Sequence[typing.Any]) -> "IResolvable":
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/anytrue anytrue} returns ``true`` if any element in a given collection is ``true`` or ``&#34;true&#34;``. It also returns ``false`` if the collection is empty.

        :param list: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1e2c80ebd0bcf62b2a273847297bc628409725e8f9978a3f5da7bac4504a5ef3)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
        return typing.cast("IResolvable", jsii.sinvoke(cls, "anytrue", [list]))

    @jsii.member(jsii_name="base64decode")
    @builtins.classmethod
    def base64decode(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/base64decode base64decode} takes a string containing a Base64 character sequence and returns the original string.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1bfb1490b25ea825f90794942532862637da7656f57b218d836242168eee0bc4)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "base64decode", [str]))

    @jsii.member(jsii_name="base64encode")
    @builtins.classmethod
    def base64encode(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/base64encode base64encode} applies Base64 encoding to a string.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8cad2f632ded722ff0f7aeefb6ea7232280c2063d59f0250bc17f4a39820e103)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "base64encode", [str]))

    @jsii.member(jsii_name="base64gzip")
    @builtins.classmethod
    def base64gzip(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/base64gzip base64gzip} compresses a string with gzip and then encodes the result in Base64 encoding.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d25133ca931a8c677df3c0367a9ae834c9187295b0e588b46fb27186c9158b3a)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "base64gzip", [str]))

    @jsii.member(jsii_name="base64sha256")
    @builtins.classmethod
    def base64sha256(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/base64sha256 base64sha256} computes the SHA256 hash of a given string and encodes it with Base64. This is not equivalent to ``base64encode(sha256(&#34;test&#34;))`` since ``sha256()`` returns hexadecimal representation.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4ab7363f9919c966b178cf29937a4bf918213d68626574601f639f74edc65e8d)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "base64sha256", [str]))

    @jsii.member(jsii_name="base64sha512")
    @builtins.classmethod
    def base64sha512(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/base64sha512 base64sha512} computes the SHA512 hash of a given string and encodes it with Base64. This is not equivalent to ``base64encode(sha512(&#34;test&#34;))`` since ``sha512()`` returns hexadecimal representation.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1a38f8d990590588523343cdab3d8a5a97b85f7ba464ce9cd3c7d7c947c206b4)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "base64sha512", [str]))

    @jsii.member(jsii_name="basename")
    @builtins.classmethod
    def basename(cls, path: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/basename basename} takes a string containing a filesystem path and removes all except the last portion from it.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4197af24499e0ae7590575caa57eb58dcf464545d2db8647b81af4dcc746f127)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "basename", [path]))

    @jsii.member(jsii_name="can")
    @builtins.classmethod
    def can(cls, expression: typing.Any) -> "IResolvable":
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/can can} evaluates the given expression and returns a boolean value indicating whether the expression produced a result without any errors.

        :param expression: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5e8f021c43a442041c180522ca4123f8481e3f15cc8a5409f17c95cc783dea40)
            check_type(argname="argument expression", value=expression, expected_type=type_hints["expression"])
        return typing.cast("IResolvable", jsii.sinvoke(cls, "can", [expression]))

    @jsii.member(jsii_name="ceil")
    @builtins.classmethod
    def ceil(cls, num: jsii.Number) -> jsii.Number:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/ceil ceil} returns the closest whole number that is greater than or equal to the given value, which may be a fraction.

        :param num: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7933556eb789871a0a5c05577d852a8d07d175032f47beca05cc3d57089feb74)
            check_type(argname="argument num", value=num, expected_type=type_hints["num"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "ceil", [num]))

    @jsii.member(jsii_name="chomp")
    @builtins.classmethod
    def chomp(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/chomp chomp} removes newline characters at the end of a string.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bfa51f81d302fb1400e15ac866546a946b95134f49013e9fad72b6fb4574284e)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "chomp", [str]))

    @jsii.member(jsii_name="chunklist")
    @builtins.classmethod
    def chunklist(
        cls,
        list: typing.Sequence[typing.Any],
        size: jsii.Number,
    ) -> typing.List[builtins.str]:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/chunklist chunklist} splits a single list into fixed-size chunks, returning a list of lists.

        :param list: -
        :param size: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f09cff6405e1e67f517686953d0fcc995b9765953d49b08c8fd5a2ffabe4b22f)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
            check_type(argname="argument size", value=size, expected_type=type_hints["size"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "chunklist", [list, size]))

    @jsii.member(jsii_name="cidrhost")
    @builtins.classmethod
    def cidrhost(cls, prefix: builtins.str, hostnum: jsii.Number) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/cidrhost cidrhost} calculates a full host IP address for a given host number within a given IP network address prefix.

        :param prefix: -
        :param hostnum: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__80dcb5796b3f5db1e5f9caaba1c81b81a6d9264da89a79aa3bef448a445bf9ff)
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument hostnum", value=hostnum, expected_type=type_hints["hostnum"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "cidrhost", [prefix, hostnum]))

    @jsii.member(jsii_name="cidrnetmask")
    @builtins.classmethod
    def cidrnetmask(cls, prefix: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/cidrnetmask cidrnetmask} converts an IPv4 address prefix given in CIDR notation into a subnet mask address.

        :param prefix: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1bdfb4dbe52ac58255e994ffc76709c3f2f253d510dbf0036c77cc2f7bbbf303)
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "cidrnetmask", [prefix]))

    @jsii.member(jsii_name="cidrsubnet")
    @builtins.classmethod
    def cidrsubnet(
        cls,
        prefix: builtins.str,
        newbits: jsii.Number,
        netnum: jsii.Number,
    ) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/cidrsubnet cidrsubnet} calculates a subnet address within given IP network address prefix.

        :param prefix: -
        :param newbits: -
        :param netnum: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9b795982f84c332a3a8dbde91a3a829f409f55bdd0e244a9ad53e470dd48718d)
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument newbits", value=newbits, expected_type=type_hints["newbits"])
            check_type(argname="argument netnum", value=netnum, expected_type=type_hints["netnum"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "cidrsubnet", [prefix, newbits, netnum]))

    @jsii.member(jsii_name="cidrsubnets")
    @builtins.classmethod
    def cidrsubnets(
        cls,
        prefix: builtins.str,
        newbits: typing.Sequence[jsii.Number],
    ) -> typing.List[builtins.str]:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/cidrsubnets cidrsubnets} calculates a sequence of consecutive IP address ranges within a particular CIDR prefix.

        :param prefix: -
        :param newbits: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__090f40e74f950c1158ca004ea10a9e48141dcdbb55bd703e53406c184083ac96)
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument newbits", value=newbits, expected_type=type_hints["newbits"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "cidrsubnets", [prefix, newbits]))

    @jsii.member(jsii_name="coalesce")
    @builtins.classmethod
    def coalesce(cls, vals: typing.Sequence[typing.Any]) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/coalesce coalesce} takes any number of arguments and returns the first one that isn't null or an empty string.

        :param vals: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d400ba2935ad2b3bbf9e1b80f1f48f2efeff7d7dbf8b85dfe28335bafd620331)
            check_type(argname="argument vals", value=vals, expected_type=type_hints["vals"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "coalesce", [vals]))

    @jsii.member(jsii_name="coalescelist")
    @builtins.classmethod
    def coalescelist(cls, vals: typing.Sequence[typing.Any]) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/coalescelist coalescelist} takes any number of list arguments and returns the first one that isn't empty.

        :param vals: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e7065613008809634d388ee03f3789020233f6ad2e161f1c8f49879f18d12c7)
            check_type(argname="argument vals", value=vals, expected_type=type_hints["vals"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "coalescelist", [vals]))

    @jsii.member(jsii_name="compact")
    @builtins.classmethod
    def compact(cls, list: typing.Sequence[builtins.str]) -> typing.List[builtins.str]:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/compact compact} takes a list of strings and returns a new list with any empty string elements removed.

        :param list: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5779b9452af162c608a415cd07ca3c4be6ebb4ea54d55f58d014026263062f81)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "compact", [list]))

    @jsii.member(jsii_name="concat")
    @builtins.classmethod
    def concat(cls, seqs: typing.Sequence[typing.Any]) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/concat concat} takes two or more lists and combines them into a single list.

        :param seqs: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b3f457dfe301ddb9b6592216b8bc153ab0ac088b0e898114e0dabfceb1e840e7)
            check_type(argname="argument seqs", value=seqs, expected_type=type_hints["seqs"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "concat", [seqs]))

    @jsii.member(jsii_name="contains")
    @builtins.classmethod
    def contains(cls, list: typing.Any, value: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/contains contains} determines whether a given list or set contains a given single value as one of its elements.

        :param list: -
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__896f4304c73244a7772df69a5fab791263841eede7ae740378bdfb8787ce05f5)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "contains", [list, value]))

    @jsii.member(jsii_name="csvdecode")
    @builtins.classmethod
    def csvdecode(cls, str: builtins.str) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/csvdecode csvdecode} decodes a string containing CSV-formatted data and produces a list of maps representing that data.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__47e5a70c92e9a10b7b1bc13a3b3fcaa961057bf3a191f070e1f032a44e5c9f8f)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "csvdecode", [str]))

    @jsii.member(jsii_name="dirname")
    @builtins.classmethod
    def dirname(cls, path: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/dirname dirname} takes a string containing a filesystem path and removes the last portion from it.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d22b803b85fbf4cce568f95562318c8f3131021c4440e0be82278ad15b6db333)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "dirname", [path]))

    @jsii.member(jsii_name="distinct")
    @builtins.classmethod
    def distinct(cls, list: typing.Sequence[typing.Any]) -> typing.List[builtins.str]:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/distinct distinct} takes a list and returns a new list with any duplicate elements removed.

        :param list: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__04b0f64e9a877d05f7a05ae37dd12aad064a1ccdd813e88dff6915b95d5b5d82)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "distinct", [list]))

    @jsii.member(jsii_name="element")
    @builtins.classmethod
    def element(cls, list: typing.Any, index: jsii.Number) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/element element} retrieves a single element from a list.

        :param list: -
        :param index: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66004255c80288f0f1ff27727a8c7d169198c93c3c97a7a48c407db951bd6246)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "element", [list, index]))

    @jsii.member(jsii_name="endswith")
    @builtins.classmethod
    def endswith(cls, str: builtins.str, suffix: builtins.str) -> "IResolvable":
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/endswith endswith} takes two values: a string to check and a suffix string. The function returns true if the first string ends with that exact suffix.

        :param str: -
        :param suffix: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb0d55440a7d524ab5f6aa1e44003cca0ed7f9262b727a357966a15d682d870a)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
            check_type(argname="argument suffix", value=suffix, expected_type=type_hints["suffix"])
        return typing.cast("IResolvable", jsii.sinvoke(cls, "endswith", [str, suffix]))

    @jsii.member(jsii_name="file")
    @builtins.classmethod
    def file(cls, path: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/file file} reads the contents of a file at the given path and returns them as a string.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__73843c5cf35df3839d51fb59b2587c70b00846e31940de42f05d1d1874545dd9)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "file", [path]))

    @jsii.member(jsii_name="filebase64")
    @builtins.classmethod
    def filebase64(cls, path: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/filebase64 filebase64} reads the contents of a file at the given path and returns them as a base64-encoded string.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__259135fa446ebbd3134f9a0d945e74bfd57bdf741f72a2e58c12446812ece9bd)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "filebase64", [path]))

    @jsii.member(jsii_name="filebase64sha256")
    @builtins.classmethod
    def filebase64sha256(cls, path: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/filebase64sha256 filebase64sha256} is a variant of ``base64sha256`` that hashes the contents of a given file rather than a literal string.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__50a5ffe43a02e6dea47b687c151606d0a513c29e46fbfc54933a5e8e03fcd014)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "filebase64sha256", [path]))

    @jsii.member(jsii_name="filebase64sha512")
    @builtins.classmethod
    def filebase64sha512(cls, path: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/filebase64sha512 filebase64sha512} is a variant of ``base64sha512`` that hashes the contents of a given file rather than a literal string.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__13c8d54eb656e6055d446f82f56b6a6be0661794fc830728cc81c9f0b2d901b4)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "filebase64sha512", [path]))

    @jsii.member(jsii_name="fileexists")
    @builtins.classmethod
    def fileexists(cls, path: builtins.str) -> "IResolvable":
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/fileexists fileexists} determines whether a file exists at a given path.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__96bee221c0de19b268b9e70bd1885cbe3b0e6f15d15f061b72663a9f823be9c3)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast("IResolvable", jsii.sinvoke(cls, "fileexists", [path]))

    @jsii.member(jsii_name="filemd5")
    @builtins.classmethod
    def filemd5(cls, path: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/filemd5 filemd5} is a variant of ``md5`` that hashes the contents of a given file rather than a literal string.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__051034d2cb64ee680a24b22416bb681e5ace82a14f0b4d1b1a327624a619dcd1)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "filemd5", [path]))

    @jsii.member(jsii_name="fileset")
    @builtins.classmethod
    def fileset(
        cls,
        path: builtins.str,
        pattern: builtins.str,
    ) -> typing.List[builtins.str]:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/fileset fileset} enumerates a set of regular file names given a path and pattern. The path is automatically removed from the resulting set of file names and any result still containing path separators always returns forward slash (``/``) as the path separator for cross-system compatibility.

        :param path: -
        :param pattern: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__986c282a93d41634f9b00495dd2ca2b295fb8748471cfccc78eb0b378a42ac3a)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument pattern", value=pattern, expected_type=type_hints["pattern"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "fileset", [path, pattern]))

    @jsii.member(jsii_name="filesha1")
    @builtins.classmethod
    def filesha1(cls, path: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/filesha1 filesha1} is a variant of ``sha1`` that hashes the contents of a given file rather than a literal string.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c8bcdef50d5449a5a1282707d7a746b496da015fd4c370bda4a1f6a8c26feef)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "filesha1", [path]))

    @jsii.member(jsii_name="filesha256")
    @builtins.classmethod
    def filesha256(cls, path: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/filesha256 filesha256} is a variant of ``sha256`` that hashes the contents of a given file rather than a literal string.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d79d1998d859617628df6c105eb7748bb36792bc22ecaf5d2a0b5b52fa135ee)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "filesha256", [path]))

    @jsii.member(jsii_name="filesha512")
    @builtins.classmethod
    def filesha512(cls, path: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/filesha512 filesha512} is a variant of ``sha512`` that hashes the contents of a given file rather than a literal string.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9cd13592d7ee55d320351269e4e2baccb2778e0993b9a417763381f2f6a4637a)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "filesha512", [path]))

    @jsii.member(jsii_name="flatten")
    @builtins.classmethod
    def flatten(cls, list: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/flatten flatten} takes a list and replaces any elements that are lists with a flattened sequence of the list contents.

        :param list: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__991ab09816aff1c6eaf6006b3e1fa695efb910d3762bfd2d64ea83c077e8e035)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "flatten", [list]))

    @jsii.member(jsii_name="floor")
    @builtins.classmethod
    def floor(cls, num: jsii.Number) -> jsii.Number:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/floor floor} returns the closest whole number that is less than or equal to the given value, which may be a fraction.

        :param num: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c50c161a0d4e73b681b891546a183e3a0bb0543912c437883c7a3aa7198019c)
            check_type(argname="argument num", value=num, expected_type=type_hints["num"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "floor", [num]))

    @jsii.member(jsii_name="format")
    @builtins.classmethod
    def format(
        cls,
        format: builtins.str,
        args: typing.Sequence[typing.Any],
    ) -> typing.Any:
        '''(experimental) The {@link https://developer.hashicorp.com/terraform/language/functions/format format} function produces a string by formatting a number of other values according to a specification string. It is similar to the ``printf`` function in C, and other similar functions in other programming languages.

        :param format: -
        :param args: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f1ce01e643b2fdd38e9d4805ddf60766c3613a37e537b899e5df8d506de208eb)
            check_type(argname="argument format", value=format, expected_type=type_hints["format"])
            check_type(argname="argument args", value=args, expected_type=type_hints["args"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "format", [format, args]))

    @jsii.member(jsii_name="formatdate")
    @builtins.classmethod
    def formatdate(cls, format: builtins.str, time: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/formatdate formatdate} converts a timestamp into a different time format.

        :param format: -
        :param time: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aa275156d1571534822a289fb8aefa43a89e8308934a44e9b91c4c64e913ad43)
            check_type(argname="argument format", value=format, expected_type=type_hints["format"])
            check_type(argname="argument time", value=time, expected_type=type_hints["time"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "formatdate", [format, time]))

    @jsii.member(jsii_name="formatlist")
    @builtins.classmethod
    def formatlist(
        cls,
        format: builtins.str,
        args: typing.Sequence[typing.Any],
    ) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/formatlist formatlist} produces a list of strings by formatting a number of other values according to a specification string.

        :param format: -
        :param args: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6923675602e3fb1af0f8f71ca694bc1222a3002a6e1777d4e9be13349302b644)
            check_type(argname="argument format", value=format, expected_type=type_hints["format"])
            check_type(argname="argument args", value=args, expected_type=type_hints["args"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "formatlist", [format, args]))

    @jsii.member(jsii_name="indent")
    @builtins.classmethod
    def indent(cls, spaces: jsii.Number, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/indent indent} adds a given number of spaces to the beginnings of all but the first line in a given multi-line string.

        :param spaces: -
        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e40e73be11ce3df3cef313af243e5c9465cb723d1fb5f555ace6e2e914f64ab6)
            check_type(argname="argument spaces", value=spaces, expected_type=type_hints["spaces"])
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "indent", [spaces, str]))

    @jsii.member(jsii_name="index")
    @builtins.classmethod
    def index(cls, list: typing.Any, value: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/index index} finds the element index for a given value in a list.

        :param list: -
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c7779a6d90a1f040056dcb3c3966818fb801b339a2e666cb1b485c1abc36792)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "index", [list, value]))

    @jsii.member(jsii_name="jsondecode")
    @builtins.classmethod
    def jsondecode(cls, str: builtins.str) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/jsondecode jsondecode} interprets a given string as JSON, returning a representation of the result of decoding that string.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dda0803f334c009ce03b2187ab3292d8b999230a99c3c250ab69cd7b00e50929)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "jsondecode", [str]))

    @jsii.member(jsii_name="jsonencode")
    @builtins.classmethod
    def jsonencode(cls, val: typing.Any) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/jsonencode jsonencode} encodes a given value to a string using JSON syntax.

        :param val: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__632bdc4dfdfade5c1ade0efffaa0fd0aa0b9b78c8086cd966e96b96e9170cc8f)
            check_type(argname="argument val", value=val, expected_type=type_hints["val"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "jsonencode", [val]))

    @jsii.member(jsii_name="keys")
    @builtins.classmethod
    def keys(cls, input_map: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/keys keys} takes a map and returns a list containing the keys from that map.

        :param input_map: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6729c76e500e8166a303ef049e3850315eae44e2e5da693a478bc12df5fe42c7)
            check_type(argname="argument input_map", value=input_map, expected_type=type_hints["input_map"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "keys", [input_map]))

    @jsii.member(jsii_name="lengthOf")
    @builtins.classmethod
    def length_of(cls, value: typing.Any) -> jsii.Number:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/length length} determines the length of a given list, map, or string.

        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__68e04618b98e481a3b0a5d372bce6aeef20e78c087d1240f6d1b2f55fc86c831)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "lengthOf", [value]))

    @jsii.member(jsii_name="log")
    @builtins.classmethod
    def log(cls, num: jsii.Number, base: jsii.Number) -> jsii.Number:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/log log} returns the logarithm of a given number in a given base.

        :param num: -
        :param base: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df61bff1ec5ff7b8f70aff56ce574fbbb4d16fdde8467f0fe5ef2224a1b2fb1e)
            check_type(argname="argument num", value=num, expected_type=type_hints["num"])
            check_type(argname="argument base", value=base, expected_type=type_hints["base"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "log", [num, base]))

    @jsii.member(jsii_name="lower")
    @builtins.classmethod
    def lower(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/lower lower} converts all cased letters in the given string to lowercase.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d3f2a69002d15d8a0762a328a691aaa7d160cbb4d3767d90512596ac95887e5)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "lower", [str]))

    @jsii.member(jsii_name="matchkeys")
    @builtins.classmethod
    def matchkeys(
        cls,
        values: typing.Sequence[typing.Any],
        keys: typing.Sequence[typing.Any],
        searchset: typing.Sequence[typing.Any],
    ) -> typing.List[builtins.str]:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/matchkeys matchkeys} constructs a new list by taking a subset of elements from one list whose indexes match the corresponding indexes of values in another list.

        :param values: -
        :param keys: -
        :param searchset: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__868c66847079298435f90c4682edb2ecd4f5df6852865136d9db4009331552ea)
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
            check_type(argname="argument keys", value=keys, expected_type=type_hints["keys"])
            check_type(argname="argument searchset", value=searchset, expected_type=type_hints["searchset"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "matchkeys", [values, keys, searchset]))

    @jsii.member(jsii_name="max")
    @builtins.classmethod
    def max(cls, numbers: typing.Sequence[jsii.Number]) -> jsii.Number:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/max max} takes one or more numbers and returns the greatest number from the set.

        :param numbers: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e64206a9a3cd3d108a4f81cc4b253854204243fc8872e9cbda1ca107671ebbb6)
            check_type(argname="argument numbers", value=numbers, expected_type=type_hints["numbers"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "max", [numbers]))

    @jsii.member(jsii_name="md5")
    @builtins.classmethod
    def md5(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/md5 md5} computes the MD5 hash of a given string and encodes it with hexadecimal digits.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__719175317fd877a84b99d56d8543093522667045dc5937c84d359628b24eda3a)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "md5", [str]))

    @jsii.member(jsii_name="merge")
    @builtins.classmethod
    def merge(cls, maps: typing.Sequence[typing.Any]) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/merge merge} takes an arbitrary number of maps or objects, and returns a single map or object that contains a merged set of elements from all arguments.

        :param maps: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__70f9f61f333dd39e63b3499fc8c0a761bb9348d76650e26718c54a390ccc8ad5)
            check_type(argname="argument maps", value=maps, expected_type=type_hints["maps"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "merge", [maps]))

    @jsii.member(jsii_name="min")
    @builtins.classmethod
    def min(cls, numbers: typing.Sequence[jsii.Number]) -> jsii.Number:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/min min} takes one or more numbers and returns the smallest number from the set.

        :param numbers: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0a75cb3c54180d76fc85d0f18812c4c6078b98d0055b660590204e9f6dd2c26d)
            check_type(argname="argument numbers", value=numbers, expected_type=type_hints["numbers"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "min", [numbers]))

    @jsii.member(jsii_name="nonsensitive")
    @builtins.classmethod
    def nonsensitive(cls, value: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/nonsensitive nonsensitive} takes a sensitive value and returns a copy of that value with the sensitive marking removed, thereby exposing the sensitive value.

        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8e3eda280663f08e1377aaad083ebd0f6333e9dae5d2eb9601232a68f5cdf1a0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "nonsensitive", [value]))

    @jsii.member(jsii_name="one")
    @builtins.classmethod
    def one(cls, list: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/one one} takes a list, set, or tuple value with either zero or one elements. If the collection is empty, ``one`` returns ``null``. Otherwise, ``one`` returns the first element. If there are two or more elements then ``one`` will return an error.

        :param list: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a3dec32badfdb66eb1015db1148a87f60c89073f615dba9bcf12a4d24d8eaab7)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "one", [list]))

    @jsii.member(jsii_name="parseint")
    @builtins.classmethod
    def parseint(cls, number: typing.Any, base: jsii.Number) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/parseint parseint} parses the given string as a representation of an integer in the specified base and returns the resulting number. The base must be between 2 and 62 inclusive.

        :param number: -
        :param base: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__86ab6d4833a2209278340ffc8b9f0d3da3d2fb213ee6f97c8f69115f5381b784)
            check_type(argname="argument number", value=number, expected_type=type_hints["number"])
            check_type(argname="argument base", value=base, expected_type=type_hints["base"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "parseint", [number, base]))

    @jsii.member(jsii_name="pathexpand")
    @builtins.classmethod
    def pathexpand(cls, path: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/pathexpand pathexpand} takes a filesystem path that might begin with a ``~`` segment, and if so it replaces that segment with the current user's home directory path.

        :param path: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ba0a79de8af9790367f928a3231d9740e59204e008b7ced0204ac77becceb11e)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "pathexpand", [path]))

    @jsii.member(jsii_name="pow")
    @builtins.classmethod
    def pow(cls, num: jsii.Number, power: jsii.Number) -> jsii.Number:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/pow pow} calculates an exponent, by raising its first argument to the power of the second argument.

        :param num: -
        :param power: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3e7693c19c86899babd803b2aef4a9fa38e2f68366dc15a26d5ab89f77d372e1)
            check_type(argname="argument num", value=num, expected_type=type_hints["num"])
            check_type(argname="argument power", value=power, expected_type=type_hints["power"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "pow", [num, power]))

    @jsii.member(jsii_name="regex")
    @builtins.classmethod
    def regex(cls, pattern: builtins.str, str: builtins.str) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/regex regex} applies a `regular expression <https://en.wikipedia.org/wiki/Regular_expression>`_ to a string and returns the matching substrings.

        :param pattern: -
        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__780c9b92c3064ab94ee8e1d500172b48f0b569f30b263f47a1807c63dd94cf88)
            check_type(argname="argument pattern", value=pattern, expected_type=type_hints["pattern"])
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "regex", [pattern, str]))

    @jsii.member(jsii_name="regexall")
    @builtins.classmethod
    def regexall(
        cls,
        pattern: builtins.str,
        str: builtins.str,
    ) -> typing.List[builtins.str]:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/regexall regexall} applies a `regular expression <https://en.wikipedia.org/wiki/Regular_expression>`_ to a string and returns a list of all matches.

        :param pattern: -
        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c0632a8db3ecaa6f24432073e0bd249e4a78d56aff92df23414486f9dbeba811)
            check_type(argname="argument pattern", value=pattern, expected_type=type_hints["pattern"])
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "regexall", [pattern, str]))

    @jsii.member(jsii_name="replace")
    @builtins.classmethod
    def replace(
        cls,
        str: builtins.str,
        substr: builtins.str,
        replace: builtins.str,
    ) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/replace replace} searches a given string for another given substring, and replaces each occurrence with a given replacement string.

        :param str: -
        :param substr: -
        :param replace: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__85238d13f9989bbf2bba72200144476708750d10004389f61763154aadfba2f9)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
            check_type(argname="argument substr", value=substr, expected_type=type_hints["substr"])
            check_type(argname="argument replace", value=replace, expected_type=type_hints["replace"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "replace", [str, substr, replace]))

    @jsii.member(jsii_name="reverse")
    @builtins.classmethod
    def reverse(cls, list: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/reverse reverse} takes a sequence and produces a new sequence of the same length with all of the same elements as the given sequence but in reverse order.

        :param list: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__22bb2a8519484bc4cb8cd13872832af8054db8b997ee68c736c632b72fe5acb2)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "reverse", [list]))

    @jsii.member(jsii_name="rsadecrypt")
    @builtins.classmethod
    def rsadecrypt(
        cls,
        ciphertext: builtins.str,
        privatekey: builtins.str,
    ) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/rsadecrypt rsadecrypt} decrypts an RSA-encrypted ciphertext, returning the corresponding cleartext.

        :param ciphertext: -
        :param privatekey: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f2a0f5ef8f7e494a4bf7bfdd8a09c86e90179512391e1fdc86dc701cae860934)
            check_type(argname="argument ciphertext", value=ciphertext, expected_type=type_hints["ciphertext"])
            check_type(argname="argument privatekey", value=privatekey, expected_type=type_hints["privatekey"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "rsadecrypt", [ciphertext, privatekey]))

    @jsii.member(jsii_name="sensitive")
    @builtins.classmethod
    def sensitive(cls, value: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/sensitive sensitive} takes any value and returns a copy of it marked so that Terraform will treat it as sensitive, with the same meaning and behavior as for `sensitive input variables </language/values/variables#suppressing-values-in-cli-output>`_.

        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ec6e766ab3750310e63be45216a20edc7b64d18d6b93705a68343b214e073f03)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "sensitive", [value]))

    @jsii.member(jsii_name="setintersection")
    @builtins.classmethod
    def setintersection(
        cls,
        first_set: typing.Sequence[typing.Any],
        other_sets: typing.Sequence[typing.Sequence[typing.Any]],
    ) -> typing.List[builtins.str]:
        '''(experimental) The {@link https://developer.hashicorp.com/terraform/language/functions/setintersection setintersection} function takes multiple sets and produces a single set containing only the elements that all of the given sets have in common. In other words, it computes the `intersection <https://en.wikipedia.org/wiki/Intersection_(set_theory)>`_ of the sets.

        :param first_set: -
        :param other_sets: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b43a3439b011ff7b23e4c00488072ad12b407f122f2c4f6ca98d6c1a91461718)
            check_type(argname="argument first_set", value=first_set, expected_type=type_hints["first_set"])
            check_type(argname="argument other_sets", value=other_sets, expected_type=type_hints["other_sets"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "setintersection", [first_set, other_sets]))

    @jsii.member(jsii_name="setproduct")
    @builtins.classmethod
    def setproduct(cls, sets: typing.Sequence[typing.Any]) -> typing.Any:
        '''(experimental) The {@link https://developer.hashicorp.com/terraform/language/functions/setproduct setproduct} function finds all of the possible combinations of elements from all of the given sets by computing the `Cartesian product <https://en.wikipedia.org/wiki/Cartesian_product>`_.

        :param sets: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7b597461f29d331fce2c4f5762603d656c577f829f5dd71634b446fb6b8f4162)
            check_type(argname="argument sets", value=sets, expected_type=type_hints["sets"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "setproduct", [sets]))

    @jsii.member(jsii_name="setsubtract")
    @builtins.classmethod
    def setsubtract(
        cls,
        a: typing.Sequence[typing.Any],
        b: typing.Sequence[typing.Any],
    ) -> typing.List[builtins.str]:
        '''(experimental) The {@link https://developer.hashicorp.com/terraform/language/functions/setsubtract setsubtract} function returns a new set containing the elements from the first set that are not present in the second set. In other words, it computes the `relative complement <https://en.wikipedia.org/wiki/Complement_(set_theory)#Relative_complement>`_ of the second set.

        :param a: -
        :param b: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bc3fcee04740c100b7cdab5747a1602c961f15aa412047d0e97fdf8162745181)
            check_type(argname="argument a", value=a, expected_type=type_hints["a"])
            check_type(argname="argument b", value=b, expected_type=type_hints["b"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "setsubtract", [a, b]))

    @jsii.member(jsii_name="setunion")
    @builtins.classmethod
    def setunion(
        cls,
        first_set: typing.Sequence[typing.Any],
        other_sets: typing.Sequence[typing.Sequence[typing.Any]],
    ) -> typing.List[builtins.str]:
        '''(experimental) The {@link https://developer.hashicorp.com/terraform/language/functions/setunion setunion} function takes multiple sets and produces a single set containing the elements from all of the given sets. In other words, it computes the `union <https://en.wikipedia.org/wiki/Union_(set_theory)>`_ of the sets.

        :param first_set: -
        :param other_sets: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dae06d6b96c6b9929ba44feb36193cc424526c69e619387feefdf7663c10b52e)
            check_type(argname="argument first_set", value=first_set, expected_type=type_hints["first_set"])
            check_type(argname="argument other_sets", value=other_sets, expected_type=type_hints["other_sets"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "setunion", [first_set, other_sets]))

    @jsii.member(jsii_name="sha1")
    @builtins.classmethod
    def sha1(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/sha1 sha1} computes the SHA1 hash of a given string and encodes it with hexadecimal digits.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__52c093b7608298d1d0f1a71c33cb3b6d71b53dd6ca1ded3be295941f1730fb14)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "sha1", [str]))

    @jsii.member(jsii_name="sha256")
    @builtins.classmethod
    def sha256(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/sha256 sha256} computes the SHA256 hash of a given string and encodes it with hexadecimal digits.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1517a1940ac600ca00d9788e9534760de4747e7a7dc18bd7ecb357d3cda95c27)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "sha256", [str]))

    @jsii.member(jsii_name="sha512")
    @builtins.classmethod
    def sha512(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/sha512 sha512} computes the SHA512 hash of a given string and encodes it with hexadecimal digits.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4bdc65d9d62a7ffb50354d8e244fd4664656dd6100de846dbfca5c05c62263ad)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "sha512", [str]))

    @jsii.member(jsii_name="signum")
    @builtins.classmethod
    def signum(cls, num: jsii.Number) -> jsii.Number:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/signum signum} determines the sign of a number, returning a number between -1 and 1 to represent the sign.

        :param num: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2faf1a7d373401d45ef4624cb16544c2f32194c8b7b195b5925a4c3be2d5bc3d)
            check_type(argname="argument num", value=num, expected_type=type_hints["num"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "signum", [num]))

    @jsii.member(jsii_name="slice")
    @builtins.classmethod
    def slice(
        cls,
        list: typing.Any,
        start_index: jsii.Number,
        end_index: jsii.Number,
    ) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/slice slice} extracts some consecutive elements from within a list.

        :param list: -
        :param start_index: -
        :param end_index: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__be9e2363d00dd9b553a2f0a52e9c220b1ea7b119413f87d0bc7ff14e9637cabd)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
            check_type(argname="argument start_index", value=start_index, expected_type=type_hints["start_index"])
            check_type(argname="argument end_index", value=end_index, expected_type=type_hints["end_index"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "slice", [list, start_index, end_index]))

    @jsii.member(jsii_name="sort")
    @builtins.classmethod
    def sort(cls, list: typing.Sequence[builtins.str]) -> typing.List[builtins.str]:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/sort sort} takes a list of strings and returns a new list with those strings sorted lexicographically.

        :param list: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d9e2e9c8efcb19d1fcd7b338592a731988ddadf6f94ad1e5128c264c1ac3cef2)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "sort", [list]))

    @jsii.member(jsii_name="split")
    @builtins.classmethod
    def split(
        cls,
        separator: builtins.str,
        str: builtins.str,
    ) -> typing.List[builtins.str]:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/split split} produces a list by dividing a given string at all occurrences of a given separator.

        :param separator: -
        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dcda6ccfb26d9f2d930154ee7126d06e489923b8ca4061933c94b7f23e7bc5d0)
            check_type(argname="argument separator", value=separator, expected_type=type_hints["separator"])
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "split", [separator, str]))

    @jsii.member(jsii_name="startswith")
    @builtins.classmethod
    def startswith(cls, str: builtins.str, prefix: builtins.str) -> "IResolvable":
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/startswith startswith} takes two values: a string to check and a prefix string. The function returns true if the string begins with that exact prefix.

        :param str: -
        :param prefix: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ce3531d9922b05b783bf6ec9d0c3589219ad35bc26c2c8bc1e0670144d18802d)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
        return typing.cast("IResolvable", jsii.sinvoke(cls, "startswith", [str, prefix]))

    @jsii.member(jsii_name="strrev")
    @builtins.classmethod
    def strrev(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/strrev strrev} reverses the characters in a string. Note that the characters are treated as *Unicode characters* (in technical terms, Unicode `grapheme cluster boundaries <https://unicode.org/reports/tr29/#Grapheme_Cluster_Boundaries>`_ are respected).

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f8de99a540c08e4bad7603a72aac90a85c48c36d685273f38476383477f023cc)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "strrev", [str]))

    @jsii.member(jsii_name="substr")
    @builtins.classmethod
    def substr(
        cls,
        str: builtins.str,
        offset: jsii.Number,
        length: jsii.Number,
    ) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/substr substr} extracts a substring from a given string by offset and (maximum) length.

        :param str: -
        :param offset: -
        :param length: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__964690f02488920761bec375dcfc23a2d5674190bdbfab4d98c0017d3e2a2dc8)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
            check_type(argname="argument offset", value=offset, expected_type=type_hints["offset"])
            check_type(argname="argument length", value=length, expected_type=type_hints["length"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "substr", [str, offset, length]))

    @jsii.member(jsii_name="sum")
    @builtins.classmethod
    def sum(cls, list: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/sum sum} takes a list or set of numbers and returns the sum of those numbers.

        :param list: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e0f058e1e10005661d3e670aaf0d2a857420ff1781b5776a3549b9c22eaa5215)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "sum", [list]))

    @jsii.member(jsii_name="templatefile")
    @builtins.classmethod
    def templatefile(cls, path: builtins.str, vars: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/templatefile templatefile} reads the file at the given path and renders its content as a template using a supplied set of template variables.

        :param path: -
        :param vars: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b03608af216453e9b22de2c53658267d1c6592dc05d6f3990ceb3dfae6f4bf51)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument vars", value=vars, expected_type=type_hints["vars"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "templatefile", [path, vars]))

    @jsii.member(jsii_name="textdecodebase64")
    @builtins.classmethod
    def textdecodebase64(
        cls,
        source: builtins.str,
        encoding: builtins.str,
    ) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/textdecodebase64 textdecodebase64} function decodes a string that was previously Base64-encoded, and then interprets the result as characters in a specified character encoding.

        :param source: -
        :param encoding: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a14ca1b9ffcc106035ce3b741ca5e0767a2dfd87e07202857d8ea29d60cb44ea)
            check_type(argname="argument source", value=source, expected_type=type_hints["source"])
            check_type(argname="argument encoding", value=encoding, expected_type=type_hints["encoding"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "textdecodebase64", [source, encoding]))

    @jsii.member(jsii_name="textencodebase64")
    @builtins.classmethod
    def textencodebase64(
        cls,
        str: builtins.str,
        encoding: builtins.str,
    ) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/textencodebase64 textencodebase64} encodes the unicode characters in a given string using a specified character encoding, returning the result base64 encoded because Terraform language strings are always sequences of unicode characters.

        :param str: -
        :param encoding: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d50339347c7b40b0955ae36a2d78ce3c8e4ddb61f40e4ff551d53516225b244)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
            check_type(argname="argument encoding", value=encoding, expected_type=type_hints["encoding"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "textencodebase64", [str, encoding]))

    @jsii.member(jsii_name="timeadd")
    @builtins.classmethod
    def timeadd(cls, timestamp: builtins.str, duration: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/timeadd timeadd} adds a duration to a timestamp, returning a new timestamp.

        :param timestamp: -
        :param duration: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__19d7acff3c681c153967bcffdf6c08fa2aa6037f22b41bfb2dd7e09de8422c94)
            check_type(argname="argument timestamp", value=timestamp, expected_type=type_hints["timestamp"])
            check_type(argname="argument duration", value=duration, expected_type=type_hints["duration"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "timeadd", [timestamp, duration]))

    @jsii.member(jsii_name="timecmp")
    @builtins.classmethod
    def timecmp(
        cls,
        timestamp_a: builtins.str,
        timestamp_b: builtins.str,
    ) -> jsii.Number:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/timecmp timecmp} compares two timestamps and returns a number that represents the ordering of the instants those timestamps represent.

        :param timestamp_a: -
        :param timestamp_b: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f384068dfd3d9fcc2b3f8c0b97abb143193e3144b49608124440429255046538)
            check_type(argname="argument timestamp_a", value=timestamp_a, expected_type=type_hints["timestamp_a"])
            check_type(argname="argument timestamp_b", value=timestamp_b, expected_type=type_hints["timestamp_b"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "timecmp", [timestamp_a, timestamp_b]))

    @jsii.member(jsii_name="timestamp")
    @builtins.classmethod
    def timestamp(cls) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/timestamp timestamp} returns a UTC timestamp string in `RFC 3339 <https://tools.ietf.org/html/rfc3339>`_ format.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sinvoke(cls, "timestamp", []))

    @jsii.member(jsii_name="title")
    @builtins.classmethod
    def title(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/title title} converts the first letter of each word in the given string to uppercase.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d3196d81e4be5893066de7efb57b2586c73cee23a4088e017f96650ea331b57a)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "title", [str]))

    @jsii.member(jsii_name="tobool")
    @builtins.classmethod
    def tobool(cls, v: typing.Any) -> "IResolvable":
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/tobool tobool} converts its argument to a boolean value.

        :param v: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__38a68cf0f491528218986aca6fca2a0adb02c11f87892815274acc13f3d2d757)
            check_type(argname="argument v", value=v, expected_type=type_hints["v"])
        return typing.cast("IResolvable", jsii.sinvoke(cls, "tobool", [v]))

    @jsii.member(jsii_name="tolist")
    @builtins.classmethod
    def tolist(cls, v: typing.Any) -> typing.List[builtins.str]:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/tolist tolist} converts its argument to a list value.

        :param v: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__15359a871c87aa8991a7d85f6d5fdda4a3937259f2c68b0ea364ad7651bcca61)
            check_type(argname="argument v", value=v, expected_type=type_hints["v"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "tolist", [v]))

    @jsii.member(jsii_name="tomap")
    @builtins.classmethod
    def tomap(cls, v: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/tomap tomap} converts its argument to a map value.

        :param v: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b87cf36013af1b929799abee868cbcc7fc8cfee2d2fe443130fc7e0cf7858ac6)
            check_type(argname="argument v", value=v, expected_type=type_hints["v"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "tomap", [v]))

    @jsii.member(jsii_name="tonumber")
    @builtins.classmethod
    def tonumber(cls, v: typing.Any) -> jsii.Number:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/tonumber tonumber} converts its argument to a number value.

        :param v: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__711bc6bfa95fd4c5626520390877df8fe872042f25e43802d368ffab9049faba)
            check_type(argname="argument v", value=v, expected_type=type_hints["v"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "tonumber", [v]))

    @jsii.member(jsii_name="toset")
    @builtins.classmethod
    def toset(cls, v: typing.Any) -> typing.List[builtins.str]:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/toset toset} converts its argument to a set value.

        :param v: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__02f98fb7d357ed43ccdb6e36328a5da722a13a55583db30790a62d101bafe025)
            check_type(argname="argument v", value=v, expected_type=type_hints["v"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "toset", [v]))

    @jsii.member(jsii_name="tostring")
    @builtins.classmethod
    def tostring(cls, v: typing.Any) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/tostring tostring} converts its argument to a string value.

        :param v: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1cb893b46225ff3f02f049d385834a81d9d22aad0977fd5783d69bfc2e71365c)
            check_type(argname="argument v", value=v, expected_type=type_hints["v"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "tostring", [v]))

    @jsii.member(jsii_name="transpose")
    @builtins.classmethod
    def transpose(cls, values: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/transpose transpose} takes a map of lists of strings and swaps the keys and values to produce a new map of lists of strings.

        :param values: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0b80761a1aa4c64987374a713ae032d7420f2a809aa6012a60c044fbf52a08f2)
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "transpose", [values]))

    @jsii.member(jsii_name="trim")
    @builtins.classmethod
    def trim(cls, str: builtins.str, cutset: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/trim trim} removes the specified set of characters from the start and end of the given string.

        :param str: -
        :param cutset: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fec6b4fb125d6bb3ad8a7c099b37a1acd2eb9b3af299aa84fafa7d77db69c87e)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
            check_type(argname="argument cutset", value=cutset, expected_type=type_hints["cutset"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "trim", [str, cutset]))

    @jsii.member(jsii_name="trimprefix")
    @builtins.classmethod
    def trimprefix(cls, str: builtins.str, prefix: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/trimprefix trimprefix} removes the specified prefix from the start of the given string. If the string does not start with the prefix, the string is returned unchanged.

        :param str: -
        :param prefix: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__644dbeff83549a3145c22c70ab41c8861975a5482e0812e9d88d8297fb67358b)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "trimprefix", [str, prefix]))

    @jsii.member(jsii_name="trimspace")
    @builtins.classmethod
    def trimspace(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/trimspace trimspace} removes any space characters from the start and end of the given string.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5a7174667a3bc9badc1d505b1b767da7f524802308d084f2d2426c6bb93e2f48)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "trimspace", [str]))

    @jsii.member(jsii_name="trimsuffix")
    @builtins.classmethod
    def trimsuffix(cls, str: builtins.str, suffix: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/trimsuffix trimsuffix} removes the specified suffix from the end of the given string.

        :param str: -
        :param suffix: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c09922adb3b4fe9e5ed8d7c0d51ff22b860c7d059631fa1ad8d71c6c6b645fd0)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
            check_type(argname="argument suffix", value=suffix, expected_type=type_hints["suffix"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "trimsuffix", [str, suffix]))

    @jsii.member(jsii_name="try")
    @builtins.classmethod
    def try_(cls, expressions: typing.Sequence[typing.Any]) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/try try} evaluates all of its argument expressions in turn and returns the result of the first one that does not produce any errors.

        :param expressions: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0800a6e4d1be9957cbd371209d3c1bb8da135a29cf6452f83c6b86a1e8c30379)
            check_type(argname="argument expressions", value=expressions, expected_type=type_hints["expressions"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "try", [expressions]))

    @jsii.member(jsii_name="upper")
    @builtins.classmethod
    def upper(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/upper upper} converts all cased letters in the given string to uppercase.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6993bb96ff70cc496e3b379329e214cc6e1f543689ad62effc81e3abed13aba4)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "upper", [str]))

    @jsii.member(jsii_name="urlencode")
    @builtins.classmethod
    def urlencode(cls, str: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/urlencode urlencode} applies URL encoding to a given string.

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fe80cfae330baf9ff30cc5fea7b8eddb142f7dde34f04f14b68d0f660018f7a3)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "urlencode", [str]))

    @jsii.member(jsii_name="uuid")
    @builtins.classmethod
    def uuid(cls) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/uuid uuid} generates a unique identifier string.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sinvoke(cls, "uuid", []))

    @jsii.member(jsii_name="uuidv5")
    @builtins.classmethod
    def uuidv5(cls, namespace: builtins.str, name: builtins.str) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/uuidv5 uuidv5} generates a *name-based* UUID, as described in `RFC 4122 section 4.3 <https://tools.ietf.org/html/rfc4122#section-4.3>`_, also known as a "version 5" UUID.

        :param namespace: -
        :param name: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a6ce5da977a0846fb7dca30da849682a446e9c25d467fefa5c978a4be1e77872)
            check_type(argname="argument namespace", value=namespace, expected_type=type_hints["namespace"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "uuidv5", [namespace, name]))

    @jsii.member(jsii_name="values")
    @builtins.classmethod
    def values(cls, mapping: typing.Any) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/values values} takes a map and returns a list containing the values of the elements in that map.

        :param mapping: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__63b91af2642b6fdc919168ec8fe3d17db811a56ef0aa20786ec538c36f6c1c61)
            check_type(argname="argument mapping", value=mapping, expected_type=type_hints["mapping"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "values", [mapping]))

    @jsii.member(jsii_name="yamldecode")
    @builtins.classmethod
    def yamldecode(cls, src: builtins.str) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/yamldecode yamldecode} parses a string as a subset of YAML, and produces a representation of its value.

        :param src: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__22b7a0aab96ae8c003c9d65635e87bffa97a8040602ffcf9c9f656b156556d2a)
            check_type(argname="argument src", value=src, expected_type=type_hints["src"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "yamldecode", [src]))

    @jsii.member(jsii_name="yamlencode")
    @builtins.classmethod
    def yamlencode(cls, value: typing.Any) -> builtins.str:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/yamlencode yamlencode} encodes a given value to a string using `YAML 1.2 <https://yaml.org/spec/1.2/spec.html>`_ block syntax.

        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__49f6bde9a7650c6a3f872a1123332fbba097ae9da2f6301fbb79479630d7284e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "yamlencode", [value]))

    @jsii.member(jsii_name="zipmap")
    @builtins.classmethod
    def zipmap(
        cls,
        keys: typing.Sequence[builtins.str],
        values: typing.Any,
    ) -> typing.Any:
        '''(experimental) {@link https://developer.hashicorp.com/terraform/language/functions/zipmap zipmap} constructs a map from a list of keys and a corresponding list of values.

        :param keys: -
        :param values: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__16eae308c5b490ba278431394cca47ee31e867b15d596d5154566c511eda0d5c)
            check_type(argname="argument keys", value=keys, expected_type=type_hints["keys"])
            check_type(argname="argument values", value=values, expected_type=type_hints["values"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "zipmap", [keys, values]))


@jsii.data_type(
    jsii_type="cdktf.GcsBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "bucket": "bucket",
        "access_token": "accessToken",
        "credentials": "credentials",
        "encryption_key": "encryptionKey",
        "impersonate_service_account": "impersonateServiceAccount",
        "impersonate_service_account_delegates": "impersonateServiceAccountDelegates",
        "prefix": "prefix",
    },
)
class GcsBackendConfig:
    def __init__(
        self,
        *,
        bucket: builtins.str,
        access_token: typing.Optional[builtins.str] = None,
        credentials: typing.Optional[builtins.str] = None,
        encryption_key: typing.Optional[builtins.str] = None,
        impersonate_service_account: typing.Optional[builtins.str] = None,
        impersonate_service_account_delegates: typing.Optional[typing.Sequence[builtins.str]] = None,
        prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Stores the state as an object in a configurable prefix in a pre-existing bucket on Google Cloud Storage (GCS).

        The bucket must exist prior to configuring the backend.

        This backend supports state locking.

        Warning! It is highly recommended that you enable Object Versioning on the GCS bucket
        to allow for state recovery in the case of accidental deletions and human error.

        Read more about this backend in the Terraform docs:
        https://developer.hashicorp.com/terraform/language/settings/backends/gcs

        :param bucket: (experimental) (Required) The name of the GCS bucket. This name must be globally unique.
        :param access_token: (experimental) (Optional) A temporary [OAuth 2.0 access token] obtained from the Google Authorization server, i.e. the Authorization: Bearer token used to authenticate HTTP requests to GCP APIs. This is an alternative to credentials. If both are specified, access_token will be used over the credentials field.
        :param credentials: (experimental) (Optional) Local path to Google Cloud Platform account credentials in JSON format. If unset, Google Application Default Credentials are used. The provided credentials must have Storage Object Admin role on the bucket. Warning: if using the Google Cloud Platform provider as well, it will also pick up the GOOGLE_CREDENTIALS environment variable.
        :param encryption_key: (experimental) (Optional) A 32 byte base64 encoded 'customer supplied encryption key' used to encrypt all state.
        :param impersonate_service_account: (experimental) (Optional) The service account to impersonate for accessing the State Bucket. You must have roles/iam.serviceAccountTokenCreator role on that account for the impersonation to succeed. If you are using a delegation chain, you can specify that using the impersonate_service_account_delegates field. Alternatively, this can be specified using the GOOGLE_IMPERSONATE_SERVICE_ACCOUNT environment variable.
        :param impersonate_service_account_delegates: (experimental) (Optional) The delegation chain for an impersonating a service account.
        :param prefix: (experimental) (Optional) GCS prefix inside the bucket. Named states for workspaces are stored in an object called /.tfstate.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0901c78bb055aae86058f8f1345bbe183f8d88adb52fa5ca2234fa51d09e2114)
            check_type(argname="argument bucket", value=bucket, expected_type=type_hints["bucket"])
            check_type(argname="argument access_token", value=access_token, expected_type=type_hints["access_token"])
            check_type(argname="argument credentials", value=credentials, expected_type=type_hints["credentials"])
            check_type(argname="argument encryption_key", value=encryption_key, expected_type=type_hints["encryption_key"])
            check_type(argname="argument impersonate_service_account", value=impersonate_service_account, expected_type=type_hints["impersonate_service_account"])
            check_type(argname="argument impersonate_service_account_delegates", value=impersonate_service_account_delegates, expected_type=type_hints["impersonate_service_account_delegates"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "bucket": bucket,
        }
        if access_token is not None:
            self._values["access_token"] = access_token
        if credentials is not None:
            self._values["credentials"] = credentials
        if encryption_key is not None:
            self._values["encryption_key"] = encryption_key
        if impersonate_service_account is not None:
            self._values["impersonate_service_account"] = impersonate_service_account
        if impersonate_service_account_delegates is not None:
            self._values["impersonate_service_account_delegates"] = impersonate_service_account_delegates
        if prefix is not None:
            self._values["prefix"] = prefix

    @builtins.property
    def bucket(self) -> builtins.str:
        '''(experimental) (Required) The name of the GCS bucket.

        This name must be globally unique.

        :stability: experimental
        '''
        result = self._values.get("bucket")
        assert result is not None, "Required property 'bucket' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def access_token(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) A temporary [OAuth 2.0 access token] obtained from the Google Authorization server, i.e. the Authorization: Bearer token used to authenticate HTTP requests to GCP APIs. This is an alternative to credentials. If both are specified, access_token will be used over the credentials field.

        :stability: experimental
        '''
        result = self._values.get("access_token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def credentials(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Local path to Google Cloud Platform account credentials in JSON format.

        If unset, Google Application Default Credentials are used.
        The provided credentials must have Storage Object Admin role on the bucket.

        Warning: if using the Google Cloud Platform provider as well,
        it will also pick up the GOOGLE_CREDENTIALS environment variable.

        :stability: experimental
        '''
        result = self._values.get("credentials")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def encryption_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) A 32 byte base64 encoded 'customer supplied encryption key' used to encrypt all state.

        :stability: experimental
        '''
        result = self._values.get("encryption_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def impersonate_service_account(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The service account to impersonate for accessing the State Bucket.

        You must have roles/iam.serviceAccountTokenCreator role on that account for the impersonation to succeed.
        If you are using a delegation chain, you can specify that using the impersonate_service_account_delegates field.
        Alternatively, this can be specified using the GOOGLE_IMPERSONATE_SERVICE_ACCOUNT environment variable.

        :stability: experimental
        '''
        result = self._values.get("impersonate_service_account")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def impersonate_service_account_delegates(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) (Optional) The delegation chain for an impersonating a service account.

        :stability: experimental
        '''
        result = self._values.get("impersonate_service_account_delegates")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) GCS prefix inside the bucket.

        Named states for workspaces are stored in an object called /.tfstate.

        :stability: experimental
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GcsBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.HttpBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "address": "address",
        "lock_address": "lockAddress",
        "lock_method": "lockMethod",
        "password": "password",
        "retry_max": "retryMax",
        "retry_wait_max": "retryWaitMax",
        "retry_wait_min": "retryWaitMin",
        "skip_cert_verification": "skipCertVerification",
        "unlock_address": "unlockAddress",
        "unlock_method": "unlockMethod",
        "update_method": "updateMethod",
        "username": "username",
    },
)
class HttpBackendConfig:
    def __init__(
        self,
        *,
        address: builtins.str,
        lock_address: typing.Optional[builtins.str] = None,
        lock_method: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        retry_max: typing.Optional[jsii.Number] = None,
        retry_wait_max: typing.Optional[jsii.Number] = None,
        retry_wait_min: typing.Optional[jsii.Number] = None,
        skip_cert_verification: typing.Optional[builtins.bool] = None,
        unlock_address: typing.Optional[builtins.str] = None,
        unlock_method: typing.Optional[builtins.str] = None,
        update_method: typing.Optional[builtins.str] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Stores the state using a simple REST client.

        State will be fetched via GET, updated via POST, and purged with DELETE.
        The method used for updating is configurable.

        This backend optionally supports state locking.
        When locking support is enabled it will use LOCK and UNLOCK requests providing the lock info in the body.
        The endpoint should return a 423: Locked or 409: Conflict with the holding lock info when
        it's already taken, 200: OK for success. Any other status will be considered an error.
        The ID of the holding lock info will be added as a query parameter to state updates requests.

        Read more about this backend in the Terraform docs:
        https://developer.hashicorp.com/terraform/language/settings/backends/http

        :param address: (experimental) (Required) The address of the REST endpoint.
        :param lock_address: (experimental) (Optional) The address of the lock REST endpoint. Defaults to disabled.
        :param lock_method: (experimental) (Optional) The HTTP method to use when locking. Defaults to LOCK.
        :param password: (experimental) (Optional) The password for HTTP basic authentication.
        :param retry_max: (experimental) (Optional) The number of HTTP request retries. Defaults to 2.
        :param retry_wait_max: (experimental) (Optional) The maximum time in seconds to wait between HTTP request attempts. Defaults to 30.
        :param retry_wait_min: (experimental) (Optional) The minimum time in seconds to wait between HTTP request attempts. Defaults to 1.
        :param skip_cert_verification: (experimental) (Optional) Whether to skip TLS verification. Defaults to false.
        :param unlock_address: (experimental) (Optional) The address of the unlock REST endpoint. Defaults to disabled.
        :param unlock_method: (experimental) (Optional) The HTTP method to use when unlocking. Defaults to UNLOCK.
        :param update_method: (experimental) (Optional) HTTP method to use when updating state. Defaults to POST.
        :param username: (experimental) (Optional) The username for HTTP basic authentication.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__66a0c61bf082086f6c5a3bff9c0c6e1dee7b7ce2b2f0ca56fc966246ca5110fe)
            check_type(argname="argument address", value=address, expected_type=type_hints["address"])
            check_type(argname="argument lock_address", value=lock_address, expected_type=type_hints["lock_address"])
            check_type(argname="argument lock_method", value=lock_method, expected_type=type_hints["lock_method"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument retry_max", value=retry_max, expected_type=type_hints["retry_max"])
            check_type(argname="argument retry_wait_max", value=retry_wait_max, expected_type=type_hints["retry_wait_max"])
            check_type(argname="argument retry_wait_min", value=retry_wait_min, expected_type=type_hints["retry_wait_min"])
            check_type(argname="argument skip_cert_verification", value=skip_cert_verification, expected_type=type_hints["skip_cert_verification"])
            check_type(argname="argument unlock_address", value=unlock_address, expected_type=type_hints["unlock_address"])
            check_type(argname="argument unlock_method", value=unlock_method, expected_type=type_hints["unlock_method"])
            check_type(argname="argument update_method", value=update_method, expected_type=type_hints["update_method"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "address": address,
        }
        if lock_address is not None:
            self._values["lock_address"] = lock_address
        if lock_method is not None:
            self._values["lock_method"] = lock_method
        if password is not None:
            self._values["password"] = password
        if retry_max is not None:
            self._values["retry_max"] = retry_max
        if retry_wait_max is not None:
            self._values["retry_wait_max"] = retry_wait_max
        if retry_wait_min is not None:
            self._values["retry_wait_min"] = retry_wait_min
        if skip_cert_verification is not None:
            self._values["skip_cert_verification"] = skip_cert_verification
        if unlock_address is not None:
            self._values["unlock_address"] = unlock_address
        if unlock_method is not None:
            self._values["unlock_method"] = unlock_method
        if update_method is not None:
            self._values["update_method"] = update_method
        if username is not None:
            self._values["username"] = username

    @builtins.property
    def address(self) -> builtins.str:
        '''(experimental) (Required) The address of the REST endpoint.

        :stability: experimental
        '''
        result = self._values.get("address")
        assert result is not None, "Required property 'address' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def lock_address(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The address of the lock REST endpoint.

        Defaults to disabled.

        :stability: experimental
        '''
        result = self._values.get("lock_address")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lock_method(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The HTTP method to use when locking.

        Defaults to LOCK.

        :stability: experimental
        '''
        result = self._values.get("lock_method")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The password for HTTP basic authentication.

        :stability: experimental
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def retry_max(self) -> typing.Optional[jsii.Number]:
        '''(experimental) (Optional) The number of HTTP request retries.

        Defaults to 2.

        :stability: experimental
        '''
        result = self._values.get("retry_max")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def retry_wait_max(self) -> typing.Optional[jsii.Number]:
        '''(experimental) (Optional) The maximum time in seconds to wait between HTTP request attempts.

        Defaults to 30.

        :stability: experimental
        '''
        result = self._values.get("retry_wait_max")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def retry_wait_min(self) -> typing.Optional[jsii.Number]:
        '''(experimental) (Optional) The minimum time in seconds to wait between HTTP request attempts.

        Defaults to 1.

        :stability: experimental
        '''
        result = self._values.get("retry_wait_min")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def skip_cert_verification(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Whether to skip TLS verification.

        Defaults to false.

        :stability: experimental
        '''
        result = self._values.get("skip_cert_verification")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def unlock_address(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The address of the unlock REST endpoint.

        Defaults to disabled.

        :stability: experimental
        '''
        result = self._values.get("unlock_address")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unlock_method(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The HTTP method to use when unlocking.

        Defaults to UNLOCK.

        :stability: experimental
        '''
        result = self._values.get("unlock_method")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def update_method(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) HTTP method to use when updating state.

        Defaults to POST.

        :stability: experimental
        '''
        result = self._values.get("update_method")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def username(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The username for HTTP basic authentication.

        :stability: experimental
        '''
        result = self._values.get("username")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HttpBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.interface(jsii_type="cdktf.IAnyProducer")
class IAnyProducer(typing_extensions.Protocol):
    '''(experimental) Interface for lazy untyped value producers.

    :stability: experimental
    '''

    @jsii.member(jsii_name="produce")
    def produce(self, context: "IResolveContext") -> typing.Any:
        '''(experimental) Produce the value.

        :param context: -

        :stability: experimental
        '''
        ...


class _IAnyProducerProxy:
    '''(experimental) Interface for lazy untyped value producers.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IAnyProducer"

    @jsii.member(jsii_name="produce")
    def produce(self, context: "IResolveContext") -> typing.Any:
        '''(experimental) Produce the value.

        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__408aff0be511b5e75036666634bf04def1952d04a81244a15cf6206c595c71ce)
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "produce", [context]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IAnyProducer).__jsii_proxy_class__ = lambda : _IAnyProducerProxy


@jsii.interface(jsii_type="cdktf.IAspect")
class IAspect(typing_extensions.Protocol):
    '''(experimental) Represents an Aspect.

    :stability: experimental
    '''

    @jsii.member(jsii_name="visit")
    def visit(self, node: _constructs_77d1e7e8.IConstruct) -> None:
        '''(experimental) All aspects can visit an IConstruct.

        :param node: -

        :stability: experimental
        '''
        ...


class _IAspectProxy:
    '''(experimental) Represents an Aspect.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IAspect"

    @jsii.member(jsii_name="visit")
    def visit(self, node: _constructs_77d1e7e8.IConstruct) -> None:
        '''(experimental) All aspects can visit an IConstruct.

        :param node: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3dc0501348fa83d7001a4755b48e62430daa3d98fc3df818f90242b09608b99c)
            check_type(argname="argument node", value=node, expected_type=type_hints["node"])
        return typing.cast(None, jsii.invoke(self, "visit", [node]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IAspect).__jsii_proxy_class__ = lambda : _IAspectProxy


@jsii.interface(jsii_type="cdktf.IFragmentConcatenator")
class IFragmentConcatenator(typing_extensions.Protocol):
    '''(experimental) Function used to concatenate symbols in the target document language.

    Interface so it could potentially be exposed over jsii.

    :stability: experimental
    '''

    @jsii.member(jsii_name="join")
    def join(self, left: typing.Any, right: typing.Any) -> typing.Any:
        '''(experimental) Join the fragment on the left and on the right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        ...


class _IFragmentConcatenatorProxy:
    '''(experimental) Function used to concatenate symbols in the target document language.

    Interface so it could potentially be exposed over jsii.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IFragmentConcatenator"

    @jsii.member(jsii_name="join")
    def join(self, left: typing.Any, right: typing.Any) -> typing.Any:
        '''(experimental) Join the fragment on the left and on the right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__02932dc0cd57f2f443384238dad4ba2a94f06916fb3aadc1ffa512e449edc65f)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(typing.Any, jsii.invoke(self, "join", [left, right]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IFragmentConcatenator).__jsii_proxy_class__ = lambda : _IFragmentConcatenatorProxy


@jsii.interface(jsii_type="cdktf.IInterpolatingParent")
class IInterpolatingParent(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    @jsii.member(jsii_name="interpolationForAttribute")
    def interpolation_for_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> "IResolvable":
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        ...


class _IInterpolatingParentProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IInterpolatingParent"

    @jsii.member(jsii_name="interpolationForAttribute")
    def interpolation_for_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> "IResolvable":
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4af2e5c3a60517fffc7cdb81e9b8f24b4d5e856aa06af62386d8e3717ad23ab5)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast("IResolvable", jsii.invoke(self, "interpolationForAttribute", [terraform_attribute]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IInterpolatingParent).__jsii_proxy_class__ = lambda : _IInterpolatingParentProxy


@jsii.interface(jsii_type="cdktf.IListProducer")
class IListProducer(typing_extensions.Protocol):
    '''(experimental) Interface for lazy list producers.

    :stability: experimental
    '''

    @jsii.member(jsii_name="produce")
    def produce(
        self,
        context: "IResolveContext",
    ) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Produce the list value.

        :param context: -

        :stability: experimental
        '''
        ...


class _IListProducerProxy:
    '''(experimental) Interface for lazy list producers.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IListProducer"

    @jsii.member(jsii_name="produce")
    def produce(
        self,
        context: "IResolveContext",
    ) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Produce the list value.

        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5e642f3e06c850183ef0ee34aa8a105f37a333867e67cd5c364756660eef8dc6)
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.invoke(self, "produce", [context]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IListProducer).__jsii_proxy_class__ = lambda : _IListProducerProxy


@jsii.interface(jsii_type="cdktf.IManifest")
class IManifest(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    @builtins.property
    @jsii.member(jsii_name="stacks")
    def stacks(self) -> typing.Mapping[builtins.str, "StackManifest"]:
        '''
        :stability: experimental
        '''
        ...

    @builtins.property
    @jsii.member(jsii_name="version")
    def version(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        ...


class _IManifestProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IManifest"

    @builtins.property
    @jsii.member(jsii_name="stacks")
    def stacks(self) -> typing.Mapping[builtins.str, "StackManifest"]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, "StackManifest"], jsii.get(self, "stacks"))

    @builtins.property
    @jsii.member(jsii_name="version")
    def version(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "version"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IManifest).__jsii_proxy_class__ = lambda : _IManifestProxy


@jsii.interface(jsii_type="cdktf.INumberProducer")
class INumberProducer(typing_extensions.Protocol):
    '''(experimental) Interface for lazy number producers.

    :stability: experimental
    '''

    @jsii.member(jsii_name="produce")
    def produce(self, context: "IResolveContext") -> typing.Optional[jsii.Number]:
        '''(experimental) Produce the number value.

        :param context: -

        :stability: experimental
        '''
        ...


class _INumberProducerProxy:
    '''(experimental) Interface for lazy number producers.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.INumberProducer"

    @jsii.member(jsii_name="produce")
    def produce(self, context: "IResolveContext") -> typing.Optional[jsii.Number]:
        '''(experimental) Produce the number value.

        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99b88e6fd773a2ac52e6f4557465e5b6a5724f0e40c0f7354f1f3045ba6df29e)
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Optional[jsii.Number], jsii.invoke(self, "produce", [context]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, INumberProducer).__jsii_proxy_class__ = lambda : _INumberProducerProxy


@jsii.interface(jsii_type="cdktf.IPostProcessor")
class IPostProcessor(typing_extensions.Protocol):
    '''(experimental) A Token that can post-process the complete resolved value, after resolve() has recursed over it.

    :stability: experimental
    '''

    @jsii.member(jsii_name="postProcess")
    def post_process(self, input: typing.Any, context: "IResolveContext") -> typing.Any:
        '''(experimental) Process the completely resolved value, after full recursion/resolution has happened.

        :param input: -
        :param context: -

        :stability: experimental
        '''
        ...


class _IPostProcessorProxy:
    '''(experimental) A Token that can post-process the complete resolved value, after resolve() has recursed over it.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IPostProcessor"

    @jsii.member(jsii_name="postProcess")
    def post_process(self, input: typing.Any, context: "IResolveContext") -> typing.Any:
        '''(experimental) Process the completely resolved value, after full recursion/resolution has happened.

        :param input: -
        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f12db1ece5782c5faeb90088f15a52607b7395355d19050f419185760f3e0e64)
            check_type(argname="argument input", value=input, expected_type=type_hints["input"])
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "postProcess", [input, context]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IPostProcessor).__jsii_proxy_class__ = lambda : _IPostProcessorProxy


@jsii.interface(jsii_type="cdktf.IRemoteWorkspace")
class IRemoteWorkspace(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    pass


class _IRemoteWorkspaceProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IRemoteWorkspace"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IRemoteWorkspace).__jsii_proxy_class__ = lambda : _IRemoteWorkspaceProxy


@jsii.interface(jsii_type="cdktf.IResolvable")
class IResolvable(typing_extensions.Protocol):
    '''(experimental) Interface for values that can be resolvable later.

    Tokens are special objects that participate in synthesis.

    :stability: experimental
    '''

    @builtins.property
    @jsii.member(jsii_name="creationStack")
    def creation_stack(self) -> typing.List[builtins.str]:
        '''(experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.

        If this returns an empty array the stack will not be attached.

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="resolve")
    def resolve(self, context: "IResolveContext") -> typing.Any:
        '''(experimental) Produce the Token's value at resolution time.

        :param context: -

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Return a string representation of this resolvable object.

        Returns a reversible string representation.

        :stability: experimental
        '''
        ...


class _IResolvableProxy:
    '''(experimental) Interface for values that can be resolvable later.

    Tokens are special objects that participate in synthesis.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IResolvable"

    @builtins.property
    @jsii.member(jsii_name="creationStack")
    def creation_stack(self) -> typing.List[builtins.str]:
        '''(experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.

        If this returns an empty array the stack will not be attached.

        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "creationStack"))

    @jsii.member(jsii_name="resolve")
    def resolve(self, context: "IResolveContext") -> typing.Any:
        '''(experimental) Produce the Token's value at resolution time.

        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__53943d46b711ae4215442ac320e17ab3cd95847a08a629a0e4dc79d10d4448e9)
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolve", [context]))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Return a string representation of this resolvable object.

        Returns a reversible string representation.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IResolvable).__jsii_proxy_class__ = lambda : _IResolvableProxy


@jsii.interface(jsii_type="cdktf.IResolveContext")
class IResolveContext(typing_extensions.Protocol):
    '''(experimental) Current resolution context for tokens.

    :stability: experimental
    '''

    @builtins.property
    @jsii.member(jsii_name="preparing")
    def preparing(self) -> builtins.bool:
        '''(experimental) True when we are still preparing, false if we're rendering the final output.

        :stability: experimental
        '''
        ...

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> _constructs_77d1e7e8.IConstruct:
        '''(experimental) The scope from which resolution has been initiated.

        :stability: experimental
        '''
        ...

    @builtins.property
    @jsii.member(jsii_name="ignoreEscapes")
    def ignore_escapes(self) -> typing.Optional[builtins.bool]:
        '''(experimental) True when ${} should not be parsed, and treated as literals.

        :stability: experimental
        '''
        ...

    @ignore_escapes.setter
    def ignore_escapes(self, value: typing.Optional[builtins.bool]) -> None:
        ...

    @builtins.property
    @jsii.member(jsii_name="iteratorContext")
    def iterator_context(self) -> typing.Optional[builtins.str]:
        '''(experimental) TerraformIterators can be passed for block attributes and normal list attributes both require different handling when the iterable variable is accessed e.g. a dynamic block needs each.key while a for expression just needs key.

        :stability: experimental
        '''
        ...

    @iterator_context.setter
    def iterator_context(self, value: typing.Optional[builtins.str]) -> None:
        ...

    @builtins.property
    @jsii.member(jsii_name="suppressBraces")
    def suppress_braces(self) -> typing.Optional[builtins.bool]:
        '''(experimental) True when ${} should be ommitted (because already inside them), false otherwise.

        :stability: experimental
        '''
        ...

    @suppress_braces.setter
    def suppress_braces(self, value: typing.Optional[builtins.bool]) -> None:
        ...

    @builtins.property
    @jsii.member(jsii_name="warnEscapes")
    def warn_escapes(self) -> typing.Optional[builtins.bool]:
        '''(experimental) True when ${} should not be included in the string to be resolved, outputs a warning.

        Default: false

        :stability: experimental
        '''
        ...

    @warn_escapes.setter
    def warn_escapes(self, value: typing.Optional[builtins.bool]) -> None:
        ...

    @jsii.member(jsii_name="registerPostProcessor")
    def register_post_processor(self, post_processor: IPostProcessor) -> None:
        '''(experimental) Use this postprocessor after the entire token structure has been resolved.

        :param post_processor: -

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="resolve")
    def resolve(self, x: typing.Any) -> typing.Any:
        '''(experimental) Resolve an inner object.

        :param x: -

        :stability: experimental
        '''
        ...


class _IResolveContextProxy:
    '''(experimental) Current resolution context for tokens.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IResolveContext"

    @builtins.property
    @jsii.member(jsii_name="preparing")
    def preparing(self) -> builtins.bool:
        '''(experimental) True when we are still preparing, false if we're rendering the final output.

        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "preparing"))

    @builtins.property
    @jsii.member(jsii_name="scope")
    def scope(self) -> _constructs_77d1e7e8.IConstruct:
        '''(experimental) The scope from which resolution has been initiated.

        :stability: experimental
        '''
        return typing.cast(_constructs_77d1e7e8.IConstruct, jsii.get(self, "scope"))

    @builtins.property
    @jsii.member(jsii_name="ignoreEscapes")
    def ignore_escapes(self) -> typing.Optional[builtins.bool]:
        '''(experimental) True when ${} should not be parsed, and treated as literals.

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "ignoreEscapes"))

    @ignore_escapes.setter
    def ignore_escapes(self, value: typing.Optional[builtins.bool]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2d045c32c3843ecb1f3038199a7ff138876f3c44213872749a1e2f05b02bbb64)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "ignoreEscapes", value)

    @builtins.property
    @jsii.member(jsii_name="iteratorContext")
    def iterator_context(self) -> typing.Optional[builtins.str]:
        '''(experimental) TerraformIterators can be passed for block attributes and normal list attributes both require different handling when the iterable variable is accessed e.g. a dynamic block needs each.key while a for expression just needs key.

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "iteratorContext"))

    @iterator_context.setter
    def iterator_context(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__df0aed023b1a6bb2a5942d31571a2c82f7943c0ed3f0273c7e392a5f17c9dba5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "iteratorContext", value)

    @builtins.property
    @jsii.member(jsii_name="suppressBraces")
    def suppress_braces(self) -> typing.Optional[builtins.bool]:
        '''(experimental) True when ${} should be ommitted (because already inside them), false otherwise.

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "suppressBraces"))

    @suppress_braces.setter
    def suppress_braces(self, value: typing.Optional[builtins.bool]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4ee9a25361314f3294b2ce29269088372ce1a7521e4a8aed8f1b21a0fa14088f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "suppressBraces", value)

    @builtins.property
    @jsii.member(jsii_name="warnEscapes")
    def warn_escapes(self) -> typing.Optional[builtins.bool]:
        '''(experimental) True when ${} should not be included in the string to be resolved, outputs a warning.

        Default: false

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "warnEscapes"))

    @warn_escapes.setter
    def warn_escapes(self, value: typing.Optional[builtins.bool]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__416cd845f107057b46df79125c38f21a932c3e9b9c302eb5c000cfd839bce1e9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "warnEscapes", value)

    @jsii.member(jsii_name="registerPostProcessor")
    def register_post_processor(self, post_processor: IPostProcessor) -> None:
        '''(experimental) Use this postprocessor after the entire token structure has been resolved.

        :param post_processor: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cee7cf418f70ff167de576f01a6e6c1dd4241af12de68c3ec42d782032ec6128)
            check_type(argname="argument post_processor", value=post_processor, expected_type=type_hints["post_processor"])
        return typing.cast(None, jsii.invoke(self, "registerPostProcessor", [post_processor]))

    @jsii.member(jsii_name="resolve")
    def resolve(self, x: typing.Any) -> typing.Any:
        '''(experimental) Resolve an inner object.

        :param x: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__074dc0971179213112b18a4ab5d483d92a8c44a2da4f36e7ac1e6135105ff443)
            check_type(argname="argument x", value=x, expected_type=type_hints["x"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolve", [x]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IResolveContext).__jsii_proxy_class__ = lambda : _IResolveContextProxy


@jsii.interface(jsii_type="cdktf.IResource")
class IResource(_constructs_77d1e7e8.IConstruct, typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    @builtins.property
    @jsii.member(jsii_name="stack")
    def stack(self) -> "TerraformStack":
        '''(experimental) The stack in which this resource is defined.

        :stability: experimental
        '''
        ...


class _IResourceProxy(
    jsii.proxy_for(_constructs_77d1e7e8.IConstruct), # type: ignore[misc]
):
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IResource"

    @builtins.property
    @jsii.member(jsii_name="stack")
    def stack(self) -> "TerraformStack":
        '''(experimental) The stack in which this resource is defined.

        :stability: experimental
        '''
        return typing.cast("TerraformStack", jsii.get(self, "stack"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IResource).__jsii_proxy_class__ = lambda : _IResourceProxy


@jsii.interface(jsii_type="cdktf.IResourceConstructor")
class IResourceConstructor(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    pass


class _IResourceConstructorProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IResourceConstructor"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IResourceConstructor).__jsii_proxy_class__ = lambda : _IResourceConstructorProxy


@jsii.interface(jsii_type="cdktf.IScopeCallback")
class IScopeCallback(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    pass


class _IScopeCallbackProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IScopeCallback"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IScopeCallback).__jsii_proxy_class__ = lambda : _IScopeCallbackProxy


@jsii.interface(jsii_type="cdktf.IStackSynthesizer")
class IStackSynthesizer(typing_extensions.Protocol):
    '''(experimental) Encodes information how a certain Stack should be deployed inspired by AWS CDK v2 implementation (synth functionality was removed in constructs v10).

    :stability: experimental
    '''

    @jsii.member(jsii_name="synthesize")
    def synthesize(self, session: "ISynthesisSession") -> None:
        '''(experimental) Synthesize the associated stack to the session.

        :param session: -

        :stability: experimental
        '''
        ...


class _IStackSynthesizerProxy:
    '''(experimental) Encodes information how a certain Stack should be deployed inspired by AWS CDK v2 implementation (synth functionality was removed in constructs v10).

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IStackSynthesizer"

    @jsii.member(jsii_name="synthesize")
    def synthesize(self, session: "ISynthesisSession") -> None:
        '''(experimental) Synthesize the associated stack to the session.

        :param session: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f429129880bed95d4db1adbdf8d6731662b4b58f7c5fd19f02779277de68b9e)
            check_type(argname="argument session", value=session, expected_type=type_hints["session"])
        return typing.cast(None, jsii.invoke(self, "synthesize", [session]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IStackSynthesizer).__jsii_proxy_class__ = lambda : _IStackSynthesizerProxy


@jsii.interface(jsii_type="cdktf.IStringProducer")
class IStringProducer(typing_extensions.Protocol):
    '''(experimental) Interface for lazy string producers.

    :stability: experimental
    '''

    @jsii.member(jsii_name="produce")
    def produce(self, context: IResolveContext) -> typing.Optional[builtins.str]:
        '''(experimental) Produce the string value.

        :param context: -

        :stability: experimental
        '''
        ...


class _IStringProducerProxy:
    '''(experimental) Interface for lazy string producers.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.IStringProducer"

    @jsii.member(jsii_name="produce")
    def produce(self, context: IResolveContext) -> typing.Optional[builtins.str]:
        '''(experimental) Produce the string value.

        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dfae5b58613a27e53a2a8814b2066785790667df47708b1197229c2f7bab0781)
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "produce", [context]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IStringProducer).__jsii_proxy_class__ = lambda : _IStringProducerProxy


@jsii.interface(jsii_type="cdktf.ISynthesisSession")
class ISynthesisSession(typing_extensions.Protocol):
    '''(experimental) Represents a single session of synthesis.

    Passed into ``TerraformStack.onSynthesize()`` methods.
    originally from aws/constructs lib v3.3.126 (synth functionality was removed in constructs v10)

    :stability: experimental
    '''

    @builtins.property
    @jsii.member(jsii_name="manifest")
    def manifest(self) -> "Manifest":
        '''
        :stability: experimental
        '''
        ...

    @builtins.property
    @jsii.member(jsii_name="outdir")
    def outdir(self) -> builtins.str:
        '''(experimental) The output directory for this synthesis session.

        :stability: experimental
        '''
        ...

    @builtins.property
    @jsii.member(jsii_name="skipValidation")
    def skip_validation(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        ...


class _ISynthesisSessionProxy:
    '''(experimental) Represents a single session of synthesis.

    Passed into ``TerraformStack.onSynthesize()`` methods.
    originally from aws/constructs lib v3.3.126 (synth functionality was removed in constructs v10)

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.ISynthesisSession"

    @builtins.property
    @jsii.member(jsii_name="manifest")
    def manifest(self) -> "Manifest":
        '''
        :stability: experimental
        '''
        return typing.cast("Manifest", jsii.get(self, "manifest"))

    @builtins.property
    @jsii.member(jsii_name="outdir")
    def outdir(self) -> builtins.str:
        '''(experimental) The output directory for this synthesis session.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "outdir"))

    @builtins.property
    @jsii.member(jsii_name="skipValidation")
    def skip_validation(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "skipValidation"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ISynthesisSession).__jsii_proxy_class__ = lambda : _ISynthesisSessionProxy


@jsii.interface(jsii_type="cdktf.ITerraformAddressable")
class ITerraformAddressable(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        ...


class _ITerraformAddressableProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.ITerraformAddressable"

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ITerraformAddressable).__jsii_proxy_class__ = lambda : _ITerraformAddressableProxy


@jsii.interface(jsii_type="cdktf.ITerraformDependable")
class ITerraformDependable(ITerraformAddressable, typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    pass


class _ITerraformDependableProxy(
    jsii.proxy_for(ITerraformAddressable), # type: ignore[misc]
):
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.ITerraformDependable"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ITerraformDependable).__jsii_proxy_class__ = lambda : _ITerraformDependableProxy


@jsii.interface(jsii_type="cdktf.ITerraformIterator")
class ITerraformIterator(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    pass


class _ITerraformIteratorProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.ITerraformIterator"
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ITerraformIterator).__jsii_proxy_class__ = lambda : _ITerraformIteratorProxy


@jsii.interface(jsii_type="cdktf.ITerraformResource")
class ITerraformResource(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        ...

    @builtins.property
    @jsii.member(jsii_name="friendlyUniqueId")
    def friendly_unique_id(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        ...

    @builtins.property
    @jsii.member(jsii_name="terraformResourceType")
    def terraform_resource_type(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        ...

    @builtins.property
    @jsii.member(jsii_name="count")
    def count(self) -> typing.Optional[typing.Union[jsii.Number, "TerraformCount"]]:
        '''
        :stability: experimental
        '''
        ...

    @count.setter
    def count(
        self,
        value: typing.Optional[typing.Union[jsii.Number, "TerraformCount"]],
    ) -> None:
        ...

    @builtins.property
    @jsii.member(jsii_name="dependsOn")
    def depends_on(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        '''
        ...

    @depends_on.setter
    def depends_on(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        ...

    @builtins.property
    @jsii.member(jsii_name="forEach")
    def for_each(self) -> typing.Optional[ITerraformIterator]:
        '''
        :stability: experimental
        '''
        ...

    @for_each.setter
    def for_each(self, value: typing.Optional[ITerraformIterator]) -> None:
        ...

    @builtins.property
    @jsii.member(jsii_name="lifecycle")
    def lifecycle(self) -> typing.Optional["TerraformResourceLifecycle"]:
        '''
        :stability: experimental
        '''
        ...

    @lifecycle.setter
    def lifecycle(self, value: typing.Optional["TerraformResourceLifecycle"]) -> None:
        ...

    @builtins.property
    @jsii.member(jsii_name="provider")
    def provider(self) -> typing.Optional["TerraformProvider"]:
        '''
        :stability: experimental
        '''
        ...

    @provider.setter
    def provider(self, value: typing.Optional["TerraformProvider"]) -> None:
        ...

    @jsii.member(jsii_name="interpolationForAttribute")
    def interpolation_for_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> IResolvable:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        ...


class _ITerraformResourceProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.ITerraformResource"

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

    @builtins.property
    @jsii.member(jsii_name="friendlyUniqueId")
    def friendly_unique_id(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "friendlyUniqueId"))

    @builtins.property
    @jsii.member(jsii_name="terraformResourceType")
    def terraform_resource_type(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformResourceType"))

    @builtins.property
    @jsii.member(jsii_name="count")
    def count(self) -> typing.Optional[typing.Union[jsii.Number, "TerraformCount"]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.Union[jsii.Number, "TerraformCount"]], jsii.get(self, "count"))

    @count.setter
    def count(
        self,
        value: typing.Optional[typing.Union[jsii.Number, "TerraformCount"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7716bb7607abdfdae2dbe39be76942dfe40b9dff4bf6d0cbd59e5c9466ba9bfd)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "count", value)

    @builtins.property
    @jsii.member(jsii_name="dependsOn")
    def depends_on(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "dependsOn"))

    @depends_on.setter
    def depends_on(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a86c5f50cefbd0c866ec9ebe4686aefe4a8b0ddfcb4a74c1a0050ed300139f69)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dependsOn", value)

    @builtins.property
    @jsii.member(jsii_name="forEach")
    def for_each(self) -> typing.Optional[ITerraformIterator]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[ITerraformIterator], jsii.get(self, "forEach"))

    @for_each.setter
    def for_each(self, value: typing.Optional[ITerraformIterator]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d764556635ab11f85f79abae2fc0f1d258c535f3ca1b70630a8fc2514035bfca)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "forEach", value)

    @builtins.property
    @jsii.member(jsii_name="lifecycle")
    def lifecycle(self) -> typing.Optional["TerraformResourceLifecycle"]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional["TerraformResourceLifecycle"], jsii.get(self, "lifecycle"))

    @lifecycle.setter
    def lifecycle(self, value: typing.Optional["TerraformResourceLifecycle"]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__49387ce6215fd5b6c9c60e44af1edcb883a441072d2d619780f0c23be6d9629f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "lifecycle", value)

    @builtins.property
    @jsii.member(jsii_name="provider")
    def provider(self) -> typing.Optional["TerraformProvider"]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional["TerraformProvider"], jsii.get(self, "provider"))

    @provider.setter
    def provider(self, value: typing.Optional["TerraformProvider"]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bafb01b0c4c2a3919ac610ab063b895a46b3de20ba785e0fe8f9e6e937ce4a1b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "provider", value)

    @jsii.member(jsii_name="interpolationForAttribute")
    def interpolation_for_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> IResolvable:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__276f0b8f659f75ea863e6ce0b436cd9d7d46a15dc47757dd02adeaa91e487c75)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(IResolvable, jsii.invoke(self, "interpolationForAttribute", [terraform_attribute]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ITerraformResource).__jsii_proxy_class__ = lambda : _ITerraformResourceProxy


@jsii.interface(jsii_type="cdktf.ITokenMapper")
class ITokenMapper(typing_extensions.Protocol):
    '''(experimental) Interface to apply operation to tokens in a string.

    Interface so it can be exported via jsii.

    :stability: experimental
    '''

    @jsii.member(jsii_name="mapToken")
    def map_token(self, t: IResolvable) -> typing.Any:
        '''(experimental) Replace a single token.

        :param t: -

        :stability: experimental
        '''
        ...


class _ITokenMapperProxy:
    '''(experimental) Interface to apply operation to tokens in a string.

    Interface so it can be exported via jsii.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.ITokenMapper"

    @jsii.member(jsii_name="mapToken")
    def map_token(self, t: IResolvable) -> typing.Any:
        '''(experimental) Replace a single token.

        :param t: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4d6c69b955c151149bef0229e15b37f9060ec6070e1ca444185b9a17bf3a10c9)
            check_type(argname="argument t", value=t, expected_type=type_hints["t"])
        return typing.cast(typing.Any, jsii.invoke(self, "mapToken", [t]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ITokenMapper).__jsii_proxy_class__ = lambda : _ITokenMapperProxy


@jsii.interface(jsii_type="cdktf.ITokenResolver")
class ITokenResolver(typing_extensions.Protocol):
    '''(experimental) How to resolve tokens.

    :stability: experimental
    '''

    @jsii.member(jsii_name="resolveList")
    def resolve_list(
        self,
        l: typing.Sequence[builtins.str],
        context: IResolveContext,
    ) -> typing.Any:
        '''(experimental) Resolve a tokenized list.

        :param l: -
        :param context: -

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="resolveMap")
    def resolve_map(
        self,
        m: typing.Mapping[builtins.str, typing.Any],
        context: IResolveContext,
    ) -> typing.Any:
        '''(experimental) Resolve a tokenized map.

        :param m: -
        :param context: -

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="resolveNumberList")
    def resolve_number_list(
        self,
        l: typing.Sequence[jsii.Number],
        context: IResolveContext,
    ) -> typing.Any:
        '''(experimental) Resolve a tokenized number list.

        :param l: -
        :param context: -

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="resolveString")
    def resolve_string(
        self,
        s: "TokenizedStringFragments",
        context: IResolveContext,
    ) -> typing.Any:
        '''(experimental) Resolve a string with at least one stringified token in it.

        (May use concatenation)

        :param s: -
        :param context: -

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="resolveToken")
    def resolve_token(
        self,
        t: IResolvable,
        context: IResolveContext,
        post_processor: IPostProcessor,
    ) -> typing.Any:
        '''(experimental) Resolve a single token.

        :param t: -
        :param context: -
        :param post_processor: -

        :stability: experimental
        '''
        ...


class _ITokenResolverProxy:
    '''(experimental) How to resolve tokens.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdktf.ITokenResolver"

    @jsii.member(jsii_name="resolveList")
    def resolve_list(
        self,
        l: typing.Sequence[builtins.str],
        context: IResolveContext,
    ) -> typing.Any:
        '''(experimental) Resolve a tokenized list.

        :param l: -
        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__34fe7a5bbf1da89be72e7c265a821a1ba6cbb8fcd65e35025ded809a91fdcbfd)
            check_type(argname="argument l", value=l, expected_type=type_hints["l"])
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolveList", [l, context]))

    @jsii.member(jsii_name="resolveMap")
    def resolve_map(
        self,
        m: typing.Mapping[builtins.str, typing.Any],
        context: IResolveContext,
    ) -> typing.Any:
        '''(experimental) Resolve a tokenized map.

        :param m: -
        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e3acf445e8a018e959d82cf331ccbf1239173e5eeea38acf9a765dc2bf4bc0c6)
            check_type(argname="argument m", value=m, expected_type=type_hints["m"])
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolveMap", [m, context]))

    @jsii.member(jsii_name="resolveNumberList")
    def resolve_number_list(
        self,
        l: typing.Sequence[jsii.Number],
        context: IResolveContext,
    ) -> typing.Any:
        '''(experimental) Resolve a tokenized number list.

        :param l: -
        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e57d79513cb8aea904659c6d60434ddffa3bfcfd86bd6b6c39b1293d650ff096)
            check_type(argname="argument l", value=l, expected_type=type_hints["l"])
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolveNumberList", [l, context]))

    @jsii.member(jsii_name="resolveString")
    def resolve_string(
        self,
        s: "TokenizedStringFragments",
        context: IResolveContext,
    ) -> typing.Any:
        '''(experimental) Resolve a string with at least one stringified token in it.

        (May use concatenation)

        :param s: -
        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea2a64ce00ad0d6c46bf542493522605665582a9c3d4a7b81520a2138ca97782)
            check_type(argname="argument s", value=s, expected_type=type_hints["s"])
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolveString", [s, context]))

    @jsii.member(jsii_name="resolveToken")
    def resolve_token(
        self,
        t: IResolvable,
        context: IResolveContext,
        post_processor: IPostProcessor,
    ) -> typing.Any:
        '''(experimental) Resolve a single token.

        :param t: -
        :param context: -
        :param post_processor: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4276129b2b8f2b6f4bf199127f36bc886e919da3bf2842dd7101bea96af9d676)
            check_type(argname="argument t", value=t, expected_type=type_hints["t"])
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
            check_type(argname="argument post_processor", value=post_processor, expected_type=type_hints["post_processor"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolveToken", [t, context, post_processor]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ITokenResolver).__jsii_proxy_class__ = lambda : _ITokenResolverProxy


class Lazy(metaclass=jsii.JSIIMeta, jsii_type="cdktf.Lazy"):
    '''(experimental) Lazily produce a value.

    Can be used to return a string, list or numeric value whose actual value
    will only be calculated later, during synthesis.

    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="anyValue")
    @builtins.classmethod
    def any_value(
        cls,
        producer: IAnyProducer,
        *,
        display_hint: typing.Optional[builtins.str] = None,
        omit_empty_array: typing.Optional[builtins.bool] = None,
    ) -> IResolvable:
        '''(experimental) Produces a lazy token from an untyped value.

        :param producer: The lazy producer.
        :param display_hint: (experimental) Use the given name as a display hint. Default: - No hint
        :param omit_empty_array: (experimental) If the produced value is an array and it is empty, return 'undefined' instead. Default: false

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__150ee71cdc34f6cede7026ef34f720b0a6f4d927dec2286d5886c33c88dba434)
            check_type(argname="argument producer", value=producer, expected_type=type_hints["producer"])
        options = LazyAnyValueOptions(
            display_hint=display_hint, omit_empty_array=omit_empty_array
        )

        return typing.cast(IResolvable, jsii.sinvoke(cls, "anyValue", [producer, options]))

    @jsii.member(jsii_name="listValue")
    @builtins.classmethod
    def list_value(
        cls,
        producer: IListProducer,
        *,
        display_hint: typing.Optional[builtins.str] = None,
        omit_empty: typing.Optional[builtins.bool] = None,
    ) -> typing.List[builtins.str]:
        '''(experimental) Returns a list-ified token for a lazy value.

        :param producer: The producer.
        :param display_hint: (experimental) Use the given name as a display hint. Default: - No hint
        :param omit_empty: (experimental) If the produced list is empty, return 'undefined' instead. Default: false

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2f3dd9a49ec6c84991977e3946ae193461f3d629a33823babfccf7968129f311)
            check_type(argname="argument producer", value=producer, expected_type=type_hints["producer"])
        options = LazyListValueOptions(
            display_hint=display_hint, omit_empty=omit_empty
        )

        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "listValue", [producer, options]))

    @jsii.member(jsii_name="numberValue")
    @builtins.classmethod
    def number_value(cls, producer: INumberProducer) -> jsii.Number:
        '''(experimental) Returns a numberified token for a lazy value.

        :param producer: The producer.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8d2dc76ed3ee8737dd0c7b6a4c44d5e0ef2cc93b26c64d292bd008d4ca0cbdd1)
            check_type(argname="argument producer", value=producer, expected_type=type_hints["producer"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "numberValue", [producer]))

    @jsii.member(jsii_name="stringValue")
    @builtins.classmethod
    def string_value(
        cls,
        producer: IStringProducer,
        *,
        display_hint: typing.Optional[builtins.str] = None,
    ) -> builtins.str:
        '''(experimental) Returns a stringified token for a lazy value.

        :param producer: The producer.
        :param display_hint: (experimental) Use the given name as a display hint. Default: - No hint

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4962ab90a5d1a1cff6b275f7ae5cddc9508952b37a4576ee1bf8f32701ddc5b7)
            check_type(argname="argument producer", value=producer, expected_type=type_hints["producer"])
        options = LazyStringValueOptions(display_hint=display_hint)

        return typing.cast(builtins.str, jsii.sinvoke(cls, "stringValue", [producer, options]))


@jsii.data_type(
    jsii_type="cdktf.LazyAnyValueOptions",
    jsii_struct_bases=[],
    name_mapping={"display_hint": "displayHint", "omit_empty_array": "omitEmptyArray"},
)
class LazyAnyValueOptions:
    def __init__(
        self,
        *,
        display_hint: typing.Optional[builtins.str] = None,
        omit_empty_array: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Options for creating lazy untyped tokens.

        :param display_hint: (experimental) Use the given name as a display hint. Default: - No hint
        :param omit_empty_array: (experimental) If the produced value is an array and it is empty, return 'undefined' instead. Default: false

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6d49802d1120ccf3b7ee2f316907f073211389191abb901171b9c70a510146f8)
            check_type(argname="argument display_hint", value=display_hint, expected_type=type_hints["display_hint"])
            check_type(argname="argument omit_empty_array", value=omit_empty_array, expected_type=type_hints["omit_empty_array"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if display_hint is not None:
            self._values["display_hint"] = display_hint
        if omit_empty_array is not None:
            self._values["omit_empty_array"] = omit_empty_array

    @builtins.property
    def display_hint(self) -> typing.Optional[builtins.str]:
        '''(experimental) Use the given name as a display hint.

        :default: - No hint

        :stability: experimental
        '''
        result = self._values.get("display_hint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def omit_empty_array(self) -> typing.Optional[builtins.bool]:
        '''(experimental) If the produced value is an array and it is empty, return 'undefined' instead.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("omit_empty_array")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LazyAnyValueOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IResolvable)
class LazyBase(metaclass=jsii.JSIIAbstractClass, jsii_type="cdktf.LazyBase"):
    '''
    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="addPostProcessor")
    def add_post_processor(self, post_processor: IPostProcessor) -> None:
        '''
        :param post_processor: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5a53368dbd8a8de182ffa95e5c02c7a46ed8884cab16f9d36e449ba0ac41cd05)
            check_type(argname="argument post_processor", value=post_processor, expected_type=type_hints["post_processor"])
        return typing.cast(None, jsii.invoke(self, "addPostProcessor", [post_processor]))

    @jsii.member(jsii_name="resolve")
    def resolve(self, context: IResolveContext) -> typing.Any:
        '''(experimental) Produce the Token's value at resolution time.

        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8614856ada724d1765d0d23a99cc2384c48fe7d271065d9ad430746d41145043)
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolve", [context]))

    @jsii.member(jsii_name="resolveLazy")
    @abc.abstractmethod
    def _resolve_lazy(self, context: IResolveContext) -> typing.Any:
        '''
        :param context: -

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="toJSON")
    def to_json(self) -> typing.Any:
        '''(experimental) Turn this Token into JSON.

        Called automatically when JSON.stringify() is called on a Token.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toJSON", []))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Return a string representation of this resolvable object.

        Returns a reversible string representation.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @builtins.property
    @jsii.member(jsii_name="creationStack")
    def creation_stack(self) -> typing.List[builtins.str]:
        '''(experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.

        If this returns an empty array the stack will not be attached.

        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "creationStack"))


class _LazyBaseProxy(LazyBase):
    @jsii.member(jsii_name="resolveLazy")
    def _resolve_lazy(self, context: IResolveContext) -> typing.Any:
        '''
        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6aa2ad50471b357eae494351c09c288e1a9cb87dec33f4e0c30471fd720c2e00)
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolveLazy", [context]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, LazyBase).__jsii_proxy_class__ = lambda : _LazyBaseProxy


@jsii.data_type(
    jsii_type="cdktf.LazyListValueOptions",
    jsii_struct_bases=[],
    name_mapping={"display_hint": "displayHint", "omit_empty": "omitEmpty"},
)
class LazyListValueOptions:
    def __init__(
        self,
        *,
        display_hint: typing.Optional[builtins.str] = None,
        omit_empty: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Options for creating a lazy list token.

        :param display_hint: (experimental) Use the given name as a display hint. Default: - No hint
        :param omit_empty: (experimental) If the produced list is empty, return 'undefined' instead. Default: false

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b482baeb13122d822a1fa72cc18a55f49e21c458eabcbc24abf987abf48c3cb8)
            check_type(argname="argument display_hint", value=display_hint, expected_type=type_hints["display_hint"])
            check_type(argname="argument omit_empty", value=omit_empty, expected_type=type_hints["omit_empty"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if display_hint is not None:
            self._values["display_hint"] = display_hint
        if omit_empty is not None:
            self._values["omit_empty"] = omit_empty

    @builtins.property
    def display_hint(self) -> typing.Optional[builtins.str]:
        '''(experimental) Use the given name as a display hint.

        :default: - No hint

        :stability: experimental
        '''
        result = self._values.get("display_hint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def omit_empty(self) -> typing.Optional[builtins.bool]:
        '''(experimental) If the produced list is empty, return 'undefined' instead.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("omit_empty")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LazyListValueOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.LazyStringValueOptions",
    jsii_struct_bases=[],
    name_mapping={"display_hint": "displayHint"},
)
class LazyStringValueOptions:
    def __init__(self, *, display_hint: typing.Optional[builtins.str] = None) -> None:
        '''(experimental) Options for creating a lazy string token.

        :param display_hint: (experimental) Use the given name as a display hint. Default: - No hint

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7630c052fae69b5b89f1dc93d962ef9945454973d23fea0cb1075ce9153b438f)
            check_type(argname="argument display_hint", value=display_hint, expected_type=type_hints["display_hint"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if display_hint is not None:
            self._values["display_hint"] = display_hint

    @builtins.property
    def display_hint(self) -> typing.Optional[builtins.str]:
        '''(experimental) Use the given name as a display hint.

        :default: - No hint

        :stability: experimental
        '''
        result = self._values.get("display_hint")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LazyStringValueOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.LocalBackendConfig",
    jsii_struct_bases=[],
    name_mapping={"path": "path", "workspace_dir": "workspaceDir"},
)
class LocalBackendConfig:
    def __init__(
        self,
        *,
        path: typing.Optional[builtins.str] = None,
        workspace_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) The local backend stores state on the local filesystem, locks that state using system APIs, and performs operations locally.

        Read more about this backend in the Terraform docs:
        https://developer.hashicorp.com/terraform/language/settings/backends/local

        :param path: (experimental) Path where the state file is stored. Default: - defaults to terraform.${stackId}.tfstate
        :param workspace_dir: (experimental) (Optional) The path to non-default workspaces.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__afd17bb1d867f91e223b336025067f7815957bed646de92335e13be0d1f9628d)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument workspace_dir", value=workspace_dir, expected_type=type_hints["workspace_dir"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if path is not None:
            self._values["path"] = path
        if workspace_dir is not None:
            self._values["workspace_dir"] = workspace_dir

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''(experimental) Path where the state file is stored.

        :default: - defaults to terraform.${stackId}.tfstate

        :stability: experimental
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def workspace_dir(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The path to non-default workspaces.

        :stability: experimental
        '''
        result = self._values.get("workspace_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LocalBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.LocalExecProvisioner",
    jsii_struct_bases=[],
    name_mapping={
        "command": "command",
        "type": "type",
        "environment": "environment",
        "interpreter": "interpreter",
        "when": "when",
        "working_dir": "workingDir",
    },
)
class LocalExecProvisioner:
    def __init__(
        self,
        *,
        command: builtins.str,
        type: builtins.str,
        environment: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        interpreter: typing.Optional[typing.Sequence[builtins.str]] = None,
        when: typing.Optional[builtins.str] = None,
        working_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) The local-exec provisioner invokes a local executable after a resource is created.

        This invokes a process on the machine running Terraform, not on the resource.

        See {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/local-exec local-exec}

        :param command: (experimental) This is the command to execute. It can be provided as a relative path to the current working directory or as an absolute path. It is evaluated in a shell, and can use environment variables or Terraform variables.
        :param type: 
        :param environment: (experimental) A record of key value pairs representing the environment of the executed command. It inherits the current process environment.
        :param interpreter: (experimental) If provided, this is a list of interpreter arguments used to execute the command. The first argument is the interpreter itself. It can be provided as a relative path to the current working directory or as an absolute path The remaining arguments are appended prior to the command. This allows building command lines of the form "/bin/bash", "-c", "echo foo". If interpreter is unspecified, sensible defaults will be chosen based on the system OS.
        :param when: (experimental) If provided, specifies when Terraform will execute the command. For example, when = destroy specifies that the provisioner will run when the associated resource is destroyed
        :param working_dir: (experimental) If provided, specifies the working directory where command will be executed. It can be provided as a relative path to the current working directory or as an absolute path. The directory must exist.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2582677b4a6f552af42084435f0ca0a9a7c4bad9acb588d12fd8f4f764c312e7)
            check_type(argname="argument command", value=command, expected_type=type_hints["command"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument environment", value=environment, expected_type=type_hints["environment"])
            check_type(argname="argument interpreter", value=interpreter, expected_type=type_hints["interpreter"])
            check_type(argname="argument when", value=when, expected_type=type_hints["when"])
            check_type(argname="argument working_dir", value=working_dir, expected_type=type_hints["working_dir"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "command": command,
            "type": type,
        }
        if environment is not None:
            self._values["environment"] = environment
        if interpreter is not None:
            self._values["interpreter"] = interpreter
        if when is not None:
            self._values["when"] = when
        if working_dir is not None:
            self._values["working_dir"] = working_dir

    @builtins.property
    def command(self) -> builtins.str:
        '''(experimental) This is the command to execute.

        It can be provided as a relative path to the current working directory or as an absolute path.
        It is evaluated in a shell, and can use environment variables or Terraform variables.

        :stability: experimental
        '''
        result = self._values.get("command")
        assert result is not None, "Required property 'command' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def environment(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''(experimental) A record of key value pairs representing the environment of the executed command.

        It inherits the current process environment.

        :stability: experimental
        '''
        result = self._values.get("environment")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def interpreter(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) If provided, this is a list of interpreter arguments used to execute the command.

        The first argument is the interpreter itself.
        It can be provided as a relative path to the current working directory or as an absolute path
        The remaining arguments are appended prior to the command.
        This allows building command lines of the form "/bin/bash", "-c", "echo foo".
        If interpreter is unspecified, sensible defaults will be chosen based on the system OS.

        :stability: experimental
        '''
        result = self._values.get("interpreter")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def when(self) -> typing.Optional[builtins.str]:
        '''(experimental) If provided, specifies when Terraform will execute the command.

        For example, when = destroy specifies that the provisioner will run when the associated resource is destroyed

        :stability: experimental
        '''
        result = self._values.get("when")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def working_dir(self) -> typing.Optional[builtins.str]:
        '''(experimental) If provided, specifies the working directory where command will be executed.

        It can be provided as a relative path to the current working directory or as an absolute path.
        The directory must exist.

        :stability: experimental
        '''
        result = self._values.get("working_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LocalExecProvisioner(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IManifest)
class Manifest(metaclass=jsii.JSIIMeta, jsii_type="cdktf.Manifest"):
    '''
    :stability: experimental
    '''

    def __init__(self, version: builtins.str, outdir: builtins.str) -> None:
        '''
        :param version: -
        :param outdir: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__94bc316282a624cc93c716c0f2ffaed3b82f3a8d112eb285db141c9f60af526c)
            check_type(argname="argument version", value=version, expected_type=type_hints["version"])
            check_type(argname="argument outdir", value=outdir, expected_type=type_hints["outdir"])
        jsii.create(self.__class__, self, [version, outdir])

    @jsii.member(jsii_name="buildManifest")
    def build_manifest(self) -> IManifest:
        '''
        :stability: experimental
        '''
        return typing.cast(IManifest, jsii.invoke(self, "buildManifest", []))

    @jsii.member(jsii_name="forStack")
    def for_stack(self, stack: "TerraformStack") -> "StackManifest":
        '''
        :param stack: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c5bdad3fe43286b299492683dc8a76bb8843405cc85fa8002cc580d5f1f777f8)
            check_type(argname="argument stack", value=stack, expected_type=type_hints["stack"])
        return typing.cast("StackManifest", jsii.invoke(self, "forStack", [stack]))

    @jsii.member(jsii_name="writeToFile")
    def write_to_file(self) -> None:
        '''
        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "writeToFile", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="fileName")
    def FILE_NAME(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "fileName"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="stackFileName")
    def STACK_FILE_NAME(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "stackFileName"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="stacksFolder")
    def STACKS_FOLDER(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "stacksFolder"))

    @builtins.property
    @jsii.member(jsii_name="outdir")
    def outdir(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "outdir"))

    @builtins.property
    @jsii.member(jsii_name="stacks")
    def stacks(self) -> typing.Mapping[builtins.str, "StackManifest"]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, "StackManifest"], jsii.get(self, "stacks"))

    @builtins.property
    @jsii.member(jsii_name="version")
    def version(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "version"))


@jsii.data_type(
    jsii_type="cdktf.MantaBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "account": "account",
        "key_id": "keyId",
        "path": "path",
        "insecure_skip_tls_verify": "insecureSkipTlsVerify",
        "key_material": "keyMaterial",
        "object_name": "objectName",
        "url": "url",
        "user": "user",
    },
)
class MantaBackendConfig:
    def __init__(
        self,
        *,
        account: builtins.str,
        key_id: builtins.str,
        path: builtins.str,
        insecure_skip_tls_verify: typing.Optional[builtins.bool] = None,
        key_material: typing.Optional[builtins.str] = None,
        object_name: typing.Optional[builtins.str] = None,
        url: typing.Optional[builtins.str] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param account: 
        :param key_id: 
        :param path: 
        :param insecure_skip_tls_verify: 
        :param key_material: 
        :param object_name: 
        :param url: 
        :param user: 

        :deprecated: CDK for Terraform no longer supports the manta backend. Terraform deprecated manta in v1.2.3 and removed it in v1.3.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__18f6e6b1eb96fc8b72da48de785ca3f813caf5a5c305c0cf205f3010f309fec4)
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument key_id", value=key_id, expected_type=type_hints["key_id"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument insecure_skip_tls_verify", value=insecure_skip_tls_verify, expected_type=type_hints["insecure_skip_tls_verify"])
            check_type(argname="argument key_material", value=key_material, expected_type=type_hints["key_material"])
            check_type(argname="argument object_name", value=object_name, expected_type=type_hints["object_name"])
            check_type(argname="argument url", value=url, expected_type=type_hints["url"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "account": account,
            "key_id": key_id,
            "path": path,
        }
        if insecure_skip_tls_verify is not None:
            self._values["insecure_skip_tls_verify"] = insecure_skip_tls_verify
        if key_material is not None:
            self._values["key_material"] = key_material
        if object_name is not None:
            self._values["object_name"] = object_name
        if url is not None:
            self._values["url"] = url
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def account(self) -> builtins.str:
        '''
        :stability: deprecated
        '''
        result = self._values.get("account")
        assert result is not None, "Required property 'account' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def key_id(self) -> builtins.str:
        '''
        :stability: deprecated
        '''
        result = self._values.get("key_id")
        assert result is not None, "Required property 'key_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''
        :stability: deprecated
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def insecure_skip_tls_verify(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("insecure_skip_tls_verify")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def key_material(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("key_material")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def object_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("object_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def url(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MantaBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ITerraformAddressable, IInterpolatingParent, IResolvable)
class MapList(metaclass=jsii.JSIIAbstractClass, jsii_type="cdktf.MapList"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param wraps_set: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4f983f57c198aaf3dec10393e11d348f678b5ac67514e1e1f5650bae1c932f29)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="computeFqn")
    def compute_fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "computeFqn", []))

    @jsii.member(jsii_name="interpolationForAttribute")
    def interpolation_for_attribute(self, property: builtins.str) -> IResolvable:
        '''
        :param property: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78519ff923ad9051774f6b88255d9d7cb3cc63c26a443f3dd586127eda1b76ca)
            check_type(argname="argument property", value=property, expected_type=type_hints["property"])
        return typing.cast(IResolvable, jsii.invoke(self, "interpolationForAttribute", [property]))

    @jsii.member(jsii_name="resolve")
    def resolve(self, _context: IResolveContext) -> typing.Any:
        '''(experimental) Produce the Token's value at resolution time.

        :param _context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__55a14ebb727eeec9d9eb4648fc8b7aea2632e1a2786ed3642f20cb532530e34e)
            check_type(argname="argument _context", value=_context, expected_type=type_hints["_context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolve", [_context]))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Return a string representation of this resolvable object.

        Returns a reversible string representation.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @builtins.property
    @jsii.member(jsii_name="creationStack")
    def creation_stack(self) -> typing.List[builtins.str]:
        '''(experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.

        If this returns an empty array the stack will not be attached.

        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "creationStack"))

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__489d54e4454e0b046f4ddb9816ec2da9deb1f99aace1159351c1979361a27328)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0658c665c443bc4d54631913259af7fe7ae42fa3821b2c4e99a391e3c975f9db)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e5757b5bc3bf37b610cbaa4696612ee96a4c74c39c8fe9672617bfa36f6a30ad)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)


class _MapListProxy(MapList):
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, MapList).__jsii_proxy_class__ = lambda : _MapListProxy


class NamedCloudWorkspace(
    CloudWorkspace,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.NamedCloudWorkspace",
):
    '''(experimental) The name of a single Terraform Cloud workspace.

    You will only be able to use the workspace specified in the configuration with this working directory, and cannot manage workspaces from the CLI (e.g. terraform workspace select or terraform workspace new).

    :stability: experimental
    '''

    def __init__(self, name: builtins.str) -> None:
        '''
        :param name: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__80e4adc7af0e96930e65e9fe3a635460389dd9f2162264346692e7b3da9472fb)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        jsii.create(self.__class__, self, [name])

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b0cfcf4b866081524c0efea839fa6eada21eac0b25887215dceee573e1775b21)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)


@jsii.implements(IRemoteWorkspace)
class NamedRemoteWorkspace(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.NamedRemoteWorkspace",
):
    '''
    :stability: experimental
    '''

    def __init__(self, name: builtins.str) -> None:
        '''
        :param name: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ddc4e58dfdc8cede77c2aec97190811215aee32bc9c22fc2ba256eb7e9ca6327)
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        jsii.create(self.__class__, self, [name])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "name"))

    @name.setter
    def name(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__97563cea5b11b841214e5f75ba28c0963f011f6d7b566f56e67fc1cd9f2f17b5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "name", value)


@jsii.implements(ITerraformAddressable, IResolvable)
class NumberMap(metaclass=jsii.JSIIMeta, jsii_type="cdktf.NumberMap"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c13610e1579bf3de3ffc60d4c280d6d16dec3fe814b38e4302eeb471b5ce70bc)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="computeFqn")
    def compute_fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "computeFqn", []))

    @jsii.member(jsii_name="lookup")
    def lookup(self, key: builtins.str) -> jsii.Number:
        '''
        :param key: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f5b5e6eb7d61f2e5645314da969091f403ae471333d84d2ed0db79c44e36d749)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(jsii.Number, jsii.invoke(self, "lookup", [key]))

    @jsii.member(jsii_name="resolve")
    def resolve(self, _context: IResolveContext) -> typing.Any:
        '''(experimental) Produce the Token's value at resolution time.

        :param _context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f44d6dff96bab4e8a48c1c4cb98c3c3ff89161472e5cfe6c9b1c26cd82a03416)
            check_type(argname="argument _context", value=_context, expected_type=type_hints["_context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolve", [_context]))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Return a string representation of this resolvable object.

        Returns a reversible string representation.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @builtins.property
    @jsii.member(jsii_name="creationStack")
    def creation_stack(self) -> typing.List[builtins.str]:
        '''(experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.

        If this returns an empty array the stack will not be attached.

        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "creationStack"))

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c25f7f32ec3d7c420aae841529f970cf9f0deb470daf8c52f3fe3e7f912d4534)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__331b393145ebcefab24075ffbe84e1ab32af44c34503e5a2b866dfd3a5222535)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)


class NumberMapList(MapList, metaclass=jsii.JSIIMeta, jsii_type="cdktf.NumberMapList"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param wraps_set: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__21aad81729e6eb21b92fee0a466143dad2f26c5ef092852db75a043cc5237a35)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> NumberMap:
        '''
        :param index: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3111712fc7ebd1ea4b148ef72483e1626c369070eb7e02fbd94d85791d8a9485)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast(NumberMap, jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1934fe4b7a1654098c322ce26b0461cef565ddf7ed73195a4ec8f8d456f6417f)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__13b9d021a86e6affbec068462b6292780a3e83789765f571e60b385ea3472c42)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6be06c99bd5f964788185c5dbaa939d19af0a72486dd20ea522b6c788a89dbc7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)


class Op(metaclass=jsii.JSIIMeta, jsii_type="cdktf.Op"):
    '''(experimental) This class contains static functions for all arithmetical and logical operators in the Terraform configutation language.

    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="add")
    @builtins.classmethod
    def add(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left + right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__115ab847e0a63f26d0353a96b89fc1a9d4946a331734666688a68ed68a735c1c)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "add", [left, right]))

    @jsii.member(jsii_name="and")
    @builtins.classmethod
    def and_(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left && right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__de66b2cdf28d3fa0c7705070d95e857c9448a836f8e8deb8aa4004df8d5f7f6d)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "and", [left, right]))

    @jsii.member(jsii_name="div")
    @builtins.classmethod
    def div(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left / right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__360f70228d50adbf09af0dbf312b04436e87854c0019a8365cef90c0a0cf78f5)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "div", [left, right]))

    @jsii.member(jsii_name="eq")
    @builtins.classmethod
    def eq(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left == right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__350b8df182c07d9ae8f4dfbaa7f1f34527fda94fa7b2353316a69da1047faf91)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "eq", [left, right]))

    @jsii.member(jsii_name="gt")
    @builtins.classmethod
    def gt(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left > right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d6d8a6cfd39c9acf32253acad5904deb64e80c0fe62433ba7bba659a9094f424)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "gt", [left, right]))

    @jsii.member(jsii_name="gte")
    @builtins.classmethod
    def gte(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left >= right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__95b75c397f275aac11579e7304d588f4b0c8cff5e96febe93d928672cff8eaeb)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "gte", [left, right]))

    @jsii.member(jsii_name="lt")
    @builtins.classmethod
    def lt(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left < right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4924015f0210fd3d3e4a816dc3af04644aeb124fe5c6d530b0c41dc3ce942447)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "lt", [left, right]))

    @jsii.member(jsii_name="lte")
    @builtins.classmethod
    def lte(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left <= right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__931284a20d4fa027a56cb1795cbe7f41c6959eda24e45d5f605549593b82129b)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "lte", [left, right]))

    @jsii.member(jsii_name="mod")
    @builtins.classmethod
    def mod(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left % right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__81ac04a469174c744d44b40c80842abdf129c3384d79cd6ca414b237e892d7ed)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "mod", [left, right]))

    @jsii.member(jsii_name="mul")
    @builtins.classmethod
    def mul(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left * right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__63b66af25bb81cb7bd12408d2364d7470a3e7581d4e57e39b0c9cc670f6ba097)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "mul", [left, right]))

    @jsii.member(jsii_name="negate")
    @builtins.classmethod
    def negate(cls, expression: typing.Any) -> IResolvable:
        '''(experimental) Renders -expression.

        :param expression: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2099e92391eed6750b46afd584deeb20eac426048dc051186691a95380d9f0fc)
            check_type(argname="argument expression", value=expression, expected_type=type_hints["expression"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "negate", [expression]))

    @jsii.member(jsii_name="neq")
    @builtins.classmethod
    def neq(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left != right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__33254f07144b2a79af44c6fcd30d22e020e2571e7bb9a5081e3148e96f1954d2)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "neq", [left, right]))

    @jsii.member(jsii_name="not")
    @builtins.classmethod
    def not_(cls, expression: typing.Any) -> IResolvable:
        '''(experimental) Renders !expression.

        :param expression: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a26db7f14fd2bfa58e3ac1c8ab53b6206228823ec6ca7f86f634e7f5fd839518)
            check_type(argname="argument expression", value=expression, expected_type=type_hints["expression"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "not", [expression]))

    @jsii.member(jsii_name="or")
    @builtins.classmethod
    def or_(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left || right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a2192c369eac134ff55e76fdc00463200c2f07a6ed8de760b7103bb9af8edb17)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "or", [left, right]))

    @jsii.member(jsii_name="sub")
    @builtins.classmethod
    def sub(cls, left: typing.Any, right: typing.Any) -> IResolvable:
        '''(experimental) Renders left - right.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af9672635fa484c09e343ce04bbc3f0ca494584abd2881f89102792f9a7d1830)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "sub", [left, right]))


@jsii.data_type(
    jsii_type="cdktf.OssAssumeRole",
    jsii_struct_bases=[],
    name_mapping={
        "role_arn": "roleArn",
        "policy": "policy",
        "session_expiration": "sessionExpiration",
        "session_name": "sessionName",
    },
)
class OssAssumeRole:
    def __init__(
        self,
        *,
        role_arn: builtins.str,
        policy: typing.Optional[builtins.str] = None,
        session_expiration: typing.Optional[jsii.Number] = None,
        session_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param role_arn: 
        :param policy: 
        :param session_expiration: 
        :param session_name: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6cc332ee3f940b3e2cf9553f3d9b4445db34ac8bba9094cc9e16007f4dbfc272)
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument policy", value=policy, expected_type=type_hints["policy"])
            check_type(argname="argument session_expiration", value=session_expiration, expected_type=type_hints["session_expiration"])
            check_type(argname="argument session_name", value=session_name, expected_type=type_hints["session_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "role_arn": role_arn,
        }
        if policy is not None:
            self._values["policy"] = policy
        if session_expiration is not None:
            self._values["session_expiration"] = session_expiration
        if session_name is not None:
            self._values["session_name"] = session_name

    @builtins.property
    def role_arn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("role_arn")
        assert result is not None, "Required property 'role_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def policy(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def session_expiration(self) -> typing.Optional[jsii.Number]:
        '''
        :stability: experimental
        '''
        result = self._values.get("session_expiration")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def session_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("session_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "OssAssumeRole(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.OssBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "bucket": "bucket",
        "access_key": "accessKey",
        "acl": "acl",
        "assume_role": "assumeRole",
        "ecs_role_name": "ecsRoleName",
        "encrypt": "encrypt",
        "endpoint": "endpoint",
        "key": "key",
        "prefix": "prefix",
        "profile": "profile",
        "region": "region",
        "secret_key": "secretKey",
        "security_token": "securityToken",
        "shared_credentials_file": "sharedCredentialsFile",
        "tablestore_endpoint": "tablestoreEndpoint",
        "tablestore_table": "tablestoreTable",
    },
)
class OssBackendConfig:
    def __init__(
        self,
        *,
        bucket: builtins.str,
        access_key: typing.Optional[builtins.str] = None,
        acl: typing.Optional[builtins.str] = None,
        assume_role: typing.Optional[typing.Union[OssAssumeRole, typing.Dict[builtins.str, typing.Any]]] = None,
        ecs_role_name: typing.Optional[builtins.str] = None,
        encrypt: typing.Optional[builtins.bool] = None,
        endpoint: typing.Optional[builtins.str] = None,
        key: typing.Optional[builtins.str] = None,
        prefix: typing.Optional[builtins.str] = None,
        profile: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        secret_key: typing.Optional[builtins.str] = None,
        security_token: typing.Optional[builtins.str] = None,
        shared_credentials_file: typing.Optional[builtins.str] = None,
        tablestore_endpoint: typing.Optional[builtins.str] = None,
        tablestore_table: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param bucket: 
        :param access_key: 
        :param acl: 
        :param assume_role: 
        :param ecs_role_name: 
        :param encrypt: 
        :param endpoint: 
        :param key: 
        :param prefix: 
        :param profile: 
        :param region: 
        :param secret_key: 
        :param security_token: 
        :param shared_credentials_file: 
        :param tablestore_endpoint: 
        :param tablestore_table: 

        :stability: experimental
        '''
        if isinstance(assume_role, dict):
            assume_role = OssAssumeRole(**assume_role)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b9bc25555c149e3b92adbaee3fe1f4dc94c87d95c183a084fb41ed6ff8aaa4e4)
            check_type(argname="argument bucket", value=bucket, expected_type=type_hints["bucket"])
            check_type(argname="argument access_key", value=access_key, expected_type=type_hints["access_key"])
            check_type(argname="argument acl", value=acl, expected_type=type_hints["acl"])
            check_type(argname="argument assume_role", value=assume_role, expected_type=type_hints["assume_role"])
            check_type(argname="argument ecs_role_name", value=ecs_role_name, expected_type=type_hints["ecs_role_name"])
            check_type(argname="argument encrypt", value=encrypt, expected_type=type_hints["encrypt"])
            check_type(argname="argument endpoint", value=endpoint, expected_type=type_hints["endpoint"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument profile", value=profile, expected_type=type_hints["profile"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument secret_key", value=secret_key, expected_type=type_hints["secret_key"])
            check_type(argname="argument security_token", value=security_token, expected_type=type_hints["security_token"])
            check_type(argname="argument shared_credentials_file", value=shared_credentials_file, expected_type=type_hints["shared_credentials_file"])
            check_type(argname="argument tablestore_endpoint", value=tablestore_endpoint, expected_type=type_hints["tablestore_endpoint"])
            check_type(argname="argument tablestore_table", value=tablestore_table, expected_type=type_hints["tablestore_table"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "bucket": bucket,
        }
        if access_key is not None:
            self._values["access_key"] = access_key
        if acl is not None:
            self._values["acl"] = acl
        if assume_role is not None:
            self._values["assume_role"] = assume_role
        if ecs_role_name is not None:
            self._values["ecs_role_name"] = ecs_role_name
        if encrypt is not None:
            self._values["encrypt"] = encrypt
        if endpoint is not None:
            self._values["endpoint"] = endpoint
        if key is not None:
            self._values["key"] = key
        if prefix is not None:
            self._values["prefix"] = prefix
        if profile is not None:
            self._values["profile"] = profile
        if region is not None:
            self._values["region"] = region
        if secret_key is not None:
            self._values["secret_key"] = secret_key
        if security_token is not None:
            self._values["security_token"] = security_token
        if shared_credentials_file is not None:
            self._values["shared_credentials_file"] = shared_credentials_file
        if tablestore_endpoint is not None:
            self._values["tablestore_endpoint"] = tablestore_endpoint
        if tablestore_table is not None:
            self._values["tablestore_table"] = tablestore_table

    @builtins.property
    def bucket(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("bucket")
        assert result is not None, "Required property 'bucket' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def access_key(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("access_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def acl(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("acl")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def assume_role(self) -> typing.Optional[OssAssumeRole]:
        '''
        :stability: experimental
        '''
        result = self._values.get("assume_role")
        return typing.cast(typing.Optional[OssAssumeRole], result)

    @builtins.property
    def ecs_role_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("ecs_role_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def encrypt(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("encrypt")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def endpoint(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def profile(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("profile")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_key(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("secret_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def security_token(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("security_token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def shared_credentials_file(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("shared_credentials_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tablestore_endpoint(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("tablestore_endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tablestore_table(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("tablestore_table")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "OssBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.PgBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "conn_str": "connStr",
        "schema_name": "schemaName",
        "skip_schema_creation": "skipSchemaCreation",
    },
)
class PgBackendConfig:
    def __init__(
        self,
        *,
        conn_str: builtins.str,
        schema_name: typing.Optional[builtins.str] = None,
        skip_schema_creation: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param conn_str: 
        :param schema_name: 
        :param skip_schema_creation: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__479db6aa894da11b4a44d05cb65761de8a1d20e0d3fa9dd6a4b22d8d24700dbe)
            check_type(argname="argument conn_str", value=conn_str, expected_type=type_hints["conn_str"])
            check_type(argname="argument schema_name", value=schema_name, expected_type=type_hints["schema_name"])
            check_type(argname="argument skip_schema_creation", value=skip_schema_creation, expected_type=type_hints["skip_schema_creation"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "conn_str": conn_str,
        }
        if schema_name is not None:
            self._values["schema_name"] = schema_name
        if skip_schema_creation is not None:
            self._values["skip_schema_creation"] = skip_schema_creation

    @builtins.property
    def conn_str(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("conn_str")
        assert result is not None, "Required property 'conn_str' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def schema_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("schema_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def skip_schema_creation(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("skip_schema_creation")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PgBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IRemoteWorkspace)
class PrefixedRemoteWorkspaces(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.PrefixedRemoteWorkspaces",
):
    '''
    :stability: experimental
    '''

    def __init__(self, prefix: builtins.str) -> None:
        '''
        :param prefix: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1792510a87c3ae36edb296aff8a3526b7e3bc3c9cb550ce530dc4edf0224bcac)
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
        jsii.create(self.__class__, self, [prefix])

    @builtins.property
    @jsii.member(jsii_name="prefix")
    def prefix(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "prefix"))

    @prefix.setter
    def prefix(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5b9f57cdb3f324e19ca7b310e7e784fd74452709dc235f3864949a26070d7963)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "prefix", value)


@jsii.data_type(
    jsii_type="cdktf.RemoteBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "organization": "organization",
        "workspaces": "workspaces",
        "hostname": "hostname",
        "token": "token",
    },
)
class RemoteBackendConfig:
    def __init__(
        self,
        *,
        organization: builtins.str,
        workspaces: IRemoteWorkspace,
        hostname: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param organization: 
        :param workspaces: 
        :param hostname: 
        :param token: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__67b75dce6bbab8cfa2778dec578c09a5d78ee257ec4f6133ce91c43547c68854)
            check_type(argname="argument organization", value=organization, expected_type=type_hints["organization"])
            check_type(argname="argument workspaces", value=workspaces, expected_type=type_hints["workspaces"])
            check_type(argname="argument hostname", value=hostname, expected_type=type_hints["hostname"])
            check_type(argname="argument token", value=token, expected_type=type_hints["token"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "organization": organization,
            "workspaces": workspaces,
        }
        if hostname is not None:
            self._values["hostname"] = hostname
        if token is not None:
            self._values["token"] = token

    @builtins.property
    def organization(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("organization")
        assert result is not None, "Required property 'organization' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def workspaces(self) -> IRemoteWorkspace:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspaces")
        assert result is not None, "Required property 'workspaces' is missing"
        return typing.cast(IRemoteWorkspace, result)

    @builtins.property
    def hostname(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("hostname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def token(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("token")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RemoteBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.RemoteExecProvisioner",
    jsii_struct_bases=[],
    name_mapping={
        "type": "type",
        "connection": "connection",
        "inline": "inline",
        "script": "script",
        "scripts": "scripts",
    },
)
class RemoteExecProvisioner:
    def __init__(
        self,
        *,
        type: builtins.str,
        connection: typing.Optional[typing.Union[typing.Union["SSHProvisionerConnection", typing.Dict[builtins.str, typing.Any]], typing.Union["WinrmProvisionerConnection", typing.Dict[builtins.str, typing.Any]]]] = None,
        inline: typing.Optional[typing.Sequence[builtins.str]] = None,
        script: typing.Optional[builtins.str] = None,
        scripts: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''(experimental) The remote-exec provisioner invokes a script on a remote resource after it is created.

        This can be used to run a configuration management tool, bootstrap into a cluster, etc
        The remote-exec provisioner requires a connection and supports both ssh and winrm.

        See {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/remote-exec remote-exec}

        :param type: 
        :param connection: (experimental) Most provisioners require access to the remote resource via SSH or WinRM and expect a nested connection block with details about how to connect. A connection must be provided here or in the parent resource.
        :param inline: (experimental) This is a list of command strings. They are executed in the order they are provided. This cannot be provided with script or scripts.
        :param script: (experimental) This is a path (relative or absolute) to a local script that will be copied to the remote resource and then executed. This cannot be provided with inline or scripts.
        :param scripts: (experimental) This is a list of paths (relative or absolute) to local scripts that will be copied to the remote resource and then executed. They are executed in the order they are provided. This cannot be provided with inline or script.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__239beadc100f174bb96752364edd6c5de711beca32370b75603e0680bb8f795c)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument inline", value=inline, expected_type=type_hints["inline"])
            check_type(argname="argument script", value=script, expected_type=type_hints["script"])
            check_type(argname="argument scripts", value=scripts, expected_type=type_hints["scripts"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "type": type,
        }
        if connection is not None:
            self._values["connection"] = connection
        if inline is not None:
            self._values["inline"] = inline
        if script is not None:
            self._values["script"] = script
        if scripts is not None:
            self._values["scripts"] = scripts

    @builtins.property
    def type(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union["SSHProvisionerConnection", "WinrmProvisionerConnection"]]:
        '''(experimental) Most provisioners require access to the remote resource via SSH or WinRM and expect a nested connection block with details about how to connect.

        A connection must be provided here or in the parent resource.

        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union["SSHProvisionerConnection", "WinrmProvisionerConnection"]], result)

    @builtins.property
    def inline(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This is a list of command strings.

        They are executed in the order they are provided.
        This cannot be provided with script or scripts.

        :stability: experimental
        '''
        result = self._values.get("inline")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def script(self) -> typing.Optional[builtins.str]:
        '''(experimental) This is a path (relative or absolute) to a local script that will be copied to the remote resource and then executed.

        This cannot be provided with inline or scripts.

        :stability: experimental
        '''
        result = self._values.get("script")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def scripts(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This is a list of paths (relative or absolute) to local scripts that will be copied to the remote resource and then executed.

        They are executed in the order they are provided.
        This cannot be provided with inline or script.

        :stability: experimental
        '''
        result = self._values.get("scripts")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "RemoteExecProvisioner(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.ResolveOptions",
    jsii_struct_bases=[],
    name_mapping={"resolver": "resolver", "scope": "scope", "preparing": "preparing"},
)
class ResolveOptions:
    def __init__(
        self,
        *,
        resolver: ITokenResolver,
        scope: _constructs_77d1e7e8.IConstruct,
        preparing: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Options to the resolve() operation.

        NOT the same as the ResolveContext; ResolveContext is exposed to Token
        implementors and resolution hooks, whereas this struct is just to bundle
        a number of things that would otherwise be arguments to resolve() in a
        readable way.

        :param resolver: (experimental) The resolver to apply to any resolvable tokens found.
        :param scope: (experimental) The scope from which resolution is performed.
        :param preparing: (experimental) Whether the resolution is being executed during the prepare phase or not. Default: false

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a8556973f518fcd5abeaf93da255b30727f3355401fd9a415bdc48f7c469a3cd)
            check_type(argname="argument resolver", value=resolver, expected_type=type_hints["resolver"])
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument preparing", value=preparing, expected_type=type_hints["preparing"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "resolver": resolver,
            "scope": scope,
        }
        if preparing is not None:
            self._values["preparing"] = preparing

    @builtins.property
    def resolver(self) -> ITokenResolver:
        '''(experimental) The resolver to apply to any resolvable tokens found.

        :stability: experimental
        '''
        result = self._values.get("resolver")
        assert result is not None, "Required property 'resolver' is missing"
        return typing.cast(ITokenResolver, result)

    @builtins.property
    def scope(self) -> _constructs_77d1e7e8.IConstruct:
        '''(experimental) The scope from which resolution is performed.

        :stability: experimental
        '''
        result = self._values.get("scope")
        assert result is not None, "Required property 'scope' is missing"
        return typing.cast(_constructs_77d1e7e8.IConstruct, result)

    @builtins.property
    def preparing(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Whether the resolution is being executed during the prepare phase or not.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("preparing")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ResolveOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IResource)
class Resource(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdktf.Resource",
):
    '''(deprecated) A construct which represents a resource.

    :deprecated: - Please use Construct from the constructs package instead.

    :stability: deprecated
    '''

    def __init__(self, scope: _constructs_77d1e7e8.Construct, id: builtins.str) -> None:
        '''
        :param scope: -
        :param id: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__30c0002faba1e8d28540707fec9ff2f30e57cc07ab647ef9fc971c25b793add8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        jsii.create(self.__class__, self, [scope, id])

    @builtins.property
    @jsii.member(jsii_name="stack")
    def stack(self) -> "TerraformStack":
        '''(deprecated) The stack in which this resource is defined.

        :stability: deprecated
        '''
        return typing.cast("TerraformStack", jsii.get(self, "stack"))


class _ResourceProxy(Resource):
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, Resource).__jsii_proxy_class__ = lambda : _ResourceProxy


@jsii.data_type(
    jsii_type="cdktf.S3BackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "bucket": "bucket",
        "key": "key",
        "access_key": "accessKey",
        "acl": "acl",
        "assume_role_policy": "assumeRolePolicy",
        "assume_role_policy_arns": "assumeRolePolicyArns",
        "assume_role_tags": "assumeRoleTags",
        "assume_role_transitive_tag_keys": "assumeRoleTransitiveTagKeys",
        "dynamodb_endpoint": "dynamodbEndpoint",
        "dynamodb_table": "dynamodbTable",
        "encrypt": "encrypt",
        "endpoint": "endpoint",
        "external_id": "externalId",
        "force_path_style": "forcePathStyle",
        "iam_endpoint": "iamEndpoint",
        "kms_key_id": "kmsKeyId",
        "max_retries": "maxRetries",
        "profile": "profile",
        "region": "region",
        "role_arn": "roleArn",
        "secret_key": "secretKey",
        "session_name": "sessionName",
        "shared_credentials_file": "sharedCredentialsFile",
        "skip_credentials_validation": "skipCredentialsValidation",
        "skip_metadata_api_check": "skipMetadataApiCheck",
        "skip_region_validation": "skipRegionValidation",
        "sse_customer_key": "sseCustomerKey",
        "sts_endpoint": "stsEndpoint",
        "token": "token",
        "workspace_key_prefix": "workspaceKeyPrefix",
    },
)
class S3BackendConfig:
    def __init__(
        self,
        *,
        bucket: builtins.str,
        key: builtins.str,
        access_key: typing.Optional[builtins.str] = None,
        acl: typing.Optional[builtins.str] = None,
        assume_role_policy: typing.Optional[builtins.str] = None,
        assume_role_policy_arns: typing.Optional[typing.Sequence[builtins.str]] = None,
        assume_role_tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        assume_role_transitive_tag_keys: typing.Optional[typing.Sequence[builtins.str]] = None,
        dynamodb_endpoint: typing.Optional[builtins.str] = None,
        dynamodb_table: typing.Optional[builtins.str] = None,
        encrypt: typing.Optional[builtins.bool] = None,
        endpoint: typing.Optional[builtins.str] = None,
        external_id: typing.Optional[builtins.str] = None,
        force_path_style: typing.Optional[builtins.bool] = None,
        iam_endpoint: typing.Optional[builtins.str] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        max_retries: typing.Optional[jsii.Number] = None,
        profile: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        role_arn: typing.Optional[builtins.str] = None,
        secret_key: typing.Optional[builtins.str] = None,
        session_name: typing.Optional[builtins.str] = None,
        shared_credentials_file: typing.Optional[builtins.str] = None,
        skip_credentials_validation: typing.Optional[builtins.bool] = None,
        skip_metadata_api_check: typing.Optional[builtins.bool] = None,
        skip_region_validation: typing.Optional[builtins.bool] = None,
        sse_customer_key: typing.Optional[builtins.str] = None,
        sts_endpoint: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
        workspace_key_prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Stores the state as a given key in a given bucket on Amazon S3.

        This backend
        also supports state locking and consistency checking via Dynamo DB, which
        can be enabled by setting the dynamodb_table field to an existing DynamoDB
        table name. A single DynamoDB table can be used to lock multiple remote
        state files. Terraform generates key names that include the values of the
        bucket and key variables.

        Warning! It is highly recommended that you enable Bucket Versioning on the
        S3 bucket to allow for state recovery in the case of accidental deletions
        and human error.

        Read more about this backend in the Terraform docs:
        https://developer.hashicorp.com/terraform/language/settings/backends/s3

        :param bucket: (experimental) Name of the S3 Bucket.
        :param key: (experimental) Path to the state file inside the S3 Bucket. When using a non-default workspace, the state path will be /workspace_key_prefix/workspace_name/key
        :param access_key: (experimental) (Optional) AWS access key. If configured, must also configure secret_key. This can also be sourced from the AWS_ACCESS_KEY_ID environment variable, AWS shared credentials file (e.g. ~/.aws/credentials), or AWS shared configuration file (e.g. ~/.aws/config).
        :param acl: (experimental) (Optional) Canned ACL to be applied to the state file.
        :param assume_role_policy: (experimental) (Optional) IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        :param assume_role_policy_arns: (experimental) (Optional) Set of Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
        :param assume_role_tags: (experimental) (Optional) Map of assume role session tags.
        :param assume_role_transitive_tag_keys: (experimental) (Optional) Set of assume role session tag keys to pass to any subsequent sessions.
        :param dynamodb_endpoint: (experimental) (Optional) Custom endpoint for the AWS DynamoDB API. This can also be sourced from the AWS_DYNAMODB_ENDPOINT environment variable.
        :param dynamodb_table: (experimental) (Optional) Name of DynamoDB Table to use for state locking and consistency. The table must have a partition key named LockID with type of String. If not configured, state locking will be disabled.
        :param encrypt: (experimental) (Optional) Enable server side encryption of the state file.
        :param endpoint: (experimental) (Optional) Custom endpoint for the AWS S3 API. This can also be sourced from the AWS_S3_ENDPOINT environment variable.
        :param external_id: (experimental) (Optional) External identifier to use when assuming the role.
        :param force_path_style: (experimental) (Optional) Enable path-style S3 URLs (https:/// instead of https://.).
        :param iam_endpoint: (experimental) (Optional) Custom endpoint for the AWS Identity and Access Management (IAM) API. This can also be sourced from the AWS_IAM_ENDPOINT environment variable.
        :param kms_key_id: (experimental) (Optional) Amazon Resource Name (ARN) of a Key Management Service (KMS) Key to use for encrypting the state. Note that if this value is specified, Terraform will need kms:Encrypt, kms:Decrypt and kms:GenerateDataKey permissions on this KMS key.
        :param max_retries: (experimental) (Optional) The maximum number of times an AWS API request is retried on retryable failure. Defaults to 5.
        :param profile: (experimental) (Optional) Name of AWS profile in AWS shared credentials file (e.g. ~/.aws/credentials) or AWS shared configuration file (e.g. ~/.aws/config) to use for credentials and/or configuration. This can also be sourced from the AWS_PROFILE environment variable.
        :param region: (experimental) AWS Region of the S3 Bucket and DynamoDB Table (if used). This can also be sourced from the AWS_DEFAULT_REGION and AWS_REGION environment variables.
        :param role_arn: (experimental) (Optional) Amazon Resource Name (ARN) of the IAM Role to assume.
        :param secret_key: (experimental) (Optional) AWS secret access key. If configured, must also configure access_key. This can also be sourced from the AWS_SECRET_ACCESS_KEY environment variable, AWS shared credentials file (e.g. ~/.aws/credentials), or AWS shared configuration file (e.g. ~/.aws/config)
        :param session_name: (experimental) (Optional) Session name to use when assuming the role.
        :param shared_credentials_file: (experimental) (Optional) Path to the AWS shared credentials file. Defaults to ~/.aws/credentials.
        :param skip_credentials_validation: (experimental) (Optional) Skip credentials validation via the STS API.
        :param skip_metadata_api_check: (experimental) (Optional) Skip usage of EC2 Metadata API.
        :param skip_region_validation: (experimental) (Optional) Skip validation of provided region name.
        :param sse_customer_key: (experimental) (Optional) The key to use for encrypting state with Server-Side Encryption with Customer-Provided Keys (SSE-C). This is the base64-encoded value of the key, which must decode to 256 bits. This can also be sourced from the AWS_SSE_CUSTOMER_KEY environment variable, which is recommended due to the sensitivity of the value. Setting it inside a terraform file will cause it to be persisted to disk in terraform.tfstate.
        :param sts_endpoint: (experimental) (Optional) Custom endpoint for the AWS Security Token Service (STS) API. This can also be sourced from the AWS_STS_ENDPOINT environment variable.
        :param token: (experimental) (Optional) Multi-Factor Authentication (MFA) token. This can also be sourced from the AWS_SESSION_TOKEN environment variable.
        :param workspace_key_prefix: (experimental) (Optional) Prefix applied to the state path inside the bucket. This is only relevant when using a non-default workspace. Defaults to env:

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__91b0e4b6e57605e57a40f0cce781741626870c5e4e384563cf68f4a15e07944e)
            check_type(argname="argument bucket", value=bucket, expected_type=type_hints["bucket"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument access_key", value=access_key, expected_type=type_hints["access_key"])
            check_type(argname="argument acl", value=acl, expected_type=type_hints["acl"])
            check_type(argname="argument assume_role_policy", value=assume_role_policy, expected_type=type_hints["assume_role_policy"])
            check_type(argname="argument assume_role_policy_arns", value=assume_role_policy_arns, expected_type=type_hints["assume_role_policy_arns"])
            check_type(argname="argument assume_role_tags", value=assume_role_tags, expected_type=type_hints["assume_role_tags"])
            check_type(argname="argument assume_role_transitive_tag_keys", value=assume_role_transitive_tag_keys, expected_type=type_hints["assume_role_transitive_tag_keys"])
            check_type(argname="argument dynamodb_endpoint", value=dynamodb_endpoint, expected_type=type_hints["dynamodb_endpoint"])
            check_type(argname="argument dynamodb_table", value=dynamodb_table, expected_type=type_hints["dynamodb_table"])
            check_type(argname="argument encrypt", value=encrypt, expected_type=type_hints["encrypt"])
            check_type(argname="argument endpoint", value=endpoint, expected_type=type_hints["endpoint"])
            check_type(argname="argument external_id", value=external_id, expected_type=type_hints["external_id"])
            check_type(argname="argument force_path_style", value=force_path_style, expected_type=type_hints["force_path_style"])
            check_type(argname="argument iam_endpoint", value=iam_endpoint, expected_type=type_hints["iam_endpoint"])
            check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            check_type(argname="argument max_retries", value=max_retries, expected_type=type_hints["max_retries"])
            check_type(argname="argument profile", value=profile, expected_type=type_hints["profile"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument secret_key", value=secret_key, expected_type=type_hints["secret_key"])
            check_type(argname="argument session_name", value=session_name, expected_type=type_hints["session_name"])
            check_type(argname="argument shared_credentials_file", value=shared_credentials_file, expected_type=type_hints["shared_credentials_file"])
            check_type(argname="argument skip_credentials_validation", value=skip_credentials_validation, expected_type=type_hints["skip_credentials_validation"])
            check_type(argname="argument skip_metadata_api_check", value=skip_metadata_api_check, expected_type=type_hints["skip_metadata_api_check"])
            check_type(argname="argument skip_region_validation", value=skip_region_validation, expected_type=type_hints["skip_region_validation"])
            check_type(argname="argument sse_customer_key", value=sse_customer_key, expected_type=type_hints["sse_customer_key"])
            check_type(argname="argument sts_endpoint", value=sts_endpoint, expected_type=type_hints["sts_endpoint"])
            check_type(argname="argument token", value=token, expected_type=type_hints["token"])
            check_type(argname="argument workspace_key_prefix", value=workspace_key_prefix, expected_type=type_hints["workspace_key_prefix"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "bucket": bucket,
            "key": key,
        }
        if access_key is not None:
            self._values["access_key"] = access_key
        if acl is not None:
            self._values["acl"] = acl
        if assume_role_policy is not None:
            self._values["assume_role_policy"] = assume_role_policy
        if assume_role_policy_arns is not None:
            self._values["assume_role_policy_arns"] = assume_role_policy_arns
        if assume_role_tags is not None:
            self._values["assume_role_tags"] = assume_role_tags
        if assume_role_transitive_tag_keys is not None:
            self._values["assume_role_transitive_tag_keys"] = assume_role_transitive_tag_keys
        if dynamodb_endpoint is not None:
            self._values["dynamodb_endpoint"] = dynamodb_endpoint
        if dynamodb_table is not None:
            self._values["dynamodb_table"] = dynamodb_table
        if encrypt is not None:
            self._values["encrypt"] = encrypt
        if endpoint is not None:
            self._values["endpoint"] = endpoint
        if external_id is not None:
            self._values["external_id"] = external_id
        if force_path_style is not None:
            self._values["force_path_style"] = force_path_style
        if iam_endpoint is not None:
            self._values["iam_endpoint"] = iam_endpoint
        if kms_key_id is not None:
            self._values["kms_key_id"] = kms_key_id
        if max_retries is not None:
            self._values["max_retries"] = max_retries
        if profile is not None:
            self._values["profile"] = profile
        if region is not None:
            self._values["region"] = region
        if role_arn is not None:
            self._values["role_arn"] = role_arn
        if secret_key is not None:
            self._values["secret_key"] = secret_key
        if session_name is not None:
            self._values["session_name"] = session_name
        if shared_credentials_file is not None:
            self._values["shared_credentials_file"] = shared_credentials_file
        if skip_credentials_validation is not None:
            self._values["skip_credentials_validation"] = skip_credentials_validation
        if skip_metadata_api_check is not None:
            self._values["skip_metadata_api_check"] = skip_metadata_api_check
        if skip_region_validation is not None:
            self._values["skip_region_validation"] = skip_region_validation
        if sse_customer_key is not None:
            self._values["sse_customer_key"] = sse_customer_key
        if sts_endpoint is not None:
            self._values["sts_endpoint"] = sts_endpoint
        if token is not None:
            self._values["token"] = token
        if workspace_key_prefix is not None:
            self._values["workspace_key_prefix"] = workspace_key_prefix

    @builtins.property
    def bucket(self) -> builtins.str:
        '''(experimental) Name of the S3 Bucket.

        :stability: experimental
        '''
        result = self._values.get("bucket")
        assert result is not None, "Required property 'bucket' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def key(self) -> builtins.str:
        '''(experimental) Path to the state file inside the S3 Bucket.

        When using a non-default workspace, the state path will be /workspace_key_prefix/workspace_name/key

        :stability: experimental
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def access_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) AWS access key.

        If configured, must also configure secret_key.
        This can also be sourced from
        the AWS_ACCESS_KEY_ID environment variable,
        AWS shared credentials file (e.g. ~/.aws/credentials),
        or AWS shared configuration file (e.g. ~/.aws/config).

        :stability: experimental
        '''
        result = self._values.get("access_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def acl(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Canned ACL to be applied to the state file.

        :stability: experimental
        '''
        result = self._values.get("acl")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def assume_role_policy(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.

        :stability: experimental
        '''
        result = self._values.get("assume_role_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def assume_role_policy_arns(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) (Optional) Set of Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.

        :stability: experimental
        '''
        result = self._values.get("assume_role_policy_arns")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def assume_role_tags(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''(experimental) (Optional) Map of assume role session tags.

        :stability: experimental
        '''
        result = self._values.get("assume_role_tags")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def assume_role_transitive_tag_keys(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) (Optional) Set of assume role session tag keys to pass to any subsequent sessions.

        :stability: experimental
        '''
        result = self._values.get("assume_role_transitive_tag_keys")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def dynamodb_endpoint(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Custom endpoint for the AWS DynamoDB API.

        This can also be sourced from the AWS_DYNAMODB_ENDPOINT environment variable.

        :stability: experimental
        '''
        result = self._values.get("dynamodb_endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def dynamodb_table(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Name of DynamoDB Table to use for state locking and consistency.

        The table must have a partition key named LockID with type of String.
        If not configured, state locking will be disabled.

        :stability: experimental
        '''
        result = self._values.get("dynamodb_table")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def encrypt(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Enable server side encryption of the state file.

        :stability: experimental
        '''
        result = self._values.get("encrypt")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def endpoint(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Custom endpoint for the AWS S3 API.

        This can also be sourced from the AWS_S3_ENDPOINT environment variable.

        :stability: experimental
        '''
        result = self._values.get("endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def external_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) External identifier to use when assuming the role.

        :stability: experimental
        '''
        result = self._values.get("external_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def force_path_style(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Enable path-style S3 URLs (https:/// instead of https://.).

        :stability: experimental
        '''
        result = self._values.get("force_path_style")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def iam_endpoint(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Custom endpoint for the AWS Identity and Access Management (IAM) API.

        This can also be sourced from the AWS_IAM_ENDPOINT environment variable.

        :stability: experimental
        '''
        result = self._values.get("iam_endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Amazon Resource Name (ARN) of a Key Management Service (KMS) Key to use for encrypting the state.

        Note that if this value is specified,
        Terraform will need kms:Encrypt, kms:Decrypt and kms:GenerateDataKey permissions on this KMS key.

        :stability: experimental
        '''
        result = self._values.get("kms_key_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def max_retries(self) -> typing.Optional[jsii.Number]:
        '''(experimental) (Optional) The maximum number of times an AWS API request is retried on retryable failure.

        Defaults to 5.

        :stability: experimental
        '''
        result = self._values.get("max_retries")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def profile(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Name of AWS profile in AWS shared credentials file (e.g. ~/.aws/credentials) or AWS shared configuration file (e.g. ~/.aws/config) to use for credentials and/or configuration. This can also be sourced from the AWS_PROFILE environment variable.

        :stability: experimental
        '''
        result = self._values.get("profile")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''(experimental) AWS Region of the S3 Bucket and DynamoDB Table (if used).

        This can also
        be sourced from the AWS_DEFAULT_REGION and AWS_REGION environment
        variables.

        :stability: experimental
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def role_arn(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Amazon Resource Name (ARN) of the IAM Role to assume.

        :stability: experimental
        '''
        result = self._values.get("role_arn")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) AWS secret access key.

        If configured, must also configure access_key.
        This can also be sourced from
        the AWS_SECRET_ACCESS_KEY environment variable,
        AWS shared credentials file (e.g. ~/.aws/credentials),
        or AWS shared configuration file (e.g. ~/.aws/config)

        :stability: experimental
        '''
        result = self._values.get("secret_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def session_name(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Session name to use when assuming the role.

        :stability: experimental
        '''
        result = self._values.get("session_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def shared_credentials_file(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Path to the AWS shared credentials file.

        Defaults to ~/.aws/credentials.

        :stability: experimental
        '''
        result = self._values.get("shared_credentials_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def skip_credentials_validation(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Skip credentials validation via the STS API.

        :stability: experimental
        '''
        result = self._values.get("skip_credentials_validation")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def skip_metadata_api_check(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Skip usage of EC2 Metadata API.

        :stability: experimental
        '''
        result = self._values.get("skip_metadata_api_check")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def skip_region_validation(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Skip validation of provided region name.

        :stability: experimental
        '''
        result = self._values.get("skip_region_validation")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def sse_customer_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The key to use for encrypting state with Server-Side Encryption with Customer-Provided Keys (SSE-C).

        This is the base64-encoded value of the key, which must decode to 256 bits.
        This can also be sourced from the AWS_SSE_CUSTOMER_KEY environment variable,
        which is recommended due to the sensitivity of the value.
        Setting it inside a terraform file will cause it to be persisted to disk in terraform.tfstate.

        :stability: experimental
        '''
        result = self._values.get("sse_customer_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sts_endpoint(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Custom endpoint for the AWS Security Token Service (STS) API.

        This can also be sourced from the AWS_STS_ENDPOINT environment variable.

        :stability: experimental
        '''
        result = self._values.get("sts_endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def token(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Multi-Factor Authentication (MFA) token.

        This can also be sourced from the AWS_SESSION_TOKEN environment variable.

        :stability: experimental
        '''
        result = self._values.get("token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def workspace_key_prefix(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Prefix applied to the state path inside the bucket.

        This is only relevant when using a non-default workspace. Defaults to env:

        :stability: experimental
        '''
        result = self._values.get("workspace_key_prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "S3BackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.SSHProvisionerConnection",
    jsii_struct_bases=[],
    name_mapping={
        "host": "host",
        "type": "type",
        "agent": "agent",
        "agent_identity": "agentIdentity",
        "bastion_certificate": "bastionCertificate",
        "bastion_host": "bastionHost",
        "bastion_host_key": "bastionHostKey",
        "bastion_password": "bastionPassword",
        "bastion_port": "bastionPort",
        "bastion_private_key": "bastionPrivateKey",
        "bastion_user": "bastionUser",
        "certificate": "certificate",
        "host_key": "hostKey",
        "password": "password",
        "port": "port",
        "private_key": "privateKey",
        "proxy_host": "proxyHost",
        "proxy_port": "proxyPort",
        "proxy_scheme": "proxyScheme",
        "proxy_user_name": "proxyUserName",
        "proxy_user_password": "proxyUserPassword",
        "script_path": "scriptPath",
        "target_platform": "targetPlatform",
        "timeout": "timeout",
        "user": "user",
    },
)
class SSHProvisionerConnection:
    def __init__(
        self,
        *,
        host: builtins.str,
        type: builtins.str,
        agent: typing.Optional[builtins.str] = None,
        agent_identity: typing.Optional[builtins.str] = None,
        bastion_certificate: typing.Optional[builtins.str] = None,
        bastion_host: typing.Optional[builtins.str] = None,
        bastion_host_key: typing.Optional[builtins.str] = None,
        bastion_password: typing.Optional[builtins.str] = None,
        bastion_port: typing.Optional[jsii.Number] = None,
        bastion_private_key: typing.Optional[builtins.str] = None,
        bastion_user: typing.Optional[builtins.str] = None,
        certificate: typing.Optional[builtins.str] = None,
        host_key: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        private_key: typing.Optional[builtins.str] = None,
        proxy_host: typing.Optional[builtins.str] = None,
        proxy_port: typing.Optional[jsii.Number] = None,
        proxy_scheme: typing.Optional[builtins.str] = None,
        proxy_user_name: typing.Optional[builtins.str] = None,
        proxy_user_password: typing.Optional[builtins.str] = None,
        script_path: typing.Optional[builtins.str] = None,
        target_platform: typing.Optional[builtins.str] = None,
        timeout: typing.Optional[builtins.str] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Most provisioners require access to the remote resource via SSH or WinRM and expect a nested connection block with details about how to connect.

        Refer to {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/connection connection}

        :param host: (experimental) The address of the resource to connect to.
        :param type: (experimental) The connection type. Valid values are "ssh" and "winrm". Provisioners typically assume that the remote system runs Microsoft Windows when using WinRM. Behaviors based on the SSH target_platform will force Windows-specific behavior for WinRM, unless otherwise specified.
        :param agent: (experimental) Set to false to disable using ssh-agent to authenticate. On Windows the only supported SSH authentication agent is Pageant.
        :param agent_identity: (experimental) The preferred identity from the ssh agent for authentication.
        :param bastion_certificate: (experimental) The contents of a signed CA Certificate. The certificate argument must be used in conjunction with a bastion_private_key. These can be loaded from a file on disk using the the file function.
        :param bastion_host: (experimental) Setting this enables the bastion Host connection. The provisioner will connect to bastion_host first, and then connect from there to host.
        :param bastion_host_key: (experimental) The public key from the remote host or the signing CA, used to verify the host connection.
        :param bastion_password: (experimental) The password to use for the bastion host.
        :param bastion_port: (experimental) The port to use connect to the bastion host.
        :param bastion_private_key: (experimental) The contents of an SSH key file to use for the bastion host. These can be loaded from a file on disk using the file function.
        :param bastion_user: (experimental) The user for the connection to the bastion host.
        :param certificate: (experimental) The contents of a signed CA Certificate. The certificate argument must be used in conjunction with a private_key. These can be loaded from a file on disk using the the file function.
        :param host_key: (experimental) The public key from the remote host or the signing CA, used to verify the connection.
        :param password: (experimental) The password to use for the connection.
        :param port: (experimental) The port to connect to. Default: 22
        :param private_key: (experimental) The contents of an SSH key to use for the connection. These can be loaded from a file on disk using the file function. This takes preference over password if provided.
        :param proxy_host: (experimental) Setting this enables the SSH over HTTP connection. This host will be connected to first, and then the host or bastion_host connection will be made from there.
        :param proxy_port: (experimental) The port to use connect to the proxy host.
        :param proxy_scheme: (experimental) The ssh connection also supports the following fields to facilitate connections by SSH over HTTP proxy.
        :param proxy_user_name: (experimental) The username to use connect to the private proxy host. This argument should be specified only if authentication is required for the HTTP Proxy server.
        :param proxy_user_password: (experimental) The password to use connect to the private proxy host. This argument should be specified only if authentication is required for the HTTP Proxy server.
        :param script_path: (experimental) The path used to copy scripts meant for remote execution. Refer to {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/connection#how-provisioners-execute-remote-scripts How Provisioners Execute Remote Scripts below for more details}
        :param target_platform: (experimental) The target platform to connect to. Valid values are "windows" and "unix". If the platform is set to windows, the default script_path is c:\\windows\\temp\\terraform_%RAND%.cmd, assuming the SSH default shell is cmd.exe. If the SSH default shell is PowerShell, set script_path to "c:/windows/temp/terraform_%RAND%.ps1" Default: unix
        :param timeout: (experimental) The timeout to wait for the connection to become available. Should be provided as a string (e.g., "30s" or "5m".) Default: 5m
        :param user: (experimental) The user to use for the connection. Default: root

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9dcc2ebd19f1995e8977143fdfe63a27dd30084315d09b221a954af52bbbae7f)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument agent", value=agent, expected_type=type_hints["agent"])
            check_type(argname="argument agent_identity", value=agent_identity, expected_type=type_hints["agent_identity"])
            check_type(argname="argument bastion_certificate", value=bastion_certificate, expected_type=type_hints["bastion_certificate"])
            check_type(argname="argument bastion_host", value=bastion_host, expected_type=type_hints["bastion_host"])
            check_type(argname="argument bastion_host_key", value=bastion_host_key, expected_type=type_hints["bastion_host_key"])
            check_type(argname="argument bastion_password", value=bastion_password, expected_type=type_hints["bastion_password"])
            check_type(argname="argument bastion_port", value=bastion_port, expected_type=type_hints["bastion_port"])
            check_type(argname="argument bastion_private_key", value=bastion_private_key, expected_type=type_hints["bastion_private_key"])
            check_type(argname="argument bastion_user", value=bastion_user, expected_type=type_hints["bastion_user"])
            check_type(argname="argument certificate", value=certificate, expected_type=type_hints["certificate"])
            check_type(argname="argument host_key", value=host_key, expected_type=type_hints["host_key"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument private_key", value=private_key, expected_type=type_hints["private_key"])
            check_type(argname="argument proxy_host", value=proxy_host, expected_type=type_hints["proxy_host"])
            check_type(argname="argument proxy_port", value=proxy_port, expected_type=type_hints["proxy_port"])
            check_type(argname="argument proxy_scheme", value=proxy_scheme, expected_type=type_hints["proxy_scheme"])
            check_type(argname="argument proxy_user_name", value=proxy_user_name, expected_type=type_hints["proxy_user_name"])
            check_type(argname="argument proxy_user_password", value=proxy_user_password, expected_type=type_hints["proxy_user_password"])
            check_type(argname="argument script_path", value=script_path, expected_type=type_hints["script_path"])
            check_type(argname="argument target_platform", value=target_platform, expected_type=type_hints["target_platform"])
            check_type(argname="argument timeout", value=timeout, expected_type=type_hints["timeout"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "host": host,
            "type": type,
        }
        if agent is not None:
            self._values["agent"] = agent
        if agent_identity is not None:
            self._values["agent_identity"] = agent_identity
        if bastion_certificate is not None:
            self._values["bastion_certificate"] = bastion_certificate
        if bastion_host is not None:
            self._values["bastion_host"] = bastion_host
        if bastion_host_key is not None:
            self._values["bastion_host_key"] = bastion_host_key
        if bastion_password is not None:
            self._values["bastion_password"] = bastion_password
        if bastion_port is not None:
            self._values["bastion_port"] = bastion_port
        if bastion_private_key is not None:
            self._values["bastion_private_key"] = bastion_private_key
        if bastion_user is not None:
            self._values["bastion_user"] = bastion_user
        if certificate is not None:
            self._values["certificate"] = certificate
        if host_key is not None:
            self._values["host_key"] = host_key
        if password is not None:
            self._values["password"] = password
        if port is not None:
            self._values["port"] = port
        if private_key is not None:
            self._values["private_key"] = private_key
        if proxy_host is not None:
            self._values["proxy_host"] = proxy_host
        if proxy_port is not None:
            self._values["proxy_port"] = proxy_port
        if proxy_scheme is not None:
            self._values["proxy_scheme"] = proxy_scheme
        if proxy_user_name is not None:
            self._values["proxy_user_name"] = proxy_user_name
        if proxy_user_password is not None:
            self._values["proxy_user_password"] = proxy_user_password
        if script_path is not None:
            self._values["script_path"] = script_path
        if target_platform is not None:
            self._values["target_platform"] = target_platform
        if timeout is not None:
            self._values["timeout"] = timeout
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def host(self) -> builtins.str:
        '''(experimental) The address of the resource to connect to.

        :stability: experimental
        '''
        result = self._values.get("host")
        assert result is not None, "Required property 'host' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''(experimental) The connection type.

        Valid values are "ssh" and "winrm".
        Provisioners typically assume that the remote system runs Microsoft Windows when using WinRM.
        Behaviors based on the SSH target_platform will force Windows-specific behavior for WinRM, unless otherwise specified.

        :stability: experimental
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def agent(self) -> typing.Optional[builtins.str]:
        '''(experimental) Set to false to disable using ssh-agent to authenticate.

        On Windows the only supported SSH authentication agent is Pageant.

        :stability: experimental
        '''
        result = self._values.get("agent")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def agent_identity(self) -> typing.Optional[builtins.str]:
        '''(experimental) The preferred identity from the ssh agent for authentication.

        :stability: experimental
        '''
        result = self._values.get("agent_identity")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def bastion_certificate(self) -> typing.Optional[builtins.str]:
        '''(experimental) The contents of a signed CA Certificate.

        The certificate argument must be used in conjunction with a bastion_private_key.
        These can be loaded from a file on disk using the the file function.

        :stability: experimental
        '''
        result = self._values.get("bastion_certificate")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def bastion_host(self) -> typing.Optional[builtins.str]:
        '''(experimental) Setting this enables the bastion Host connection.

        The provisioner will connect to bastion_host first, and then connect from there to host.

        :stability: experimental
        '''
        result = self._values.get("bastion_host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def bastion_host_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) The public key from the remote host or the signing CA, used to verify the host connection.

        :stability: experimental
        '''
        result = self._values.get("bastion_host_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def bastion_password(self) -> typing.Optional[builtins.str]:
        '''(experimental) The password to use for the bastion host.

        :stability: experimental
        '''
        result = self._values.get("bastion_password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def bastion_port(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The port to use connect to the bastion host.

        :stability: experimental
        '''
        result = self._values.get("bastion_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def bastion_private_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) The contents of an SSH key file to use for the bastion host.

        These can be loaded from a file on disk using the file function.

        :stability: experimental
        '''
        result = self._values.get("bastion_private_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def bastion_user(self) -> typing.Optional[builtins.str]:
        '''(experimental) The user for the connection to the bastion host.

        :stability: experimental
        '''
        result = self._values.get("bastion_user")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def certificate(self) -> typing.Optional[builtins.str]:
        '''(experimental) The contents of a signed CA Certificate.

        The certificate argument must be used in conjunction with a private_key.
        These can be loaded from a file on disk using the the file function.

        :stability: experimental
        '''
        result = self._values.get("certificate")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def host_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) The public key from the remote host or the signing CA, used to verify the connection.

        :stability: experimental
        '''
        result = self._values.get("host_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''(experimental) The password to use for the connection.

        :stability: experimental
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The port to connect to.

        :default: 22

        :stability: experimental
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def private_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) The contents of an SSH key to use for the connection.

        These can be loaded from a file on disk using the file function.
        This takes preference over password if provided.

        :stability: experimental
        '''
        result = self._values.get("private_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def proxy_host(self) -> typing.Optional[builtins.str]:
        '''(experimental) Setting this enables the SSH over HTTP connection.

        This host will be connected to first, and then the host or bastion_host connection will be made from there.

        :stability: experimental
        '''
        result = self._values.get("proxy_host")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def proxy_port(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The port to use connect to the proxy host.

        :stability: experimental
        '''
        result = self._values.get("proxy_port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def proxy_scheme(self) -> typing.Optional[builtins.str]:
        '''(experimental) The ssh connection also supports the following fields to facilitate connections by SSH over HTTP proxy.

        :stability: experimental
        '''
        result = self._values.get("proxy_scheme")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def proxy_user_name(self) -> typing.Optional[builtins.str]:
        '''(experimental) The username to use connect to the private proxy host.

        This argument should be specified only if authentication is required for the HTTP Proxy server.

        :stability: experimental
        '''
        result = self._values.get("proxy_user_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def proxy_user_password(self) -> typing.Optional[builtins.str]:
        '''(experimental) The password to use connect to the private proxy host.

        This argument should be specified only if authentication is required for the HTTP Proxy server.

        :stability: experimental
        '''
        result = self._values.get("proxy_user_password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def script_path(self) -> typing.Optional[builtins.str]:
        '''(experimental) The path used to copy scripts meant for remote execution.

        Refer to {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/connection#how-provisioners-execute-remote-scripts How Provisioners Execute Remote Scripts below for more details}

        :stability: experimental
        '''
        result = self._values.get("script_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def target_platform(self) -> typing.Optional[builtins.str]:
        '''(experimental) The target platform to connect to.

        Valid values are "windows" and "unix".
        If the platform is set to windows, the default script_path is c:\\windows\\temp\\terraform_%RAND%.cmd, assuming the SSH default shell is cmd.exe.
        If the SSH default shell is PowerShell, set script_path to "c:/windows/temp/terraform_%RAND%.ps1"

        :default: unix

        :stability: experimental
        '''
        result = self._values.get("target_platform")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def timeout(self) -> typing.Optional[builtins.str]:
        '''(experimental) The timeout to wait for the connection to become available.

        Should be provided as a string (e.g., "30s" or "5m".)

        :default: 5m

        :stability: experimental
        '''
        result = self._values.get("timeout")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''(experimental) The user to use for the connection.

        :default: root

        :stability: experimental
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SSHProvisionerConnection(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.StackAnnotation",
    jsii_struct_bases=[],
    name_mapping={
        "construct_path": "constructPath",
        "level": "level",
        "message": "message",
        "stacktrace": "stacktrace",
    },
)
class StackAnnotation:
    def __init__(
        self,
        *,
        construct_path: builtins.str,
        level: AnnotationMetadataEntryType,
        message: builtins.str,
        stacktrace: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param construct_path: 
        :param level: 
        :param message: 
        :param stacktrace: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5bea199c879881a36dcad688a3de77348813b71cca2e75042f317476f48d571a)
            check_type(argname="argument construct_path", value=construct_path, expected_type=type_hints["construct_path"])
            check_type(argname="argument level", value=level, expected_type=type_hints["level"])
            check_type(argname="argument message", value=message, expected_type=type_hints["message"])
            check_type(argname="argument stacktrace", value=stacktrace, expected_type=type_hints["stacktrace"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "construct_path": construct_path,
            "level": level,
            "message": message,
        }
        if stacktrace is not None:
            self._values["stacktrace"] = stacktrace

    @builtins.property
    def construct_path(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("construct_path")
        assert result is not None, "Required property 'construct_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def level(self) -> AnnotationMetadataEntryType:
        '''
        :stability: experimental
        '''
        result = self._values.get("level")
        assert result is not None, "Required property 'level' is missing"
        return typing.cast(AnnotationMetadataEntryType, result)

    @builtins.property
    def message(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("message")
        assert result is not None, "Required property 'message' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def stacktrace(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("stacktrace")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "StackAnnotation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.StackManifest",
    jsii_struct_bases=[],
    name_mapping={
        "annotations": "annotations",
        "construct_path": "constructPath",
        "dependencies": "dependencies",
        "name": "name",
        "synthesized_stack_path": "synthesizedStackPath",
        "working_directory": "workingDirectory",
    },
)
class StackManifest:
    def __init__(
        self,
        *,
        annotations: typing.Sequence[typing.Union[StackAnnotation, typing.Dict[builtins.str, typing.Any]]],
        construct_path: builtins.str,
        dependencies: typing.Sequence[builtins.str],
        name: builtins.str,
        synthesized_stack_path: builtins.str,
        working_directory: builtins.str,
    ) -> None:
        '''
        :param annotations: 
        :param construct_path: 
        :param dependencies: 
        :param name: 
        :param synthesized_stack_path: 
        :param working_directory: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7366ee8d34bdd4492749341ffe9629542a7d0d69095030cd5275a8fe21ef8040)
            check_type(argname="argument annotations", value=annotations, expected_type=type_hints["annotations"])
            check_type(argname="argument construct_path", value=construct_path, expected_type=type_hints["construct_path"])
            check_type(argname="argument dependencies", value=dependencies, expected_type=type_hints["dependencies"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument synthesized_stack_path", value=synthesized_stack_path, expected_type=type_hints["synthesized_stack_path"])
            check_type(argname="argument working_directory", value=working_directory, expected_type=type_hints["working_directory"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "annotations": annotations,
            "construct_path": construct_path,
            "dependencies": dependencies,
            "name": name,
            "synthesized_stack_path": synthesized_stack_path,
            "working_directory": working_directory,
        }

    @builtins.property
    def annotations(self) -> typing.List[StackAnnotation]:
        '''
        :stability: experimental
        '''
        result = self._values.get("annotations")
        assert result is not None, "Required property 'annotations' is missing"
        return typing.cast(typing.List[StackAnnotation], result)

    @builtins.property
    def construct_path(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("construct_path")
        assert result is not None, "Required property 'construct_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def dependencies(self) -> typing.List[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("dependencies")
        assert result is not None, "Required property 'dependencies' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def synthesized_stack_path(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("synthesized_stack_path")
        assert result is not None, "Required property 'synthesized_stack_path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def working_directory(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("working_directory")
        assert result is not None, "Required property 'working_directory' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "StackManifest(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IFragmentConcatenator)
class StringConcat(metaclass=jsii.JSIIMeta, jsii_type="cdktf.StringConcat"):
    '''(experimental) Converts all fragments to strings and concats those.

    Drops 'undefined's.

    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="join")
    def join(self, left: typing.Any, right: typing.Any) -> typing.Any:
        '''(experimental) Concatenates string fragments.

        :param left: -
        :param right: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3399e87a9c6cdde1acb2808fe872724a1e61aeb316712621986ae9ba42f47fc7)
            check_type(argname="argument left", value=left, expected_type=type_hints["left"])
            check_type(argname="argument right", value=right, expected_type=type_hints["right"])
        return typing.cast(typing.Any, jsii.invoke(self, "join", [left, right]))


@jsii.implements(ITerraformAddressable, IResolvable)
class StringMap(metaclass=jsii.JSIIMeta, jsii_type="cdktf.StringMap"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d78b93062ef99f0ed74b487b511225ccba7a2d5e4a112636968f75f9987e1c7)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="computeFqn")
    def compute_fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "computeFqn", []))

    @jsii.member(jsii_name="lookup")
    def lookup(self, key: builtins.str) -> builtins.str:
        '''
        :param key: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e9f9dc1364ed8eb8d45d444b770a10a603c2499a544fb3c51408ff512684a627)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(builtins.str, jsii.invoke(self, "lookup", [key]))

    @jsii.member(jsii_name="resolve")
    def resolve(self, _context: IResolveContext) -> typing.Any:
        '''(experimental) Produce the Token's value at resolution time.

        :param _context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e5185a7f1eeecd9bda91f6ecdb193858bc02175f9dca3532a323d80cca48342b)
            check_type(argname="argument _context", value=_context, expected_type=type_hints["_context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolve", [_context]))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Return a string representation of this resolvable object.

        Returns a reversible string representation.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @builtins.property
    @jsii.member(jsii_name="creationStack")
    def creation_stack(self) -> typing.List[builtins.str]:
        '''(experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.

        If this returns an empty array the stack will not be attached.

        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "creationStack"))

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6fb2977463e8e9060f35d7b82ac95a4a5404971759a55d40a47ed5540ee50fc7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__262fa0e9d0edc03e1fbace0ee43d9564397fe1f2c26de078059e1016e11e875e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)


class StringMapList(MapList, metaclass=jsii.JSIIMeta, jsii_type="cdktf.StringMapList"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param wraps_set: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4cbf0552b4e8fa57f0fbc65384a9902e04d857fc9c17403394f071c8020c2d41)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> StringMap:
        '''
        :param index: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__01400c822b014bb747cd3b20c8ee5eb7319b67adaf5a23d542bb0af6001b2187)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast(StringMap, jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2eefeadb52be1ce433a22d1e070c7830025bc053e51614ff0394534ec2cf5458)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__27aaf1e13ea10ab122e473428bbd8284b74a02a3dc782443af08fbe64e6976a5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__767ad19c65ba5e98bf18455c1e7efba0e5803d08f20d11e20cead2e50f8a8d4b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)


@jsii.data_type(
    jsii_type="cdktf.SwiftBackendConfig",
    jsii_struct_bases=[],
    name_mapping={
        "container": "container",
        "application_credential_id": "applicationCredentialId",
        "application_credential_name": "applicationCredentialName",
        "application_credential_secret": "applicationCredentialSecret",
        "archive_container": "archiveContainer",
        "auth_url": "authUrl",
        "cacert_file": "cacertFile",
        "cert": "cert",
        "cloud": "cloud",
        "default_domain": "defaultDomain",
        "domain_id": "domainId",
        "domain_name": "domainName",
        "expire_after": "expireAfter",
        "insecure": "insecure",
        "key": "key",
        "password": "password",
        "project_domain_id": "projectDomainId",
        "project_domain_name": "projectDomainName",
        "region_name": "regionName",
        "state_name": "stateName",
        "tenant_id": "tenantId",
        "tenant_name": "tenantName",
        "token": "token",
        "user_domain_id": "userDomainId",
        "user_domain_name": "userDomainName",
        "user_id": "userId",
        "user_name": "userName",
    },
)
class SwiftBackendConfig:
    def __init__(
        self,
        *,
        container: builtins.str,
        application_credential_id: typing.Optional[builtins.str] = None,
        application_credential_name: typing.Optional[builtins.str] = None,
        application_credential_secret: typing.Optional[builtins.str] = None,
        archive_container: typing.Optional[builtins.str] = None,
        auth_url: typing.Optional[builtins.str] = None,
        cacert_file: typing.Optional[builtins.str] = None,
        cert: typing.Optional[builtins.str] = None,
        cloud: typing.Optional[builtins.str] = None,
        default_domain: typing.Optional[builtins.str] = None,
        domain_id: typing.Optional[builtins.str] = None,
        domain_name: typing.Optional[builtins.str] = None,
        expire_after: typing.Optional[builtins.str] = None,
        insecure: typing.Optional[builtins.bool] = None,
        key: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        project_domain_id: typing.Optional[builtins.str] = None,
        project_domain_name: typing.Optional[builtins.str] = None,
        region_name: typing.Optional[builtins.str] = None,
        state_name: typing.Optional[builtins.str] = None,
        tenant_id: typing.Optional[builtins.str] = None,
        tenant_name: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
        user_domain_id: typing.Optional[builtins.str] = None,
        user_domain_name: typing.Optional[builtins.str] = None,
        user_id: typing.Optional[builtins.str] = None,
        user_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param container: 
        :param application_credential_id: 
        :param application_credential_name: 
        :param application_credential_secret: 
        :param archive_container: 
        :param auth_url: 
        :param cacert_file: 
        :param cert: 
        :param cloud: 
        :param default_domain: 
        :param domain_id: 
        :param domain_name: 
        :param expire_after: 
        :param insecure: 
        :param key: 
        :param password: 
        :param project_domain_id: 
        :param project_domain_name: 
        :param region_name: 
        :param state_name: 
        :param tenant_id: 
        :param tenant_name: 
        :param token: 
        :param user_domain_id: 
        :param user_domain_name: 
        :param user_id: 
        :param user_name: 

        :deprecated: CDK for Terraform no longer supports the swift backend. Terraform deprecated swift in v1.2.3 and removed it in v1.3.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ce066d1c29f07254aeee7e1186a2ceb2bd4ff5cf497cdae98b6a797dc78449cc)
            check_type(argname="argument container", value=container, expected_type=type_hints["container"])
            check_type(argname="argument application_credential_id", value=application_credential_id, expected_type=type_hints["application_credential_id"])
            check_type(argname="argument application_credential_name", value=application_credential_name, expected_type=type_hints["application_credential_name"])
            check_type(argname="argument application_credential_secret", value=application_credential_secret, expected_type=type_hints["application_credential_secret"])
            check_type(argname="argument archive_container", value=archive_container, expected_type=type_hints["archive_container"])
            check_type(argname="argument auth_url", value=auth_url, expected_type=type_hints["auth_url"])
            check_type(argname="argument cacert_file", value=cacert_file, expected_type=type_hints["cacert_file"])
            check_type(argname="argument cert", value=cert, expected_type=type_hints["cert"])
            check_type(argname="argument cloud", value=cloud, expected_type=type_hints["cloud"])
            check_type(argname="argument default_domain", value=default_domain, expected_type=type_hints["default_domain"])
            check_type(argname="argument domain_id", value=domain_id, expected_type=type_hints["domain_id"])
            check_type(argname="argument domain_name", value=domain_name, expected_type=type_hints["domain_name"])
            check_type(argname="argument expire_after", value=expire_after, expected_type=type_hints["expire_after"])
            check_type(argname="argument insecure", value=insecure, expected_type=type_hints["insecure"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument project_domain_id", value=project_domain_id, expected_type=type_hints["project_domain_id"])
            check_type(argname="argument project_domain_name", value=project_domain_name, expected_type=type_hints["project_domain_name"])
            check_type(argname="argument region_name", value=region_name, expected_type=type_hints["region_name"])
            check_type(argname="argument state_name", value=state_name, expected_type=type_hints["state_name"])
            check_type(argname="argument tenant_id", value=tenant_id, expected_type=type_hints["tenant_id"])
            check_type(argname="argument tenant_name", value=tenant_name, expected_type=type_hints["tenant_name"])
            check_type(argname="argument token", value=token, expected_type=type_hints["token"])
            check_type(argname="argument user_domain_id", value=user_domain_id, expected_type=type_hints["user_domain_id"])
            check_type(argname="argument user_domain_name", value=user_domain_name, expected_type=type_hints["user_domain_name"])
            check_type(argname="argument user_id", value=user_id, expected_type=type_hints["user_id"])
            check_type(argname="argument user_name", value=user_name, expected_type=type_hints["user_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container": container,
        }
        if application_credential_id is not None:
            self._values["application_credential_id"] = application_credential_id
        if application_credential_name is not None:
            self._values["application_credential_name"] = application_credential_name
        if application_credential_secret is not None:
            self._values["application_credential_secret"] = application_credential_secret
        if archive_container is not None:
            self._values["archive_container"] = archive_container
        if auth_url is not None:
            self._values["auth_url"] = auth_url
        if cacert_file is not None:
            self._values["cacert_file"] = cacert_file
        if cert is not None:
            self._values["cert"] = cert
        if cloud is not None:
            self._values["cloud"] = cloud
        if default_domain is not None:
            self._values["default_domain"] = default_domain
        if domain_id is not None:
            self._values["domain_id"] = domain_id
        if domain_name is not None:
            self._values["domain_name"] = domain_name
        if expire_after is not None:
            self._values["expire_after"] = expire_after
        if insecure is not None:
            self._values["insecure"] = insecure
        if key is not None:
            self._values["key"] = key
        if password is not None:
            self._values["password"] = password
        if project_domain_id is not None:
            self._values["project_domain_id"] = project_domain_id
        if project_domain_name is not None:
            self._values["project_domain_name"] = project_domain_name
        if region_name is not None:
            self._values["region_name"] = region_name
        if state_name is not None:
            self._values["state_name"] = state_name
        if tenant_id is not None:
            self._values["tenant_id"] = tenant_id
        if tenant_name is not None:
            self._values["tenant_name"] = tenant_name
        if token is not None:
            self._values["token"] = token
        if user_domain_id is not None:
            self._values["user_domain_id"] = user_domain_id
        if user_domain_name is not None:
            self._values["user_domain_name"] = user_domain_name
        if user_id is not None:
            self._values["user_id"] = user_id
        if user_name is not None:
            self._values["user_name"] = user_name

    @builtins.property
    def container(self) -> builtins.str:
        '''
        :stability: deprecated
        '''
        result = self._values.get("container")
        assert result is not None, "Required property 'container' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def application_credential_id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("application_credential_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def application_credential_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("application_credential_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def application_credential_secret(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("application_credential_secret")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def archive_container(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("archive_container")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def auth_url(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("auth_url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cacert_file(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("cacert_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cert(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("cert")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cloud(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("cloud")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def default_domain(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("default_domain")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def domain_id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("domain_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def domain_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("domain_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def expire_after(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("expire_after")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def insecure(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("insecure")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def project_domain_id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("project_domain_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def project_domain_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("project_domain_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("region_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def state_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("state_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tenant_id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("tenant_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tenant_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("tenant_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def token(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user_domain_id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("user_domain_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user_domain_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("user_domain_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user_id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("user_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("user_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SwiftBackendConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TaggedCloudWorkspaces(
    CloudWorkspace,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.TaggedCloudWorkspaces",
):
    '''(experimental) A set of Terraform Cloud workspace tags.

    You will be able to use this working directory with any workspaces that have all of the specified tags, and can use the terraform workspace commands to switch between them or create new workspaces. New workspaces will automatically have the specified tags. This option conflicts with name.

    :stability: experimental
    '''

    def __init__(self, tags: typing.Sequence[builtins.str]) -> None:
        '''
        :param tags: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c4287b0ee15ce873f70ecf7ca58579b5796a5468a064e0e699dc3f60c04b347f)
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        jsii.create(self.__class__, self, [tags])

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.List[builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "tags"))

    @tags.setter
    def tags(self, value: typing.List[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4109af05c0e65229be0aec15742867d10c4358fe2241c4721ad4217cb6c7db37)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "tags", value)


class TerraformAsset(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.TerraformAsset",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        path: builtins.str,
        asset_hash: typing.Optional[builtins.str] = None,
        type: typing.Optional[AssetType] = None,
    ) -> None:
        '''(experimental) A Terraform Asset takes a file or directory outside of the CDK for Terraform context and moves it into it.

        Assets copy referenced files into the stacks context for further usage in other resources.

        :param scope: -
        :param id: -
        :param path: 
        :param asset_hash: 
        :param type: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5904adae06fe789226815218fccc098cd80ceec6022c64910a734fcc5e10d521)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = TerraformAssetConfig(path=path, asset_hash=asset_hash, type=type)

        jsii.create(self.__class__, self, [scope, id, config])

    @builtins.property
    @jsii.member(jsii_name="fileName")
    def file_name(self) -> builtins.str:
        '''(experimental) Name of the asset.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fileName"))

    @builtins.property
    @jsii.member(jsii_name="path")
    def path(self) -> builtins.str:
        '''(experimental) The path relative to the root of the terraform directory in posix format Use this property to reference the asset.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "path"))

    @builtins.property
    @jsii.member(jsii_name="assetHash")
    def asset_hash(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "assetHash"))

    @asset_hash.setter
    def asset_hash(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f8358775252de38bba2cb3e44f7a78d25be5dde0063f40d4bd5dddae5c5b81fe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "assetHash", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> AssetType:
        '''
        :stability: experimental
        '''
        return typing.cast(AssetType, jsii.get(self, "type"))

    @type.setter
    def type(self, value: AssetType) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__728200d5454ebdc51b6d15bc17cbeab1c51f2f2b8dbca693762fa3242fe441ff)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "type", value)


@jsii.data_type(
    jsii_type="cdktf.TerraformAssetConfig",
    jsii_struct_bases=[],
    name_mapping={"path": "path", "asset_hash": "assetHash", "type": "type"},
)
class TerraformAssetConfig:
    def __init__(
        self,
        *,
        path: builtins.str,
        asset_hash: typing.Optional[builtins.str] = None,
        type: typing.Optional[AssetType] = None,
    ) -> None:
        '''
        :param path: 
        :param asset_hash: 
        :param type: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6322ac748b3f77279565453a6c72c42c9ffe58fcecbb89d4ccb87a5d7ad49e37)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument asset_hash", value=asset_hash, expected_type=type_hints["asset_hash"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
        }
        if asset_hash is not None:
            self._values["asset_hash"] = asset_hash
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def path(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def asset_hash(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("asset_hash")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def type(self) -> typing.Optional[AssetType]:
        '''
        :stability: experimental
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[AssetType], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformAssetConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.TerraformCondition",
    jsii_struct_bases=[],
    name_mapping={"condition": "condition", "error_message": "errorMessage"},
)
class TerraformCondition:
    def __init__(self, *, condition: typing.Any, error_message: builtins.str) -> None:
        '''
        :param condition: (experimental) This is a boolean expression that should return true if the intended assumption or guarantee is fulfilled or false if it does not.
        :param error_message: (experimental) This contains the text that Terraform will include as part of error messages when it detects an unmet condition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78e264f3267b7f1dd4ec2e2992582a01cb46eb45e9da29bbf457d7b23cb28d5e)
            check_type(argname="argument condition", value=condition, expected_type=type_hints["condition"])
            check_type(argname="argument error_message", value=error_message, expected_type=type_hints["error_message"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "condition": condition,
            "error_message": error_message,
        }

    @builtins.property
    def condition(self) -> typing.Any:
        '''(experimental) This is a boolean expression that should return true if the intended assumption or guarantee is fulfilled or false if it does not.

        :stability: experimental
        '''
        result = self._values.get("condition")
        assert result is not None, "Required property 'condition' is missing"
        return typing.cast(typing.Any, result)

    @builtins.property
    def error_message(self) -> builtins.str:
        '''(experimental) This contains the text that Terraform will include as part of error messages when it detects an unmet condition.

        :stability: experimental
        '''
        result = self._values.get("error_message")
        assert result is not None, "Required property 'error_message' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformCondition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TerraformCount(metaclass=jsii.JSIIMeta, jsii_type="cdktf.TerraformCount"):
    '''(experimental) Iterator for the Terraform count property.

    :stability: experimental
    '''

    @jsii.member(jsii_name="isTerraformCount")
    @builtins.classmethod
    def is_terraform_count(cls, x: typing.Any) -> builtins.bool:
        '''
        :param x: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c4a386480c1e3f138601b59d288a0202176d9f9a501b3db42b4dcf5a1cd15251)
            check_type(argname="argument x", value=x, expected_type=type_hints["x"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "isTerraformCount", [x]))

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(cls, count: jsii.Number) -> "TerraformCount":
        '''
        :param count: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e7d8fde8bfd3c0eab385497527a6932296194365c52a83868427fe7f8172372)
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
        return typing.cast("TerraformCount", jsii.sinvoke(cls, "of", [count]))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        return typing.cast(jsii.Number, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="index")
    def index(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        return typing.cast(jsii.Number, jsii.get(self, "index"))


class TerraformElement(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.TerraformElement",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        element_type: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param element_type: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0179327d4233f1ffee85f70b689d3de442028b01912d0a7aa178066fcdb1fd0c)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument element_type", value=element_type, expected_type=type_hints["element_type"])
        jsii.create(self.__class__, self, [scope, id, element_type])

    @jsii.member(jsii_name="isTerraformElement")
    @builtins.classmethod
    def is_terraform_element(cls, x: typing.Any) -> builtins.bool:
        '''
        :param x: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__96475989318d338bfb16eea59d3485e3e21bb7af40d1f5ee3c81cd236fec8651)
            check_type(argname="argument x", value=x, expected_type=type_hints["x"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "isTerraformElement", [x]))

    @jsii.member(jsii_name="addOverride")
    def add_override(self, path: builtins.str, value: typing.Any) -> None:
        '''
        :param path: -
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__04bf2051cf9d95b27e9c598e57f0c9c10f690ee55668574d300ca40796d9a6f5)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addOverride", [path, value]))

    @jsii.member(jsii_name="overrideLogicalId")
    def override_logical_id(self, new_logical_id: builtins.str) -> None:
        '''(experimental) Overrides the auto-generated logical ID with a specific ID.

        :param new_logical_id: The new logical ID to use for this stack element.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1b4003980b44a0be252dd8b426961856252cbc9112a9f33dad3a27bf2340343f)
            check_type(argname="argument new_logical_id", value=new_logical_id, expected_type=type_hints["new_logical_id"])
        return typing.cast(None, jsii.invoke(self, "overrideLogicalId", [new_logical_id]))

    @jsii.member(jsii_name="resetOverrideLogicalId")
    def reset_override_logical_id(self) -> None:
        '''(experimental) Resets a previously passed logical Id to use the auto-generated logical id again.

        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "resetOverrideLogicalId", []))

    @jsii.member(jsii_name="toMetadata")
    def to_metadata(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toMetadata", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="cdktfStack")
    def cdktf_stack(self) -> "TerraformStack":
        '''
        :stability: experimental
        '''
        return typing.cast("TerraformStack", jsii.get(self, "cdktfStack"))

    @builtins.property
    @jsii.member(jsii_name="constructNodeMetadata")
    def _construct_node_metadata(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "constructNodeMetadata"))

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

    @builtins.property
    @jsii.member(jsii_name="friendlyUniqueId")
    def friendly_unique_id(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "friendlyUniqueId"))

    @builtins.property
    @jsii.member(jsii_name="rawOverrides")
    def _raw_overrides(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "rawOverrides"))


@jsii.data_type(
    jsii_type="cdktf.TerraformElementMetadata",
    jsii_struct_bases=[],
    name_mapping={
        "path": "path",
        "stack_trace": "stackTrace",
        "unique_id": "uniqueId",
    },
)
class TerraformElementMetadata:
    def __init__(
        self,
        *,
        path: builtins.str,
        stack_trace: typing.Sequence[builtins.str],
        unique_id: builtins.str,
    ) -> None:
        '''
        :param path: 
        :param stack_trace: 
        :param unique_id: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__16c744875f3246b8305a2698f2b73e0a6261dc70614843d066a87eaf7e1efcc9)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument stack_trace", value=stack_trace, expected_type=type_hints["stack_trace"])
            check_type(argname="argument unique_id", value=unique_id, expected_type=type_hints["unique_id"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "path": path,
            "stack_trace": stack_trace,
            "unique_id": unique_id,
        }

    @builtins.property
    def path(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def stack_trace(self) -> typing.List[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("stack_trace")
        assert result is not None, "Required property 'stack_trace' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def unique_id(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("unique_id")
        assert result is not None, "Required property 'unique_id' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformElementMetadata(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ITerraformIterator)
class TerraformIterator(
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdktf.TerraformIterator",
):
    '''
    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="fromList")
    @builtins.classmethod
    def from_list(
        cls,
        list: typing.Union[typing.Sequence[builtins.str], IResolvable, typing.Sequence[jsii.Number], "ComplexList", StringMapList, NumberMapList, "BooleanMapList", "AnyMapList", typing.Sequence[typing.Union[builtins.bool, IResolvable]]],
    ) -> "ListTerraformIterator":
        '''(experimental) Creates a new iterator from a list.

        :param list: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f6ea9ee1035f4ac8cc4ca324a1379483772365af469696e486b47d317dd1ffa3)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
        return typing.cast("ListTerraformIterator", jsii.sinvoke(cls, "fromList", [list]))

    @jsii.member(jsii_name="fromMap")
    @builtins.classmethod
    def from_map(
        cls,
        map: typing.Union["ComplexMap", typing.Mapping[builtins.str, typing.Any], typing.Mapping[builtins.str, builtins.str], typing.Mapping[builtins.str, jsii.Number], typing.Mapping[builtins.str, builtins.bool]],
    ) -> "MapTerraformIterator":
        '''(experimental) Creates a new iterator from a map.

        :param map: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__83b09d28bca4f2116edf45fb6c5e2466589950b679da898c1056d205b63d817a)
            check_type(argname="argument map", value=map, expected_type=type_hints["map"])
        return typing.cast("MapTerraformIterator", jsii.sinvoke(cls, "fromMap", [map]))

    @jsii.member(jsii_name="dynamic")
    def dynamic(
        self,
        attributes: typing.Mapping[builtins.str, typing.Any],
    ) -> IResolvable:
        '''
        :param attributes: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a04a7ecaf8076e573251b9ac31f1a5ea5b0dd7cd2172f49c3ab0a42184e5b87e)
            check_type(argname="argument attributes", value=attributes, expected_type=type_hints["attributes"])
        return typing.cast(IResolvable, jsii.invoke(self, "dynamic", [attributes]))

    @jsii.member(jsii_name="getAny")
    def get_any(self, attribute: builtins.str) -> IResolvable:
        '''
        :param attribute: name of the property to retrieve.

        :return: the given attribute of the current item iterated over as any

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d8af2145837ff9a07999f2a7998a387d2a7c7bb3168a8b76bc29ecc2053208f)
            check_type(argname="argument attribute", value=attribute, expected_type=type_hints["attribute"])
        return typing.cast(IResolvable, jsii.invoke(self, "getAny", [attribute]))

    @jsii.member(jsii_name="getAnyMap")
    def get_any_map(
        self,
        attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param attribute: name of the property to retrieve.

        :return: the given attribute of the current item iterated over as a map of any

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fdd1efbff123f3fefd6936e4c47093ea0bfd453b4e0c1759fb19a67710ad9944)
            check_type(argname="argument attribute", value=attribute, expected_type=type_hints["attribute"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "getAnyMap", [attribute]))

    @jsii.member(jsii_name="getBoolean")
    def get_boolean(self, attribute: builtins.str) -> IResolvable:
        '''
        :param attribute: name of the property to retrieve.

        :return: the given attribute of the current item iterated over as a boolean

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c84a9cfa9b74ba6db49d0afd4dc3a3883c6cab0a71645e385ae98f5df67c528a)
            check_type(argname="argument attribute", value=attribute, expected_type=type_hints["attribute"])
        return typing.cast(IResolvable, jsii.invoke(self, "getBoolean", [attribute]))

    @jsii.member(jsii_name="getBooleanMap")
    def get_boolean_map(
        self,
        attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, builtins.bool]:
        '''
        :param attribute: name of the property to retrieve.

        :return: the given attribute of the current item iterated over as a map of booleans

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d308c417e0b3748c9fe84e66123054bb37206ba3bbf967f2d62831370856d867)
            check_type(argname="argument attribute", value=attribute, expected_type=type_hints["attribute"])
        return typing.cast(typing.Mapping[builtins.str, builtins.bool], jsii.invoke(self, "getBooleanMap", [attribute]))

    @jsii.member(jsii_name="getList")
    def get_list(self, attribute: builtins.str) -> typing.List[builtins.str]:
        '''
        :param attribute: name of the property to retrieve.

        :return: the given attribute of the current item iterated over as a (string) list

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3d35a93aa30dc38ad3797f948482163c4335420b750400bcb2234e68b213bbe8)
            check_type(argname="argument attribute", value=attribute, expected_type=type_hints["attribute"])
        return typing.cast(typing.List[builtins.str], jsii.invoke(self, "getList", [attribute]))

    @jsii.member(jsii_name="getMap")
    def get_map(
        self,
        attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param attribute: name of the property to retrieve.

        :return: the given attribute of the current item iterated over as a map

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e4cbcf0ae877a0c1afb7688eda278066c6f046aaf29ae4f85644cb9b12be65e7)
            check_type(argname="argument attribute", value=attribute, expected_type=type_hints["attribute"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "getMap", [attribute]))

    @jsii.member(jsii_name="getNumber")
    def get_number(self, attribute: builtins.str) -> jsii.Number:
        '''
        :param attribute: name of the property to retrieve.

        :return: the given attribute of the current item iterated over as a number

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__795bb1927d317c894f8f506d960625db91c4b01f01f3e72800a66e1d1afdced0)
            check_type(argname="argument attribute", value=attribute, expected_type=type_hints["attribute"])
        return typing.cast(jsii.Number, jsii.invoke(self, "getNumber", [attribute]))

    @jsii.member(jsii_name="getNumberList")
    def get_number_list(self, attribute: builtins.str) -> typing.List[jsii.Number]:
        '''
        :param attribute: name of the property to retrieve.

        :return: the given attribute of the current item iterated over as a number list

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__36d22783b501fc375a43586eceea7eb5edf04fc687984b070a7c5a64c624e562)
            check_type(argname="argument attribute", value=attribute, expected_type=type_hints["attribute"])
        return typing.cast(typing.List[jsii.Number], jsii.invoke(self, "getNumberList", [attribute]))

    @jsii.member(jsii_name="getNumberMap")
    def get_number_map(
        self,
        attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, jsii.Number]:
        '''
        :param attribute: name of the property to retrieve.

        :return: the given attribute of the current item iterated over as a map of numbers

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__96ca2568d3f59690a8456d498d0deb72d96a913b674d0159dae3ca8850e1df0e)
            check_type(argname="argument attribute", value=attribute, expected_type=type_hints["attribute"])
        return typing.cast(typing.Mapping[builtins.str, jsii.Number], jsii.invoke(self, "getNumberMap", [attribute]))

    @jsii.member(jsii_name="getString")
    def get_string(self, attribute: builtins.str) -> builtins.str:
        '''
        :param attribute: name of the property to retrieve.

        :return: the given attribute of the current item iterated over as a string

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4867d5dc2dddb8c09a52d411100b68092df0aa5e9552653aa9c52d5e2ac28916)
            check_type(argname="argument attribute", value=attribute, expected_type=type_hints["attribute"])
        return typing.cast(builtins.str, jsii.invoke(self, "getString", [attribute]))

    @jsii.member(jsii_name="getStringMap")
    def get_string_map(
        self,
        attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :param attribute: name of the property to retrieve.

        :return: the given attribute of the current item iterated over as a map of strings

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1363804c437b90fa4950e7a3da3e1bc15cd3fbdfbe98e5221074c65b62d6a566)
            check_type(argname="argument attribute", value=attribute, expected_type=type_hints["attribute"])
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.invoke(self, "getStringMap", [attribute]))


class _TerraformIteratorProxy(TerraformIterator):
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, TerraformIterator).__jsii_proxy_class__ = lambda : _TerraformIteratorProxy


@jsii.implements(ITerraformAddressable)
class TerraformLocal(
    TerraformElement,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.TerraformLocal",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        expression: typing.Any,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param expression: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8f1b2327d879da9f988260a68ad46fa966b59e203a7e67da102873d36c3ee4d1)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument expression", value=expression, expected_type=type_hints["expression"])
        jsii.create(self.__class__, self, [scope, id, expression])

    @jsii.member(jsii_name="toMetadata")
    def to_metadata(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toMetadata", []))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Returns a string representation of this construct.

        :return: a string token referencing the value of this local

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="asAnyMap")
    def as_any_map(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "asAnyMap"))

    @builtins.property
    @jsii.member(jsii_name="asBoolean")
    def as_boolean(self) -> IResolvable:
        '''
        :stability: experimental
        '''
        return typing.cast(IResolvable, jsii.get(self, "asBoolean"))

    @builtins.property
    @jsii.member(jsii_name="asBooleanMap")
    def as_boolean_map(self) -> typing.Mapping[builtins.str, builtins.bool]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.bool], jsii.get(self, "asBooleanMap"))

    @builtins.property
    @jsii.member(jsii_name="asList")
    def as_list(self) -> typing.List[builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "asList"))

    @builtins.property
    @jsii.member(jsii_name="asNumber")
    def as_number(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        return typing.cast(jsii.Number, jsii.get(self, "asNumber"))

    @builtins.property
    @jsii.member(jsii_name="asNumberMap")
    def as_number_map(self) -> typing.Mapping[builtins.str, jsii.Number]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, jsii.Number], jsii.get(self, "asNumberMap"))

    @builtins.property
    @jsii.member(jsii_name="asString")
    def as_string(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "asString"))

    @builtins.property
    @jsii.member(jsii_name="asStringMap")
    def as_string_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "asStringMap"))

    @builtins.property
    @jsii.member(jsii_name="expression")
    def expression(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "expression"))

    @expression.setter
    def expression(self, value: typing.Any) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b5d6d81a989ac602586613f56b46223168592c0892b9f4b4ca376e71cf0fb38c)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "expression", value)


@jsii.data_type(
    jsii_type="cdktf.TerraformMetaArguments",
    jsii_struct_bases=[],
    name_mapping={
        "connection": "connection",
        "count": "count",
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "provisioners": "provisioners",
    },
)
class TerraformMetaArguments:
    def __init__(
        self,
        *,
        connection: typing.Optional[typing.Union[typing.Union[SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union["WinrmProvisionerConnection", typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[typing.Union[jsii.Number, TerraformCount]] = None,
        depends_on: typing.Optional[typing.Sequence[ITerraformDependable]] = None,
        for_each: typing.Optional[ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union["TerraformResourceLifecycle", typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional["TerraformProvider"] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 

        :stability: experimental
        '''
        if isinstance(lifecycle, dict):
            lifecycle = TerraformResourceLifecycle(**lifecycle)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__39fb1f41172cf6ec55e0e91c95ba0ecd16ac58f75944fb5b6d8489d5f41b4e91)
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument provisioners", value=provisioners, expected_type=type_hints["provisioners"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if connection is not None:
            self._values["connection"] = connection
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if provisioners is not None:
            self._values["provisioners"] = provisioners

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union[SSHProvisionerConnection, "WinrmProvisionerConnection"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union[SSHProvisionerConnection, "WinrmProvisionerConnection"]], result)

    @builtins.property
    def count(self) -> typing.Optional[typing.Union[jsii.Number, TerraformCount]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[typing.Union[jsii.Number, TerraformCount]], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[ITerraformIterator], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional["TerraformResourceLifecycle"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional["TerraformResourceLifecycle"], result)

    @builtins.property
    def provider(self) -> typing.Optional["TerraformProvider"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional["TerraformProvider"], result)

    @builtins.property
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provisioners")
        return typing.cast(typing.Optional[typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformMetaArguments(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ITerraformDependable)
class TerraformModule(
    TerraformElement,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdktf.TerraformModule",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        source: builtins.str,
        version: typing.Optional[builtins.str] = None,
        depends_on: typing.Optional[typing.Sequence[ITerraformDependable]] = None,
        for_each: typing.Optional[ITerraformIterator] = None,
        providers: typing.Optional[typing.Sequence[typing.Union["TerraformProvider", typing.Union["TerraformModuleProvider", typing.Dict[builtins.str, typing.Any]]]]] = None,
        skip_asset_creation_from_local_modules: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param source: 
        :param version: 
        :param depends_on: 
        :param for_each: 
        :param providers: 
        :param skip_asset_creation_from_local_modules: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29d29b74f0bba8d3d6ada6998d1306f53dca3cda05cc23b5cc5d644ee48f426f)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        options = TerraformModuleConfig(
            source=source,
            version=version,
            depends_on=depends_on,
            for_each=for_each,
            providers=providers,
            skip_asset_creation_from_local_modules=skip_asset_creation_from_local_modules,
        )

        jsii.create(self.__class__, self, [scope, id, options])

    @jsii.member(jsii_name="addProvider")
    def add_provider(
        self,
        provider: typing.Union["TerraformProvider", typing.Union["TerraformModuleProvider", typing.Dict[builtins.str, typing.Any]]],
    ) -> None:
        '''
        :param provider: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__471c00d32e3e3565ff57f56fe0e4d93dd4c7d969fcd9fdcf428238c0afe2c2a3)
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
        return typing.cast(None, jsii.invoke(self, "addProvider", [provider]))

    @jsii.member(jsii_name="getString")
    def get_string(self, output: builtins.str) -> builtins.str:
        '''
        :param output: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__29bfa03ae78a6a674d74fc3e98eb973f819ad73da3b9fb6a2b146e3e1f7cd037)
            check_type(argname="argument output", value=output, expected_type=type_hints["output"])
        return typing.cast(builtins.str, jsii.invoke(self, "getString", [output]))

    @jsii.member(jsii_name="interpolationForOutput")
    def interpolation_for_output(self, module_output: builtins.str) -> IResolvable:
        '''
        :param module_output: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5fec8d1121c27774878d1ff5e99b7f526969653caae485964923f6446cd03a31)
            check_type(argname="argument module_output", value=module_output, expected_type=type_hints["module_output"])
        return typing.cast(IResolvable, jsii.invoke(self, "interpolationForOutput", [module_output]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.member(jsii_name="toMetadata")
    def to_metadata(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toMetadata", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="source")
    def source(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "source"))

    @builtins.property
    @jsii.member(jsii_name="providers")
    def providers(
        self,
    ) -> typing.Optional[typing.List[typing.Union["TerraformProvider", "TerraformModuleProvider"]]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.List[typing.Union["TerraformProvider", "TerraformModuleProvider"]]], jsii.get(self, "providers"))

    @builtins.property
    @jsii.member(jsii_name="skipAssetCreationFromLocalModules")
    def skip_asset_creation_from_local_modules(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "skipAssetCreationFromLocalModules"))

    @builtins.property
    @jsii.member(jsii_name="version")
    def version(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "version"))

    @builtins.property
    @jsii.member(jsii_name="dependsOn")
    def depends_on(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "dependsOn"))

    @depends_on.setter
    def depends_on(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__21926c41203cb69084b9e31257961f9750a83a0669f2d58b74818abfe8723d50)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dependsOn", value)

    @builtins.property
    @jsii.member(jsii_name="forEach")
    def for_each(self) -> typing.Optional[ITerraformIterator]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[ITerraformIterator], jsii.get(self, "forEach"))

    @for_each.setter
    def for_each(self, value: typing.Optional[ITerraformIterator]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__477de2ea56e1e68dcdf8ab8474f87ca8183adcc1a6704f73f2b2807b55f37fa1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "forEach", value)


class _TerraformModuleProxy(TerraformModule):
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, TerraformModule).__jsii_proxy_class__ = lambda : _TerraformModuleProxy


@jsii.data_type(
    jsii_type="cdktf.TerraformModuleProvider",
    jsii_struct_bases=[],
    name_mapping={"module_alias": "moduleAlias", "provider": "provider"},
)
class TerraformModuleProvider:
    def __init__(
        self,
        *,
        module_alias: builtins.str,
        provider: "TerraformProvider",
    ) -> None:
        '''
        :param module_alias: 
        :param provider: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1e5647548710201d9ca95160ff5fb753b4b240992871e6fb33dcb17799d142f4)
            check_type(argname="argument module_alias", value=module_alias, expected_type=type_hints["module_alias"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "module_alias": module_alias,
            "provider": provider,
        }

    @builtins.property
    def module_alias(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("module_alias")
        assert result is not None, "Required property 'module_alias' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def provider(self) -> "TerraformProvider":
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        assert result is not None, "Required property 'provider' is missing"
        return typing.cast("TerraformProvider", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformModuleProvider(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.TerraformModuleUserConfig",
    jsii_struct_bases=[],
    name_mapping={
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "providers": "providers",
        "skip_asset_creation_from_local_modules": "skipAssetCreationFromLocalModules",
    },
)
class TerraformModuleUserConfig:
    def __init__(
        self,
        *,
        depends_on: typing.Optional[typing.Sequence[ITerraformDependable]] = None,
        for_each: typing.Optional[ITerraformIterator] = None,
        providers: typing.Optional[typing.Sequence[typing.Union["TerraformProvider", typing.Union[TerraformModuleProvider, typing.Dict[builtins.str, typing.Any]]]]] = None,
        skip_asset_creation_from_local_modules: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param depends_on: 
        :param for_each: 
        :param providers: 
        :param skip_asset_creation_from_local_modules: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ecbaf27e2d40bd52e98013d49ad409a50a02ca4a39d72400e278ec23b2c837a1)
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument providers", value=providers, expected_type=type_hints["providers"])
            check_type(argname="argument skip_asset_creation_from_local_modules", value=skip_asset_creation_from_local_modules, expected_type=type_hints["skip_asset_creation_from_local_modules"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if providers is not None:
            self._values["providers"] = providers
        if skip_asset_creation_from_local_modules is not None:
            self._values["skip_asset_creation_from_local_modules"] = skip_asset_creation_from_local_modules

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[ITerraformIterator], result)

    @builtins.property
    def providers(
        self,
    ) -> typing.Optional[typing.List[typing.Union["TerraformProvider", TerraformModuleProvider]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("providers")
        return typing.cast(typing.Optional[typing.List[typing.Union["TerraformProvider", TerraformModuleProvider]]], result)

    @builtins.property
    def skip_asset_creation_from_local_modules(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("skip_asset_creation_from_local_modules")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformModuleUserConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TerraformOutput(
    TerraformElement,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.TerraformOutput",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        value: typing.Any,
        depends_on: typing.Optional[typing.Sequence[ITerraformDependable]] = None,
        description: typing.Optional[builtins.str] = None,
        precondition: typing.Optional[typing.Union["Precondition", typing.Dict[builtins.str, typing.Any]]] = None,
        sensitive: typing.Optional[builtins.bool] = None,
        static_id: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param value: 
        :param depends_on: 
        :param description: 
        :param precondition: 
        :param sensitive: 
        :param static_id: (experimental) If set to true the synthesized Terraform Output will be named after the ``id`` passed to the constructor instead of the default (TerraformOutput.friendlyUniqueId). Default: false

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__36a3b105a85c6d47657a5121a9eca4707a95310d788f2a3679591b04d762e26c)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = TerraformOutputConfig(
            value=value,
            depends_on=depends_on,
            description=description,
            precondition=precondition,
            sensitive=sensitive,
            static_id=static_id,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="isTerraformOutput")
    @builtins.classmethod
    def is_terraform_output(cls, x: typing.Any) -> builtins.bool:
        '''
        :param x: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e9ec11c1b9b92184c754947619c4d10afb1cfa0d6c1ab1fa6161ec165d52131f)
            check_type(argname="argument x", value=x, expected_type=type_hints["x"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "isTerraformOutput", [x]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.member(jsii_name="toMetadata")
    def to_metadata(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toMetadata", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="staticId")
    def static_id(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "staticId"))

    @static_id.setter
    def static_id(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b1c65755c7c07cc99b0be5a077e1f24ce30e1c8844557ae4f926cd38d77d16f4)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "staticId", value)

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))

    @value.setter
    def value(self, value: typing.Any) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6f25fb48ebd1cb74e3e0c61381eb2b7d02f55726642d275ab99ee4c55d50f9b9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "value", value)

    @builtins.property
    @jsii.member(jsii_name="dependsOn")
    def depends_on(self) -> typing.Optional[typing.List[ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.List[ITerraformDependable]], jsii.get(self, "dependsOn"))

    @depends_on.setter
    def depends_on(
        self,
        value: typing.Optional[typing.List[ITerraformDependable]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f20c3d28004c72b8e297650841805a3681d7b57e3b6d8e33970714176850dfa6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dependsOn", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @description.setter
    def description(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__79ed3e979fa43b1085d6c04aef8f015ae1fc5941090a992a0324897523a1c0f5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="precondition")
    def precondition(self) -> typing.Optional["Precondition"]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional["Precondition"], jsii.get(self, "precondition"))

    @precondition.setter
    def precondition(self, value: typing.Optional["Precondition"]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__76a5bfca58514336fea48eb8bdee89caad4e66986bb6f5be2dce7942f36557ed)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "precondition", value)

    @builtins.property
    @jsii.member(jsii_name="sensitive")
    def sensitive(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "sensitive"))

    @sensitive.setter
    def sensitive(self, value: typing.Optional[builtins.bool]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__92ecc7239d178b87a3e77f4182c5b7fcc0f4ae2d431e9bf92609cc2454806e36)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "sensitive", value)


@jsii.data_type(
    jsii_type="cdktf.TerraformOutputConfig",
    jsii_struct_bases=[],
    name_mapping={
        "value": "value",
        "depends_on": "dependsOn",
        "description": "description",
        "precondition": "precondition",
        "sensitive": "sensitive",
        "static_id": "staticId",
    },
)
class TerraformOutputConfig:
    def __init__(
        self,
        *,
        value: typing.Any,
        depends_on: typing.Optional[typing.Sequence[ITerraformDependable]] = None,
        description: typing.Optional[builtins.str] = None,
        precondition: typing.Optional[typing.Union["Precondition", typing.Dict[builtins.str, typing.Any]]] = None,
        sensitive: typing.Optional[builtins.bool] = None,
        static_id: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param value: 
        :param depends_on: 
        :param description: 
        :param precondition: 
        :param sensitive: 
        :param static_id: (experimental) If set to true the synthesized Terraform Output will be named after the ``id`` passed to the constructor instead of the default (TerraformOutput.friendlyUniqueId). Default: false

        :stability: experimental
        '''
        if isinstance(precondition, dict):
            precondition = Precondition(**precondition)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0a7b66b5c957c2978b5bf72154d84debe99f43d06a37027fd2d4f4fcab397e8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument precondition", value=precondition, expected_type=type_hints["precondition"])
            check_type(argname="argument sensitive", value=sensitive, expected_type=type_hints["sensitive"])
            check_type(argname="argument static_id", value=static_id, expected_type=type_hints["static_id"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "value": value,
        }
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if description is not None:
            self._values["description"] = description
        if precondition is not None:
            self._values["precondition"] = precondition
        if sensitive is not None:
            self._values["sensitive"] = sensitive
        if static_id is not None:
            self._values["static_id"] = static_id

    @builtins.property
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(typing.Any, result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[ITerraformDependable]], result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def precondition(self) -> typing.Optional["Precondition"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("precondition")
        return typing.cast(typing.Optional["Precondition"], result)

    @builtins.property
    def sensitive(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("sensitive")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def static_id(self) -> typing.Optional[builtins.bool]:
        '''(experimental) If set to true the synthesized Terraform Output will be named after the ``id`` passed to the constructor instead of the default (TerraformOutput.friendlyUniqueId).

        :default: false

        :stability: experimental
        '''
        result = self._values.get("static_id")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformOutputConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TerraformProvider(
    TerraformElement,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdktf.TerraformProvider",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        terraform_resource_type: builtins.str,
        terraform_generator_metadata: typing.Optional[typing.Union["TerraformProviderGeneratorMetadata", typing.Dict[builtins.str, typing.Any]]] = None,
        terraform_provider_source: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param terraform_resource_type: 
        :param terraform_generator_metadata: 
        :param terraform_provider_source: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7c8c9be5a8b8a6b9527edfebd2a85c64037af13412efca3ac2b4aed3dfb87ace)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = TerraformProviderConfig(
            terraform_resource_type=terraform_resource_type,
            terraform_generator_metadata=terraform_generator_metadata,
            terraform_provider_source=terraform_provider_source,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="isTerraformProvider")
    @builtins.classmethod
    def is_terraform_provider(cls, x: typing.Any) -> builtins.bool:
        '''
        :param x: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d9008bc40d564420de5c8f38a6c2523bbdb69f044b4548865df5f6b6d2b1aa8)
            check_type(argname="argument x", value=x, expected_type=type_hints["x"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "isTerraformProvider", [x]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.member(jsii_name="toMetadata")
    def to_metadata(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toMetadata", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''(experimental) Adds this resource to the terraform JSON output.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

    @builtins.property
    @jsii.member(jsii_name="metaAttributes")
    def meta_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "metaAttributes"))

    @builtins.property
    @jsii.member(jsii_name="terraformResourceType")
    def terraform_resource_type(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformResourceType"))

    @builtins.property
    @jsii.member(jsii_name="terraformGeneratorMetadata")
    def terraform_generator_metadata(
        self,
    ) -> typing.Optional["TerraformProviderGeneratorMetadata"]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional["TerraformProviderGeneratorMetadata"], jsii.get(self, "terraformGeneratorMetadata"))

    @builtins.property
    @jsii.member(jsii_name="terraformProviderSource")
    def terraform_provider_source(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "terraformProviderSource"))

    @builtins.property
    @jsii.member(jsii_name="alias")
    def alias(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "alias"))

    @alias.setter
    def alias(self, value: typing.Optional[builtins.str]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b261427b92a923b3ce466f40c54e2fe7141cceaebd680e75d15f16f1be4d6c8d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "alias", value)


class _TerraformProviderProxy(TerraformProvider):
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, TerraformProvider).__jsii_proxy_class__ = lambda : _TerraformProviderProxy


@jsii.data_type(
    jsii_type="cdktf.TerraformProviderConfig",
    jsii_struct_bases=[],
    name_mapping={
        "terraform_resource_type": "terraformResourceType",
        "terraform_generator_metadata": "terraformGeneratorMetadata",
        "terraform_provider_source": "terraformProviderSource",
    },
)
class TerraformProviderConfig:
    def __init__(
        self,
        *,
        terraform_resource_type: builtins.str,
        terraform_generator_metadata: typing.Optional[typing.Union["TerraformProviderGeneratorMetadata", typing.Dict[builtins.str, typing.Any]]] = None,
        terraform_provider_source: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param terraform_resource_type: 
        :param terraform_generator_metadata: 
        :param terraform_provider_source: 

        :stability: experimental
        '''
        if isinstance(terraform_generator_metadata, dict):
            terraform_generator_metadata = TerraformProviderGeneratorMetadata(**terraform_generator_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3f273a6bd4815eac8993e4f42dcbdc2bc475f5336e8098c34c81c21df46d9fd0)
            check_type(argname="argument terraform_resource_type", value=terraform_resource_type, expected_type=type_hints["terraform_resource_type"])
            check_type(argname="argument terraform_generator_metadata", value=terraform_generator_metadata, expected_type=type_hints["terraform_generator_metadata"])
            check_type(argname="argument terraform_provider_source", value=terraform_provider_source, expected_type=type_hints["terraform_provider_source"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "terraform_resource_type": terraform_resource_type,
        }
        if terraform_generator_metadata is not None:
            self._values["terraform_generator_metadata"] = terraform_generator_metadata
        if terraform_provider_source is not None:
            self._values["terraform_provider_source"] = terraform_provider_source

    @builtins.property
    def terraform_resource_type(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("terraform_resource_type")
        assert result is not None, "Required property 'terraform_resource_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def terraform_generator_metadata(
        self,
    ) -> typing.Optional["TerraformProviderGeneratorMetadata"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("terraform_generator_metadata")
        return typing.cast(typing.Optional["TerraformProviderGeneratorMetadata"], result)

    @builtins.property
    def terraform_provider_source(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("terraform_provider_source")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformProviderConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.TerraformProviderGeneratorMetadata",
    jsii_struct_bases=[],
    name_mapping={
        "provider_name": "providerName",
        "provider_version": "providerVersion",
        "provider_version_constraint": "providerVersionConstraint",
    },
)
class TerraformProviderGeneratorMetadata:
    def __init__(
        self,
        *,
        provider_name: builtins.str,
        provider_version: typing.Optional[builtins.str] = None,
        provider_version_constraint: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param provider_name: 
        :param provider_version: 
        :param provider_version_constraint: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9bafd746d7d0a388424f35f76f0695b8bc17b37f3814e7c10ddfa43e62011f1e)
            check_type(argname="argument provider_name", value=provider_name, expected_type=type_hints["provider_name"])
            check_type(argname="argument provider_version", value=provider_version, expected_type=type_hints["provider_version"])
            check_type(argname="argument provider_version_constraint", value=provider_version_constraint, expected_type=type_hints["provider_version_constraint"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "provider_name": provider_name,
        }
        if provider_version is not None:
            self._values["provider_version"] = provider_version
        if provider_version_constraint is not None:
            self._values["provider_version_constraint"] = provider_version_constraint

    @builtins.property
    def provider_name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider_name")
        assert result is not None, "Required property 'provider_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def provider_version(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider_version")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def provider_version_constraint(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider_version_constraint")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformProviderGeneratorMetadata(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ITerraformAddressable)
class TerraformRemoteState(
    TerraformElement,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdktf.TerraformRemoteState",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        backend: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param backend: -
        :param defaults: 
        :param workspace: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9554854b20b580dc0f65651063645f5eb9babb1b2db23e4a2b61e676146d3d60)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
        config = DataTerraformRemoteStateConfig(defaults=defaults, workspace=workspace)

        jsii.create(self.__class__, self, [scope, id, backend, config])

    @jsii.member(jsii_name="get")
    def get(self, output: builtins.str) -> IResolvable:
        '''
        :param output: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__35328b6342ddad06d49b1e625048de0cef7b556e8eacf498abcd353e23223a59)
            check_type(argname="argument output", value=output, expected_type=type_hints["output"])
        return typing.cast(IResolvable, jsii.invoke(self, "get", [output]))

    @jsii.member(jsii_name="getBoolean")
    def get_boolean(self, output: builtins.str) -> IResolvable:
        '''
        :param output: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a92a7aecd1e4e93f06014f7bcc1f43f2494c375a2c6d1b59d672df0c19322143)
            check_type(argname="argument output", value=output, expected_type=type_hints["output"])
        return typing.cast(IResolvable, jsii.invoke(self, "getBoolean", [output]))

    @jsii.member(jsii_name="getList")
    def get_list(self, output: builtins.str) -> typing.List[builtins.str]:
        '''
        :param output: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__729c70e8216a9f253af8dcd60e25201b12cae927149a965bc6a411491f1d0135)
            check_type(argname="argument output", value=output, expected_type=type_hints["output"])
        return typing.cast(typing.List[builtins.str], jsii.invoke(self, "getList", [output]))

    @jsii.member(jsii_name="getNumber")
    def get_number(self, output: builtins.str) -> jsii.Number:
        '''
        :param output: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ce29a3248ce70121c26dfe4f56e202f7e024bfa3b5108537b88d96dfd1bc278b)
            check_type(argname="argument output", value=output, expected_type=type_hints["output"])
        return typing.cast(jsii.Number, jsii.invoke(self, "getNumber", [output]))

    @jsii.member(jsii_name="getString")
    def get_string(self, output: builtins.str) -> builtins.str:
        '''
        :param output: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__945ebf3417cb1d1066ce69ffb3eecf44fcd08d13f2df5e477a36fc9411be7138)
            check_type(argname="argument output", value=output, expected_type=type_hints["output"])
        return typing.cast(builtins.str, jsii.invoke(self, "getString", [output]))

    @jsii.member(jsii_name="toMetadata")
    def to_metadata(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toMetadata", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''(experimental) Adds this resource to the terraform JSON output.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="tfResourceType")
    def TF_RESOURCE_TYPE(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "tfResourceType"))


class _TerraformRemoteStateProxy(TerraformRemoteState):
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, TerraformRemoteState).__jsii_proxy_class__ = lambda : _TerraformRemoteStateProxy


@jsii.implements(ITerraformResource, ITerraformDependable, IInterpolatingParent)
class TerraformResource(
    TerraformElement,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.TerraformResource",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        terraform_resource_type: builtins.str,
        terraform_generator_metadata: typing.Optional[typing.Union[TerraformProviderGeneratorMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        connection: typing.Optional[typing.Union[typing.Union[SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union["WinrmProvisionerConnection", typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[typing.Union[jsii.Number, TerraformCount]] = None,
        depends_on: typing.Optional[typing.Sequence[ITerraformDependable]] = None,
        for_each: typing.Optional[ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union["TerraformResourceLifecycle", typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param terraform_resource_type: 
        :param terraform_generator_metadata: 
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0cb2cf41cfcadbcd914117fb91655f58fd431e3da8ed3e7c11dc87898c06035d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = TerraformResourceConfig(
            terraform_resource_type=terraform_resource_type,
            terraform_generator_metadata=terraform_generator_metadata,
            connection=connection,
            count=count,
            depends_on=depends_on,
            for_each=for_each,
            lifecycle=lifecycle,
            provider=provider,
            provisioners=provisioners,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="isTerraformResource")
    @builtins.classmethod
    def is_terraform_resource(cls, x: typing.Any) -> builtins.bool:
        '''
        :param x: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__20e6b846df3179513287f11b2c73284fdb82400cf6f97c2e3f71d0d91f1d0092)
            check_type(argname="argument x", value=x, expected_type=type_hints["x"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "isTerraformResource", [x]))

    @jsii.member(jsii_name="getAnyMapAttribute")
    def get_any_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__341fc832f0679a44ff5a36c177cc0366cdf225e98445f98931a82339c702b5a6)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "getAnyMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getBooleanAttribute")
    def get_boolean_attribute(self, terraform_attribute: builtins.str) -> IResolvable:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__56c27c15cbe3a6295560644a9e186db05f90280506bcb8b49cd691daff4c6e7c)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(IResolvable, jsii.invoke(self, "getBooleanAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getBooleanMapAttribute")
    def get_boolean_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, builtins.bool]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ea5199ee8b2ebedcd733c588706c4a1c60d85219c6d21f5e8f6f0307d5ca5746)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, builtins.bool], jsii.invoke(self, "getBooleanMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getListAttribute")
    def get_list_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.List[builtins.str]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d40f652ecf963c8dad7fb564a3f3f419439e8ff7d8c5a71a74f882f7fe546d6f)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.List[builtins.str], jsii.invoke(self, "getListAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getNumberAttribute")
    def get_number_attribute(self, terraform_attribute: builtins.str) -> jsii.Number:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1fa6956da0fcf6751dbd511fba442db3f0f71c3f3d84a91b5bf8edec895626cc)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(jsii.Number, jsii.invoke(self, "getNumberAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getNumberListAttribute")
    def get_number_list_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.List[jsii.Number]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__edc01990664ae0f33d299dfad7b6c7ebbc45f8b5f5b6a71bb2749512d83a35e9)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.List[jsii.Number], jsii.invoke(self, "getNumberListAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getNumberMapAttribute")
    def get_number_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, jsii.Number]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1c4f371e8928f9f870dbe505b14f9f80184eeac01c03b39eed27d59c9d7e05f7)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, jsii.Number], jsii.invoke(self, "getNumberMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getStringAttribute")
    def get_string_attribute(self, terraform_attribute: builtins.str) -> builtins.str:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1eaa341359443fcb8bf61c7d37141bab017aa6d9ebd0decf3ae3bfd78a2d63c1)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(builtins.str, jsii.invoke(self, "getStringAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getStringMapAttribute")
    def get_string_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ea26189d0f86f2ebfa79650ea435e4fd7bad5ac4dccf2525a7b7d98d3def202)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.invoke(self, "getStringMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="interpolationForAttribute")
    def interpolation_for_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> IResolvable:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b1ceb5b8b176294c6f7edd346fabf3d9dc2f4767f6ac31797876b75121d96c03)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(IResolvable, jsii.invoke(self, "interpolationForAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.member(jsii_name="toMetadata")
    def to_metadata(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toMetadata", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''(experimental) Adds this resource to the terraform JSON output.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="terraformMetaArguments")
    def terraform_meta_arguments(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "terraformMetaArguments"))

    @builtins.property
    @jsii.member(jsii_name="terraformResourceType")
    def terraform_resource_type(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformResourceType"))

    @builtins.property
    @jsii.member(jsii_name="terraformGeneratorMetadata")
    def terraform_generator_metadata(
        self,
    ) -> typing.Optional[TerraformProviderGeneratorMetadata]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[TerraformProviderGeneratorMetadata], jsii.get(self, "terraformGeneratorMetadata"))

    @builtins.property
    @jsii.member(jsii_name="connection")
    def connection(
        self,
    ) -> typing.Optional[typing.Union[SSHProvisionerConnection, "WinrmProvisionerConnection"]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.Union[SSHProvisionerConnection, "WinrmProvisionerConnection"]], jsii.get(self, "connection"))

    @connection.setter
    def connection(
        self,
        value: typing.Optional[typing.Union[SSHProvisionerConnection, "WinrmProvisionerConnection"]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a73d22256f953749b2bf4c143ff6ff6933d60bb532c2db6a687996850fda0d02)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "connection", value)

    @builtins.property
    @jsii.member(jsii_name="count")
    def count(self) -> typing.Optional[typing.Union[jsii.Number, TerraformCount]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.Union[jsii.Number, TerraformCount]], jsii.get(self, "count"))

    @count.setter
    def count(
        self,
        value: typing.Optional[typing.Union[jsii.Number, TerraformCount]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__682b7b6177f1bc28f7cfed7f9b597e764233ce37c529b080d9899af8d4d55397)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "count", value)

    @builtins.property
    @jsii.member(jsii_name="dependsOn")
    def depends_on(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "dependsOn"))

    @depends_on.setter
    def depends_on(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__08c021940f50f8946ba54f3616d072de9d9a51a0c764a15f22b0782d9c9f0fa9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dependsOn", value)

    @builtins.property
    @jsii.member(jsii_name="forEach")
    def for_each(self) -> typing.Optional[ITerraformIterator]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[ITerraformIterator], jsii.get(self, "forEach"))

    @for_each.setter
    def for_each(self, value: typing.Optional[ITerraformIterator]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__080ff5cb9a26e75882bdc292c8e41ac4c8f5ecb89ca009ca61761280917de434)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "forEach", value)

    @builtins.property
    @jsii.member(jsii_name="lifecycle")
    def lifecycle(self) -> typing.Optional["TerraformResourceLifecycle"]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional["TerraformResourceLifecycle"], jsii.get(self, "lifecycle"))

    @lifecycle.setter
    def lifecycle(self, value: typing.Optional["TerraformResourceLifecycle"]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b73eea3719fd1a1773428fcecdb2a64a6489a9c07edc04ccc3b3133f695541e8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "lifecycle", value)

    @builtins.property
    @jsii.member(jsii_name="provider")
    def provider(self) -> typing.Optional[TerraformProvider]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[TerraformProvider], jsii.get(self, "provider"))

    @provider.setter
    def provider(self, value: typing.Optional[TerraformProvider]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__281202bd152a05b8961cd648de0a193f9f082384dab7e65aa961434e6f39ee48)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "provider", value)

    @builtins.property
    @jsii.member(jsii_name="provisioners")
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]], jsii.get(self, "provisioners"))

    @provisioners.setter
    def provisioners(
        self,
        value: typing.Optional[typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fd067a43d397caebbe65ee8ccc577eba7998abd35e886b2f9d2ea15d19b0140a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "provisioners", value)


@jsii.data_type(
    jsii_type="cdktf.TerraformResourceConfig",
    jsii_struct_bases=[TerraformMetaArguments],
    name_mapping={
        "connection": "connection",
        "count": "count",
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "provisioners": "provisioners",
        "terraform_resource_type": "terraformResourceType",
        "terraform_generator_metadata": "terraformGeneratorMetadata",
    },
)
class TerraformResourceConfig(TerraformMetaArguments):
    def __init__(
        self,
        *,
        connection: typing.Optional[typing.Union[typing.Union[SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union["WinrmProvisionerConnection", typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[typing.Union[jsii.Number, TerraformCount]] = None,
        depends_on: typing.Optional[typing.Sequence[ITerraformDependable]] = None,
        for_each: typing.Optional[ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union["TerraformResourceLifecycle", typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
        terraform_resource_type: builtins.str,
        terraform_generator_metadata: typing.Optional[typing.Union[TerraformProviderGeneratorMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 
        :param terraform_resource_type: 
        :param terraform_generator_metadata: 

        :stability: experimental
        '''
        if isinstance(lifecycle, dict):
            lifecycle = TerraformResourceLifecycle(**lifecycle)
        if isinstance(terraform_generator_metadata, dict):
            terraform_generator_metadata = TerraformProviderGeneratorMetadata(**terraform_generator_metadata)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5cb26b6db59e53a077913f64bdb2b38dd01153cb559b28ad0fbeccd96944f654)
            check_type(argname="argument connection", value=connection, expected_type=type_hints["connection"])
            check_type(argname="argument count", value=count, expected_type=type_hints["count"])
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument lifecycle", value=lifecycle, expected_type=type_hints["lifecycle"])
            check_type(argname="argument provider", value=provider, expected_type=type_hints["provider"])
            check_type(argname="argument provisioners", value=provisioners, expected_type=type_hints["provisioners"])
            check_type(argname="argument terraform_resource_type", value=terraform_resource_type, expected_type=type_hints["terraform_resource_type"])
            check_type(argname="argument terraform_generator_metadata", value=terraform_generator_metadata, expected_type=type_hints["terraform_generator_metadata"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "terraform_resource_type": terraform_resource_type,
        }
        if connection is not None:
            self._values["connection"] = connection
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if provisioners is not None:
            self._values["provisioners"] = provisioners
        if terraform_generator_metadata is not None:
            self._values["terraform_generator_metadata"] = terraform_generator_metadata

    @builtins.property
    def connection(
        self,
    ) -> typing.Optional[typing.Union[SSHProvisionerConnection, "WinrmProvisionerConnection"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("connection")
        return typing.cast(typing.Optional[typing.Union[SSHProvisionerConnection, "WinrmProvisionerConnection"]], result)

    @builtins.property
    def count(self) -> typing.Optional[typing.Union[jsii.Number, TerraformCount]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("count")
        return typing.cast(typing.Optional[typing.Union[jsii.Number, TerraformCount]], result)

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[ITerraformIterator], result)

    @builtins.property
    def lifecycle(self) -> typing.Optional["TerraformResourceLifecycle"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lifecycle")
        return typing.cast(typing.Optional["TerraformResourceLifecycle"], result)

    @builtins.property
    def provider(self) -> typing.Optional[TerraformProvider]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provider")
        return typing.cast(typing.Optional[TerraformProvider], result)

    @builtins.property
    def provisioners(
        self,
    ) -> typing.Optional[typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("provisioners")
        return typing.cast(typing.Optional[typing.List[typing.Union[FileProvisioner, LocalExecProvisioner, RemoteExecProvisioner]]], result)

    @builtins.property
    def terraform_resource_type(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("terraform_resource_type")
        assert result is not None, "Required property 'terraform_resource_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def terraform_generator_metadata(
        self,
    ) -> typing.Optional[TerraformProviderGeneratorMetadata]:
        '''
        :stability: experimental
        '''
        result = self._values.get("terraform_generator_metadata")
        return typing.cast(typing.Optional[TerraformProviderGeneratorMetadata], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformResourceConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.TerraformResourceLifecycle",
    jsii_struct_bases=[],
    name_mapping={
        "create_before_destroy": "createBeforeDestroy",
        "ignore_changes": "ignoreChanges",
        "postcondition": "postcondition",
        "precondition": "precondition",
        "prevent_destroy": "preventDestroy",
        "replace_triggered_by": "replaceTriggeredBy",
    },
)
class TerraformResourceLifecycle:
    def __init__(
        self,
        *,
        create_before_destroy: typing.Optional[builtins.bool] = None,
        ignore_changes: typing.Optional[typing.Union[typing.Sequence[builtins.str], builtins.str]] = None,
        postcondition: typing.Optional[typing.Sequence[typing.Union["Postcondition", typing.Dict[builtins.str, typing.Any]]]] = None,
        precondition: typing.Optional[typing.Sequence[typing.Union["Precondition", typing.Dict[builtins.str, typing.Any]]]] = None,
        prevent_destroy: typing.Optional[builtins.bool] = None,
        replace_triggered_by: typing.Optional[typing.Sequence[typing.Union[builtins.str, ITerraformDependable]]] = None,
    ) -> None:
        '''
        :param create_before_destroy: 
        :param ignore_changes: 
        :param postcondition: 
        :param precondition: 
        :param prevent_destroy: 
        :param replace_triggered_by: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__935e77e72f3666e07f04d8ab1694fb20efc6c7dfecd0b48c46e3c07423732791)
            check_type(argname="argument create_before_destroy", value=create_before_destroy, expected_type=type_hints["create_before_destroy"])
            check_type(argname="argument ignore_changes", value=ignore_changes, expected_type=type_hints["ignore_changes"])
            check_type(argname="argument postcondition", value=postcondition, expected_type=type_hints["postcondition"])
            check_type(argname="argument precondition", value=precondition, expected_type=type_hints["precondition"])
            check_type(argname="argument prevent_destroy", value=prevent_destroy, expected_type=type_hints["prevent_destroy"])
            check_type(argname="argument replace_triggered_by", value=replace_triggered_by, expected_type=type_hints["replace_triggered_by"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if create_before_destroy is not None:
            self._values["create_before_destroy"] = create_before_destroy
        if ignore_changes is not None:
            self._values["ignore_changes"] = ignore_changes
        if postcondition is not None:
            self._values["postcondition"] = postcondition
        if precondition is not None:
            self._values["precondition"] = precondition
        if prevent_destroy is not None:
            self._values["prevent_destroy"] = prevent_destroy
        if replace_triggered_by is not None:
            self._values["replace_triggered_by"] = replace_triggered_by

    @builtins.property
    def create_before_destroy(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("create_before_destroy")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def ignore_changes(
        self,
    ) -> typing.Optional[typing.Union[typing.List[builtins.str], builtins.str]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("ignore_changes")
        return typing.cast(typing.Optional[typing.Union[typing.List[builtins.str], builtins.str]], result)

    @builtins.property
    def postcondition(self) -> typing.Optional[typing.List["Postcondition"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("postcondition")
        return typing.cast(typing.Optional[typing.List["Postcondition"]], result)

    @builtins.property
    def precondition(self) -> typing.Optional[typing.List["Precondition"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("precondition")
        return typing.cast(typing.Optional[typing.List["Precondition"]], result)

    @builtins.property
    def prevent_destroy(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("prevent_destroy")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def replace_triggered_by(
        self,
    ) -> typing.Optional[typing.List[typing.Union[builtins.str, ITerraformDependable]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("replace_triggered_by")
        return typing.cast(typing.Optional[typing.List[typing.Union[builtins.str, ITerraformDependable]]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformResourceLifecycle(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class TerraformSelf(metaclass=jsii.JSIIMeta, jsii_type="cdktf.TerraformSelf"):
    '''(experimental) Expressions in connection blocks cannot refer to their parent resource by name.

    References create dependencies, and referring to a resource by name within its own block would create a dependency cycle.
    Instead, expressions can use the self object, which represents the connection's parent resource and has all of that resource's attributes.
    For example, use self.public_ip to reference an aws_instance's public_ip attribute.

    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="getAny")
    @builtins.classmethod
    def get_any(cls, key: builtins.str) -> typing.Any:
        '''(experimental) Only usable within a connection block to reference the connections parent resource.

        Access a property on the resource like this: ``getAny("hostPort")``

        :param key: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__65d6316b42ca61e665f418a7344003f2c7bce5cf55c54cbff7e989e791f69e49)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "getAny", [key]))

    @jsii.member(jsii_name="getNumber")
    @builtins.classmethod
    def get_number(cls, key: builtins.str) -> jsii.Number:
        '''(experimental) Only usable within a connection block to reference the connections parent resource.

        Access a property on the resource like this: ``getNumber("hostPort")``

        :param key: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__12136af1dd176b0c3326835270beb547d6734ff189c1780cd32b150f07764451)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "getNumber", [key]))

    @jsii.member(jsii_name="getString")
    @builtins.classmethod
    def get_string(cls, key: builtins.str) -> builtins.str:
        '''(experimental) Only usable within a connection block to reference the connections parent resource.

        Access a property on the resource like this: ``getString("publicIp")``

        :param key: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bcee76abba4dd46262ae295c719f289abf9a3fa6114a7cd20f38fd520c1c6450)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "getString", [key]))


class TerraformStack(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.TerraformStack",
):
    '''
    :stability: experimental
    '''

    def __init__(self, scope: _constructs_77d1e7e8.Construct, id: builtins.str) -> None:
        '''
        :param scope: -
        :param id: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__51c107d11015c59662fc4d76cfc5e2c1a8de465fd2276965e7ece7199860d459)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        jsii.create(self.__class__, self, [scope, id])

    @jsii.member(jsii_name="isStack")
    @builtins.classmethod
    def is_stack(cls, x: typing.Any) -> builtins.bool:
        '''
        :param x: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3162ee6826c174f3621b80634d76a124a9cc979088c32ae64631a2ec1c69e1d0)
            check_type(argname="argument x", value=x, expected_type=type_hints["x"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "isStack", [x]))

    @jsii.member(jsii_name="of")
    @builtins.classmethod
    def of(cls, construct: _constructs_77d1e7e8.IConstruct) -> "TerraformStack":
        '''
        :param construct: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5ea58110954d8ee6c23fd35d7ff38c6ef43f6c65ad1e87ca8689878b9ea0de60)
            check_type(argname="argument construct", value=construct, expected_type=type_hints["construct"])
        return typing.cast("TerraformStack", jsii.sinvoke(cls, "of", [construct]))

    @jsii.member(jsii_name="addDependency")
    def add_dependency(self, dependency: "TerraformStack") -> None:
        '''
        :param dependency: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__716e0ed3c94055a76d59ebb8575076bd5fc0e890b092f7f580bb1adb6ac24b1b)
            check_type(argname="argument dependency", value=dependency, expected_type=type_hints["dependency"])
        return typing.cast(None, jsii.invoke(self, "addDependency", [dependency]))

    @jsii.member(jsii_name="addOverride")
    def add_override(self, path: builtins.str, value: typing.Any) -> None:
        '''
        :param path: -
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d3cb1c2e3948ab1898856112361ae3e6cdf604e70d0d9abf39f9fc7f4a8aa82)
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addOverride", [path, value]))

    @jsii.member(jsii_name="allocateLogicalId")
    def _allocate_logical_id(
        self,
        tf_element: typing.Union[_constructs_77d1e7e8.Node, TerraformElement],
    ) -> builtins.str:
        '''(experimental) Returns the naming scheme used to allocate logical IDs.

        By default, uses
        the ``HashedAddressingScheme`` but this method can be overridden to customize
        this behavior.

        :param tf_element: The element for which the logical ID is allocated.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a58ad4c36366704477dba954fe8c7ea965d51e7dc5bb97c9c20ba45e4718b9a2)
            check_type(argname="argument tf_element", value=tf_element, expected_type=type_hints["tf_element"])
        return typing.cast(builtins.str, jsii.invoke(self, "allocateLogicalId", [tf_element]))

    @jsii.member(jsii_name="allProviders")
    def all_providers(self) -> typing.List[TerraformProvider]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.List[TerraformProvider], jsii.invoke(self, "allProviders", []))

    @jsii.member(jsii_name="dependsOn")
    def depends_on(self, stack: "TerraformStack") -> builtins.bool:
        '''
        :param stack: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__577855731e917a50a5aa1c9632c4049d45943be48d4f47e4cde44b1a41b7c012)
            check_type(argname="argument stack", value=stack, expected_type=type_hints["stack"])
        return typing.cast(builtins.bool, jsii.invoke(self, "dependsOn", [stack]))

    @jsii.member(jsii_name="ensureBackendExists")
    def ensure_backend_exists(self) -> "TerraformBackend":
        '''
        :stability: experimental
        '''
        return typing.cast("TerraformBackend", jsii.invoke(self, "ensureBackendExists", []))

    @jsii.member(jsii_name="getLogicalId")
    def get_logical_id(
        self,
        tf_element: typing.Union[_constructs_77d1e7e8.Node, TerraformElement],
    ) -> builtins.str:
        '''
        :param tf_element: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c8364c3103bec99a9cb4aa9089397929371ff864d87dd9494b5b15b121d2742e)
            check_type(argname="argument tf_element", value=tf_element, expected_type=type_hints["tf_element"])
        return typing.cast(builtins.str, jsii.invoke(self, "getLogicalId", [tf_element]))

    @jsii.member(jsii_name="prepareStack")
    def prepare_stack(self) -> None:
        '''
        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "prepareStack", []))

    @jsii.member(jsii_name="registerIncomingCrossStackReference")
    def register_incoming_cross_stack_reference(
        self,
        from_stack: "TerraformStack",
    ) -> TerraformRemoteState:
        '''
        :param from_stack: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71f577e4932f540a3bc52246f482beb3fb675585639c29c8b8565d3c2b528c4e)
            check_type(argname="argument from_stack", value=from_stack, expected_type=type_hints["from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "registerIncomingCrossStackReference", [from_stack]))

    @jsii.member(jsii_name="registerOutgoingCrossStackReference")
    def register_outgoing_cross_stack_reference(
        self,
        identifier: builtins.str,
    ) -> TerraformOutput:
        '''
        :param identifier: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e0b0d080786ddfafd6b8bb74ddb2b1b9ffda797a6b664ca7144d92fa4fc0b00d)
            check_type(argname="argument identifier", value=identifier, expected_type=type_hints["identifier"])
        return typing.cast(TerraformOutput, jsii.invoke(self, "registerOutgoingCrossStackReference", [identifier]))

    @jsii.member(jsii_name="runAllValidations")
    def run_all_validations(self) -> None:
        '''(experimental) Run all validations on the stack.

        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "runAllValidations", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="dependencies")
    def dependencies(self) -> typing.List["TerraformStack"]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.List["TerraformStack"], jsii.get(self, "dependencies"))

    @dependencies.setter
    def dependencies(self, value: typing.List["TerraformStack"]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__10d647fdfea94574fe5429ca07e97d6c29972671796e40103a0c5c392a6d2048)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dependencies", value)

    @builtins.property
    @jsii.member(jsii_name="synthesizer")
    def synthesizer(self) -> IStackSynthesizer:
        '''
        :stability: experimental
        '''
        return typing.cast(IStackSynthesizer, jsii.get(self, "synthesizer"))

    @synthesizer.setter
    def synthesizer(self, value: IStackSynthesizer) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__519c1c3e544263fd5b7141acf3d2bebb161d74a9a39ce5040c6bd854880246fc)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "synthesizer", value)


@jsii.data_type(
    jsii_type="cdktf.TerraformStackMetadata",
    jsii_struct_bases=[],
    name_mapping={
        "backend": "backend",
        "stack_name": "stackName",
        "version": "version",
        "cloud": "cloud",
    },
)
class TerraformStackMetadata:
    def __init__(
        self,
        *,
        backend: builtins.str,
        stack_name: builtins.str,
        version: builtins.str,
        cloud: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param backend: 
        :param stack_name: 
        :param version: 
        :param cloud: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ac1cd8c759a347b62e57529854e0efcd15206adc83a94a40ab529e3345012755)
            check_type(argname="argument backend", value=backend, expected_type=type_hints["backend"])
            check_type(argname="argument stack_name", value=stack_name, expected_type=type_hints["stack_name"])
            check_type(argname="argument version", value=version, expected_type=type_hints["version"])
            check_type(argname="argument cloud", value=cloud, expected_type=type_hints["cloud"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "backend": backend,
            "stack_name": stack_name,
            "version": version,
        }
        if cloud is not None:
            self._values["cloud"] = cloud

    @builtins.property
    def backend(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("backend")
        assert result is not None, "Required property 'backend' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def stack_name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("stack_name")
        assert result is not None, "Required property 'stack_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def version(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("version")
        assert result is not None, "Required property 'version' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def cloud(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("cloud")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformStackMetadata(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ITerraformAddressable)
class TerraformVariable(
    TerraformElement,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.TerraformVariable",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        default: typing.Any = None,
        description: typing.Optional[builtins.str] = None,
        nullable: typing.Optional[builtins.bool] = None,
        sensitive: typing.Optional[builtins.bool] = None,
        type: typing.Optional[builtins.str] = None,
        validation: typing.Optional[typing.Sequence[typing.Union["TerraformVariableValidationConfig", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param default: 
        :param description: 
        :param nullable: 
        :param sensitive: 
        :param type: (experimental) The type argument in a variable block allows you to restrict the type of value that will be accepted as the value for a variable. If no type constraint is set then a value of any type is accepted. While type constraints are optional, we recommend specifying them; they serve as easy reminders for users of the module, and allow Terraform to return a helpful error message if the wrong type is used. Type constraints are created from a mixture of type keywords and type constructors. The supported type keywords are: - string - number - bool The type constructors allow you to specify complex types such as collections: - list(<TYPE>) - set(<TYPE>) - map(<TYPE>) - object({<ATTR NAME> = <TYPE>, ... }) - tuple([<TYPE>, ...]) The keyword any may be used to indicate that any type is acceptable. For more information on the meaning and behavior of these different types, as well as detailed information about automatic conversion of complex types, refer to {@link https://developer.hashicorp.com/terraform/language/expressions/type-constraints Type Constraints}. If both the type and default arguments are specified, the given default value must be convertible to the specified type.
        :param validation: (experimental) Specify arbitrary custom validation rules for a particular variable using a validation block nested within the corresponding variable block.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8a55502c851d3bb141f2a4e9c60d9b6ba59960c56d69523b18338f52271bc588)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = TerraformVariableConfig(
            default=default,
            description=description,
            nullable=nullable,
            sensitive=sensitive,
            type=type,
            validation=validation,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="addValidation")
    def add_validation(
        self,
        *,
        condition: typing.Any,
        error_message: builtins.str,
    ) -> None:
        '''
        :param condition: (experimental) This is a boolean expression that should return true if the intended assumption or guarantee is fulfilled or false if it does not.
        :param error_message: (experimental) This contains the text that Terraform will include as part of error messages when it detects an unmet condition.

        :stability: experimental
        '''
        validation = TerraformVariableValidationConfig(
            condition=condition, error_message=error_message
        )

        return typing.cast(None, jsii.invoke(self, "addValidation", [validation]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Returns a string representation of this construct.

        :return: a string token referencing the value of this variable

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="booleanValue")
    def boolean_value(self) -> IResolvable:
        '''
        :stability: experimental
        '''
        return typing.cast(IResolvable, jsii.get(self, "booleanValue"))

    @builtins.property
    @jsii.member(jsii_name="listValue")
    def list_value(self) -> typing.List[builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "listValue"))

    @builtins.property
    @jsii.member(jsii_name="numberValue")
    def number_value(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        return typing.cast(jsii.Number, jsii.get(self, "numberValue"))

    @builtins.property
    @jsii.member(jsii_name="stringValue")
    def string_value(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "stringValue"))

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))

    @builtins.property
    @jsii.member(jsii_name="default")
    def default(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "default"))

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "description"))

    @builtins.property
    @jsii.member(jsii_name="nullable")
    def nullable(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "nullable"))

    @builtins.property
    @jsii.member(jsii_name="sensitive")
    def sensitive(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "sensitive"))

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "type"))

    @builtins.property
    @jsii.member(jsii_name="validation")
    def validation(
        self,
    ) -> typing.Optional[typing.List["TerraformVariableValidationConfig"]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.List["TerraformVariableValidationConfig"]], jsii.get(self, "validation"))


@jsii.data_type(
    jsii_type="cdktf.TerraformVariableConfig",
    jsii_struct_bases=[],
    name_mapping={
        "default": "default",
        "description": "description",
        "nullable": "nullable",
        "sensitive": "sensitive",
        "type": "type",
        "validation": "validation",
    },
)
class TerraformVariableConfig:
    def __init__(
        self,
        *,
        default: typing.Any = None,
        description: typing.Optional[builtins.str] = None,
        nullable: typing.Optional[builtins.bool] = None,
        sensitive: typing.Optional[builtins.bool] = None,
        type: typing.Optional[builtins.str] = None,
        validation: typing.Optional[typing.Sequence[typing.Union["TerraformVariableValidationConfig", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param default: 
        :param description: 
        :param nullable: 
        :param sensitive: 
        :param type: (experimental) The type argument in a variable block allows you to restrict the type of value that will be accepted as the value for a variable. If no type constraint is set then a value of any type is accepted. While type constraints are optional, we recommend specifying them; they serve as easy reminders for users of the module, and allow Terraform to return a helpful error message if the wrong type is used. Type constraints are created from a mixture of type keywords and type constructors. The supported type keywords are: - string - number - bool The type constructors allow you to specify complex types such as collections: - list(<TYPE>) - set(<TYPE>) - map(<TYPE>) - object({<ATTR NAME> = <TYPE>, ... }) - tuple([<TYPE>, ...]) The keyword any may be used to indicate that any type is acceptable. For more information on the meaning and behavior of these different types, as well as detailed information about automatic conversion of complex types, refer to {@link https://developer.hashicorp.com/terraform/language/expressions/type-constraints Type Constraints}. If both the type and default arguments are specified, the given default value must be convertible to the specified type.
        :param validation: (experimental) Specify arbitrary custom validation rules for a particular variable using a validation block nested within the corresponding variable block.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__587911e5baa911ec620a0cbeef5853230095407b009012273c1115c1b02c3053)
            check_type(argname="argument default", value=default, expected_type=type_hints["default"])
            check_type(argname="argument description", value=description, expected_type=type_hints["description"])
            check_type(argname="argument nullable", value=nullable, expected_type=type_hints["nullable"])
            check_type(argname="argument sensitive", value=sensitive, expected_type=type_hints["sensitive"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument validation", value=validation, expected_type=type_hints["validation"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if default is not None:
            self._values["default"] = default
        if description is not None:
            self._values["description"] = description
        if nullable is not None:
            self._values["nullable"] = nullable
        if sensitive is not None:
            self._values["sensitive"] = sensitive
        if type is not None:
            self._values["type"] = type
        if validation is not None:
            self._values["validation"] = validation

    @builtins.property
    def default(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        result = self._values.get("default")
        return typing.cast(typing.Any, result)

    @builtins.property
    def description(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def nullable(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("nullable")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def sensitive(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("sensitive")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def type(self) -> typing.Optional[builtins.str]:
        '''(experimental) The type argument in a variable block allows you to restrict the type of value that will be accepted as the value for a variable.

        If no type constraint is set then a value of any type is accepted.

        While type constraints are optional, we recommend specifying them; they serve as easy reminders for users of the module, and allow Terraform to return a helpful error message if the wrong type is used.

        Type constraints are created from a mixture of type keywords and type constructors. The supported type keywords are:

        - string
        - number
        - bool

        The type constructors allow you to specify complex types such as collections:

        - list()
        - set()
        - map()
        - object({ = , ... })
        - tuple([, ...])

        The keyword any may be used to indicate that any type is acceptable. For more information on the meaning and behavior of these different types, as well as detailed information about automatic conversion of complex types, refer to {@link https://developer.hashicorp.com/terraform/language/expressions/type-constraints Type Constraints}.

        If both the type and default arguments are specified, the given default value must be convertible to the specified type.

        :stability: experimental
        '''
        result = self._values.get("type")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def validation(
        self,
    ) -> typing.Optional[typing.List["TerraformVariableValidationConfig"]]:
        '''(experimental) Specify arbitrary custom validation rules for a particular variable using a validation block nested within the corresponding variable block.

        :stability: experimental
        '''
        result = self._values.get("validation")
        return typing.cast(typing.Optional[typing.List["TerraformVariableValidationConfig"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformVariableConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.TerraformVariableValidationConfig",
    jsii_struct_bases=[TerraformCondition],
    name_mapping={"condition": "condition", "error_message": "errorMessage"},
)
class TerraformVariableValidationConfig(TerraformCondition):
    def __init__(self, *, condition: typing.Any, error_message: builtins.str) -> None:
        '''(experimental) Add one or more validation blocks within the variable block to specify custom conditions.

        :param condition: (experimental) This is a boolean expression that should return true if the intended assumption or guarantee is fulfilled or false if it does not.
        :param error_message: (experimental) This contains the text that Terraform will include as part of error messages when it detects an unmet condition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ecb590d3eacdf7313e1c690a8fad3a392d6c463b1e1a2ef6ed1d8c2174971dd2)
            check_type(argname="argument condition", value=condition, expected_type=type_hints["condition"])
            check_type(argname="argument error_message", value=error_message, expected_type=type_hints["error_message"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "condition": condition,
            "error_message": error_message,
        }

    @builtins.property
    def condition(self) -> typing.Any:
        '''(experimental) This is a boolean expression that should return true if the intended assumption or guarantee is fulfilled or false if it does not.

        :stability: experimental
        '''
        result = self._values.get("condition")
        assert result is not None, "Required property 'condition' is missing"
        return typing.cast(typing.Any, result)

    @builtins.property
    def error_message(self) -> builtins.str:
        '''(experimental) This contains the text that Terraform will include as part of error messages when it detects an unmet condition.

        :stability: experimental
        '''
        result = self._values.get("error_message")
        assert result is not None, "Required property 'error_message' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformVariableValidationConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Testing(metaclass=jsii.JSIIMeta, jsii_type="cdktf.Testing"):
    '''(experimental) Testing utilities for cdktf applications.

    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="app")
    @builtins.classmethod
    def app(
        cls,
        *,
        enable_future_flags: typing.Optional[builtins.bool] = None,
        fake_cdktf_json_path: typing.Optional[builtins.bool] = None,
        outdir: typing.Optional[builtins.str] = None,
        stack_traces: typing.Optional[builtins.bool] = None,
        stub_version: typing.Optional[builtins.bool] = None,
    ) -> App:
        '''(experimental) Returns an app for testing with the following properties: - Output directory is a temp dir.

        :param enable_future_flags: 
        :param fake_cdktf_json_path: 
        :param outdir: 
        :param stack_traces: 
        :param stub_version: 

        :stability: experimental
        '''
        options = TestingAppConfig(
            enable_future_flags=enable_future_flags,
            fake_cdktf_json_path=fake_cdktf_json_path,
            outdir=outdir,
            stack_traces=stack_traces,
            stub_version=stub_version,
        )

        return typing.cast(App, jsii.sinvoke(cls, "app", [options]))

    @jsii.member(jsii_name="enableFutureFlags")
    @builtins.classmethod
    def enable_future_flags(cls, app: App) -> App:
        '''
        :param app: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5868b5d4f83144aff9c33d43ad367c4b204a4ff7b6c643db972ab960517b108a)
            check_type(argname="argument app", value=app, expected_type=type_hints["app"])
        return typing.cast(App, jsii.sinvoke(cls, "enableFutureFlags", [app]))

    @jsii.member(jsii_name="fakeCdktfJsonPath")
    @builtins.classmethod
    def fake_cdktf_json_path(cls, app: App) -> App:
        '''
        :param app: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3345ed487e64660c0d5cb0ab64417db7d623a4edccda46394b3504ddb016d373)
            check_type(argname="argument app", value=app, expected_type=type_hints["app"])
        return typing.cast(App, jsii.sinvoke(cls, "fakeCdktfJsonPath", [app]))

    @jsii.member(jsii_name="fullSynth")
    @builtins.classmethod
    def full_synth(cls, stack: TerraformStack) -> builtins.str:
        '''
        :param stack: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__edccef4527c305991143e09bd63b8744c66c6a6cab8f0e7ba496d172eeb63c6d)
            check_type(argname="argument stack", value=stack, expected_type=type_hints["stack"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "fullSynth", [stack]))

    @jsii.member(jsii_name="renderConstructTree")
    @builtins.classmethod
    def render_construct_tree(
        cls,
        construct: _constructs_77d1e7e8.IConstruct,
    ) -> builtins.str:
        '''
        :param construct: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2640f33359d02572b8f8ee5b86615db20bd52ab5e4a7e9169139e7db0b33f94d)
            check_type(argname="argument construct", value=construct, expected_type=type_hints["construct"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "renderConstructTree", [construct]))

    @jsii.member(jsii_name="setupJest")
    @builtins.classmethod
    def setup_jest(cls) -> None:
        '''
        :stability: experimental
        '''
        return typing.cast(None, jsii.sinvoke(cls, "setupJest", []))

    @jsii.member(jsii_name="stubVersion")
    @builtins.classmethod
    def stub_version(cls, app: App) -> App:
        '''
        :param app: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f8e221c24a11c92d8ffc7b92304d3701bf956f378204d2190f7b949ca35c4eaf)
            check_type(argname="argument app", value=app, expected_type=type_hints["app"])
        return typing.cast(App, jsii.sinvoke(cls, "stubVersion", [app]))

    @jsii.member(jsii_name="synth")
    @builtins.classmethod
    def synth(
        cls,
        stack: TerraformStack,
        run_validations: typing.Optional[builtins.bool] = None,
    ) -> builtins.str:
        '''(experimental) Returns the Terraform synthesized JSON.

        :param stack: -
        :param run_validations: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f21dff943abbe8880957bddecc36c1486c3e74eea2a4f4b573c1d003c97ac981)
            check_type(argname="argument stack", value=stack, expected_type=type_hints["stack"])
            check_type(argname="argument run_validations", value=run_validations, expected_type=type_hints["run_validations"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "synth", [stack, run_validations]))

    @jsii.member(jsii_name="synthScope")
    @builtins.classmethod
    def synth_scope(cls, fn: IScopeCallback) -> builtins.str:
        '''
        :param fn: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__62b8ea71dfd1113a8a0ce6350641f6fa26da86c8483ee671e84d2053f6a05c3a)
            check_type(argname="argument fn", value=fn, expected_type=type_hints["fn"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "synthScope", [fn]))

    @jsii.member(jsii_name="toBeValidTerraform")
    @builtins.classmethod
    def to_be_valid_terraform(cls, received: builtins.str) -> builtins.bool:
        '''
        :param received: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__816b505305731fe729e605677a6802239610ff8f4fd40ed0bf3a1b2e5088b0dc)
            check_type(argname="argument received", value=received, expected_type=type_hints["received"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "toBeValidTerraform", [received]))

    @jsii.member(jsii_name="toHaveDataSource")
    @builtins.classmethod
    def to_have_data_source(
        cls,
        received: builtins.str,
        resource_type: builtins.str,
    ) -> builtins.bool:
        '''
        :param received: -
        :param resource_type: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__71fecb780c391363ca21eb1d1b928d382a8141f3e277ae27ffc773d565c6bb8b)
            check_type(argname="argument received", value=received, expected_type=type_hints["received"])
            check_type(argname="argument resource_type", value=resource_type, expected_type=type_hints["resource_type"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "toHaveDataSource", [received, resource_type]))

    @jsii.member(jsii_name="toHaveDataSourceWithProperties")
    @builtins.classmethod
    def to_have_data_source_with_properties(
        cls,
        received: builtins.str,
        resource_type: builtins.str,
        properties: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
    ) -> builtins.bool:
        '''
        :param received: -
        :param resource_type: -
        :param properties: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__23539ba58d055b7936f0566a87e2ffccd3dd517d52fd6bda654520dd5d4c913b)
            check_type(argname="argument received", value=received, expected_type=type_hints["received"])
            check_type(argname="argument resource_type", value=resource_type, expected_type=type_hints["resource_type"])
            check_type(argname="argument properties", value=properties, expected_type=type_hints["properties"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "toHaveDataSourceWithProperties", [received, resource_type, properties]))

    @jsii.member(jsii_name="toHaveProvider")
    @builtins.classmethod
    def to_have_provider(
        cls,
        received: builtins.str,
        resource_type: builtins.str,
    ) -> builtins.bool:
        '''
        :param received: -
        :param resource_type: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__baa2a7f7c6245d6e4e98e833e168366aeebbce35f1401dc562a174e782c00019)
            check_type(argname="argument received", value=received, expected_type=type_hints["received"])
            check_type(argname="argument resource_type", value=resource_type, expected_type=type_hints["resource_type"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "toHaveProvider", [received, resource_type]))

    @jsii.member(jsii_name="toHaveProviderWithProperties")
    @builtins.classmethod
    def to_have_provider_with_properties(
        cls,
        received: builtins.str,
        resource_type: builtins.str,
        properties: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
    ) -> builtins.bool:
        '''
        :param received: -
        :param resource_type: -
        :param properties: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ead3b20a7e59f8ab9e32f15e67ef96ce162af159a606f17abd6b81a64d2f262)
            check_type(argname="argument received", value=received, expected_type=type_hints["received"])
            check_type(argname="argument resource_type", value=resource_type, expected_type=type_hints["resource_type"])
            check_type(argname="argument properties", value=properties, expected_type=type_hints["properties"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "toHaveProviderWithProperties", [received, resource_type, properties]))

    @jsii.member(jsii_name="toHaveResource")
    @builtins.classmethod
    def to_have_resource(
        cls,
        received: builtins.str,
        resource_type: builtins.str,
    ) -> builtins.bool:
        '''
        :param received: -
        :param resource_type: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a7ff00009834f6e29269743360a1c21b9ccdade6697d019cbc5adc186472a5d8)
            check_type(argname="argument received", value=received, expected_type=type_hints["received"])
            check_type(argname="argument resource_type", value=resource_type, expected_type=type_hints["resource_type"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "toHaveResource", [received, resource_type]))

    @jsii.member(jsii_name="toHaveResourceWithProperties")
    @builtins.classmethod
    def to_have_resource_with_properties(
        cls,
        received: builtins.str,
        resource_type: builtins.str,
        properties: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
    ) -> builtins.bool:
        '''
        :param received: -
        :param resource_type: -
        :param properties: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__21836788c7f2fdc64a3d11b2877a1acf243b87c260d862a1a46857e19910be96)
            check_type(argname="argument received", value=received, expected_type=type_hints["received"])
            check_type(argname="argument resource_type", value=resource_type, expected_type=type_hints["resource_type"])
            check_type(argname="argument properties", value=properties, expected_type=type_hints["properties"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "toHaveResourceWithProperties", [received, resource_type, properties]))


@jsii.data_type(
    jsii_type="cdktf.TestingAppConfig",
    jsii_struct_bases=[],
    name_mapping={
        "enable_future_flags": "enableFutureFlags",
        "fake_cdktf_json_path": "fakeCdktfJsonPath",
        "outdir": "outdir",
        "stack_traces": "stackTraces",
        "stub_version": "stubVersion",
    },
)
class TestingAppConfig:
    def __init__(
        self,
        *,
        enable_future_flags: typing.Optional[builtins.bool] = None,
        fake_cdktf_json_path: typing.Optional[builtins.bool] = None,
        outdir: typing.Optional[builtins.str] = None,
        stack_traces: typing.Optional[builtins.bool] = None,
        stub_version: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param enable_future_flags: 
        :param fake_cdktf_json_path: 
        :param outdir: 
        :param stack_traces: 
        :param stub_version: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b2ba38fc552098e457cdd7cb27c30b6e19743dce356bc889fc7824e4ebc14ec6)
            check_type(argname="argument enable_future_flags", value=enable_future_flags, expected_type=type_hints["enable_future_flags"])
            check_type(argname="argument fake_cdktf_json_path", value=fake_cdktf_json_path, expected_type=type_hints["fake_cdktf_json_path"])
            check_type(argname="argument outdir", value=outdir, expected_type=type_hints["outdir"])
            check_type(argname="argument stack_traces", value=stack_traces, expected_type=type_hints["stack_traces"])
            check_type(argname="argument stub_version", value=stub_version, expected_type=type_hints["stub_version"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if enable_future_flags is not None:
            self._values["enable_future_flags"] = enable_future_flags
        if fake_cdktf_json_path is not None:
            self._values["fake_cdktf_json_path"] = fake_cdktf_json_path
        if outdir is not None:
            self._values["outdir"] = outdir
        if stack_traces is not None:
            self._values["stack_traces"] = stack_traces
        if stub_version is not None:
            self._values["stub_version"] = stub_version

    @builtins.property
    def enable_future_flags(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("enable_future_flags")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def fake_cdktf_json_path(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("fake_cdktf_json_path")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def outdir(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("outdir")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def stack_traces(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("stack_traces")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def stub_version(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("stub_version")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TestingAppConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Token(metaclass=jsii.JSIIMeta, jsii_type="cdktf.Token"):
    '''(experimental) Represents a special or lazily-evaluated value.

    Can be used to delay evaluation of a certain value in case, for example,
    that it requires some context or late-bound data. Can also be used to
    mark values that need special processing at document rendering time.

    Tokens can be embedded into strings while retaining their original
    semantics.

    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="asAny")
    @builtins.classmethod
    def as_any(cls, value: typing.Any) -> IResolvable:
        '''(experimental) Return a resolvable representation of the given value.

        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6465606eb709d055f38061e12603c5a51d61b4c7c1674c8f037efc64c5f99890)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(IResolvable, jsii.sinvoke(cls, "asAny", [value]))

    @jsii.member(jsii_name="asAnyMap")
    @builtins.classmethod
    def as_any_map(
        cls,
        value: typing.Any,
        *,
        display_hint: typing.Optional[builtins.str] = None,
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''(experimental) Return a reversible map representation of this token.

        :param value: -
        :param display_hint: (experimental) A hint for the Token's purpose when stringifying it. Default: - no display hint

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__75078c2f3eab27bd5050aed8d17e1a438484b3d94a43ad360315dd781d70ac95)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        options = EncodingOptions(display_hint=display_hint)

        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.sinvoke(cls, "asAnyMap", [value, options]))

    @jsii.member(jsii_name="asBooleanMap")
    @builtins.classmethod
    def as_boolean_map(
        cls,
        value: typing.Any,
        *,
        display_hint: typing.Optional[builtins.str] = None,
    ) -> typing.Mapping[builtins.str, builtins.bool]:
        '''(experimental) Return a reversible map representation of this token.

        :param value: -
        :param display_hint: (experimental) A hint for the Token's purpose when stringifying it. Default: - no display hint

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cb82cf45dc6eda7176274c590f640cf76f1c59cc910a6b33c15526f3d7db478a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        options = EncodingOptions(display_hint=display_hint)

        return typing.cast(typing.Mapping[builtins.str, builtins.bool], jsii.sinvoke(cls, "asBooleanMap", [value, options]))

    @jsii.member(jsii_name="asList")
    @builtins.classmethod
    def as_list(
        cls,
        value: typing.Any,
        *,
        display_hint: typing.Optional[builtins.str] = None,
    ) -> typing.List[builtins.str]:
        '''(experimental) Return a reversible list representation of this token.

        :param value: -
        :param display_hint: (experimental) A hint for the Token's purpose when stringifying it. Default: - no display hint

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a4b6a166c00798d3c505f7811540b9c060ec12b508a042c6d16c388141930e7a)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        options = EncodingOptions(display_hint=display_hint)

        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "asList", [value, options]))

    @jsii.member(jsii_name="asMap")
    @builtins.classmethod
    def as_map(
        cls,
        value: typing.Any,
        map_value: typing.Any,
        *,
        display_hint: typing.Optional[builtins.str] = None,
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''(experimental) Return a reversible map representation of this token.

        :param value: -
        :param map_value: -
        :param display_hint: (experimental) A hint for the Token's purpose when stringifying it. Default: - no display hint

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__114fcb734990db6280d763e4050a4bf24a88bf81343d9e9e9779475b111d04a3)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
            check_type(argname="argument map_value", value=map_value, expected_type=type_hints["map_value"])
        options = EncodingOptions(display_hint=display_hint)

        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.sinvoke(cls, "asMap", [value, map_value, options]))

    @jsii.member(jsii_name="asNumber")
    @builtins.classmethod
    def as_number(cls, value: typing.Any) -> jsii.Number:
        '''(experimental) Return a reversible number representation of this token.

        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__553c69b4ca2bda89b68e3338b5ef0be353f0f84b90948f0db8de74636a964ff5)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(jsii.Number, jsii.sinvoke(cls, "asNumber", [value]))

    @jsii.member(jsii_name="asNumberList")
    @builtins.classmethod
    def as_number_list(cls, value: typing.Any) -> typing.List[jsii.Number]:
        '''(experimental) Return a reversible list representation of this token.

        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__406f25ec6862fe14d9219f7153f794df3bc291ceb8106fb226bce00385ff7868)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(typing.List[jsii.Number], jsii.sinvoke(cls, "asNumberList", [value]))

    @jsii.member(jsii_name="asNumberMap")
    @builtins.classmethod
    def as_number_map(
        cls,
        value: typing.Any,
        *,
        display_hint: typing.Optional[builtins.str] = None,
    ) -> typing.Mapping[builtins.str, jsii.Number]:
        '''(experimental) Return a reversible map representation of this token.

        :param value: -
        :param display_hint: (experimental) A hint for the Token's purpose when stringifying it. Default: - no display hint

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__486819029c5fc81d8d6a5cb85e38f94924cd6e3f3d686ac9a73588c33dfa3501)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        options = EncodingOptions(display_hint=display_hint)

        return typing.cast(typing.Mapping[builtins.str, jsii.Number], jsii.sinvoke(cls, "asNumberMap", [value, options]))

    @jsii.member(jsii_name="asString")
    @builtins.classmethod
    def as_string(
        cls,
        value: typing.Any,
        *,
        display_hint: typing.Optional[builtins.str] = None,
    ) -> builtins.str:
        '''(experimental) Return a reversible string representation of this token.

        If the Token is initialized with a literal, the stringified value of the
        literal is returned. Otherwise, a special quoted string representation
        of the Token is returned that can be embedded into other strings.

        Strings with quoted Tokens in them can be restored back into
        complex values with the Tokens restored by calling ``resolve()``
        on the string.

        :param value: -
        :param display_hint: (experimental) A hint for the Token's purpose when stringifying it. Default: - no display hint

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af987d5271674cd9dd2413c61a564b5f838d4f9d818be7e8dd65a3232d33f901)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        options = EncodingOptions(display_hint=display_hint)

        return typing.cast(builtins.str, jsii.sinvoke(cls, "asString", [value, options]))

    @jsii.member(jsii_name="asStringMap")
    @builtins.classmethod
    def as_string_map(
        cls,
        value: typing.Any,
        *,
        display_hint: typing.Optional[builtins.str] = None,
    ) -> typing.Mapping[builtins.str, builtins.str]:
        '''(experimental) Return a reversible map representation of this token.

        :param value: -
        :param display_hint: (experimental) A hint for the Token's purpose when stringifying it. Default: - no display hint

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9d72cebab1b9a56a728e95293570db84929ccb915d53ffbc0978e35c8a5cb677)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        options = EncodingOptions(display_hint=display_hint)

        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.sinvoke(cls, "asStringMap", [value, options]))

    @jsii.member(jsii_name="isUnresolved")
    @builtins.classmethod
    def is_unresolved(cls, obj: typing.Any) -> builtins.bool:
        '''(experimental) Returns true if obj represents an unresolved value.

        One of these must be true:

        - ``obj`` is an IResolvable
        - ``obj`` is a string containing at least one encoded ``IResolvable``
        - ``obj`` is either an encoded number or list

        This does NOT recurse into lists or objects to see if they
        containing resolvables.

        :param obj: The object to test.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__305f325383d2bebe6042d0235466661ee9dc73d58b4498c938573dcb517debfc)
            check_type(argname="argument obj", value=obj, expected_type=type_hints["obj"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "isUnresolved", [obj]))

    @jsii.member(jsii_name="nullValue")
    @builtins.classmethod
    def null_value(cls) -> IResolvable:
        '''(experimental) Return a Token containing a ``null`` value.

        Note: This is different than ``undefined``, ``nil``, ``None`` or similar
        as it will end up in the Terraform config and can be used to explicitly
        not set an attribute (which is sometimes required by Terraform providers)

        :return: a Token resolving to ``null`` as understood by Terraform

        :stability: experimental
        '''
        return typing.cast(IResolvable, jsii.sinvoke(cls, "nullValue", []))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ANY_MAP_TOKEN_VALUE")
    def ANY_MAP_TOKEN_VALUE(cls) -> builtins.str:
        '''(experimental) Any map token representation.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "ANY_MAP_TOKEN_VALUE"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NUMBER_MAP_TOKEN_VALUE")
    def NUMBER_MAP_TOKEN_VALUE(cls) -> jsii.Number:
        '''(experimental) Number Map token value representation.

        :stability: experimental
        '''
        return typing.cast(jsii.Number, jsii.sget(cls, "NUMBER_MAP_TOKEN_VALUE"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="STRING_MAP_TOKEN_VALUE")
    def STRING_MAP_TOKEN_VALUE(cls) -> builtins.str:
        '''(experimental) String Map token value representation.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "STRING_MAP_TOKEN_VALUE"))


class Tokenization(metaclass=jsii.JSIIMeta, jsii_type="cdktf.Tokenization"):
    '''(experimental) Less oft-needed functions to manipulate Tokens.

    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="isResolvable")
    @builtins.classmethod
    def is_resolvable(cls, obj: typing.Any) -> builtins.bool:
        '''(experimental) Return whether the given object is an IResolvable object.

        This is different from Token.isUnresolved() which will also check for
        encoded Tokens, whereas this method will only do a type check on the given
        object.

        :param obj: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d47c66157c550796cbd8760d9da465fad9cec31a2434747c2afa15849dc583cd)
            check_type(argname="argument obj", value=obj, expected_type=type_hints["obj"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "isResolvable", [obj]))

    @jsii.member(jsii_name="resolve")
    @builtins.classmethod
    def resolve(
        cls,
        obj: typing.Any,
        *,
        resolver: ITokenResolver,
        scope: _constructs_77d1e7e8.IConstruct,
        preparing: typing.Optional[builtins.bool] = None,
    ) -> typing.Any:
        '''(experimental) Resolves an object by evaluating all tokens and removing any undefined or empty objects or arrays.

        Values can only be primitives, arrays or tokens. Other objects (i.e. with methods) will be rejected.

        :param obj: The object to resolve.
        :param resolver: (experimental) The resolver to apply to any resolvable tokens found.
        :param scope: (experimental) The scope from which resolution is performed.
        :param preparing: (experimental) Whether the resolution is being executed during the prepare phase or not. Default: false

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7e1675dcd8513804d5fac6352aeed528db5698314a96d51db550a617b9225700)
            check_type(argname="argument obj", value=obj, expected_type=type_hints["obj"])
        options = ResolveOptions(resolver=resolver, scope=scope, preparing=preparing)

        return typing.cast(typing.Any, jsii.sinvoke(cls, "resolve", [obj, options]))

    @jsii.member(jsii_name="reverse")
    @builtins.classmethod
    def reverse(cls, x: typing.Any) -> typing.List[IResolvable]:
        '''(experimental) Reverse any value into Resolvables, if possible.

        :param x: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bff6892c1ffe90ea8a2e89b63e3d5a0350781c5970ab382fef9ec305e7e437f0)
            check_type(argname="argument x", value=x, expected_type=type_hints["x"])
        return typing.cast(typing.List[IResolvable], jsii.sinvoke(cls, "reverse", [x]))

    @jsii.member(jsii_name="reverseList")
    @builtins.classmethod
    def reverse_list(
        cls,
        l: typing.Sequence[builtins.str],
    ) -> typing.Optional[IResolvable]:
        '''(experimental) Un-encode a Tokenized value from a list.

        :param l: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c07d284f11db3dc1cb71ad4515509e239267107ad7522e34ac1a72a6ac6f2802)
            check_type(argname="argument l", value=l, expected_type=type_hints["l"])
        return typing.cast(typing.Optional[IResolvable], jsii.sinvoke(cls, "reverseList", [l]))

    @jsii.member(jsii_name="reverseMap")
    @builtins.classmethod
    def reverse_map(
        cls,
        m: typing.Mapping[builtins.str, typing.Any],
    ) -> typing.Optional[IResolvable]:
        '''(experimental) Un-encode a Tokenized value from a map.

        :param m: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78da4151a4e8cb3a7d48a95aab021857dbfd12c3f6704a72ab7cb5a53b7ec9f0)
            check_type(argname="argument m", value=m, expected_type=type_hints["m"])
        return typing.cast(typing.Optional[IResolvable], jsii.sinvoke(cls, "reverseMap", [m]))

    @jsii.member(jsii_name="reverseNumber")
    @builtins.classmethod
    def reverse_number(cls, n: jsii.Number) -> typing.Optional[IResolvable]:
        '''(experimental) Un-encode a Tokenized value from a number.

        :param n: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2d07d0938b61343973af65aea42618d714c3d5d88e159cf25d08ee326b583ddc)
            check_type(argname="argument n", value=n, expected_type=type_hints["n"])
        return typing.cast(typing.Optional[IResolvable], jsii.sinvoke(cls, "reverseNumber", [n]))

    @jsii.member(jsii_name="reverseNumberList")
    @builtins.classmethod
    def reverse_number_list(
        cls,
        l: typing.Sequence[jsii.Number],
    ) -> typing.Optional[IResolvable]:
        '''(experimental) Un-encode a Tokenized value from a list.

        :param l: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__350f39333ba38c10238a6b7c32c0d9c7e1ef449033d339d382b7c695c0fe44ca)
            check_type(argname="argument l", value=l, expected_type=type_hints["l"])
        return typing.cast(typing.Optional[IResolvable], jsii.sinvoke(cls, "reverseNumberList", [l]))

    @jsii.member(jsii_name="reverseString")
    @builtins.classmethod
    def reverse_string(cls, s: builtins.str) -> "TokenizedStringFragments":
        '''(experimental) Un-encode a string potentially containing encoded tokens.

        :param s: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2265f0b5417d3eaf73a94eba6cb2289915925b3993c6ace5e05066993483828c)
            check_type(argname="argument s", value=s, expected_type=type_hints["s"])
        return typing.cast("TokenizedStringFragments", jsii.sinvoke(cls, "reverseString", [s]))

    @jsii.member(jsii_name="stringifyNumber")
    @builtins.classmethod
    def stringify_number(cls, x: jsii.Number) -> builtins.str:
        '''(experimental) Stringify a number directly or lazily if it's a Token.

        If it is an object (i.e., { Ref: 'SomeLogicalId' }), return it as-is.

        :param x: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__54c920c972c9cc3619812a7c67ababf282a2e795aa0ed01a49c28d1463ef26d9)
            check_type(argname="argument x", value=x, expected_type=type_hints["x"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "stringifyNumber", [x]))


class TokenizedStringFragments(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.TokenizedStringFragments",
):
    '''(experimental) Fragments of a concatenated string containing stringified Tokens.

    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="addEscape")
    def add_escape(self, kind: builtins.str) -> None:
        '''
        :param kind: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__501e1cb7a3f99e4c72f020d537954b9e6b9d63fbbc6362403b11a7100b9c935e)
            check_type(argname="argument kind", value=kind, expected_type=type_hints["kind"])
        return typing.cast(None, jsii.invoke(self, "addEscape", [kind]))

    @jsii.member(jsii_name="addIntrinsic")
    def add_intrinsic(self, value: typing.Any) -> None:
        '''(experimental) Adds an intrinsic fragment.

        :param value: the intrinsic value to add.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4bcb7ecbb9aac7e5cb14e803bff0f53dcd361a8d632fe2f75767f2526afd8790)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "addIntrinsic", [value]))

    @jsii.member(jsii_name="addLiteral")
    def add_literal(self, lit: typing.Any) -> None:
        '''(experimental) Adds a literal fragment.

        :param lit: the literal to add.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2d7737ee2e7b4040e04fee4e106f51355dfe3bd295d0b19090bced5beec97bf6)
            check_type(argname="argument lit", value=lit, expected_type=type_hints["lit"])
        return typing.cast(None, jsii.invoke(self, "addLiteral", [lit]))

    @jsii.member(jsii_name="addToken")
    def add_token(self, token: IResolvable) -> None:
        '''(experimental) Adds a token fragment.

        :param token: the token to add.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__216413d96524fedcc24c14cdb84074599c56ae684eb293b72772193e37f7b0af)
            check_type(argname="argument token", value=token, expected_type=type_hints["token"])
        return typing.cast(None, jsii.invoke(self, "addToken", [token]))

    @jsii.member(jsii_name="concat")
    def concat(self, other: "TokenizedStringFragments") -> None:
        '''
        :param other: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5bc0172faa9bc46188d6c681b75886dd61b4fc7ce2e50514efeca61d8d0f2662)
            check_type(argname="argument other", value=other, expected_type=type_hints["other"])
        return typing.cast(None, jsii.invoke(self, "concat", [other]))

    @jsii.member(jsii_name="join")
    def join(self, concat: IFragmentConcatenator) -> typing.Any:
        '''(experimental) Combine the string fragments using the given joiner.

        If there are any

        :param concat: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0efd2b284d9da60d536ca212f07342ebc5c65c39a371bde4fdd8dc20348cffae)
            check_type(argname="argument concat", value=concat, expected_type=type_hints["concat"])
        return typing.cast(typing.Any, jsii.invoke(self, "join", [concat]))

    @jsii.member(jsii_name="mapTokens")
    def map_tokens(self, context: IResolveContext) -> "TokenizedStringFragments":
        '''(experimental) Apply a transformation function to all tokens in the string.

        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__785cdb6e2fb36f21dd197be608c186135b26a1f978b658c0e42555c941f69578)
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast("TokenizedStringFragments", jsii.invoke(self, "mapTokens", [context]))

    @builtins.property
    @jsii.member(jsii_name="escapes")
    def escapes(self) -> typing.List[IResolvable]:
        '''(experimental) Return all escape fragments from this string.

        :stability: experimental
        '''
        return typing.cast(typing.List[IResolvable], jsii.get(self, "escapes"))

    @builtins.property
    @jsii.member(jsii_name="firstValue")
    def first_value(self) -> typing.Any:
        '''(experimental) Returns the first value.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "firstValue"))

    @builtins.property
    @jsii.member(jsii_name="intrinsic")
    def intrinsic(self) -> typing.List[IResolvable]:
        '''(experimental) Return all intrinsic fragments from this string.

        :stability: experimental
        '''
        return typing.cast(typing.List[IResolvable], jsii.get(self, "intrinsic"))

    @builtins.property
    @jsii.member(jsii_name="length")
    def length(self) -> jsii.Number:
        '''(experimental) Returns the number of fragments.

        :stability: experimental
        '''
        return typing.cast(jsii.Number, jsii.get(self, "length"))

    @builtins.property
    @jsii.member(jsii_name="literals")
    def literals(self) -> typing.List[IResolvable]:
        '''(experimental) Return all literals from this string.

        :stability: experimental
        '''
        return typing.cast(typing.List[IResolvable], jsii.get(self, "literals"))

    @builtins.property
    @jsii.member(jsii_name="tokens")
    def tokens(self) -> typing.List[IResolvable]:
        '''(experimental) Return all Tokens from this string.

        :stability: experimental
        '''
        return typing.cast(typing.List[IResolvable], jsii.get(self, "tokens"))

    @builtins.property
    @jsii.member(jsii_name="firstToken")
    def first_token(self) -> typing.Optional[IResolvable]:
        '''(experimental) Returns the first token.

        :stability: experimental
        '''
        return typing.cast(typing.Optional[IResolvable], jsii.get(self, "firstToken"))


class VariableType(metaclass=jsii.JSIIAbstractClass, jsii_type="cdktf.VariableType"):
    '''
    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="list")
    @builtins.classmethod
    def list(cls, type: builtins.str) -> builtins.str:
        '''
        :param type: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9b1553c2200f8b4ba9a80d1d06cc9df5d28a70534b8415c5832307318d8c5e3a)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "list", [type]))

    @jsii.member(jsii_name="map")
    @builtins.classmethod
    def map(cls, type: builtins.str) -> builtins.str:
        '''
        :param type: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__708feb75b2e98bde2bc0f3effc87597814c6a836c35f7882632470b807d0e4d3)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "map", [type]))

    @jsii.member(jsii_name="object")
    @builtins.classmethod
    def object(
        cls,
        attributes: typing.Mapping[builtins.str, builtins.str],
    ) -> builtins.str:
        '''
        :param attributes: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0ceff60d205285e56234a5a228e82cd5d4725a3c8637889682deb0d305318ce)
            check_type(argname="argument attributes", value=attributes, expected_type=type_hints["attributes"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "object", [attributes]))

    @jsii.member(jsii_name="set")
    @builtins.classmethod
    def set(cls, type: builtins.str) -> builtins.str:
        '''
        :param type: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__593fa557b9c4a9af64e05caa24b7786bcf2e1b51007ae48984ddb07ae87fd79b)
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "set", [type]))

    @jsii.member(jsii_name="tuple")
    @builtins.classmethod
    def tuple(cls, *elements: builtins.str) -> builtins.str:
        '''
        :param elements: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3383e7f30e18eef19e54612bc57750d0cedbfd4d14b26fa39d244ea5065c50c9)
            check_type(argname="argument elements", value=elements, expected_type=typing.Tuple[type_hints["elements"], ...]) # pyright: ignore [reportGeneralTypeIssues]
        return typing.cast(builtins.str, jsii.sinvoke(cls, "tuple", [*elements]))

    @jsii.python.classproperty
    @jsii.member(jsii_name="ANY")
    def ANY(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "ANY"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="BOOL")
    def BOOL(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "BOOL"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LIST")
    def LIST(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "LIST"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LIST_BOOL")
    def LIST_BOOL(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "LIST_BOOL"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LIST_NUMBER")
    def LIST_NUMBER(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "LIST_NUMBER"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="LIST_STRING")
    def LIST_STRING(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "LIST_STRING"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="MAP")
    def MAP(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "MAP"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="MAP_BOOL")
    def MAP_BOOL(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "MAP_BOOL"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="MAP_NUMBER")
    def MAP_NUMBER(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "MAP_NUMBER"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="MAP_STRING")
    def MAP_STRING(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "MAP_STRING"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="NUMBER")
    def NUMBER(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "NUMBER"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SET")
    def SET(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "SET"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SET_BOOL")
    def SET_BOOL(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "SET_BOOL"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SET_NUMBER")
    def SET_NUMBER(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "SET_NUMBER"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="SET_STRING")
    def SET_STRING(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "SET_STRING"))

    @jsii.python.classproperty
    @jsii.member(jsii_name="STRING")
    def STRING(cls) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.sget(cls, "STRING"))


class _VariableTypeProxy(VariableType):
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, VariableType).__jsii_proxy_class__ = lambda : _VariableTypeProxy


@jsii.data_type(
    jsii_type="cdktf.WinrmProvisionerConnection",
    jsii_struct_bases=[],
    name_mapping={
        "host": "host",
        "type": "type",
        "cacert": "cacert",
        "https": "https",
        "insecure": "insecure",
        "password": "password",
        "port": "port",
        "script_path": "scriptPath",
        "timeout": "timeout",
        "use_ntlm": "useNtlm",
        "user": "user",
    },
)
class WinrmProvisionerConnection:
    def __init__(
        self,
        *,
        host: builtins.str,
        type: builtins.str,
        cacert: typing.Optional[builtins.str] = None,
        https: typing.Optional[builtins.bool] = None,
        insecure: typing.Optional[builtins.bool] = None,
        password: typing.Optional[builtins.str] = None,
        port: typing.Optional[jsii.Number] = None,
        script_path: typing.Optional[builtins.str] = None,
        timeout: typing.Optional[builtins.str] = None,
        use_ntlm: typing.Optional[builtins.bool] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Most provisioners require access to the remote resource via SSH or WinRM and expect a nested connection block with details about how to connect.

        See {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/connection connection}

        :param host: (experimental) The address of the resource to connect to.
        :param type: (experimental) The connection type. Valid values are "ssh" and "winrm". Provisioners typically assume that the remote system runs Microsoft Windows when using WinRM. Behaviors based on the SSH target_platform will force Windows-specific behavior for WinRM, unless otherwise specified.
        :param cacert: (experimental) The CA certificate to validate against.
        :param https: (experimental) Set to true to connect using HTTPS instead of HTTP.
        :param insecure: (experimental) Set to true to skip validating the HTTPS certificate chain.
        :param password: (experimental) The password to use for the connection.
        :param port: (experimental) The port to connect to. Default: 22
        :param script_path: (experimental) The path used to copy scripts meant for remote execution. Refer to {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/connection#how-provisioners-execute-remote-scripts How Provisioners Execute Remote Scripts below for more details}
        :param timeout: (experimental) The timeout to wait for the connection to become available. Should be provided as a string (e.g., "30s" or "5m".) Default: 5m
        :param use_ntlm: (experimental) Set to true to use NTLM authentication rather than default (basic authentication), removing the requirement for basic authentication to be enabled within the target guest. Refer to Authentication for Remote Connections in the Windows App Development documentation for more details.
        :param user: (experimental) The user to use for the connection. Default: root

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2242829a900f5f580a0a70ca2f581d0d54bbe8cf99d86de3ab03f42515b66582)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument type", value=type, expected_type=type_hints["type"])
            check_type(argname="argument cacert", value=cacert, expected_type=type_hints["cacert"])
            check_type(argname="argument https", value=https, expected_type=type_hints["https"])
            check_type(argname="argument insecure", value=insecure, expected_type=type_hints["insecure"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument script_path", value=script_path, expected_type=type_hints["script_path"])
            check_type(argname="argument timeout", value=timeout, expected_type=type_hints["timeout"])
            check_type(argname="argument use_ntlm", value=use_ntlm, expected_type=type_hints["use_ntlm"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "host": host,
            "type": type,
        }
        if cacert is not None:
            self._values["cacert"] = cacert
        if https is not None:
            self._values["https"] = https
        if insecure is not None:
            self._values["insecure"] = insecure
        if password is not None:
            self._values["password"] = password
        if port is not None:
            self._values["port"] = port
        if script_path is not None:
            self._values["script_path"] = script_path
        if timeout is not None:
            self._values["timeout"] = timeout
        if use_ntlm is not None:
            self._values["use_ntlm"] = use_ntlm
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def host(self) -> builtins.str:
        '''(experimental) The address of the resource to connect to.

        :stability: experimental
        '''
        result = self._values.get("host")
        assert result is not None, "Required property 'host' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def type(self) -> builtins.str:
        '''(experimental) The connection type.

        Valid values are "ssh" and "winrm".
        Provisioners typically assume that the remote system runs Microsoft Windows when using WinRM.
        Behaviors based on the SSH target_platform will force Windows-specific behavior for WinRM, unless otherwise specified.

        :stability: experimental
        '''
        result = self._values.get("type")
        assert result is not None, "Required property 'type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def cacert(self) -> typing.Optional[builtins.str]:
        '''(experimental) The CA certificate to validate against.

        :stability: experimental
        '''
        result = self._values.get("cacert")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def https(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Set to true to connect using HTTPS instead of HTTP.

        :stability: experimental
        '''
        result = self._values.get("https")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def insecure(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Set to true to skip validating the HTTPS certificate chain.

        :stability: experimental
        '''
        result = self._values.get("insecure")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''(experimental) The password to use for the connection.

        :stability: experimental
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        '''(experimental) The port to connect to.

        :default: 22

        :stability: experimental
        '''
        result = self._values.get("port")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def script_path(self) -> typing.Optional[builtins.str]:
        '''(experimental) The path used to copy scripts meant for remote execution.

        Refer to {@link https://developer.hashicorp.com/terraform/language/resources/provisioners/connection#how-provisioners-execute-remote-scripts How Provisioners Execute Remote Scripts below for more details}

        :stability: experimental
        '''
        result = self._values.get("script_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def timeout(self) -> typing.Optional[builtins.str]:
        '''(experimental) The timeout to wait for the connection to become available.

        Should be provided as a string (e.g., "30s" or "5m".)

        :default: 5m

        :stability: experimental
        '''
        result = self._values.get("timeout")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def use_ntlm(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Set to true to use NTLM authentication rather than default (basic authentication), removing the requirement for basic authentication to be enabled within the target guest.

        Refer to Authentication for Remote Connections in the Windows App Development documentation for more details.

        :stability: experimental
        '''
        result = self._values.get("use_ntlm")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''(experimental) The user to use for the connection.

        :default: root

        :stability: experimental
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "WinrmProvisionerConnection(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ITerraformAddressable, IResolvable)
class AnyMap(metaclass=jsii.JSIIMeta, jsii_type="cdktf.AnyMap"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__90f31f71458a3b8b9aa57c80aeeed1cb7385340f543f2679026b66eda1147d26)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="computeFqn")
    def compute_fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "computeFqn", []))

    @jsii.member(jsii_name="lookup")
    def lookup(self, key: builtins.str) -> typing.Any:
        '''
        :param key: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c6b8c2d6a2b0cc4c1b7c07bebf446fab24a639530fca64a5dd49689e0af58aed)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(typing.Any, jsii.invoke(self, "lookup", [key]))

    @jsii.member(jsii_name="resolve")
    def resolve(self, _context: IResolveContext) -> typing.Any:
        '''(experimental) Produce the Token's value at resolution time.

        :param _context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b5b713508cf3aa41e108275c871c923a706d5fe09d2d4fc14363a507741f99ab)
            check_type(argname="argument _context", value=_context, expected_type=type_hints["_context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolve", [_context]))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Return a string representation of this resolvable object.

        Returns a reversible string representation.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @builtins.property
    @jsii.member(jsii_name="creationStack")
    def creation_stack(self) -> typing.List[builtins.str]:
        '''(experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.

        If this returns an empty array the stack will not be attached.

        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "creationStack"))

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2310560e8c08f2a917fc1e4da95cf3fbfc91f5c9a027d2d9600dde9401c0e9ad)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d837cde449400bf1593a48dd814ee29b8d8b096902277dcd7e83163b49a783fa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)


class AnyMapList(MapList, metaclass=jsii.JSIIMeta, jsii_type="cdktf.AnyMapList"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param wraps_set: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f4d4aa07b1ffa15c0e19692ee72561c1a20d0b0e6edc96a5fd343299842386fb)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> AnyMap:
        '''
        :param index: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__622d3ca5645cfd2f28f34efb1e7540acc34d9a3087d87c75c157083fe17bae89)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast(AnyMap, jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e2f2fa2819f98be613db85620aa64878d80b38a6b69dd75ab702d7b98cc3a9ed)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4e2139bed36c3ba442006614c00456eb80b82252d90668a7f58176ed77fe6d32)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0f37807e28d1c8833cf4e8dceb1e254fe832814bb139c94dc5332f345a11c1d1)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)


@jsii.implements(ITerraformAddressable, IResolvable)
class BooleanMap(metaclass=jsii.JSIIMeta, jsii_type="cdktf.BooleanMap"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e8c8be20d71098ba29ae3fb4ac5afe203245db43597074debe501b66eab10370)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="computeFqn")
    def compute_fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "computeFqn", []))

    @jsii.member(jsii_name="lookup")
    def lookup(self, key: builtins.str) -> IResolvable:
        '''
        :param key: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e279f43113522de2664b4d36a4af7764fad8edb4526a55195ea8be8ea01d7971)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(IResolvable, jsii.invoke(self, "lookup", [key]))

    @jsii.member(jsii_name="resolve")
    def resolve(self, _context: IResolveContext) -> typing.Any:
        '''(experimental) Produce the Token's value at resolution time.

        :param _context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__35e4adf801bd9c59c589a02bbc380f60223fe30b31a9f224b3f933422ab62552)
            check_type(argname="argument _context", value=_context, expected_type=type_hints["_context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolve", [_context]))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Return a string representation of this resolvable object.

        Returns a reversible string representation.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @builtins.property
    @jsii.member(jsii_name="creationStack")
    def creation_stack(self) -> typing.List[builtins.str]:
        '''(experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.

        If this returns an empty array the stack will not be attached.

        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "creationStack"))

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5852525fa99c6040128658743b132c87faccfd82e64170313a05a33081ead8ae)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b384ed65c089a9651cef401526861b0a8bf50163f79e58c671a2079d4c644cfa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)


class BooleanMapList(
    MapList,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.BooleanMapList",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param wraps_set: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a6067a0d70b28348c6919a27785e705176c8e48817da28a2cbf81f9282f27949)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> BooleanMap:
        '''
        :param index: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__41b5849fd300e172019b6552cb8f54fc926640cb276223a2ea914aa69d2010a7)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast(BooleanMap, jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f5005aba6476faad235a9cce2cabbd321e410197eb65628b51bfc703aa75b6ff)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ef321618a45b84b9b0d0b63acb80fccdd27ba198172dc53703420a2c5bd224e2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dd2e043f8b33f19a095b4aef520151248679faffaa6264585edf89e6405d9294)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)


@jsii.implements(IInterpolatingParent, IResolvable, ITerraformAddressable)
class ComplexComputedList(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.ComplexComputedList",
):
    '''
    :deprecated:

    Going to be replaced by Array of ComplexListItem
    and will be removed in the future

    :stability: deprecated
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_computed_list_index: builtins.str,
        wraps_set: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param complex_computed_list_index: -
        :param wraps_set: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4a6dfcd7640aed5c1523688006a66c6cbca2b5f214621b394b41e9611f184dd5)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_computed_list_index", value=complex_computed_list_index, expected_type=type_hints["complex_computed_list_index"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_computed_list_index, wraps_set])

    @jsii.member(jsii_name="computeFqn")
    def compute_fqn(self) -> builtins.str:
        '''
        :stability: deprecated
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "computeFqn", []))

    @jsii.member(jsii_name="getAnyMapAttribute")
    def get_any_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param terraform_attribute: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2a6b4b8d311a603ef4e79b4daaba6559c382c69168b487eafc7f733ce73835ac)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "getAnyMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getBooleanAttribute")
    def get_boolean_attribute(self, terraform_attribute: builtins.str) -> IResolvable:
        '''
        :param terraform_attribute: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0951dc2dce66dc2c5c3b5226f8bf32094dd8c01647a6505137e3771e4a8678ae)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(IResolvable, jsii.invoke(self, "getBooleanAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getBooleanMapAttribute")
    def get_boolean_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, builtins.bool]:
        '''
        :param terraform_attribute: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__483b4ae57e428d16451324d333979606bbf7cdf99fbd99aafc15a647bd257f3a)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, builtins.bool], jsii.invoke(self, "getBooleanMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getListAttribute")
    def get_list_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.List[builtins.str]:
        '''
        :param terraform_attribute: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__efde2e99e4c76c50f8e30cd95173d9c60a5c31f6f25b6e46937d05400d74eb3f)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.List[builtins.str], jsii.invoke(self, "getListAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getNumberAttribute")
    def get_number_attribute(self, terraform_attribute: builtins.str) -> jsii.Number:
        '''
        :param terraform_attribute: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8dfbf7cf7ff4e8e317241e09cd3727f5e5d605f7dc4efbe7edbe84cabe271616)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(jsii.Number, jsii.invoke(self, "getNumberAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getNumberListAttribute")
    def get_number_list_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.List[jsii.Number]:
        '''
        :param terraform_attribute: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1ac1422e412904b5a33489bc7d2f65456c30d3bdbdc67a5ba3f3bef1f69abee8)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.List[jsii.Number], jsii.invoke(self, "getNumberListAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getNumberMapAttribute")
    def get_number_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, jsii.Number]:
        '''
        :param terraform_attribute: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d0032459cb80f7fbc1f39eff1f98ea9a0d58fb3b9695f6ce8d88f3be8b24ac9e)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, jsii.Number], jsii.invoke(self, "getNumberMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getStringAttribute")
    def get_string_attribute(self, terraform_attribute: builtins.str) -> builtins.str:
        '''
        :param terraform_attribute: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c8914dd42b0c97818437f8f0c54f1bced0c64e47580854e0c917c357c332e1f)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(builtins.str, jsii.invoke(self, "getStringAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getStringMapAttribute")
    def get_string_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :param terraform_attribute: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dc23011d67c23af978c630e948612edfc2889a101d7dd442179b66dda7f36747)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.invoke(self, "getStringMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="interpolationForAttribute")
    def interpolation_for_attribute(self, property: builtins.str) -> IResolvable:
        '''
        :param property: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__40b87c293a7c7fcf3dfdb99b82be8375653046dcfc640393b7ea1feaa68d56d1)
            check_type(argname="argument property", value=property, expected_type=type_hints["property"])
        return typing.cast(IResolvable, jsii.invoke(self, "interpolationForAttribute", [property]))

    @jsii.member(jsii_name="resolve")
    def resolve(self, _context: IResolveContext) -> typing.Any:
        '''(deprecated) Produce the Token's value at resolution time.

        :param _context: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8314e0cd5c83d48676d04c29480342881974cf10b64bab10f118b2f2a043aae2)
            check_type(argname="argument _context", value=_context, expected_type=type_hints["_context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolve", [_context]))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(deprecated) Return a string representation of this resolvable object.

        Returns a reversible string representation.

        :stability: deprecated
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @builtins.property
    @jsii.member(jsii_name="creationStack")
    def creation_stack(self) -> typing.List[builtins.str]:
        '''(deprecated) The creation stack of this resolvable which will be appended to errors thrown during resolution.

        If this returns an empty array the stack will not be attached.

        :stability: deprecated
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "creationStack"))

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: deprecated
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

    @builtins.property
    @jsii.member(jsii_name="complexComputedListIndex")
    def _complex_computed_list_index(self) -> builtins.str:
        '''
        :stability: deprecated
        '''
        return typing.cast(builtins.str, jsii.get(self, "complexComputedListIndex"))

    @_complex_computed_list_index.setter
    def _complex_computed_list_index(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9fc82709e1eeda6a4c7bb123adff7587afd948cee3323ad10f66cd8b03eb9ac2)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "complexComputedListIndex", value)

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: deprecated
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c2565f798a681bd106dc4660dc048822f4a814788f2df7459811d855f0a01f7)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: deprecated
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2cc973bb5d0d6a8797af31feeee6ad1e97d6a5cb54a23c6f43c93736d800df6d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: deprecated
        '''
        return typing.cast(typing.Optional[builtins.bool], jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: typing.Optional[builtins.bool]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1ef0b0d4c10ca9fcbb98b30351df5910b2dcbd74e3db0600738d1152115c8d83)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)


@jsii.implements(ITerraformAddressable, IResolvable)
class ComplexList(metaclass=jsii.JSIIAbstractClass, jsii_type="cdktf.ComplexList"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param wraps_set: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f794b67ccb84da3235336a1335f8fc4b62d65d56eba539a33c422432cc1c3937)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="computeFqn")
    def compute_fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "computeFqn", []))

    @jsii.member(jsii_name="resolve")
    def resolve(self, _context: IResolveContext) -> typing.Any:
        '''(experimental) Produce the Token's value at resolution time.

        :param _context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0c2888fdf94e066e773a1a6dc8507e38ce26e18957ad16121b92c3455a6b8032)
            check_type(argname="argument _context", value=_context, expected_type=type_hints["_context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolve", [_context]))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Return a string representation of this resolvable object.

        Returns a reversible string representation.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @builtins.property
    @jsii.member(jsii_name="creationStack")
    def creation_stack(self) -> typing.List[builtins.str]:
        '''(experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.

        If this returns an empty array the stack will not be attached.

        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "creationStack"))

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ab331a879f8749f0961b685441a099350ad9e2c4bc4f433594a8306bd82a1fa8)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__156b696bdd18cf1fef1b9451c793bc586c4484a46b9749ef8bd6eba6fe1534b0)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0cf5563332e2cf01ff5be32dce067b65f98744a6279c62b3915b11ca19eb0a3e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)


class _ComplexListProxy(ComplexList):
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, ComplexList).__jsii_proxy_class__ = lambda : _ComplexListProxy


@jsii.implements(ITerraformAddressable, IResolvable)
class ComplexMap(metaclass=jsii.JSIIAbstractClass, jsii_type="cdktf.ComplexMap"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f4abed4df6ee5554c02e8bd4e65ebfe80519c1c57033fbccafeba569ed8f70a9)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="computeFqn")
    def compute_fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "computeFqn", []))

    @jsii.member(jsii_name="interpolationForAttribute")
    def interpolation_for_attribute(self, property: builtins.str) -> IResolvable:
        '''
        :param property: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0507441efd70ce746c62da81b6b609574a3f4f787d9099d387ff25cd210304bc)
            check_type(argname="argument property", value=property, expected_type=type_hints["property"])
        return typing.cast(IResolvable, jsii.invoke(self, "interpolationForAttribute", [property]))

    @jsii.member(jsii_name="resolve")
    def resolve(self, _context: IResolveContext) -> typing.Any:
        '''(experimental) Produce the Token's value at resolution time.

        :param _context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__00412282ff3ffaee8a7daacf9df45a1125c8b44eac87547f5715094be0097780)
            check_type(argname="argument _context", value=_context, expected_type=type_hints["_context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolve", [_context]))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Return a string representation of this resolvable object.

        Returns a reversible string representation.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @builtins.property
    @jsii.member(jsii_name="creationStack")
    def creation_stack(self) -> typing.List[builtins.str]:
        '''(experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.

        If this returns an empty array the stack will not be attached.

        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "creationStack"))

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6c4c11f441958760b243af2c115dfd2fa50ce07f2414f53bf07640b1ead12b8b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0776a416d9f6869f7df24cab4578c088f3609321c82636c74c28ddcef8eb0d9d)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)


class _ComplexMapProxy(ComplexMap):
    pass

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, ComplexMap).__jsii_proxy_class__ = lambda : _ComplexMapProxy


@jsii.implements(IInterpolatingParent, IResolvable, ITerraformAddressable)
class ComplexObject(metaclass=jsii.JSIIMeta, jsii_type="cdktf.ComplexObject"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
        complex_object_is_from_set: builtins.bool,
        complex_object_index: typing.Optional[typing.Union[builtins.str, jsii.Number]] = None,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param complex_object_is_from_set: set to true if this item is from inside a set and needs tolist() for accessing it set to "0" for single list items.
        :param complex_object_index: the index of the complex object in a list.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d8d428c8643cc4a95c2511c66022a7ea8153a2e5a853cd1a764f5a5d0897b72a)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument complex_object_is_from_set", value=complex_object_is_from_set, expected_type=type_hints["complex_object_is_from_set"])
            check_type(argname="argument complex_object_index", value=complex_object_index, expected_type=type_hints["complex_object_index"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, complex_object_is_from_set, complex_object_index])

    @jsii.member(jsii_name="computeFqn")
    def compute_fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "computeFqn", []))

    @jsii.member(jsii_name="getAnyMapAttribute")
    def get_any_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d61a437b00de5abaa15c47ad184fcfedd194277d3472d8ead2520c28717b5afc)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "getAnyMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getBooleanAttribute")
    def get_boolean_attribute(self, terraform_attribute: builtins.str) -> IResolvable:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__53bcd6eb735e11ccfa5f2618fb8526681973865b25641ca2774990d46b3f5e03)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(IResolvable, jsii.invoke(self, "getBooleanAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getBooleanMapAttribute")
    def get_boolean_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, builtins.bool]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0d99d102fad2eb121048531932f673bdbf62a01b1f0d5b6a03ea71d2001d0ca1)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, builtins.bool], jsii.invoke(self, "getBooleanMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getListAttribute")
    def get_list_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.List[builtins.str]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ef07d66081240fa970ab80c08f6d59a6ee44b4ab36864b95ec7a719d09d77e7)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.List[builtins.str], jsii.invoke(self, "getListAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getNumberAttribute")
    def get_number_attribute(self, terraform_attribute: builtins.str) -> jsii.Number:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__56a7cc846d957f54447554f00f1117c647fce55f8dbf2e365612914f0255f304)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(jsii.Number, jsii.invoke(self, "getNumberAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getNumberListAttribute")
    def get_number_list_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.List[jsii.Number]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9085bc7eaa4cdcc7c156b3399a6c82461d90b7bad6c437c9c047f7e2a00e9ef1)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.List[jsii.Number], jsii.invoke(self, "getNumberListAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getNumberMapAttribute")
    def get_number_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, jsii.Number]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__faaa2eb53fa467e89f358cdd96ba9b25cf2949f126093b921d755a1851f214d6)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, jsii.Number], jsii.invoke(self, "getNumberMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getStringAttribute")
    def get_string_attribute(self, terraform_attribute: builtins.str) -> builtins.str:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a228b7ac8f9ae3895909b822ab7298c0ca64774392da8c8fa9a95f6b336a2641)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(builtins.str, jsii.invoke(self, "getStringAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getStringMapAttribute")
    def get_string_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4ad23f4ca5b38d62a56180da04280dffe24ca6f64a48d97f6aa1c82271f438e6)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.invoke(self, "getStringMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="interpolationAsList")
    def _interpolation_as_list(self) -> IResolvable:
        '''
        :stability: experimental
        '''
        return typing.cast(IResolvable, jsii.invoke(self, "interpolationAsList", []))

    @jsii.member(jsii_name="interpolationForAttribute")
    def interpolation_for_attribute(self, property: builtins.str) -> IResolvable:
        '''
        :param property: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9ff43c860584be7240f2ebdef739951354cb879fd9d3e4f244ffdeaa08cdb866)
            check_type(argname="argument property", value=property, expected_type=type_hints["property"])
        return typing.cast(IResolvable, jsii.invoke(self, "interpolationForAttribute", [property]))

    @jsii.member(jsii_name="resolve")
    def resolve(self, _context: IResolveContext) -> typing.Any:
        '''(experimental) Produce the Token's value at resolution time.

        :param _context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bb1ad5b43cc72baad8e931b7beb6d6f3cb8a38f71b6cc057a88ecb32415c868e)
            check_type(argname="argument _context", value=_context, expected_type=type_hints["_context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolve", [_context]))

    @jsii.member(jsii_name="toString")
    def to_string(self) -> builtins.str:
        '''(experimental) Return a string representation of this resolvable object.

        Returns a reversible string representation.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "toString", []))

    @builtins.property
    @jsii.member(jsii_name="creationStack")
    def creation_stack(self) -> typing.List[builtins.str]:
        '''(experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.

        If this returns an empty array the stack will not be attached.

        :stability: experimental
        '''
        return typing.cast(typing.List[builtins.str], jsii.get(self, "creationStack"))

    @builtins.property
    @jsii.member(jsii_name="fqn")
    def fqn(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "fqn"))

    @builtins.property
    @jsii.member(jsii_name="complexObjectIsFromSet")
    def _complex_object_is_from_set(self) -> builtins.bool:
        '''(experimental) set to true if this item is from inside a set and needs tolist() for accessing it set to "0" for single list items.

        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "complexObjectIsFromSet"))

    @_complex_object_is_from_set.setter
    def _complex_object_is_from_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e4ac6cc1af646fdd814e207a211e237552b49be54ef9e23ef6620abc15308366)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "complexObjectIsFromSet", value)

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__654af4313a4d439aaa1e5b907eafda14a65f034636aba85f2b2b8524a18552ed)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__15d2d6564851c6fe7c34adc60b427202f30c21a3fad446cab05cf748c0054d6e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="complexObjectIndex")
    def _complex_object_index(
        self,
    ) -> typing.Optional[typing.Union[builtins.str, jsii.Number]]:
        '''(experimental) the index of the complex object in a list.

        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.Union[builtins.str, jsii.Number]], jsii.get(self, "complexObjectIndex"))

    @_complex_object_index.setter
    def _complex_object_index(
        self,
        value: typing.Optional[typing.Union[builtins.str, jsii.Number]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__364932b0d79eb17aad85c4a85dae96ea911e9110f0f7bb175892457e8efe845e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "complexObjectIndex", value)


class DataTerraformRemoteState(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteState",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        organization: builtins.str,
        workspaces: IRemoteWorkspace,
        hostname: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param organization: 
        :param workspaces: 
        :param hostname: 
        :param token: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__664948d3102211f973cfc7c422ad96c944e785aab3d910768a67f99143d08285)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateRemoteConfig(
            defaults=defaults,
            workspace=workspace,
            organization=organization,
            workspaces=workspaces,
            hostname=hostname,
            token=token,
        )

        jsii.create(self.__class__, self, [scope, id, config])


class DataTerraformRemoteStateArtifactory(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateArtifactory",
):
    '''
    :deprecated: CDK for Terraform no longer supports the artifactory backend. Terraform deprecated artifactory in v1.2.3 and removed it in v1.3.

    :stability: deprecated
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        password: builtins.str,
        repo: builtins.str,
        subpath: builtins.str,
        url: builtins.str,
        username: builtins.str,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param password: (deprecated) (Required) - The password.
        :param repo: (deprecated) (Required) - The repository name.
        :param subpath: (deprecated) (Required) - Path within the repository.
        :param url: (deprecated) (Required) - The URL. Note that this is the base url to artifactory not the full repo and subpath.
        :param username: (deprecated) (Required) - The username.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__931434eebe4d191afc98d0432df6f0989f7136824491da98bbda1dcc82846a4d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateArtifactoryConfig(
            defaults=defaults,
            workspace=workspace,
            password=password,
            repo=repo,
            subpath=subpath,
            url=url,
            username=username,
        )

        jsii.create(self.__class__, self, [scope, id, config])


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateArtifactoryConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, ArtifactoryBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "password": "password",
        "repo": "repo",
        "subpath": "subpath",
        "url": "url",
        "username": "username",
    },
)
class DataTerraformRemoteStateArtifactoryConfig(
    DataTerraformRemoteStateConfig,
    ArtifactoryBackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        password: builtins.str,
        repo: builtins.str,
        subpath: builtins.str,
        url: builtins.str,
        username: builtins.str,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param password: (deprecated) (Required) - The password.
        :param repo: (deprecated) (Required) - The repository name.
        :param subpath: (deprecated) (Required) - Path within the repository.
        :param url: (deprecated) (Required) - The URL. Note that this is the base url to artifactory not the full repo and subpath.
        :param username: (deprecated) (Required) - The username.

        :deprecated: CDK for Terraform no longer supports the artifactory backend. Terraform deprecated artifactory in v1.2.3 and removed it in v1.3.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e94a16da353d5f6ff8df5651b224c27b65ea9205cecaa902c9e29641a784ec75)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument repo", value=repo, expected_type=type_hints["repo"])
            check_type(argname="argument subpath", value=subpath, expected_type=type_hints["subpath"])
            check_type(argname="argument url", value=url, expected_type=type_hints["url"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "password": password,
            "repo": repo,
            "subpath": subpath,
            "url": url,
            "username": username,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> builtins.str:
        '''(deprecated) (Required) - The password.

        :stability: deprecated
        '''
        result = self._values.get("password")
        assert result is not None, "Required property 'password' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def repo(self) -> builtins.str:
        '''(deprecated) (Required) - The repository name.

        :stability: deprecated
        '''
        result = self._values.get("repo")
        assert result is not None, "Required property 'repo' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def subpath(self) -> builtins.str:
        '''(deprecated) (Required) - Path within the repository.

        :stability: deprecated
        '''
        result = self._values.get("subpath")
        assert result is not None, "Required property 'subpath' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def url(self) -> builtins.str:
        '''(deprecated) (Required) - The URL.

        Note that this is the base url to artifactory not the full repo and subpath.

        :stability: deprecated
        '''
        result = self._values.get("url")
        assert result is not None, "Required property 'url' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def username(self) -> builtins.str:
        '''(deprecated) (Required) - The username.

        :stability: deprecated
        '''
        result = self._values.get("username")
        assert result is not None, "Required property 'username' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateArtifactoryConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DataTerraformRemoteStateAzurerm(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateAzurerm",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        container_name: builtins.str,
        key: builtins.str,
        storage_account_name: builtins.str,
        access_key: typing.Optional[builtins.str] = None,
        client_certificate_password: typing.Optional[builtins.str] = None,
        client_certificate_path: typing.Optional[builtins.str] = None,
        client_id: typing.Optional[builtins.str] = None,
        client_secret: typing.Optional[builtins.str] = None,
        endpoint: typing.Optional[builtins.str] = None,
        environment: typing.Optional[builtins.str] = None,
        msi_endpoint: typing.Optional[builtins.str] = None,
        oidc_request_token: typing.Optional[builtins.str] = None,
        oidc_request_url: typing.Optional[builtins.str] = None,
        resource_group_name: typing.Optional[builtins.str] = None,
        sas_token: typing.Optional[builtins.str] = None,
        snapshot: typing.Optional[builtins.bool] = None,
        subscription_id: typing.Optional[builtins.str] = None,
        tenant_id: typing.Optional[builtins.str] = None,
        use_azuread_auth: typing.Optional[builtins.bool] = None,
        use_microsoft_graph: typing.Optional[builtins.bool] = None,
        use_msi: typing.Optional[builtins.bool] = None,
        use_oidc: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param container_name: (experimental) (Required) The Name of the Storage Container within the Storage Account.
        :param key: (experimental) (Required) The name of the Blob used to retrieve/store Terraform's State file inside the Storage Container.
        :param storage_account_name: (experimental) (Required) The Name of the Storage Account.
        :param access_key: (experimental) access_key - (Optional) The Access Key used to access the Blob Storage Account. This can also be sourced from the ARM_ACCESS_KEY environment variable.
        :param client_certificate_password: (experimental) (Optional) The password associated with the Client Certificate specified in client_certificate_path. This can also be sourced from the ARM_CLIENT_CERTIFICATE_PASSWORD environment variable.
        :param client_certificate_path: (experimental) (Optional) The path to the PFX file used as the Client Certificate when authenticating as a Service Principal. This can also be sourced from the ARM_CLIENT_CERTIFICATE_PATH environment variable.
        :param client_id: (experimental) (Optional) The Client ID of the Service Principal. This can also be sourced from the ARM_CLIENT_ID environment variable.
        :param client_secret: (experimental) (Optional) The Client Secret of the Service Principal. This can also be sourced from the ARM_CLIENT_SECRET environment variable.
        :param endpoint: (experimental) (Optional) The Custom Endpoint for Azure Resource Manager. This can also be sourced from the ARM_ENDPOINT environment variable. NOTE: An endpoint should only be configured when using Azure Stack.
        :param environment: (experimental) (Optional) The Azure Environment which should be used. This can also be sourced from the ARM_ENVIRONMENT environment variable. Possible values are public, china, german, stack and usgovernment. Defaults to public.
        :param msi_endpoint: (experimental) (Optional) The path to a custom Managed Service Identity endpoint which is automatically determined if not specified. This can also be sourced from the ARM_MSI_ENDPOINT environment variable.
        :param oidc_request_token: (experimental) (Optional) The bearer token for the request to the OIDC provider. This can also be sourced from the ARM_OIDC_REQUEST_TOKEN or ACTIONS_ID_TOKEN_REQUEST_TOKEN environment variables.
        :param oidc_request_url: (experimental) (Optional) The URL for the OIDC provider from which to request an ID token. This can also be sourced from the ARM_OIDC_REQUEST_URL or ACTIONS_ID_TOKEN_REQUEST_URL environment variables.
        :param resource_group_name: (experimental) (Required) The Name of the Resource Group in which the Storage Account exists.
        :param sas_token: (experimental) (Optional) The SAS Token used to access the Blob Storage Account. This can also be sourced from the ARM_SAS_TOKEN environment variable.
        :param snapshot: (experimental) (Optional) Should the Blob used to store the Terraform Statefile be snapshotted before use? Defaults to false. This value can also be sourced from the ARM_SNAPSHOT environment variable.
        :param subscription_id: (experimental) (Optional) The Subscription ID in which the Storage Account exists. This can also be sourced from the ARM_SUBSCRIPTION_ID environment variable.
        :param tenant_id: (experimental) (Optional) The Tenant ID in which the Subscription exists. This can also be sourced from the ARM_TENANT_ID environment variable.
        :param use_azuread_auth: (experimental) (Optional) Should AzureAD Authentication be used to access the Blob Storage Account. This can also be sourced from the ARM_USE_AZUREAD environment variable. Note: When using AzureAD for Authentication to Storage you also need to ensure the Storage Blob Data Owner role is assigned.
        :param use_microsoft_graph: (experimental) (Optional) Should MSAL be used for authentication instead of ADAL, and should Microsoft Graph be used instead of Azure Active Directory Graph? Defaults to true. Note: In Terraform 1.2 the Azure Backend uses MSAL (and Microsoft Graph) rather than ADAL (and Azure Active Directory Graph) for authentication by default - you can disable this by setting use_microsoft_graph to false. This setting will be removed in Terraform 1.3, due to Microsoft's deprecation of ADAL.
        :param use_msi: (experimental) (Optional) Should Managed Service Identity authentication be used? This can also be sourced from the ARM_USE_MSI environment variable.
        :param use_oidc: (experimental) (Optional) Should OIDC authentication be used? This can also be sourced from the ARM_USE_OIDC environment variable. Note: When using OIDC for authentication, use_microsoft_graph must be set to true (which is the default).

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__42611643373554ea99a604273bf00e8d02a1edfeb70a0447b26c848e1a5ae7ed)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateAzurermConfig(
            defaults=defaults,
            workspace=workspace,
            container_name=container_name,
            key=key,
            storage_account_name=storage_account_name,
            access_key=access_key,
            client_certificate_password=client_certificate_password,
            client_certificate_path=client_certificate_path,
            client_id=client_id,
            client_secret=client_secret,
            endpoint=endpoint,
            environment=environment,
            msi_endpoint=msi_endpoint,
            oidc_request_token=oidc_request_token,
            oidc_request_url=oidc_request_url,
            resource_group_name=resource_group_name,
            sas_token=sas_token,
            snapshot=snapshot,
            subscription_id=subscription_id,
            tenant_id=tenant_id,
            use_azuread_auth=use_azuread_auth,
            use_microsoft_graph=use_microsoft_graph,
            use_msi=use_msi,
            use_oidc=use_oidc,
        )

        jsii.create(self.__class__, self, [scope, id, config])


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateAzurermConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, AzurermBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "container_name": "containerName",
        "key": "key",
        "storage_account_name": "storageAccountName",
        "access_key": "accessKey",
        "client_certificate_password": "clientCertificatePassword",
        "client_certificate_path": "clientCertificatePath",
        "client_id": "clientId",
        "client_secret": "clientSecret",
        "endpoint": "endpoint",
        "environment": "environment",
        "msi_endpoint": "msiEndpoint",
        "oidc_request_token": "oidcRequestToken",
        "oidc_request_url": "oidcRequestUrl",
        "resource_group_name": "resourceGroupName",
        "sas_token": "sasToken",
        "snapshot": "snapshot",
        "subscription_id": "subscriptionId",
        "tenant_id": "tenantId",
        "use_azuread_auth": "useAzureadAuth",
        "use_microsoft_graph": "useMicrosoftGraph",
        "use_msi": "useMsi",
        "use_oidc": "useOidc",
    },
)
class DataTerraformRemoteStateAzurermConfig(
    DataTerraformRemoteStateConfig,
    AzurermBackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        container_name: builtins.str,
        key: builtins.str,
        storage_account_name: builtins.str,
        access_key: typing.Optional[builtins.str] = None,
        client_certificate_password: typing.Optional[builtins.str] = None,
        client_certificate_path: typing.Optional[builtins.str] = None,
        client_id: typing.Optional[builtins.str] = None,
        client_secret: typing.Optional[builtins.str] = None,
        endpoint: typing.Optional[builtins.str] = None,
        environment: typing.Optional[builtins.str] = None,
        msi_endpoint: typing.Optional[builtins.str] = None,
        oidc_request_token: typing.Optional[builtins.str] = None,
        oidc_request_url: typing.Optional[builtins.str] = None,
        resource_group_name: typing.Optional[builtins.str] = None,
        sas_token: typing.Optional[builtins.str] = None,
        snapshot: typing.Optional[builtins.bool] = None,
        subscription_id: typing.Optional[builtins.str] = None,
        tenant_id: typing.Optional[builtins.str] = None,
        use_azuread_auth: typing.Optional[builtins.bool] = None,
        use_microsoft_graph: typing.Optional[builtins.bool] = None,
        use_msi: typing.Optional[builtins.bool] = None,
        use_oidc: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param container_name: (experimental) (Required) The Name of the Storage Container within the Storage Account.
        :param key: (experimental) (Required) The name of the Blob used to retrieve/store Terraform's State file inside the Storage Container.
        :param storage_account_name: (experimental) (Required) The Name of the Storage Account.
        :param access_key: (experimental) access_key - (Optional) The Access Key used to access the Blob Storage Account. This can also be sourced from the ARM_ACCESS_KEY environment variable.
        :param client_certificate_password: (experimental) (Optional) The password associated with the Client Certificate specified in client_certificate_path. This can also be sourced from the ARM_CLIENT_CERTIFICATE_PASSWORD environment variable.
        :param client_certificate_path: (experimental) (Optional) The path to the PFX file used as the Client Certificate when authenticating as a Service Principal. This can also be sourced from the ARM_CLIENT_CERTIFICATE_PATH environment variable.
        :param client_id: (experimental) (Optional) The Client ID of the Service Principal. This can also be sourced from the ARM_CLIENT_ID environment variable.
        :param client_secret: (experimental) (Optional) The Client Secret of the Service Principal. This can also be sourced from the ARM_CLIENT_SECRET environment variable.
        :param endpoint: (experimental) (Optional) The Custom Endpoint for Azure Resource Manager. This can also be sourced from the ARM_ENDPOINT environment variable. NOTE: An endpoint should only be configured when using Azure Stack.
        :param environment: (experimental) (Optional) The Azure Environment which should be used. This can also be sourced from the ARM_ENVIRONMENT environment variable. Possible values are public, china, german, stack and usgovernment. Defaults to public.
        :param msi_endpoint: (experimental) (Optional) The path to a custom Managed Service Identity endpoint which is automatically determined if not specified. This can also be sourced from the ARM_MSI_ENDPOINT environment variable.
        :param oidc_request_token: (experimental) (Optional) The bearer token for the request to the OIDC provider. This can also be sourced from the ARM_OIDC_REQUEST_TOKEN or ACTIONS_ID_TOKEN_REQUEST_TOKEN environment variables.
        :param oidc_request_url: (experimental) (Optional) The URL for the OIDC provider from which to request an ID token. This can also be sourced from the ARM_OIDC_REQUEST_URL or ACTIONS_ID_TOKEN_REQUEST_URL environment variables.
        :param resource_group_name: (experimental) (Required) The Name of the Resource Group in which the Storage Account exists.
        :param sas_token: (experimental) (Optional) The SAS Token used to access the Blob Storage Account. This can also be sourced from the ARM_SAS_TOKEN environment variable.
        :param snapshot: (experimental) (Optional) Should the Blob used to store the Terraform Statefile be snapshotted before use? Defaults to false. This value can also be sourced from the ARM_SNAPSHOT environment variable.
        :param subscription_id: (experimental) (Optional) The Subscription ID in which the Storage Account exists. This can also be sourced from the ARM_SUBSCRIPTION_ID environment variable.
        :param tenant_id: (experimental) (Optional) The Tenant ID in which the Subscription exists. This can also be sourced from the ARM_TENANT_ID environment variable.
        :param use_azuread_auth: (experimental) (Optional) Should AzureAD Authentication be used to access the Blob Storage Account. This can also be sourced from the ARM_USE_AZUREAD environment variable. Note: When using AzureAD for Authentication to Storage you also need to ensure the Storage Blob Data Owner role is assigned.
        :param use_microsoft_graph: (experimental) (Optional) Should MSAL be used for authentication instead of ADAL, and should Microsoft Graph be used instead of Azure Active Directory Graph? Defaults to true. Note: In Terraform 1.2 the Azure Backend uses MSAL (and Microsoft Graph) rather than ADAL (and Azure Active Directory Graph) for authentication by default - you can disable this by setting use_microsoft_graph to false. This setting will be removed in Terraform 1.3, due to Microsoft's deprecation of ADAL.
        :param use_msi: (experimental) (Optional) Should Managed Service Identity authentication be used? This can also be sourced from the ARM_USE_MSI environment variable.
        :param use_oidc: (experimental) (Optional) Should OIDC authentication be used? This can also be sourced from the ARM_USE_OIDC environment variable. Note: When using OIDC for authentication, use_microsoft_graph must be set to true (which is the default).

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f7cb1a6743595986bee169028ed0ca6ca4fde3fdd255acefdb8ab4aa304be8d2)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument container_name", value=container_name, expected_type=type_hints["container_name"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument storage_account_name", value=storage_account_name, expected_type=type_hints["storage_account_name"])
            check_type(argname="argument access_key", value=access_key, expected_type=type_hints["access_key"])
            check_type(argname="argument client_certificate_password", value=client_certificate_password, expected_type=type_hints["client_certificate_password"])
            check_type(argname="argument client_certificate_path", value=client_certificate_path, expected_type=type_hints["client_certificate_path"])
            check_type(argname="argument client_id", value=client_id, expected_type=type_hints["client_id"])
            check_type(argname="argument client_secret", value=client_secret, expected_type=type_hints["client_secret"])
            check_type(argname="argument endpoint", value=endpoint, expected_type=type_hints["endpoint"])
            check_type(argname="argument environment", value=environment, expected_type=type_hints["environment"])
            check_type(argname="argument msi_endpoint", value=msi_endpoint, expected_type=type_hints["msi_endpoint"])
            check_type(argname="argument oidc_request_token", value=oidc_request_token, expected_type=type_hints["oidc_request_token"])
            check_type(argname="argument oidc_request_url", value=oidc_request_url, expected_type=type_hints["oidc_request_url"])
            check_type(argname="argument resource_group_name", value=resource_group_name, expected_type=type_hints["resource_group_name"])
            check_type(argname="argument sas_token", value=sas_token, expected_type=type_hints["sas_token"])
            check_type(argname="argument snapshot", value=snapshot, expected_type=type_hints["snapshot"])
            check_type(argname="argument subscription_id", value=subscription_id, expected_type=type_hints["subscription_id"])
            check_type(argname="argument tenant_id", value=tenant_id, expected_type=type_hints["tenant_id"])
            check_type(argname="argument use_azuread_auth", value=use_azuread_auth, expected_type=type_hints["use_azuread_auth"])
            check_type(argname="argument use_microsoft_graph", value=use_microsoft_graph, expected_type=type_hints["use_microsoft_graph"])
            check_type(argname="argument use_msi", value=use_msi, expected_type=type_hints["use_msi"])
            check_type(argname="argument use_oidc", value=use_oidc, expected_type=type_hints["use_oidc"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container_name": container_name,
            "key": key,
            "storage_account_name": storage_account_name,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if access_key is not None:
            self._values["access_key"] = access_key
        if client_certificate_password is not None:
            self._values["client_certificate_password"] = client_certificate_password
        if client_certificate_path is not None:
            self._values["client_certificate_path"] = client_certificate_path
        if client_id is not None:
            self._values["client_id"] = client_id
        if client_secret is not None:
            self._values["client_secret"] = client_secret
        if endpoint is not None:
            self._values["endpoint"] = endpoint
        if environment is not None:
            self._values["environment"] = environment
        if msi_endpoint is not None:
            self._values["msi_endpoint"] = msi_endpoint
        if oidc_request_token is not None:
            self._values["oidc_request_token"] = oidc_request_token
        if oidc_request_url is not None:
            self._values["oidc_request_url"] = oidc_request_url
        if resource_group_name is not None:
            self._values["resource_group_name"] = resource_group_name
        if sas_token is not None:
            self._values["sas_token"] = sas_token
        if snapshot is not None:
            self._values["snapshot"] = snapshot
        if subscription_id is not None:
            self._values["subscription_id"] = subscription_id
        if tenant_id is not None:
            self._values["tenant_id"] = tenant_id
        if use_azuread_auth is not None:
            self._values["use_azuread_auth"] = use_azuread_auth
        if use_microsoft_graph is not None:
            self._values["use_microsoft_graph"] = use_microsoft_graph
        if use_msi is not None:
            self._values["use_msi"] = use_msi
        if use_oidc is not None:
            self._values["use_oidc"] = use_oidc

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def container_name(self) -> builtins.str:
        '''(experimental) (Required) The Name of the Storage Container within the Storage Account.

        :stability: experimental
        '''
        result = self._values.get("container_name")
        assert result is not None, "Required property 'container_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def key(self) -> builtins.str:
        '''(experimental) (Required) The name of the Blob used to retrieve/store Terraform's State file inside the Storage Container.

        :stability: experimental
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def storage_account_name(self) -> builtins.str:
        '''(experimental) (Required) The Name of the Storage Account.

        :stability: experimental
        '''
        result = self._values.get("storage_account_name")
        assert result is not None, "Required property 'storage_account_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def access_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) access_key - (Optional) The Access Key used to access the Blob Storage Account.

        This can also be sourced from the ARM_ACCESS_KEY environment variable.

        :stability: experimental
        '''
        result = self._values.get("access_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def client_certificate_password(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The password associated with the Client Certificate specified in client_certificate_path.

        This can also be sourced from the
        ARM_CLIENT_CERTIFICATE_PASSWORD environment variable.

        :stability: experimental
        '''
        result = self._values.get("client_certificate_password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def client_certificate_path(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The path to the PFX file used as the Client Certificate when authenticating as a Service Principal.

        This can also be sourced from the
        ARM_CLIENT_CERTIFICATE_PATH environment variable.

        :stability: experimental
        '''
        result = self._values.get("client_certificate_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def client_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The Client ID of the Service Principal.

        This can also be sourced from the ARM_CLIENT_ID environment variable.

        :stability: experimental
        '''
        result = self._values.get("client_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def client_secret(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The Client Secret of the Service Principal.

        This can also be sourced from the ARM_CLIENT_SECRET environment variable.

        :stability: experimental
        '''
        result = self._values.get("client_secret")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def endpoint(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The Custom Endpoint for Azure Resource Manager. This can also be sourced from the ARM_ENDPOINT environment variable.

        NOTE: An endpoint should only be configured when using Azure Stack.

        :stability: experimental
        '''
        result = self._values.get("endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def environment(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The Azure Environment which should be used.

        This can also be sourced from the ARM_ENVIRONMENT environment variable.
        Possible values are public, china, german, stack and usgovernment. Defaults to public.

        :stability: experimental
        '''
        result = self._values.get("environment")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def msi_endpoint(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The path to a custom Managed Service Identity endpoint which is automatically determined if not specified.

        This can also be sourced from the ARM_MSI_ENDPOINT environment variable.

        :stability: experimental
        '''
        result = self._values.get("msi_endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def oidc_request_token(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The bearer token for the request to the OIDC provider.

        This can
        also be sourced from the ARM_OIDC_REQUEST_TOKEN or
        ACTIONS_ID_TOKEN_REQUEST_TOKEN environment variables.

        :stability: experimental
        '''
        result = self._values.get("oidc_request_token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def oidc_request_url(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The URL for the OIDC provider from which to request an ID token.

        This can also be sourced from the ARM_OIDC_REQUEST_URL or
        ACTIONS_ID_TOKEN_REQUEST_URL environment variables.

        :stability: experimental
        '''
        result = self._values.get("oidc_request_url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def resource_group_name(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Required) The Name of the Resource Group in which the Storage Account exists.

        :stability: experimental
        '''
        result = self._values.get("resource_group_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sas_token(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The SAS Token used to access the Blob Storage Account.

        This can also be sourced from the ARM_SAS_TOKEN environment variable.

        :stability: experimental
        '''
        result = self._values.get("sas_token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def snapshot(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Should the Blob used to store the Terraform Statefile be snapshotted before use?

        Defaults to false. This value can also be sourced
        from the ARM_SNAPSHOT environment variable.

        :stability: experimental
        '''
        result = self._values.get("snapshot")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def subscription_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The Subscription ID in which the Storage Account exists.

        This can also be sourced from the ARM_SUBSCRIPTION_ID environment variable.

        :stability: experimental
        '''
        result = self._values.get("subscription_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tenant_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The Tenant ID in which the Subscription exists.

        This can also be sourced from the ARM_TENANT_ID environment variable.

        :stability: experimental
        '''
        result = self._values.get("tenant_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def use_azuread_auth(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Should AzureAD Authentication be used to access the Blob Storage Account.

        This can also be sourced from the ARM_USE_AZUREAD environment
        variable.

        Note: When using AzureAD for Authentication to Storage you also need to
        ensure the Storage Blob Data Owner role is assigned.

        :stability: experimental
        '''
        result = self._values.get("use_azuread_auth")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def use_microsoft_graph(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Should MSAL be used for authentication instead of ADAL, and should Microsoft Graph be used instead of Azure Active Directory Graph?

        Defaults to true.

        Note: In Terraform 1.2 the Azure Backend uses MSAL (and Microsoft Graph)
        rather than ADAL (and Azure Active Directory Graph) for authentication by
        default - you can disable this by setting use_microsoft_graph to false.
        This setting will be removed in Terraform 1.3, due to Microsoft's
        deprecation of ADAL.

        :stability: experimental
        '''
        result = self._values.get("use_microsoft_graph")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def use_msi(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Should Managed Service Identity authentication be used?

        This can also be sourced from the ARM_USE_MSI environment variable.

        :stability: experimental
        '''
        result = self._values.get("use_msi")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def use_oidc(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Should OIDC authentication be used? This can also be sourced from the ARM_USE_OIDC environment variable.

        Note: When using OIDC for authentication, use_microsoft_graph
        must be set to true (which is the default).

        :stability: experimental
        '''
        result = self._values.get("use_oidc")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateAzurermConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DataTerraformRemoteStateConsul(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateConsul",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        access_token: builtins.str,
        path: builtins.str,
        address: typing.Optional[builtins.str] = None,
        ca_file: typing.Optional[builtins.str] = None,
        cert_file: typing.Optional[builtins.str] = None,
        datacenter: typing.Optional[builtins.str] = None,
        gzip: typing.Optional[builtins.bool] = None,
        http_auth: typing.Optional[builtins.str] = None,
        key_file: typing.Optional[builtins.str] = None,
        lock: typing.Optional[builtins.bool] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param access_token: (experimental) (Required) Access token.
        :param path: (experimental) (Required) Path in the Consul KV store.
        :param address: (experimental) (Optional) DNS name and port of your Consul endpoint specified in the format dnsname:port. Defaults to the local agent HTTP listener.
        :param ca_file: (experimental) (Optional) A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param cert_file: (experimental) (Optional) A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file.
        :param datacenter: (experimental) (Optional) The datacenter to use. Defaults to that of the agent.
        :param gzip: (experimental) (Optional) true to compress the state data using gzip, or false (the default) to leave it uncompressed.
        :param http_auth: (experimental) (Optional) HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either user or user:pass.
        :param key_file: (experimental) (Optional) A path to a PEM-encoded private key, required if cert_file is specified.
        :param lock: (experimental) (Optional) false to disable locking. This defaults to true, but will require session permissions with Consul and at least kv write permissions on $path/.lock to perform locking.
        :param scheme: (experimental) (Optional) Specifies what protocol to use when talking to the given address,either http or https. SSL support can also be triggered by setting then environment variable CONSUL_HTTP_SSL to true.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fba76f7bc9f9269d4c1f41bb732c85d350b91f8475d0a28820d59dbc47c2ed00)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateConsulConfig(
            defaults=defaults,
            workspace=workspace,
            access_token=access_token,
            path=path,
            address=address,
            ca_file=ca_file,
            cert_file=cert_file,
            datacenter=datacenter,
            gzip=gzip,
            http_auth=http_auth,
            key_file=key_file,
            lock=lock,
            scheme=scheme,
        )

        jsii.create(self.__class__, self, [scope, id, config])


class DataTerraformRemoteStateCos(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateCos",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        bucket: builtins.str,
        acl: typing.Optional[builtins.str] = None,
        encrypt: typing.Optional[builtins.bool] = None,
        key: typing.Optional[builtins.str] = None,
        prefix: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        secret_id: typing.Optional[builtins.str] = None,
        secret_key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param bucket: (experimental) (Required) The name of the COS bucket. You shall manually create it first.
        :param acl: (experimental) (Optional) Object ACL to be applied to the state file, allows private and public-read. Defaults to private.
        :param encrypt: (experimental) (Optional) Whether to enable server side encryption of the state file. If it is true, COS will use 'AES256' encryption algorithm to encrypt state file.
        :param key: (experimental) (Optional) The path for saving the state file in bucket. Defaults to terraform.tfstate.
        :param prefix: (experimental) (Optional) The directory for saving the state file in bucket. Default to "env:".
        :param region: (experimental) (Optional) The region of the COS bucket. It supports environment variables TENCENTCLOUD_REGION.
        :param secret_id: (experimental) (Optional) Secret id of Tencent Cloud. It supports environment variables TENCENTCLOUD_SECRET_ID.
        :param secret_key: (experimental) (Optional) Secret key of Tencent Cloud. It supports environment variables TENCENTCLOUD_SECRET_KEY.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ec53472e87616259ff44fa7a1c40dcce97f22acc7a04e217aa57c6b78ed2f664)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateCosConfig(
            defaults=defaults,
            workspace=workspace,
            bucket=bucket,
            acl=acl,
            encrypt=encrypt,
            key=key,
            prefix=prefix,
            region=region,
            secret_id=secret_id,
            secret_key=secret_key,
        )

        jsii.create(self.__class__, self, [scope, id, config])


class DataTerraformRemoteStateEtcd(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateEtcd",
):
    '''
    :deprecated: CDK for Terraform no longer supports the etcd backend. Terraform deprecated etcd in v1.2.3 and removed it in v1.3.

    :stability: deprecated
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        endpoints: builtins.str,
        path: builtins.str,
        password: typing.Optional[builtins.str] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param endpoints: (deprecated) (Required) A space-separated list of the etcd endpoints.
        :param path: (deprecated) (Required) The path where to store the state.
        :param password: (deprecated) (Optional) The password.
        :param username: (deprecated) (Optional) The username.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__167185c48d9d0ef836b8705387edef8676fd46f0fda16da43994798ce5199de9)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateEtcdConfig(
            defaults=defaults,
            workspace=workspace,
            endpoints=endpoints,
            path=path,
            password=password,
            username=username,
        )

        jsii.create(self.__class__, self, [scope, id, config])


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateEtcdConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, EtcdBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "endpoints": "endpoints",
        "path": "path",
        "password": "password",
        "username": "username",
    },
)
class DataTerraformRemoteStateEtcdConfig(
    DataTerraformRemoteStateConfig,
    EtcdBackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        endpoints: builtins.str,
        path: builtins.str,
        password: typing.Optional[builtins.str] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param endpoints: (deprecated) (Required) A space-separated list of the etcd endpoints.
        :param path: (deprecated) (Required) The path where to store the state.
        :param password: (deprecated) (Optional) The password.
        :param username: (deprecated) (Optional) The username.

        :deprecated: CDK for Terraform no longer supports the etcd backend. Terraform deprecated etcd in v1.2.3 and removed it in v1.3.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__54c24c4a88e6540c820739fa1d97d6c40711c7f954f9b32f0a6ed92666b5e10a)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoints": endpoints,
            "path": path,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if password is not None:
            self._values["password"] = password
        if username is not None:
            self._values["username"] = username

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def endpoints(self) -> builtins.str:
        '''(deprecated) (Required) A space-separated list of the etcd endpoints.

        :stability: deprecated
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''(deprecated) (Required) The path where to store the state.

        :stability: deprecated
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) The password.

        :stability: deprecated
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def username(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) The username.

        :stability: deprecated
        '''
        result = self._values.get("username")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateEtcdConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DataTerraformRemoteStateEtcdV3(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateEtcdV3",
):
    '''
    :deprecated: CDK for Terraform no longer supports the etcdv3 backend. Terraform deprecated etcdv3 in v1.2.3 and removed it in v1.3.

    :stability: deprecated
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        endpoints: typing.Sequence[builtins.str],
        cacert_path: typing.Optional[builtins.str] = None,
        cert_path: typing.Optional[builtins.str] = None,
        key_path: typing.Optional[builtins.str] = None,
        lock: typing.Optional[builtins.bool] = None,
        password: typing.Optional[builtins.str] = None,
        prefix: typing.Optional[builtins.str] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param endpoints: (deprecated) (Required) The list of 'etcd' endpoints which to connect to.
        :param cacert_path: (deprecated) (Optional) The path to a PEM-encoded CA bundle with which to verify certificates of TLS-enabled etcd servers.
        :param cert_path: (deprecated) (Optional) The path to a PEM-encoded certificate to provide to etcd for secure client identification.
        :param key_path: (deprecated) (Optional) The path to a PEM-encoded key to provide to etcd for secure client identification.
        :param lock: (deprecated) (Optional) Whether to lock state access. Defaults to true.
        :param password: (deprecated) (Optional) Password used to connect to the etcd cluster.
        :param prefix: (deprecated) (Optional) An optional prefix to be added to keys when to storing state in etcd. Defaults to "".
        :param username: (deprecated) (Optional) Username used to connect to the etcd cluster.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__80e21a063b26b3c263ca893701fead6fd5be3535f94375919080cf8ff0a0fe6c)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateEtcdV3Config(
            defaults=defaults,
            workspace=workspace,
            endpoints=endpoints,
            cacert_path=cacert_path,
            cert_path=cert_path,
            key_path=key_path,
            lock=lock,
            password=password,
            prefix=prefix,
            username=username,
        )

        jsii.create(self.__class__, self, [scope, id, config])


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateEtcdV3Config",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, EtcdV3BackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "endpoints": "endpoints",
        "cacert_path": "cacertPath",
        "cert_path": "certPath",
        "key_path": "keyPath",
        "lock": "lock",
        "password": "password",
        "prefix": "prefix",
        "username": "username",
    },
)
class DataTerraformRemoteStateEtcdV3Config(
    DataTerraformRemoteStateConfig,
    EtcdV3BackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        endpoints: typing.Sequence[builtins.str],
        cacert_path: typing.Optional[builtins.str] = None,
        cert_path: typing.Optional[builtins.str] = None,
        key_path: typing.Optional[builtins.str] = None,
        lock: typing.Optional[builtins.bool] = None,
        password: typing.Optional[builtins.str] = None,
        prefix: typing.Optional[builtins.str] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param endpoints: (deprecated) (Required) The list of 'etcd' endpoints which to connect to.
        :param cacert_path: (deprecated) (Optional) The path to a PEM-encoded CA bundle with which to verify certificates of TLS-enabled etcd servers.
        :param cert_path: (deprecated) (Optional) The path to a PEM-encoded certificate to provide to etcd for secure client identification.
        :param key_path: (deprecated) (Optional) The path to a PEM-encoded key to provide to etcd for secure client identification.
        :param lock: (deprecated) (Optional) Whether to lock state access. Defaults to true.
        :param password: (deprecated) (Optional) Password used to connect to the etcd cluster.
        :param prefix: (deprecated) (Optional) An optional prefix to be added to keys when to storing state in etcd. Defaults to "".
        :param username: (deprecated) (Optional) Username used to connect to the etcd cluster.

        :deprecated: CDK for Terraform no longer supports the etcdv3 backend. Terraform deprecated etcdv3 in v1.2.3 and removed it in v1.3.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7948e772cf882f2ed770bade5c275f6db5c4b2ae01b8b0d15764bb8e590ca4be)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument endpoints", value=endpoints, expected_type=type_hints["endpoints"])
            check_type(argname="argument cacert_path", value=cacert_path, expected_type=type_hints["cacert_path"])
            check_type(argname="argument cert_path", value=cert_path, expected_type=type_hints["cert_path"])
            check_type(argname="argument key_path", value=key_path, expected_type=type_hints["key_path"])
            check_type(argname="argument lock", value=lock, expected_type=type_hints["lock"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoints": endpoints,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if cacert_path is not None:
            self._values["cacert_path"] = cacert_path
        if cert_path is not None:
            self._values["cert_path"] = cert_path
        if key_path is not None:
            self._values["key_path"] = key_path
        if lock is not None:
            self._values["lock"] = lock
        if password is not None:
            self._values["password"] = password
        if prefix is not None:
            self._values["prefix"] = prefix
        if username is not None:
            self._values["username"] = username

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def endpoints(self) -> typing.List[builtins.str]:
        '''(deprecated) (Required) The list of 'etcd' endpoints which to connect to.

        :stability: deprecated
        '''
        result = self._values.get("endpoints")
        assert result is not None, "Required property 'endpoints' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def cacert_path(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) The path to a PEM-encoded CA bundle with which to verify certificates of TLS-enabled etcd servers.

        :stability: deprecated
        '''
        result = self._values.get("cacert_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cert_path(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) The path to a PEM-encoded certificate to provide to etcd for secure client identification.

        :stability: deprecated
        '''
        result = self._values.get("cert_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key_path(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) The path to a PEM-encoded key to provide to etcd for secure client identification.

        :stability: deprecated
        '''
        result = self._values.get("key_path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lock(self) -> typing.Optional[builtins.bool]:
        '''(deprecated) (Optional) Whether to lock state access.

        Defaults to true.

        :stability: deprecated
        '''
        result = self._values.get("lock")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) Password used to connect to the etcd cluster.

        :stability: deprecated
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) An optional prefix to be added to keys when to storing state in etcd.

        Defaults to "".

        :stability: deprecated
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def username(self) -> typing.Optional[builtins.str]:
        '''(deprecated) (Optional) Username used to connect to the etcd cluster.

        :stability: deprecated
        '''
        result = self._values.get("username")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateEtcdV3Config(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DataTerraformRemoteStateGcs(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateGcs",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        bucket: builtins.str,
        access_token: typing.Optional[builtins.str] = None,
        credentials: typing.Optional[builtins.str] = None,
        encryption_key: typing.Optional[builtins.str] = None,
        impersonate_service_account: typing.Optional[builtins.str] = None,
        impersonate_service_account_delegates: typing.Optional[typing.Sequence[builtins.str]] = None,
        prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param bucket: (experimental) (Required) The name of the GCS bucket. This name must be globally unique.
        :param access_token: (experimental) (Optional) A temporary [OAuth 2.0 access token] obtained from the Google Authorization server, i.e. the Authorization: Bearer token used to authenticate HTTP requests to GCP APIs. This is an alternative to credentials. If both are specified, access_token will be used over the credentials field.
        :param credentials: (experimental) (Optional) Local path to Google Cloud Platform account credentials in JSON format. If unset, Google Application Default Credentials are used. The provided credentials must have Storage Object Admin role on the bucket. Warning: if using the Google Cloud Platform provider as well, it will also pick up the GOOGLE_CREDENTIALS environment variable.
        :param encryption_key: (experimental) (Optional) A 32 byte base64 encoded 'customer supplied encryption key' used to encrypt all state.
        :param impersonate_service_account: (experimental) (Optional) The service account to impersonate for accessing the State Bucket. You must have roles/iam.serviceAccountTokenCreator role on that account for the impersonation to succeed. If you are using a delegation chain, you can specify that using the impersonate_service_account_delegates field. Alternatively, this can be specified using the GOOGLE_IMPERSONATE_SERVICE_ACCOUNT environment variable.
        :param impersonate_service_account_delegates: (experimental) (Optional) The delegation chain for an impersonating a service account.
        :param prefix: (experimental) (Optional) GCS prefix inside the bucket. Named states for workspaces are stored in an object called /.tfstate.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__bcd0346cad49030d2a17de253a0e7e30058743cfa18994ac04240d0b15b182d5)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateGcsConfig(
            defaults=defaults,
            workspace=workspace,
            bucket=bucket,
            access_token=access_token,
            credentials=credentials,
            encryption_key=encryption_key,
            impersonate_service_account=impersonate_service_account,
            impersonate_service_account_delegates=impersonate_service_account_delegates,
            prefix=prefix,
        )

        jsii.create(self.__class__, self, [scope, id, config])


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateGcsConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, GcsBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "bucket": "bucket",
        "access_token": "accessToken",
        "credentials": "credentials",
        "encryption_key": "encryptionKey",
        "impersonate_service_account": "impersonateServiceAccount",
        "impersonate_service_account_delegates": "impersonateServiceAccountDelegates",
        "prefix": "prefix",
    },
)
class DataTerraformRemoteStateGcsConfig(
    DataTerraformRemoteStateConfig,
    GcsBackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        bucket: builtins.str,
        access_token: typing.Optional[builtins.str] = None,
        credentials: typing.Optional[builtins.str] = None,
        encryption_key: typing.Optional[builtins.str] = None,
        impersonate_service_account: typing.Optional[builtins.str] = None,
        impersonate_service_account_delegates: typing.Optional[typing.Sequence[builtins.str]] = None,
        prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param bucket: (experimental) (Required) The name of the GCS bucket. This name must be globally unique.
        :param access_token: (experimental) (Optional) A temporary [OAuth 2.0 access token] obtained from the Google Authorization server, i.e. the Authorization: Bearer token used to authenticate HTTP requests to GCP APIs. This is an alternative to credentials. If both are specified, access_token will be used over the credentials field.
        :param credentials: (experimental) (Optional) Local path to Google Cloud Platform account credentials in JSON format. If unset, Google Application Default Credentials are used. The provided credentials must have Storage Object Admin role on the bucket. Warning: if using the Google Cloud Platform provider as well, it will also pick up the GOOGLE_CREDENTIALS environment variable.
        :param encryption_key: (experimental) (Optional) A 32 byte base64 encoded 'customer supplied encryption key' used to encrypt all state.
        :param impersonate_service_account: (experimental) (Optional) The service account to impersonate for accessing the State Bucket. You must have roles/iam.serviceAccountTokenCreator role on that account for the impersonation to succeed. If you are using a delegation chain, you can specify that using the impersonate_service_account_delegates field. Alternatively, this can be specified using the GOOGLE_IMPERSONATE_SERVICE_ACCOUNT environment variable.
        :param impersonate_service_account_delegates: (experimental) (Optional) The delegation chain for an impersonating a service account.
        :param prefix: (experimental) (Optional) GCS prefix inside the bucket. Named states for workspaces are stored in an object called /.tfstate.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f5811b3bc35c19f7c3cab1f35d2fdd5f8115af59928a07f08ce79199bb6c39a7)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument bucket", value=bucket, expected_type=type_hints["bucket"])
            check_type(argname="argument access_token", value=access_token, expected_type=type_hints["access_token"])
            check_type(argname="argument credentials", value=credentials, expected_type=type_hints["credentials"])
            check_type(argname="argument encryption_key", value=encryption_key, expected_type=type_hints["encryption_key"])
            check_type(argname="argument impersonate_service_account", value=impersonate_service_account, expected_type=type_hints["impersonate_service_account"])
            check_type(argname="argument impersonate_service_account_delegates", value=impersonate_service_account_delegates, expected_type=type_hints["impersonate_service_account_delegates"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "bucket": bucket,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if access_token is not None:
            self._values["access_token"] = access_token
        if credentials is not None:
            self._values["credentials"] = credentials
        if encryption_key is not None:
            self._values["encryption_key"] = encryption_key
        if impersonate_service_account is not None:
            self._values["impersonate_service_account"] = impersonate_service_account
        if impersonate_service_account_delegates is not None:
            self._values["impersonate_service_account_delegates"] = impersonate_service_account_delegates
        if prefix is not None:
            self._values["prefix"] = prefix

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def bucket(self) -> builtins.str:
        '''(experimental) (Required) The name of the GCS bucket.

        This name must be globally unique.

        :stability: experimental
        '''
        result = self._values.get("bucket")
        assert result is not None, "Required property 'bucket' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def access_token(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) A temporary [OAuth 2.0 access token] obtained from the Google Authorization server, i.e. the Authorization: Bearer token used to authenticate HTTP requests to GCP APIs. This is an alternative to credentials. If both are specified, access_token will be used over the credentials field.

        :stability: experimental
        '''
        result = self._values.get("access_token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def credentials(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Local path to Google Cloud Platform account credentials in JSON format.

        If unset, Google Application Default Credentials are used.
        The provided credentials must have Storage Object Admin role on the bucket.

        Warning: if using the Google Cloud Platform provider as well,
        it will also pick up the GOOGLE_CREDENTIALS environment variable.

        :stability: experimental
        '''
        result = self._values.get("credentials")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def encryption_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) A 32 byte base64 encoded 'customer supplied encryption key' used to encrypt all state.

        :stability: experimental
        '''
        result = self._values.get("encryption_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def impersonate_service_account(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The service account to impersonate for accessing the State Bucket.

        You must have roles/iam.serviceAccountTokenCreator role on that account for the impersonation to succeed.
        If you are using a delegation chain, you can specify that using the impersonate_service_account_delegates field.
        Alternatively, this can be specified using the GOOGLE_IMPERSONATE_SERVICE_ACCOUNT environment variable.

        :stability: experimental
        '''
        result = self._values.get("impersonate_service_account")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def impersonate_service_account_delegates(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) (Optional) The delegation chain for an impersonating a service account.

        :stability: experimental
        '''
        result = self._values.get("impersonate_service_account_delegates")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) GCS prefix inside the bucket.

        Named states for workspaces are stored in an object called /.tfstate.

        :stability: experimental
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateGcsConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DataTerraformRemoteStateHttp(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateHttp",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        address: builtins.str,
        lock_address: typing.Optional[builtins.str] = None,
        lock_method: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        retry_max: typing.Optional[jsii.Number] = None,
        retry_wait_max: typing.Optional[jsii.Number] = None,
        retry_wait_min: typing.Optional[jsii.Number] = None,
        skip_cert_verification: typing.Optional[builtins.bool] = None,
        unlock_address: typing.Optional[builtins.str] = None,
        unlock_method: typing.Optional[builtins.str] = None,
        update_method: typing.Optional[builtins.str] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param address: (experimental) (Required) The address of the REST endpoint.
        :param lock_address: (experimental) (Optional) The address of the lock REST endpoint. Defaults to disabled.
        :param lock_method: (experimental) (Optional) The HTTP method to use when locking. Defaults to LOCK.
        :param password: (experimental) (Optional) The password for HTTP basic authentication.
        :param retry_max: (experimental) (Optional) The number of HTTP request retries. Defaults to 2.
        :param retry_wait_max: (experimental) (Optional) The maximum time in seconds to wait between HTTP request attempts. Defaults to 30.
        :param retry_wait_min: (experimental) (Optional) The minimum time in seconds to wait between HTTP request attempts. Defaults to 1.
        :param skip_cert_verification: (experimental) (Optional) Whether to skip TLS verification. Defaults to false.
        :param unlock_address: (experimental) (Optional) The address of the unlock REST endpoint. Defaults to disabled.
        :param unlock_method: (experimental) (Optional) The HTTP method to use when unlocking. Defaults to UNLOCK.
        :param update_method: (experimental) (Optional) HTTP method to use when updating state. Defaults to POST.
        :param username: (experimental) (Optional) The username for HTTP basic authentication.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__88ae5ffe7747f1c4c4bff7841df50f50de2df33834a8c213bae9c9f0c4a326ad)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateHttpConfig(
            defaults=defaults,
            workspace=workspace,
            address=address,
            lock_address=lock_address,
            lock_method=lock_method,
            password=password,
            retry_max=retry_max,
            retry_wait_max=retry_wait_max,
            retry_wait_min=retry_wait_min,
            skip_cert_verification=skip_cert_verification,
            unlock_address=unlock_address,
            unlock_method=unlock_method,
            update_method=update_method,
            username=username,
        )

        jsii.create(self.__class__, self, [scope, id, config])


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateHttpConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, HttpBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "address": "address",
        "lock_address": "lockAddress",
        "lock_method": "lockMethod",
        "password": "password",
        "retry_max": "retryMax",
        "retry_wait_max": "retryWaitMax",
        "retry_wait_min": "retryWaitMin",
        "skip_cert_verification": "skipCertVerification",
        "unlock_address": "unlockAddress",
        "unlock_method": "unlockMethod",
        "update_method": "updateMethod",
        "username": "username",
    },
)
class DataTerraformRemoteStateHttpConfig(
    DataTerraformRemoteStateConfig,
    HttpBackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        address: builtins.str,
        lock_address: typing.Optional[builtins.str] = None,
        lock_method: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        retry_max: typing.Optional[jsii.Number] = None,
        retry_wait_max: typing.Optional[jsii.Number] = None,
        retry_wait_min: typing.Optional[jsii.Number] = None,
        skip_cert_verification: typing.Optional[builtins.bool] = None,
        unlock_address: typing.Optional[builtins.str] = None,
        unlock_method: typing.Optional[builtins.str] = None,
        update_method: typing.Optional[builtins.str] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param address: (experimental) (Required) The address of the REST endpoint.
        :param lock_address: (experimental) (Optional) The address of the lock REST endpoint. Defaults to disabled.
        :param lock_method: (experimental) (Optional) The HTTP method to use when locking. Defaults to LOCK.
        :param password: (experimental) (Optional) The password for HTTP basic authentication.
        :param retry_max: (experimental) (Optional) The number of HTTP request retries. Defaults to 2.
        :param retry_wait_max: (experimental) (Optional) The maximum time in seconds to wait between HTTP request attempts. Defaults to 30.
        :param retry_wait_min: (experimental) (Optional) The minimum time in seconds to wait between HTTP request attempts. Defaults to 1.
        :param skip_cert_verification: (experimental) (Optional) Whether to skip TLS verification. Defaults to false.
        :param unlock_address: (experimental) (Optional) The address of the unlock REST endpoint. Defaults to disabled.
        :param unlock_method: (experimental) (Optional) The HTTP method to use when unlocking. Defaults to UNLOCK.
        :param update_method: (experimental) (Optional) HTTP method to use when updating state. Defaults to POST.
        :param username: (experimental) (Optional) The username for HTTP basic authentication.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__12173ae88a31040dce8df909aa508c89e44817d2042a61aabdd0529ee79358b4)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument address", value=address, expected_type=type_hints["address"])
            check_type(argname="argument lock_address", value=lock_address, expected_type=type_hints["lock_address"])
            check_type(argname="argument lock_method", value=lock_method, expected_type=type_hints["lock_method"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument retry_max", value=retry_max, expected_type=type_hints["retry_max"])
            check_type(argname="argument retry_wait_max", value=retry_wait_max, expected_type=type_hints["retry_wait_max"])
            check_type(argname="argument retry_wait_min", value=retry_wait_min, expected_type=type_hints["retry_wait_min"])
            check_type(argname="argument skip_cert_verification", value=skip_cert_verification, expected_type=type_hints["skip_cert_verification"])
            check_type(argname="argument unlock_address", value=unlock_address, expected_type=type_hints["unlock_address"])
            check_type(argname="argument unlock_method", value=unlock_method, expected_type=type_hints["unlock_method"])
            check_type(argname="argument update_method", value=update_method, expected_type=type_hints["update_method"])
            check_type(argname="argument username", value=username, expected_type=type_hints["username"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "address": address,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if lock_address is not None:
            self._values["lock_address"] = lock_address
        if lock_method is not None:
            self._values["lock_method"] = lock_method
        if password is not None:
            self._values["password"] = password
        if retry_max is not None:
            self._values["retry_max"] = retry_max
        if retry_wait_max is not None:
            self._values["retry_wait_max"] = retry_wait_max
        if retry_wait_min is not None:
            self._values["retry_wait_min"] = retry_wait_min
        if skip_cert_verification is not None:
            self._values["skip_cert_verification"] = skip_cert_verification
        if unlock_address is not None:
            self._values["unlock_address"] = unlock_address
        if unlock_method is not None:
            self._values["unlock_method"] = unlock_method
        if update_method is not None:
            self._values["update_method"] = update_method
        if username is not None:
            self._values["username"] = username

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def address(self) -> builtins.str:
        '''(experimental) (Required) The address of the REST endpoint.

        :stability: experimental
        '''
        result = self._values.get("address")
        assert result is not None, "Required property 'address' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def lock_address(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The address of the lock REST endpoint.

        Defaults to disabled.

        :stability: experimental
        '''
        result = self._values.get("lock_address")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def lock_method(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The HTTP method to use when locking.

        Defaults to LOCK.

        :stability: experimental
        '''
        result = self._values.get("lock_method")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The password for HTTP basic authentication.

        :stability: experimental
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def retry_max(self) -> typing.Optional[jsii.Number]:
        '''(experimental) (Optional) The number of HTTP request retries.

        Defaults to 2.

        :stability: experimental
        '''
        result = self._values.get("retry_max")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def retry_wait_max(self) -> typing.Optional[jsii.Number]:
        '''(experimental) (Optional) The maximum time in seconds to wait between HTTP request attempts.

        Defaults to 30.

        :stability: experimental
        '''
        result = self._values.get("retry_wait_max")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def retry_wait_min(self) -> typing.Optional[jsii.Number]:
        '''(experimental) (Optional) The minimum time in seconds to wait between HTTP request attempts.

        Defaults to 1.

        :stability: experimental
        '''
        result = self._values.get("retry_wait_min")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def skip_cert_verification(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Whether to skip TLS verification.

        Defaults to false.

        :stability: experimental
        '''
        result = self._values.get("skip_cert_verification")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def unlock_address(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The address of the unlock REST endpoint.

        Defaults to disabled.

        :stability: experimental
        '''
        result = self._values.get("unlock_address")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def unlock_method(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The HTTP method to use when unlocking.

        Defaults to UNLOCK.

        :stability: experimental
        '''
        result = self._values.get("unlock_method")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def update_method(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) HTTP method to use when updating state.

        Defaults to POST.

        :stability: experimental
        '''
        result = self._values.get("update_method")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def username(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The username for HTTP basic authentication.

        :stability: experimental
        '''
        result = self._values.get("username")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateHttpConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DataTerraformRemoteStateLocal(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateLocal",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        path: typing.Optional[builtins.str] = None,
        workspace_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param path: (experimental) Path where the state file is stored. Default: - defaults to terraform.${stackId}.tfstate
        :param workspace_dir: (experimental) (Optional) The path to non-default workspaces.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3aee74c0fce23045491020ff445efdaeb117acf5602b5d4dd9457525c9dd647a)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateLocalConfig(
            defaults=defaults,
            workspace=workspace,
            path=path,
            workspace_dir=workspace_dir,
        )

        jsii.create(self.__class__, self, [scope, id, config])


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateLocalConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, LocalBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "path": "path",
        "workspace_dir": "workspaceDir",
    },
)
class DataTerraformRemoteStateLocalConfig(
    DataTerraformRemoteStateConfig,
    LocalBackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        path: typing.Optional[builtins.str] = None,
        workspace_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param path: (experimental) Path where the state file is stored. Default: - defaults to terraform.${stackId}.tfstate
        :param workspace_dir: (experimental) (Optional) The path to non-default workspaces.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9f97527e2d2d1095fb81cfac6757265aaac303c7617b716627d75f478a45eca5)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument workspace_dir", value=workspace_dir, expected_type=type_hints["workspace_dir"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if path is not None:
            self._values["path"] = path
        if workspace_dir is not None:
            self._values["workspace_dir"] = workspace_dir

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def path(self) -> typing.Optional[builtins.str]:
        '''(experimental) Path where the state file is stored.

        :default: - defaults to terraform.${stackId}.tfstate

        :stability: experimental
        '''
        result = self._values.get("path")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def workspace_dir(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The path to non-default workspaces.

        :stability: experimental
        '''
        result = self._values.get("workspace_dir")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateLocalConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DataTerraformRemoteStateManta(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateManta",
):
    '''
    :deprecated: CDK for Terraform no longer supports the manta backend. Terraform deprecated manta in v1.2.3 and removed it in v1.3.

    :stability: deprecated
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        account: builtins.str,
        key_id: builtins.str,
        path: builtins.str,
        insecure_skip_tls_verify: typing.Optional[builtins.bool] = None,
        key_material: typing.Optional[builtins.str] = None,
        object_name: typing.Optional[builtins.str] = None,
        url: typing.Optional[builtins.str] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param account: 
        :param key_id: 
        :param path: 
        :param insecure_skip_tls_verify: 
        :param key_material: 
        :param object_name: 
        :param url: 
        :param user: 

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__85e58fa7c82fc9d6daf5af8bffdb86822c97f1b52c4e403824ac58a70a77f503)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateMantaConfig(
            defaults=defaults,
            workspace=workspace,
            account=account,
            key_id=key_id,
            path=path,
            insecure_skip_tls_verify=insecure_skip_tls_verify,
            key_material=key_material,
            object_name=object_name,
            url=url,
            user=user,
        )

        jsii.create(self.__class__, self, [scope, id, config])


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateMantaConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, MantaBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "account": "account",
        "key_id": "keyId",
        "path": "path",
        "insecure_skip_tls_verify": "insecureSkipTlsVerify",
        "key_material": "keyMaterial",
        "object_name": "objectName",
        "url": "url",
        "user": "user",
    },
)
class DataTerraformRemoteStateMantaConfig(
    DataTerraformRemoteStateConfig,
    MantaBackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        account: builtins.str,
        key_id: builtins.str,
        path: builtins.str,
        insecure_skip_tls_verify: typing.Optional[builtins.bool] = None,
        key_material: typing.Optional[builtins.str] = None,
        object_name: typing.Optional[builtins.str] = None,
        url: typing.Optional[builtins.str] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param account: 
        :param key_id: 
        :param path: 
        :param insecure_skip_tls_verify: 
        :param key_material: 
        :param object_name: 
        :param url: 
        :param user: 

        :deprecated: CDK for Terraform no longer supports the manta backend. Terraform deprecated manta in v1.2.3 and removed it in v1.3.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__30240a06d0c8e562654669b0d4e9434795d47887b95e9e4cd98daf079a99a0c1)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument key_id", value=key_id, expected_type=type_hints["key_id"])
            check_type(argname="argument path", value=path, expected_type=type_hints["path"])
            check_type(argname="argument insecure_skip_tls_verify", value=insecure_skip_tls_verify, expected_type=type_hints["insecure_skip_tls_verify"])
            check_type(argname="argument key_material", value=key_material, expected_type=type_hints["key_material"])
            check_type(argname="argument object_name", value=object_name, expected_type=type_hints["object_name"])
            check_type(argname="argument url", value=url, expected_type=type_hints["url"])
            check_type(argname="argument user", value=user, expected_type=type_hints["user"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "account": account,
            "key_id": key_id,
            "path": path,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if insecure_skip_tls_verify is not None:
            self._values["insecure_skip_tls_verify"] = insecure_skip_tls_verify
        if key_material is not None:
            self._values["key_material"] = key_material
        if object_name is not None:
            self._values["object_name"] = object_name
        if url is not None:
            self._values["url"] = url
        if user is not None:
            self._values["user"] = user

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def account(self) -> builtins.str:
        '''
        :stability: deprecated
        '''
        result = self._values.get("account")
        assert result is not None, "Required property 'account' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def key_id(self) -> builtins.str:
        '''
        :stability: deprecated
        '''
        result = self._values.get("key_id")
        assert result is not None, "Required property 'key_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def path(self) -> builtins.str:
        '''
        :stability: deprecated
        '''
        result = self._values.get("path")
        assert result is not None, "Required property 'path' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def insecure_skip_tls_verify(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("insecure_skip_tls_verify")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def key_material(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("key_material")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def object_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("object_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def url(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("user")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateMantaConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DataTerraformRemoteStateOss(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateOss",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        bucket: builtins.str,
        access_key: typing.Optional[builtins.str] = None,
        acl: typing.Optional[builtins.str] = None,
        assume_role: typing.Optional[typing.Union[OssAssumeRole, typing.Dict[builtins.str, typing.Any]]] = None,
        ecs_role_name: typing.Optional[builtins.str] = None,
        encrypt: typing.Optional[builtins.bool] = None,
        endpoint: typing.Optional[builtins.str] = None,
        key: typing.Optional[builtins.str] = None,
        prefix: typing.Optional[builtins.str] = None,
        profile: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        secret_key: typing.Optional[builtins.str] = None,
        security_token: typing.Optional[builtins.str] = None,
        shared_credentials_file: typing.Optional[builtins.str] = None,
        tablestore_endpoint: typing.Optional[builtins.str] = None,
        tablestore_table: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param bucket: 
        :param access_key: 
        :param acl: 
        :param assume_role: 
        :param ecs_role_name: 
        :param encrypt: 
        :param endpoint: 
        :param key: 
        :param prefix: 
        :param profile: 
        :param region: 
        :param secret_key: 
        :param security_token: 
        :param shared_credentials_file: 
        :param tablestore_endpoint: 
        :param tablestore_table: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d32c9e57e0e1add20388f143b55138e72e332bb4f8ad501ff84ccdb90e0226b4)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateOssConfig(
            defaults=defaults,
            workspace=workspace,
            bucket=bucket,
            access_key=access_key,
            acl=acl,
            assume_role=assume_role,
            ecs_role_name=ecs_role_name,
            encrypt=encrypt,
            endpoint=endpoint,
            key=key,
            prefix=prefix,
            profile=profile,
            region=region,
            secret_key=secret_key,
            security_token=security_token,
            shared_credentials_file=shared_credentials_file,
            tablestore_endpoint=tablestore_endpoint,
            tablestore_table=tablestore_table,
        )

        jsii.create(self.__class__, self, [scope, id, config])


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateOssConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, OssBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "bucket": "bucket",
        "access_key": "accessKey",
        "acl": "acl",
        "assume_role": "assumeRole",
        "ecs_role_name": "ecsRoleName",
        "encrypt": "encrypt",
        "endpoint": "endpoint",
        "key": "key",
        "prefix": "prefix",
        "profile": "profile",
        "region": "region",
        "secret_key": "secretKey",
        "security_token": "securityToken",
        "shared_credentials_file": "sharedCredentialsFile",
        "tablestore_endpoint": "tablestoreEndpoint",
        "tablestore_table": "tablestoreTable",
    },
)
class DataTerraformRemoteStateOssConfig(
    DataTerraformRemoteStateConfig,
    OssBackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        bucket: builtins.str,
        access_key: typing.Optional[builtins.str] = None,
        acl: typing.Optional[builtins.str] = None,
        assume_role: typing.Optional[typing.Union[OssAssumeRole, typing.Dict[builtins.str, typing.Any]]] = None,
        ecs_role_name: typing.Optional[builtins.str] = None,
        encrypt: typing.Optional[builtins.bool] = None,
        endpoint: typing.Optional[builtins.str] = None,
        key: typing.Optional[builtins.str] = None,
        prefix: typing.Optional[builtins.str] = None,
        profile: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        secret_key: typing.Optional[builtins.str] = None,
        security_token: typing.Optional[builtins.str] = None,
        shared_credentials_file: typing.Optional[builtins.str] = None,
        tablestore_endpoint: typing.Optional[builtins.str] = None,
        tablestore_table: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param bucket: 
        :param access_key: 
        :param acl: 
        :param assume_role: 
        :param ecs_role_name: 
        :param encrypt: 
        :param endpoint: 
        :param key: 
        :param prefix: 
        :param profile: 
        :param region: 
        :param secret_key: 
        :param security_token: 
        :param shared_credentials_file: 
        :param tablestore_endpoint: 
        :param tablestore_table: 

        :stability: experimental
        '''
        if isinstance(assume_role, dict):
            assume_role = OssAssumeRole(**assume_role)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cd05c08106f13cd249737a39af4a2a5bf6e7579e853ddce11b1c33b5f402e74d)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument bucket", value=bucket, expected_type=type_hints["bucket"])
            check_type(argname="argument access_key", value=access_key, expected_type=type_hints["access_key"])
            check_type(argname="argument acl", value=acl, expected_type=type_hints["acl"])
            check_type(argname="argument assume_role", value=assume_role, expected_type=type_hints["assume_role"])
            check_type(argname="argument ecs_role_name", value=ecs_role_name, expected_type=type_hints["ecs_role_name"])
            check_type(argname="argument encrypt", value=encrypt, expected_type=type_hints["encrypt"])
            check_type(argname="argument endpoint", value=endpoint, expected_type=type_hints["endpoint"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument prefix", value=prefix, expected_type=type_hints["prefix"])
            check_type(argname="argument profile", value=profile, expected_type=type_hints["profile"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument secret_key", value=secret_key, expected_type=type_hints["secret_key"])
            check_type(argname="argument security_token", value=security_token, expected_type=type_hints["security_token"])
            check_type(argname="argument shared_credentials_file", value=shared_credentials_file, expected_type=type_hints["shared_credentials_file"])
            check_type(argname="argument tablestore_endpoint", value=tablestore_endpoint, expected_type=type_hints["tablestore_endpoint"])
            check_type(argname="argument tablestore_table", value=tablestore_table, expected_type=type_hints["tablestore_table"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "bucket": bucket,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if access_key is not None:
            self._values["access_key"] = access_key
        if acl is not None:
            self._values["acl"] = acl
        if assume_role is not None:
            self._values["assume_role"] = assume_role
        if ecs_role_name is not None:
            self._values["ecs_role_name"] = ecs_role_name
        if encrypt is not None:
            self._values["encrypt"] = encrypt
        if endpoint is not None:
            self._values["endpoint"] = endpoint
        if key is not None:
            self._values["key"] = key
        if prefix is not None:
            self._values["prefix"] = prefix
        if profile is not None:
            self._values["profile"] = profile
        if region is not None:
            self._values["region"] = region
        if secret_key is not None:
            self._values["secret_key"] = secret_key
        if security_token is not None:
            self._values["security_token"] = security_token
        if shared_credentials_file is not None:
            self._values["shared_credentials_file"] = shared_credentials_file
        if tablestore_endpoint is not None:
            self._values["tablestore_endpoint"] = tablestore_endpoint
        if tablestore_table is not None:
            self._values["tablestore_table"] = tablestore_table

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def bucket(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("bucket")
        assert result is not None, "Required property 'bucket' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def access_key(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("access_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def acl(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("acl")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def assume_role(self) -> typing.Optional[OssAssumeRole]:
        '''
        :stability: experimental
        '''
        result = self._values.get("assume_role")
        return typing.cast(typing.Optional[OssAssumeRole], result)

    @builtins.property
    def ecs_role_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("ecs_role_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def encrypt(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("encrypt")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def endpoint(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def prefix(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def profile(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("profile")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_key(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("secret_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def security_token(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("security_token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def shared_credentials_file(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("shared_credentials_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tablestore_endpoint(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("tablestore_endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tablestore_table(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("tablestore_table")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateOssConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DataTerraformRemoteStatePg(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStatePg",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        conn_str: builtins.str,
        schema_name: typing.Optional[builtins.str] = None,
        skip_schema_creation: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param conn_str: 
        :param schema_name: 
        :param skip_schema_creation: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__94b09e7003f7c6430d195f1d60942436a3bb706d99718594058666e3df20d3cf)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStatePgConfig(
            defaults=defaults,
            workspace=workspace,
            conn_str=conn_str,
            schema_name=schema_name,
            skip_schema_creation=skip_schema_creation,
        )

        jsii.create(self.__class__, self, [scope, id, config])


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStatePgConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, PgBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "conn_str": "connStr",
        "schema_name": "schemaName",
        "skip_schema_creation": "skipSchemaCreation",
    },
)
class DataTerraformRemoteStatePgConfig(DataTerraformRemoteStateConfig, PgBackendConfig):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        conn_str: builtins.str,
        schema_name: typing.Optional[builtins.str] = None,
        skip_schema_creation: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param conn_str: 
        :param schema_name: 
        :param skip_schema_creation: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__76599e398e09c781d0b1c797d29a5b5717339eba684e729fb434a7a182ad227a)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument conn_str", value=conn_str, expected_type=type_hints["conn_str"])
            check_type(argname="argument schema_name", value=schema_name, expected_type=type_hints["schema_name"])
            check_type(argname="argument skip_schema_creation", value=skip_schema_creation, expected_type=type_hints["skip_schema_creation"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "conn_str": conn_str,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if schema_name is not None:
            self._values["schema_name"] = schema_name
        if skip_schema_creation is not None:
            self._values["skip_schema_creation"] = skip_schema_creation

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def conn_str(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("conn_str")
        assert result is not None, "Required property 'conn_str' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def schema_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("schema_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def skip_schema_creation(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("skip_schema_creation")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStatePgConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateRemoteConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, RemoteBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "organization": "organization",
        "workspaces": "workspaces",
        "hostname": "hostname",
        "token": "token",
    },
)
class DataTerraformRemoteStateRemoteConfig(
    DataTerraformRemoteStateConfig,
    RemoteBackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        organization: builtins.str,
        workspaces: IRemoteWorkspace,
        hostname: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param organization: 
        :param workspaces: 
        :param hostname: 
        :param token: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fe83691cd46de19aca4f9482c121dcc3a03816f2430abd15c8bd83555e259076)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument organization", value=organization, expected_type=type_hints["organization"])
            check_type(argname="argument workspaces", value=workspaces, expected_type=type_hints["workspaces"])
            check_type(argname="argument hostname", value=hostname, expected_type=type_hints["hostname"])
            check_type(argname="argument token", value=token, expected_type=type_hints["token"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "organization": organization,
            "workspaces": workspaces,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if hostname is not None:
            self._values["hostname"] = hostname
        if token is not None:
            self._values["token"] = token

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def organization(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("organization")
        assert result is not None, "Required property 'organization' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def workspaces(self) -> IRemoteWorkspace:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspaces")
        assert result is not None, "Required property 'workspaces' is missing"
        return typing.cast(IRemoteWorkspace, result)

    @builtins.property
    def hostname(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("hostname")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def token(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("token")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateRemoteConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DataTerraformRemoteStateS3(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateS3",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        bucket: builtins.str,
        key: builtins.str,
        access_key: typing.Optional[builtins.str] = None,
        acl: typing.Optional[builtins.str] = None,
        assume_role_policy: typing.Optional[builtins.str] = None,
        assume_role_policy_arns: typing.Optional[typing.Sequence[builtins.str]] = None,
        assume_role_tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        assume_role_transitive_tag_keys: typing.Optional[typing.Sequence[builtins.str]] = None,
        dynamodb_endpoint: typing.Optional[builtins.str] = None,
        dynamodb_table: typing.Optional[builtins.str] = None,
        encrypt: typing.Optional[builtins.bool] = None,
        endpoint: typing.Optional[builtins.str] = None,
        external_id: typing.Optional[builtins.str] = None,
        force_path_style: typing.Optional[builtins.bool] = None,
        iam_endpoint: typing.Optional[builtins.str] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        max_retries: typing.Optional[jsii.Number] = None,
        profile: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        role_arn: typing.Optional[builtins.str] = None,
        secret_key: typing.Optional[builtins.str] = None,
        session_name: typing.Optional[builtins.str] = None,
        shared_credentials_file: typing.Optional[builtins.str] = None,
        skip_credentials_validation: typing.Optional[builtins.bool] = None,
        skip_metadata_api_check: typing.Optional[builtins.bool] = None,
        skip_region_validation: typing.Optional[builtins.bool] = None,
        sse_customer_key: typing.Optional[builtins.str] = None,
        sts_endpoint: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
        workspace_key_prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param bucket: (experimental) Name of the S3 Bucket.
        :param key: (experimental) Path to the state file inside the S3 Bucket. When using a non-default workspace, the state path will be /workspace_key_prefix/workspace_name/key
        :param access_key: (experimental) (Optional) AWS access key. If configured, must also configure secret_key. This can also be sourced from the AWS_ACCESS_KEY_ID environment variable, AWS shared credentials file (e.g. ~/.aws/credentials), or AWS shared configuration file (e.g. ~/.aws/config).
        :param acl: (experimental) (Optional) Canned ACL to be applied to the state file.
        :param assume_role_policy: (experimental) (Optional) IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        :param assume_role_policy_arns: (experimental) (Optional) Set of Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
        :param assume_role_tags: (experimental) (Optional) Map of assume role session tags.
        :param assume_role_transitive_tag_keys: (experimental) (Optional) Set of assume role session tag keys to pass to any subsequent sessions.
        :param dynamodb_endpoint: (experimental) (Optional) Custom endpoint for the AWS DynamoDB API. This can also be sourced from the AWS_DYNAMODB_ENDPOINT environment variable.
        :param dynamodb_table: (experimental) (Optional) Name of DynamoDB Table to use for state locking and consistency. The table must have a partition key named LockID with type of String. If not configured, state locking will be disabled.
        :param encrypt: (experimental) (Optional) Enable server side encryption of the state file.
        :param endpoint: (experimental) (Optional) Custom endpoint for the AWS S3 API. This can also be sourced from the AWS_S3_ENDPOINT environment variable.
        :param external_id: (experimental) (Optional) External identifier to use when assuming the role.
        :param force_path_style: (experimental) (Optional) Enable path-style S3 URLs (https:/// instead of https://.).
        :param iam_endpoint: (experimental) (Optional) Custom endpoint for the AWS Identity and Access Management (IAM) API. This can also be sourced from the AWS_IAM_ENDPOINT environment variable.
        :param kms_key_id: (experimental) (Optional) Amazon Resource Name (ARN) of a Key Management Service (KMS) Key to use for encrypting the state. Note that if this value is specified, Terraform will need kms:Encrypt, kms:Decrypt and kms:GenerateDataKey permissions on this KMS key.
        :param max_retries: (experimental) (Optional) The maximum number of times an AWS API request is retried on retryable failure. Defaults to 5.
        :param profile: (experimental) (Optional) Name of AWS profile in AWS shared credentials file (e.g. ~/.aws/credentials) or AWS shared configuration file (e.g. ~/.aws/config) to use for credentials and/or configuration. This can also be sourced from the AWS_PROFILE environment variable.
        :param region: (experimental) AWS Region of the S3 Bucket and DynamoDB Table (if used). This can also be sourced from the AWS_DEFAULT_REGION and AWS_REGION environment variables.
        :param role_arn: (experimental) (Optional) Amazon Resource Name (ARN) of the IAM Role to assume.
        :param secret_key: (experimental) (Optional) AWS secret access key. If configured, must also configure access_key. This can also be sourced from the AWS_SECRET_ACCESS_KEY environment variable, AWS shared credentials file (e.g. ~/.aws/credentials), or AWS shared configuration file (e.g. ~/.aws/config)
        :param session_name: (experimental) (Optional) Session name to use when assuming the role.
        :param shared_credentials_file: (experimental) (Optional) Path to the AWS shared credentials file. Defaults to ~/.aws/credentials.
        :param skip_credentials_validation: (experimental) (Optional) Skip credentials validation via the STS API.
        :param skip_metadata_api_check: (experimental) (Optional) Skip usage of EC2 Metadata API.
        :param skip_region_validation: (experimental) (Optional) Skip validation of provided region name.
        :param sse_customer_key: (experimental) (Optional) The key to use for encrypting state with Server-Side Encryption with Customer-Provided Keys (SSE-C). This is the base64-encoded value of the key, which must decode to 256 bits. This can also be sourced from the AWS_SSE_CUSTOMER_KEY environment variable, which is recommended due to the sensitivity of the value. Setting it inside a terraform file will cause it to be persisted to disk in terraform.tfstate.
        :param sts_endpoint: (experimental) (Optional) Custom endpoint for the AWS Security Token Service (STS) API. This can also be sourced from the AWS_STS_ENDPOINT environment variable.
        :param token: (experimental) (Optional) Multi-Factor Authentication (MFA) token. This can also be sourced from the AWS_SESSION_TOKEN environment variable.
        :param workspace_key_prefix: (experimental) (Optional) Prefix applied to the state path inside the bucket. This is only relevant when using a non-default workspace. Defaults to env:

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f5b15e133ba75102830900116fce5e5cc442f06dab3314ebb2a8920b13126f29)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateS3Config(
            defaults=defaults,
            workspace=workspace,
            bucket=bucket,
            key=key,
            access_key=access_key,
            acl=acl,
            assume_role_policy=assume_role_policy,
            assume_role_policy_arns=assume_role_policy_arns,
            assume_role_tags=assume_role_tags,
            assume_role_transitive_tag_keys=assume_role_transitive_tag_keys,
            dynamodb_endpoint=dynamodb_endpoint,
            dynamodb_table=dynamodb_table,
            encrypt=encrypt,
            endpoint=endpoint,
            external_id=external_id,
            force_path_style=force_path_style,
            iam_endpoint=iam_endpoint,
            kms_key_id=kms_key_id,
            max_retries=max_retries,
            profile=profile,
            region=region,
            role_arn=role_arn,
            secret_key=secret_key,
            session_name=session_name,
            shared_credentials_file=shared_credentials_file,
            skip_credentials_validation=skip_credentials_validation,
            skip_metadata_api_check=skip_metadata_api_check,
            skip_region_validation=skip_region_validation,
            sse_customer_key=sse_customer_key,
            sts_endpoint=sts_endpoint,
            token=token,
            workspace_key_prefix=workspace_key_prefix,
        )

        jsii.create(self.__class__, self, [scope, id, config])


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateS3Config",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, S3BackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "bucket": "bucket",
        "key": "key",
        "access_key": "accessKey",
        "acl": "acl",
        "assume_role_policy": "assumeRolePolicy",
        "assume_role_policy_arns": "assumeRolePolicyArns",
        "assume_role_tags": "assumeRoleTags",
        "assume_role_transitive_tag_keys": "assumeRoleTransitiveTagKeys",
        "dynamodb_endpoint": "dynamodbEndpoint",
        "dynamodb_table": "dynamodbTable",
        "encrypt": "encrypt",
        "endpoint": "endpoint",
        "external_id": "externalId",
        "force_path_style": "forcePathStyle",
        "iam_endpoint": "iamEndpoint",
        "kms_key_id": "kmsKeyId",
        "max_retries": "maxRetries",
        "profile": "profile",
        "region": "region",
        "role_arn": "roleArn",
        "secret_key": "secretKey",
        "session_name": "sessionName",
        "shared_credentials_file": "sharedCredentialsFile",
        "skip_credentials_validation": "skipCredentialsValidation",
        "skip_metadata_api_check": "skipMetadataApiCheck",
        "skip_region_validation": "skipRegionValidation",
        "sse_customer_key": "sseCustomerKey",
        "sts_endpoint": "stsEndpoint",
        "token": "token",
        "workspace_key_prefix": "workspaceKeyPrefix",
    },
)
class DataTerraformRemoteStateS3Config(DataTerraformRemoteStateConfig, S3BackendConfig):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        bucket: builtins.str,
        key: builtins.str,
        access_key: typing.Optional[builtins.str] = None,
        acl: typing.Optional[builtins.str] = None,
        assume_role_policy: typing.Optional[builtins.str] = None,
        assume_role_policy_arns: typing.Optional[typing.Sequence[builtins.str]] = None,
        assume_role_tags: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        assume_role_transitive_tag_keys: typing.Optional[typing.Sequence[builtins.str]] = None,
        dynamodb_endpoint: typing.Optional[builtins.str] = None,
        dynamodb_table: typing.Optional[builtins.str] = None,
        encrypt: typing.Optional[builtins.bool] = None,
        endpoint: typing.Optional[builtins.str] = None,
        external_id: typing.Optional[builtins.str] = None,
        force_path_style: typing.Optional[builtins.bool] = None,
        iam_endpoint: typing.Optional[builtins.str] = None,
        kms_key_id: typing.Optional[builtins.str] = None,
        max_retries: typing.Optional[jsii.Number] = None,
        profile: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        role_arn: typing.Optional[builtins.str] = None,
        secret_key: typing.Optional[builtins.str] = None,
        session_name: typing.Optional[builtins.str] = None,
        shared_credentials_file: typing.Optional[builtins.str] = None,
        skip_credentials_validation: typing.Optional[builtins.bool] = None,
        skip_metadata_api_check: typing.Optional[builtins.bool] = None,
        skip_region_validation: typing.Optional[builtins.bool] = None,
        sse_customer_key: typing.Optional[builtins.str] = None,
        sts_endpoint: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
        workspace_key_prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param bucket: (experimental) Name of the S3 Bucket.
        :param key: (experimental) Path to the state file inside the S3 Bucket. When using a non-default workspace, the state path will be /workspace_key_prefix/workspace_name/key
        :param access_key: (experimental) (Optional) AWS access key. If configured, must also configure secret_key. This can also be sourced from the AWS_ACCESS_KEY_ID environment variable, AWS shared credentials file (e.g. ~/.aws/credentials), or AWS shared configuration file (e.g. ~/.aws/config).
        :param acl: (experimental) (Optional) Canned ACL to be applied to the state file.
        :param assume_role_policy: (experimental) (Optional) IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        :param assume_role_policy_arns: (experimental) (Optional) Set of Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
        :param assume_role_tags: (experimental) (Optional) Map of assume role session tags.
        :param assume_role_transitive_tag_keys: (experimental) (Optional) Set of assume role session tag keys to pass to any subsequent sessions.
        :param dynamodb_endpoint: (experimental) (Optional) Custom endpoint for the AWS DynamoDB API. This can also be sourced from the AWS_DYNAMODB_ENDPOINT environment variable.
        :param dynamodb_table: (experimental) (Optional) Name of DynamoDB Table to use for state locking and consistency. The table must have a partition key named LockID with type of String. If not configured, state locking will be disabled.
        :param encrypt: (experimental) (Optional) Enable server side encryption of the state file.
        :param endpoint: (experimental) (Optional) Custom endpoint for the AWS S3 API. This can also be sourced from the AWS_S3_ENDPOINT environment variable.
        :param external_id: (experimental) (Optional) External identifier to use when assuming the role.
        :param force_path_style: (experimental) (Optional) Enable path-style S3 URLs (https:/// instead of https://.).
        :param iam_endpoint: (experimental) (Optional) Custom endpoint for the AWS Identity and Access Management (IAM) API. This can also be sourced from the AWS_IAM_ENDPOINT environment variable.
        :param kms_key_id: (experimental) (Optional) Amazon Resource Name (ARN) of a Key Management Service (KMS) Key to use for encrypting the state. Note that if this value is specified, Terraform will need kms:Encrypt, kms:Decrypt and kms:GenerateDataKey permissions on this KMS key.
        :param max_retries: (experimental) (Optional) The maximum number of times an AWS API request is retried on retryable failure. Defaults to 5.
        :param profile: (experimental) (Optional) Name of AWS profile in AWS shared credentials file (e.g. ~/.aws/credentials) or AWS shared configuration file (e.g. ~/.aws/config) to use for credentials and/or configuration. This can also be sourced from the AWS_PROFILE environment variable.
        :param region: (experimental) AWS Region of the S3 Bucket and DynamoDB Table (if used). This can also be sourced from the AWS_DEFAULT_REGION and AWS_REGION environment variables.
        :param role_arn: (experimental) (Optional) Amazon Resource Name (ARN) of the IAM Role to assume.
        :param secret_key: (experimental) (Optional) AWS secret access key. If configured, must also configure access_key. This can also be sourced from the AWS_SECRET_ACCESS_KEY environment variable, AWS shared credentials file (e.g. ~/.aws/credentials), or AWS shared configuration file (e.g. ~/.aws/config)
        :param session_name: (experimental) (Optional) Session name to use when assuming the role.
        :param shared_credentials_file: (experimental) (Optional) Path to the AWS shared credentials file. Defaults to ~/.aws/credentials.
        :param skip_credentials_validation: (experimental) (Optional) Skip credentials validation via the STS API.
        :param skip_metadata_api_check: (experimental) (Optional) Skip usage of EC2 Metadata API.
        :param skip_region_validation: (experimental) (Optional) Skip validation of provided region name.
        :param sse_customer_key: (experimental) (Optional) The key to use for encrypting state with Server-Side Encryption with Customer-Provided Keys (SSE-C). This is the base64-encoded value of the key, which must decode to 256 bits. This can also be sourced from the AWS_SSE_CUSTOMER_KEY environment variable, which is recommended due to the sensitivity of the value. Setting it inside a terraform file will cause it to be persisted to disk in terraform.tfstate.
        :param sts_endpoint: (experimental) (Optional) Custom endpoint for the AWS Security Token Service (STS) API. This can also be sourced from the AWS_STS_ENDPOINT environment variable.
        :param token: (experimental) (Optional) Multi-Factor Authentication (MFA) token. This can also be sourced from the AWS_SESSION_TOKEN environment variable.
        :param workspace_key_prefix: (experimental) (Optional) Prefix applied to the state path inside the bucket. This is only relevant when using a non-default workspace. Defaults to env:

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__900b13dc456293803e03bdf26171a594a9e85d09280eed9d395057d8f03a994f)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument bucket", value=bucket, expected_type=type_hints["bucket"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument access_key", value=access_key, expected_type=type_hints["access_key"])
            check_type(argname="argument acl", value=acl, expected_type=type_hints["acl"])
            check_type(argname="argument assume_role_policy", value=assume_role_policy, expected_type=type_hints["assume_role_policy"])
            check_type(argname="argument assume_role_policy_arns", value=assume_role_policy_arns, expected_type=type_hints["assume_role_policy_arns"])
            check_type(argname="argument assume_role_tags", value=assume_role_tags, expected_type=type_hints["assume_role_tags"])
            check_type(argname="argument assume_role_transitive_tag_keys", value=assume_role_transitive_tag_keys, expected_type=type_hints["assume_role_transitive_tag_keys"])
            check_type(argname="argument dynamodb_endpoint", value=dynamodb_endpoint, expected_type=type_hints["dynamodb_endpoint"])
            check_type(argname="argument dynamodb_table", value=dynamodb_table, expected_type=type_hints["dynamodb_table"])
            check_type(argname="argument encrypt", value=encrypt, expected_type=type_hints["encrypt"])
            check_type(argname="argument endpoint", value=endpoint, expected_type=type_hints["endpoint"])
            check_type(argname="argument external_id", value=external_id, expected_type=type_hints["external_id"])
            check_type(argname="argument force_path_style", value=force_path_style, expected_type=type_hints["force_path_style"])
            check_type(argname="argument iam_endpoint", value=iam_endpoint, expected_type=type_hints["iam_endpoint"])
            check_type(argname="argument kms_key_id", value=kms_key_id, expected_type=type_hints["kms_key_id"])
            check_type(argname="argument max_retries", value=max_retries, expected_type=type_hints["max_retries"])
            check_type(argname="argument profile", value=profile, expected_type=type_hints["profile"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument role_arn", value=role_arn, expected_type=type_hints["role_arn"])
            check_type(argname="argument secret_key", value=secret_key, expected_type=type_hints["secret_key"])
            check_type(argname="argument session_name", value=session_name, expected_type=type_hints["session_name"])
            check_type(argname="argument shared_credentials_file", value=shared_credentials_file, expected_type=type_hints["shared_credentials_file"])
            check_type(argname="argument skip_credentials_validation", value=skip_credentials_validation, expected_type=type_hints["skip_credentials_validation"])
            check_type(argname="argument skip_metadata_api_check", value=skip_metadata_api_check, expected_type=type_hints["skip_metadata_api_check"])
            check_type(argname="argument skip_region_validation", value=skip_region_validation, expected_type=type_hints["skip_region_validation"])
            check_type(argname="argument sse_customer_key", value=sse_customer_key, expected_type=type_hints["sse_customer_key"])
            check_type(argname="argument sts_endpoint", value=sts_endpoint, expected_type=type_hints["sts_endpoint"])
            check_type(argname="argument token", value=token, expected_type=type_hints["token"])
            check_type(argname="argument workspace_key_prefix", value=workspace_key_prefix, expected_type=type_hints["workspace_key_prefix"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "bucket": bucket,
            "key": key,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if access_key is not None:
            self._values["access_key"] = access_key
        if acl is not None:
            self._values["acl"] = acl
        if assume_role_policy is not None:
            self._values["assume_role_policy"] = assume_role_policy
        if assume_role_policy_arns is not None:
            self._values["assume_role_policy_arns"] = assume_role_policy_arns
        if assume_role_tags is not None:
            self._values["assume_role_tags"] = assume_role_tags
        if assume_role_transitive_tag_keys is not None:
            self._values["assume_role_transitive_tag_keys"] = assume_role_transitive_tag_keys
        if dynamodb_endpoint is not None:
            self._values["dynamodb_endpoint"] = dynamodb_endpoint
        if dynamodb_table is not None:
            self._values["dynamodb_table"] = dynamodb_table
        if encrypt is not None:
            self._values["encrypt"] = encrypt
        if endpoint is not None:
            self._values["endpoint"] = endpoint
        if external_id is not None:
            self._values["external_id"] = external_id
        if force_path_style is not None:
            self._values["force_path_style"] = force_path_style
        if iam_endpoint is not None:
            self._values["iam_endpoint"] = iam_endpoint
        if kms_key_id is not None:
            self._values["kms_key_id"] = kms_key_id
        if max_retries is not None:
            self._values["max_retries"] = max_retries
        if profile is not None:
            self._values["profile"] = profile
        if region is not None:
            self._values["region"] = region
        if role_arn is not None:
            self._values["role_arn"] = role_arn
        if secret_key is not None:
            self._values["secret_key"] = secret_key
        if session_name is not None:
            self._values["session_name"] = session_name
        if shared_credentials_file is not None:
            self._values["shared_credentials_file"] = shared_credentials_file
        if skip_credentials_validation is not None:
            self._values["skip_credentials_validation"] = skip_credentials_validation
        if skip_metadata_api_check is not None:
            self._values["skip_metadata_api_check"] = skip_metadata_api_check
        if skip_region_validation is not None:
            self._values["skip_region_validation"] = skip_region_validation
        if sse_customer_key is not None:
            self._values["sse_customer_key"] = sse_customer_key
        if sts_endpoint is not None:
            self._values["sts_endpoint"] = sts_endpoint
        if token is not None:
            self._values["token"] = token
        if workspace_key_prefix is not None:
            self._values["workspace_key_prefix"] = workspace_key_prefix

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def bucket(self) -> builtins.str:
        '''(experimental) Name of the S3 Bucket.

        :stability: experimental
        '''
        result = self._values.get("bucket")
        assert result is not None, "Required property 'bucket' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def key(self) -> builtins.str:
        '''(experimental) Path to the state file inside the S3 Bucket.

        When using a non-default workspace, the state path will be /workspace_key_prefix/workspace_name/key

        :stability: experimental
        '''
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def access_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) AWS access key.

        If configured, must also configure secret_key.
        This can also be sourced from
        the AWS_ACCESS_KEY_ID environment variable,
        AWS shared credentials file (e.g. ~/.aws/credentials),
        or AWS shared configuration file (e.g. ~/.aws/config).

        :stability: experimental
        '''
        result = self._values.get("access_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def acl(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Canned ACL to be applied to the state file.

        :stability: experimental
        '''
        result = self._values.get("acl")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def assume_role_policy(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.

        :stability: experimental
        '''
        result = self._values.get("assume_role_policy")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def assume_role_policy_arns(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) (Optional) Set of Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.

        :stability: experimental
        '''
        result = self._values.get("assume_role_policy_arns")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def assume_role_tags(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, builtins.str]]:
        '''(experimental) (Optional) Map of assume role session tags.

        :stability: experimental
        '''
        result = self._values.get("assume_role_tags")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, builtins.str]], result)

    @builtins.property
    def assume_role_transitive_tag_keys(
        self,
    ) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) (Optional) Set of assume role session tag keys to pass to any subsequent sessions.

        :stability: experimental
        '''
        result = self._values.get("assume_role_transitive_tag_keys")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def dynamodb_endpoint(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Custom endpoint for the AWS DynamoDB API.

        This can also be sourced from the AWS_DYNAMODB_ENDPOINT environment variable.

        :stability: experimental
        '''
        result = self._values.get("dynamodb_endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def dynamodb_table(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Name of DynamoDB Table to use for state locking and consistency.

        The table must have a partition key named LockID with type of String.
        If not configured, state locking will be disabled.

        :stability: experimental
        '''
        result = self._values.get("dynamodb_table")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def encrypt(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Enable server side encryption of the state file.

        :stability: experimental
        '''
        result = self._values.get("encrypt")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def endpoint(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Custom endpoint for the AWS S3 API.

        This can also be sourced from the AWS_S3_ENDPOINT environment variable.

        :stability: experimental
        '''
        result = self._values.get("endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def external_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) External identifier to use when assuming the role.

        :stability: experimental
        '''
        result = self._values.get("external_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def force_path_style(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Enable path-style S3 URLs (https:/// instead of https://.).

        :stability: experimental
        '''
        result = self._values.get("force_path_style")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def iam_endpoint(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Custom endpoint for the AWS Identity and Access Management (IAM) API.

        This can also be sourced from the AWS_IAM_ENDPOINT environment variable.

        :stability: experimental
        '''
        result = self._values.get("iam_endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def kms_key_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Amazon Resource Name (ARN) of a Key Management Service (KMS) Key to use for encrypting the state.

        Note that if this value is specified,
        Terraform will need kms:Encrypt, kms:Decrypt and kms:GenerateDataKey permissions on this KMS key.

        :stability: experimental
        '''
        result = self._values.get("kms_key_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def max_retries(self) -> typing.Optional[jsii.Number]:
        '''(experimental) (Optional) The maximum number of times an AWS API request is retried on retryable failure.

        Defaults to 5.

        :stability: experimental
        '''
        result = self._values.get("max_retries")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def profile(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Name of AWS profile in AWS shared credentials file (e.g. ~/.aws/credentials) or AWS shared configuration file (e.g. ~/.aws/config) to use for credentials and/or configuration. This can also be sourced from the AWS_PROFILE environment variable.

        :stability: experimental
        '''
        result = self._values.get("profile")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''(experimental) AWS Region of the S3 Bucket and DynamoDB Table (if used).

        This can also
        be sourced from the AWS_DEFAULT_REGION and AWS_REGION environment
        variables.

        :stability: experimental
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def role_arn(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Amazon Resource Name (ARN) of the IAM Role to assume.

        :stability: experimental
        '''
        result = self._values.get("role_arn")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def secret_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) AWS secret access key.

        If configured, must also configure access_key.
        This can also be sourced from
        the AWS_SECRET_ACCESS_KEY environment variable,
        AWS shared credentials file (e.g. ~/.aws/credentials),
        or AWS shared configuration file (e.g. ~/.aws/config)

        :stability: experimental
        '''
        result = self._values.get("secret_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def session_name(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Session name to use when assuming the role.

        :stability: experimental
        '''
        result = self._values.get("session_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def shared_credentials_file(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Path to the AWS shared credentials file.

        Defaults to ~/.aws/credentials.

        :stability: experimental
        '''
        result = self._values.get("shared_credentials_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def skip_credentials_validation(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Skip credentials validation via the STS API.

        :stability: experimental
        '''
        result = self._values.get("skip_credentials_validation")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def skip_metadata_api_check(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Skip usage of EC2 Metadata API.

        :stability: experimental
        '''
        result = self._values.get("skip_metadata_api_check")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def skip_region_validation(self) -> typing.Optional[builtins.bool]:
        '''(experimental) (Optional) Skip validation of provided region name.

        :stability: experimental
        '''
        result = self._values.get("skip_region_validation")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def sse_customer_key(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) The key to use for encrypting state with Server-Side Encryption with Customer-Provided Keys (SSE-C).

        This is the base64-encoded value of the key, which must decode to 256 bits.
        This can also be sourced from the AWS_SSE_CUSTOMER_KEY environment variable,
        which is recommended due to the sensitivity of the value.
        Setting it inside a terraform file will cause it to be persisted to disk in terraform.tfstate.

        :stability: experimental
        '''
        result = self._values.get("sse_customer_key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def sts_endpoint(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Custom endpoint for the AWS Security Token Service (STS) API.

        This can also be sourced from the AWS_STS_ENDPOINT environment variable.

        :stability: experimental
        '''
        result = self._values.get("sts_endpoint")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def token(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Multi-Factor Authentication (MFA) token.

        This can also be sourced from the AWS_SESSION_TOKEN environment variable.

        :stability: experimental
        '''
        result = self._values.get("token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def workspace_key_prefix(self) -> typing.Optional[builtins.str]:
        '''(experimental) (Optional) Prefix applied to the state path inside the bucket.

        This is only relevant when using a non-default workspace. Defaults to env:

        :stability: experimental
        '''
        result = self._values.get("workspace_key_prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateS3Config(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DataTerraformRemoteStateSwift(
    TerraformRemoteState,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DataTerraformRemoteStateSwift",
):
    '''
    :deprecated: CDK for Terraform no longer supports the swift backend. Terraform deprecated swift in v1.2.3 and removed it in v1.3.

    :stability: deprecated
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        container: builtins.str,
        application_credential_id: typing.Optional[builtins.str] = None,
        application_credential_name: typing.Optional[builtins.str] = None,
        application_credential_secret: typing.Optional[builtins.str] = None,
        archive_container: typing.Optional[builtins.str] = None,
        auth_url: typing.Optional[builtins.str] = None,
        cacert_file: typing.Optional[builtins.str] = None,
        cert: typing.Optional[builtins.str] = None,
        cloud: typing.Optional[builtins.str] = None,
        default_domain: typing.Optional[builtins.str] = None,
        domain_id: typing.Optional[builtins.str] = None,
        domain_name: typing.Optional[builtins.str] = None,
        expire_after: typing.Optional[builtins.str] = None,
        insecure: typing.Optional[builtins.bool] = None,
        key: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        project_domain_id: typing.Optional[builtins.str] = None,
        project_domain_name: typing.Optional[builtins.str] = None,
        region_name: typing.Optional[builtins.str] = None,
        state_name: typing.Optional[builtins.str] = None,
        tenant_id: typing.Optional[builtins.str] = None,
        tenant_name: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
        user_domain_id: typing.Optional[builtins.str] = None,
        user_domain_name: typing.Optional[builtins.str] = None,
        user_id: typing.Optional[builtins.str] = None,
        user_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param defaults: 
        :param workspace: 
        :param container: 
        :param application_credential_id: 
        :param application_credential_name: 
        :param application_credential_secret: 
        :param archive_container: 
        :param auth_url: 
        :param cacert_file: 
        :param cert: 
        :param cloud: 
        :param default_domain: 
        :param domain_id: 
        :param domain_name: 
        :param expire_after: 
        :param insecure: 
        :param key: 
        :param password: 
        :param project_domain_id: 
        :param project_domain_name: 
        :param region_name: 
        :param state_name: 
        :param tenant_id: 
        :param tenant_name: 
        :param token: 
        :param user_domain_id: 
        :param user_domain_name: 
        :param user_id: 
        :param user_name: 

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__025ba5234ddaea92e04108c0ef7d4badc8278f552dd35e763c87e50842a17c02)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = DataTerraformRemoteStateSwiftConfig(
            defaults=defaults,
            workspace=workspace,
            container=container,
            application_credential_id=application_credential_id,
            application_credential_name=application_credential_name,
            application_credential_secret=application_credential_secret,
            archive_container=archive_container,
            auth_url=auth_url,
            cacert_file=cacert_file,
            cert=cert,
            cloud=cloud,
            default_domain=default_domain,
            domain_id=domain_id,
            domain_name=domain_name,
            expire_after=expire_after,
            insecure=insecure,
            key=key,
            password=password,
            project_domain_id=project_domain_id,
            project_domain_name=project_domain_name,
            region_name=region_name,
            state_name=state_name,
            tenant_id=tenant_id,
            tenant_name=tenant_name,
            token=token,
            user_domain_id=user_domain_id,
            user_domain_name=user_domain_name,
            user_id=user_id,
            user_name=user_name,
        )

        jsii.create(self.__class__, self, [scope, id, config])


@jsii.data_type(
    jsii_type="cdktf.DataTerraformRemoteStateSwiftConfig",
    jsii_struct_bases=[DataTerraformRemoteStateConfig, SwiftBackendConfig],
    name_mapping={
        "defaults": "defaults",
        "workspace": "workspace",
        "container": "container",
        "application_credential_id": "applicationCredentialId",
        "application_credential_name": "applicationCredentialName",
        "application_credential_secret": "applicationCredentialSecret",
        "archive_container": "archiveContainer",
        "auth_url": "authUrl",
        "cacert_file": "cacertFile",
        "cert": "cert",
        "cloud": "cloud",
        "default_domain": "defaultDomain",
        "domain_id": "domainId",
        "domain_name": "domainName",
        "expire_after": "expireAfter",
        "insecure": "insecure",
        "key": "key",
        "password": "password",
        "project_domain_id": "projectDomainId",
        "project_domain_name": "projectDomainName",
        "region_name": "regionName",
        "state_name": "stateName",
        "tenant_id": "tenantId",
        "tenant_name": "tenantName",
        "token": "token",
        "user_domain_id": "userDomainId",
        "user_domain_name": "userDomainName",
        "user_id": "userId",
        "user_name": "userName",
    },
)
class DataTerraformRemoteStateSwiftConfig(
    DataTerraformRemoteStateConfig,
    SwiftBackendConfig,
):
    def __init__(
        self,
        *,
        defaults: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        workspace: typing.Optional[builtins.str] = None,
        container: builtins.str,
        application_credential_id: typing.Optional[builtins.str] = None,
        application_credential_name: typing.Optional[builtins.str] = None,
        application_credential_secret: typing.Optional[builtins.str] = None,
        archive_container: typing.Optional[builtins.str] = None,
        auth_url: typing.Optional[builtins.str] = None,
        cacert_file: typing.Optional[builtins.str] = None,
        cert: typing.Optional[builtins.str] = None,
        cloud: typing.Optional[builtins.str] = None,
        default_domain: typing.Optional[builtins.str] = None,
        domain_id: typing.Optional[builtins.str] = None,
        domain_name: typing.Optional[builtins.str] = None,
        expire_after: typing.Optional[builtins.str] = None,
        insecure: typing.Optional[builtins.bool] = None,
        key: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        project_domain_id: typing.Optional[builtins.str] = None,
        project_domain_name: typing.Optional[builtins.str] = None,
        region_name: typing.Optional[builtins.str] = None,
        state_name: typing.Optional[builtins.str] = None,
        tenant_id: typing.Optional[builtins.str] = None,
        tenant_name: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
        user_domain_id: typing.Optional[builtins.str] = None,
        user_domain_name: typing.Optional[builtins.str] = None,
        user_id: typing.Optional[builtins.str] = None,
        user_name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param defaults: 
        :param workspace: 
        :param container: 
        :param application_credential_id: 
        :param application_credential_name: 
        :param application_credential_secret: 
        :param archive_container: 
        :param auth_url: 
        :param cacert_file: 
        :param cert: 
        :param cloud: 
        :param default_domain: 
        :param domain_id: 
        :param domain_name: 
        :param expire_after: 
        :param insecure: 
        :param key: 
        :param password: 
        :param project_domain_id: 
        :param project_domain_name: 
        :param region_name: 
        :param state_name: 
        :param tenant_id: 
        :param tenant_name: 
        :param token: 
        :param user_domain_id: 
        :param user_domain_name: 
        :param user_id: 
        :param user_name: 

        :deprecated: CDK for Terraform no longer supports the swift backend. Terraform deprecated swift in v1.2.3 and removed it in v1.3.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__30d0e67dcaa7e6baddf9a91f1a296bd44ce649626feb604bb2c721b5a826816f)
            check_type(argname="argument defaults", value=defaults, expected_type=type_hints["defaults"])
            check_type(argname="argument workspace", value=workspace, expected_type=type_hints["workspace"])
            check_type(argname="argument container", value=container, expected_type=type_hints["container"])
            check_type(argname="argument application_credential_id", value=application_credential_id, expected_type=type_hints["application_credential_id"])
            check_type(argname="argument application_credential_name", value=application_credential_name, expected_type=type_hints["application_credential_name"])
            check_type(argname="argument application_credential_secret", value=application_credential_secret, expected_type=type_hints["application_credential_secret"])
            check_type(argname="argument archive_container", value=archive_container, expected_type=type_hints["archive_container"])
            check_type(argname="argument auth_url", value=auth_url, expected_type=type_hints["auth_url"])
            check_type(argname="argument cacert_file", value=cacert_file, expected_type=type_hints["cacert_file"])
            check_type(argname="argument cert", value=cert, expected_type=type_hints["cert"])
            check_type(argname="argument cloud", value=cloud, expected_type=type_hints["cloud"])
            check_type(argname="argument default_domain", value=default_domain, expected_type=type_hints["default_domain"])
            check_type(argname="argument domain_id", value=domain_id, expected_type=type_hints["domain_id"])
            check_type(argname="argument domain_name", value=domain_name, expected_type=type_hints["domain_name"])
            check_type(argname="argument expire_after", value=expire_after, expected_type=type_hints["expire_after"])
            check_type(argname="argument insecure", value=insecure, expected_type=type_hints["insecure"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument password", value=password, expected_type=type_hints["password"])
            check_type(argname="argument project_domain_id", value=project_domain_id, expected_type=type_hints["project_domain_id"])
            check_type(argname="argument project_domain_name", value=project_domain_name, expected_type=type_hints["project_domain_name"])
            check_type(argname="argument region_name", value=region_name, expected_type=type_hints["region_name"])
            check_type(argname="argument state_name", value=state_name, expected_type=type_hints["state_name"])
            check_type(argname="argument tenant_id", value=tenant_id, expected_type=type_hints["tenant_id"])
            check_type(argname="argument tenant_name", value=tenant_name, expected_type=type_hints["tenant_name"])
            check_type(argname="argument token", value=token, expected_type=type_hints["token"])
            check_type(argname="argument user_domain_id", value=user_domain_id, expected_type=type_hints["user_domain_id"])
            check_type(argname="argument user_domain_name", value=user_domain_name, expected_type=type_hints["user_domain_name"])
            check_type(argname="argument user_id", value=user_id, expected_type=type_hints["user_id"])
            check_type(argname="argument user_name", value=user_name, expected_type=type_hints["user_name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "container": container,
        }
        if defaults is not None:
            self._values["defaults"] = defaults
        if workspace is not None:
            self._values["workspace"] = workspace
        if application_credential_id is not None:
            self._values["application_credential_id"] = application_credential_id
        if application_credential_name is not None:
            self._values["application_credential_name"] = application_credential_name
        if application_credential_secret is not None:
            self._values["application_credential_secret"] = application_credential_secret
        if archive_container is not None:
            self._values["archive_container"] = archive_container
        if auth_url is not None:
            self._values["auth_url"] = auth_url
        if cacert_file is not None:
            self._values["cacert_file"] = cacert_file
        if cert is not None:
            self._values["cert"] = cert
        if cloud is not None:
            self._values["cloud"] = cloud
        if default_domain is not None:
            self._values["default_domain"] = default_domain
        if domain_id is not None:
            self._values["domain_id"] = domain_id
        if domain_name is not None:
            self._values["domain_name"] = domain_name
        if expire_after is not None:
            self._values["expire_after"] = expire_after
        if insecure is not None:
            self._values["insecure"] = insecure
        if key is not None:
            self._values["key"] = key
        if password is not None:
            self._values["password"] = password
        if project_domain_id is not None:
            self._values["project_domain_id"] = project_domain_id
        if project_domain_name is not None:
            self._values["project_domain_name"] = project_domain_name
        if region_name is not None:
            self._values["region_name"] = region_name
        if state_name is not None:
            self._values["state_name"] = state_name
        if tenant_id is not None:
            self._values["tenant_id"] = tenant_id
        if tenant_name is not None:
            self._values["tenant_name"] = tenant_name
        if token is not None:
            self._values["token"] = token
        if user_domain_id is not None:
            self._values["user_domain_id"] = user_domain_id
        if user_domain_name is not None:
            self._values["user_domain_name"] = user_domain_name
        if user_id is not None:
            self._values["user_id"] = user_id
        if user_name is not None:
            self._values["user_name"] = user_name

    @builtins.property
    def defaults(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("defaults")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def workspace(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("workspace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def container(self) -> builtins.str:
        '''
        :stability: deprecated
        '''
        result = self._values.get("container")
        assert result is not None, "Required property 'container' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def application_credential_id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("application_credential_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def application_credential_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("application_credential_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def application_credential_secret(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("application_credential_secret")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def archive_container(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("archive_container")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def auth_url(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("auth_url")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cacert_file(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("cacert_file")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cert(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("cert")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def cloud(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("cloud")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def default_domain(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("default_domain")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def domain_id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("domain_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def domain_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("domain_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def expire_after(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("expire_after")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def insecure(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("insecure")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def key(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("key")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def password(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("password")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def project_domain_id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("project_domain_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def project_domain_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("project_domain_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("region_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def state_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("state_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tenant_id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("tenant_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tenant_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("tenant_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def token(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user_domain_id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("user_domain_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user_domain_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("user_domain_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user_id(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("user_id")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def user_name(self) -> typing.Optional[builtins.str]:
        '''
        :stability: deprecated
        '''
        result = self._values.get("user_name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DataTerraformRemoteStateSwiftConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(ITokenResolver)
class DefaultTokenResolver(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.DefaultTokenResolver",
):
    '''(experimental) Default resolver implementation.

    :stability: experimental
    '''

    def __init__(self, concat: IFragmentConcatenator) -> None:
        '''(experimental) Resolves tokens.

        :param concat: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1f11d254991d653a7afa3ee9123e2d6181abf7d05d6dc880dbd97446ae34a940)
            check_type(argname="argument concat", value=concat, expected_type=type_hints["concat"])
        jsii.create(self.__class__, self, [concat])

    @jsii.member(jsii_name="resolveList")
    def resolve_list(
        self,
        xs: typing.Sequence[builtins.str],
        context: IResolveContext,
    ) -> typing.Any:
        '''(experimental) Resolves a list of string.

        :param xs: -
        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__51fe19dbaacdb1962147fe084001f23fc7d7827cde0e0b8188d7679966ba8d22)
            check_type(argname="argument xs", value=xs, expected_type=type_hints["xs"])
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolveList", [xs, context]))

    @jsii.member(jsii_name="resolveMap")
    def resolve_map(
        self,
        xs: typing.Mapping[builtins.str, typing.Any],
        context: IResolveContext,
    ) -> typing.Any:
        '''(experimental) Resolves a map token.

        :param xs: -
        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2214f13d6bb49fe86089c7de9bfa9100898e1a37c9a00c97c03199c8c08b0ba3)
            check_type(argname="argument xs", value=xs, expected_type=type_hints["xs"])
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolveMap", [xs, context]))

    @jsii.member(jsii_name="resolveNumberList")
    def resolve_number_list(
        self,
        xs: typing.Sequence[jsii.Number],
        context: IResolveContext,
    ) -> typing.Any:
        '''(experimental) Resolves a list of numbers.

        :param xs: -
        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8aaa70feb2a94d2c0591b0d8e1a5323280b8f69dbcbfb2a264f29c43ee75af19)
            check_type(argname="argument xs", value=xs, expected_type=type_hints["xs"])
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolveNumberList", [xs, context]))

    @jsii.member(jsii_name="resolveString")
    def resolve_string(
        self,
        fragments: TokenizedStringFragments,
        context: IResolveContext,
    ) -> typing.Any:
        '''(experimental) Resolve string fragments to Tokens.

        :param fragments: -
        :param context: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__877ad16f6f0b84605bb92158bdbddf52a49554c6b2ad584b82c003512f11e037)
            check_type(argname="argument fragments", value=fragments, expected_type=type_hints["fragments"])
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolveString", [fragments, context]))

    @jsii.member(jsii_name="resolveToken")
    def resolve_token(
        self,
        t: IResolvable,
        context: IResolveContext,
        post_processor: IPostProcessor,
    ) -> typing.Any:
        '''(experimental) Default Token resolution.

        Resolve the Token, recurse into whatever it returns,
        then finally post-process it.

        :param t: -
        :param context: -
        :param post_processor: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__47b93291ccc35a27f986c04db1f2ae9ae6b0a3983827097f18acac714fc3021d)
            check_type(argname="argument t", value=t, expected_type=type_hints["t"])
            check_type(argname="argument context", value=context, expected_type=type_hints["context"])
            check_type(argname="argument post_processor", value=post_processor, expected_type=type_hints["post_processor"])
        return typing.cast(typing.Any, jsii.invoke(self, "resolveToken", [t, context, post_processor]))


class Fn(FnGenerated, metaclass=jsii.JSIIMeta, jsii_type="cdktf.Fn"):
    '''
    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="bcrypt")
    @builtins.classmethod
    def bcrypt(
        cls,
        str: builtins.str,
        cost: typing.Optional[jsii.Number] = None,
    ) -> builtins.str:
        '''(experimental) {@link /terraform/docs/language/functions/bcrypt.html bcrypt} computes a hash of the given string using the Blowfish cipher, returning a string in `the *Modular Crypt Format* <https://passlib.readthedocs.io/en/stable/modular_crypt_format.html>`_ usually expected in the shadow password file on many Unix systems.

        :param str: -
        :param cost: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__dca182f80a8d12e3b4cc17986233795b274be2fbd64424612b57c63dee19485b)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
            check_type(argname="argument cost", value=cost, expected_type=type_hints["cost"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "bcrypt", [str, cost]))

    @jsii.member(jsii_name="join")
    @builtins.classmethod
    def join(
        cls,
        separator: builtins.str,
        list: typing.Sequence[builtins.str],
    ) -> builtins.str:
        '''(experimental) {@link /terraform/docs/language/functions/join.html join} produces a string by concatenating together all elements of a given list of strings with the given delimiter.

        :param separator: -
        :param list: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9c0a1a231ffce05f4fb1748f4adae216ae9f307bcfef1f981aaf647bdfb2f090)
            check_type(argname="argument separator", value=separator, expected_type=type_hints["separator"])
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "join", [separator, list]))

    @jsii.member(jsii_name="lookup")
    @builtins.classmethod
    def lookup(
        cls,
        input_map: typing.Any,
        key: builtins.str,
        default_value: typing.Any,
    ) -> typing.Any:
        '''(experimental) {@link /terraform/docs/language/functions/lookup.html lookup} retrieves the value of a single element from a map, given its key. If the given key does not exist, the given default value is returned instead.

        :param input_map: -
        :param key: -
        :param default_value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b097a2224159f1087db8dee1efed387056c8b1c5ea8000b598e8a64ce159c7a2)
            check_type(argname="argument input_map", value=input_map, expected_type=type_hints["input_map"])
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument default_value", value=default_value, expected_type=type_hints["default_value"])
        return typing.cast(typing.Any, jsii.sinvoke(cls, "lookup", [input_map, key, default_value]))

    @jsii.member(jsii_name="range")
    @builtins.classmethod
    def range(
        cls,
        start: jsii.Number,
        limit: jsii.Number,
        step: typing.Optional[jsii.Number] = None,
    ) -> typing.List[builtins.str]:
        '''(experimental) {@link /terraform/docs/language/functions/range.html range} generates a list of numbers using a start value, a limit value, and a step value.

        :param start: -
        :param limit: -
        :param step: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f446032ee0b2f07fb7b9e4bb6e04e2f6c960ecddc73797e12f76ad3e9a343d25)
            check_type(argname="argument start", value=start, expected_type=type_hints["start"])
            check_type(argname="argument limit", value=limit, expected_type=type_hints["limit"])
            check_type(argname="argument step", value=step, expected_type=type_hints["step"])
        return typing.cast(typing.List[builtins.str], jsii.sinvoke(cls, "range", [start, limit, step]))

    @jsii.member(jsii_name="rawString")
    @builtins.classmethod
    def raw_string(cls, str: builtins.str) -> builtins.str:
        '''(experimental) Use this function to wrap a string and escape it properly for the use in Terraform This is only needed in certain scenarios (e.g., if you have unescaped double quotes in the string).

        :param str: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af92d149fffeb34d269ef685949c5c8baf82a6df8780857b84c991e4d1515b9c)
            check_type(argname="argument str", value=str, expected_type=type_hints["str"])
        return typing.cast(builtins.str, jsii.sinvoke(cls, "rawString", [str]))


class ListTerraformIterator(
    TerraformIterator,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.ListTerraformIterator",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        list: typing.Union[typing.Sequence[builtins.str], IResolvable, typing.Sequence[jsii.Number], ComplexList, StringMapList, NumberMapList, BooleanMapList, AnyMapList, typing.Sequence[typing.Union[builtins.bool, IResolvable]]],
    ) -> None:
        '''
        :param list: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b210417b1cec4ca8694cd3bc6043b275d36856f723a96dadbba6402df4577229)
            check_type(argname="argument list", value=list, expected_type=type_hints["list"])
        jsii.create(self.__class__, self, [list])

    @builtins.property
    @jsii.member(jsii_name="key")
    def key(self) -> typing.Any:
        '''(experimental) Returns the currenty entry in the list or set that is being iterated over.

        For lists this is the same as ``iterator.value``. If you need the index,
        use count using the escape hatch:
        https://developer.hashicorp.com/terraform/cdktf/concepts/resources#escape-hatch

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "key"))

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''(experimental) Returns the value of the current item iterated over.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


class MapTerraformIterator(
    TerraformIterator,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.MapTerraformIterator",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        map: typing.Union[StringMap, NumberMap, BooleanMap, AnyMap, ComplexMap, typing.Mapping[builtins.str, typing.Any], typing.Mapping[builtins.str, builtins.str], typing.Mapping[builtins.str, jsii.Number]],
    ) -> None:
        '''
        :param map: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5f4f6bf3cf486ffbd63fa4117f55ba4a3c8879194d3c4c5be3f29c24852ff3f0)
            check_type(argname="argument map", value=map, expected_type=type_hints["map"])
        jsii.create(self.__class__, self, [map])

    @builtins.property
    @jsii.member(jsii_name="key")
    def key(self) -> builtins.str:
        '''(experimental) Returns the key of the current entry in the map that is being iterated over.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "key"))

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Any:
        '''(experimental) Returns the value of the current item iterated over.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.get(self, "value"))


class NumberListMap(
    ComplexMap,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.NumberListMap",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a7281a237e7994a69f6ccfdf12150de0b26610710df97b986a1f25c9efa08b74)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="get")
    def get(self, key: builtins.str) -> typing.List[jsii.Number]:
        '''
        :param key: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__afa537cd170a91e4febd1e152720f606d0bfb9c4183f9e98d34b0ffb9341cde1)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(typing.List[jsii.Number], jsii.invoke(self, "get", [key]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f49a0c699666475886454e18076d046b6ff2fa06e3cb3708dadc48faab42e294)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c38a78837a9a534f347fb4289cd7447c5c4b10bc3fe4568d20d2f0667dab306e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)


@jsii.data_type(
    jsii_type="cdktf.Postcondition",
    jsii_struct_bases=[TerraformCondition],
    name_mapping={"condition": "condition", "error_message": "errorMessage"},
)
class Postcondition(TerraformCondition):
    def __init__(self, *, condition: typing.Any, error_message: builtins.str) -> None:
        '''(experimental) Terraform checks a postcondition after evaluating the object it is associated with.

        :param condition: (experimental) This is a boolean expression that should return true if the intended assumption or guarantee is fulfilled or false if it does not.
        :param error_message: (experimental) This contains the text that Terraform will include as part of error messages when it detects an unmet condition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0ab7d214748b13f84c893c637ae988be1013fed527fd6ef2f3041215974eed5e)
            check_type(argname="argument condition", value=condition, expected_type=type_hints["condition"])
            check_type(argname="argument error_message", value=error_message, expected_type=type_hints["error_message"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "condition": condition,
            "error_message": error_message,
        }

    @builtins.property
    def condition(self) -> typing.Any:
        '''(experimental) This is a boolean expression that should return true if the intended assumption or guarantee is fulfilled or false if it does not.

        :stability: experimental
        '''
        result = self._values.get("condition")
        assert result is not None, "Required property 'condition' is missing"
        return typing.cast(typing.Any, result)

    @builtins.property
    def error_message(self) -> builtins.str:
        '''(experimental) This contains the text that Terraform will include as part of error messages when it detects an unmet condition.

        :stability: experimental
        '''
        result = self._values.get("error_message")
        assert result is not None, "Required property 'error_message' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Postcondition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdktf.Precondition",
    jsii_struct_bases=[TerraformCondition],
    name_mapping={"condition": "condition", "error_message": "errorMessage"},
)
class Precondition(TerraformCondition):
    def __init__(self, *, condition: typing.Any, error_message: builtins.str) -> None:
        '''(experimental) Terraform checks a precondition before evaluating the object it is associated with.

        :param condition: (experimental) This is a boolean expression that should return true if the intended assumption or guarantee is fulfilled or false if it does not.
        :param error_message: (experimental) This contains the text that Terraform will include as part of error messages when it detects an unmet condition.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9fd2be3b40a757b8ea0f1567317c1bea46c5d89e196f404917fffabf318620ff)
            check_type(argname="argument condition", value=condition, expected_type=type_hints["condition"])
            check_type(argname="argument error_message", value=error_message, expected_type=type_hints["error_message"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "condition": condition,
            "error_message": error_message,
        }

    @builtins.property
    def condition(self) -> typing.Any:
        '''(experimental) This is a boolean expression that should return true if the intended assumption or guarantee is fulfilled or false if it does not.

        :stability: experimental
        '''
        result = self._values.get("condition")
        assert result is not None, "Required property 'condition' is missing"
        return typing.cast(typing.Any, result)

    @builtins.property
    def error_message(self) -> builtins.str:
        '''(experimental) This contains the text that Terraform will include as part of error messages when it detects an unmet condition.

        :stability: experimental
        '''
        result = self._values.get("error_message")
        assert result is not None, "Required property 'error_message' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Precondition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class StringListMap(
    ComplexMap,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.StringListMap",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__305e443bbdf03350c871a388352663f9920b922cabfdad0aac2c33e97931f6d5)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="get")
    def get(self, key: builtins.str) -> typing.List[builtins.str]:
        '''
        :param key: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__562493d43f406e579d5f1ad9280614dca554e574bb9b0a6f0a9a00d411083de3)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(typing.List[builtins.str], jsii.invoke(self, "get", [key]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__18d088de89615a04157083477970b9374cfff49afb4aded7cac88f9fe0dfe3fa)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c04afdf1a5219f3aab9051b7272822305bc8cd858f3273242585dcc7a67df0fe)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)


class TerraformBackend(
    TerraformElement,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdktf.TerraformBackend",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        name: builtins.str,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param name: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d6fb997bcc7583c1ce7831b4e6534557939a1d85af5ca262d578cad1c8d3866d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        jsii.create(self.__class__, self, [scope, id, name])

    @jsii.member(jsii_name="isBackend")
    @builtins.classmethod
    def is_backend(cls, x: typing.Any) -> builtins.bool:
        '''
        :param x: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d563abf56d607f3e33139cf8260461f72e92211fe02699ac0c3b8630b15e91e2)
            check_type(argname="argument x", value=x, expected_type=type_hints["x"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "isBackend", [x]))

    @jsii.member(jsii_name="getRemoteStateDataSource")
    @abc.abstractmethod
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(experimental) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param from_stack: -

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.member(jsii_name="toMetadata")
    def to_metadata(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toMetadata", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''(experimental) Adds this resource to the terraform JSON output.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="name")
    def _name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "name"))


class _TerraformBackendProxy(TerraformBackend):
    @jsii.member(jsii_name="getRemoteStateDataSource")
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(experimental) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param from_stack: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cfe86b3e048212077640b322819748b66ca8d69a31d453ab907605ae634e83e9)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument from_stack", value=from_stack, expected_type=type_hints["from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "getRemoteStateDataSource", [scope, name, from_stack]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, TerraformBackend).__jsii_proxy_class__ = lambda : _TerraformBackendProxy


@jsii.implements(ITerraformResource, ITerraformDependable, IInterpolatingParent)
class TerraformDataSource(
    TerraformElement,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.TerraformDataSource",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        terraform_resource_type: builtins.str,
        terraform_generator_metadata: typing.Optional[typing.Union[TerraformProviderGeneratorMetadata, typing.Dict[builtins.str, typing.Any]]] = None,
        connection: typing.Optional[typing.Union[typing.Union[SSHProvisionerConnection, typing.Dict[builtins.str, typing.Any]], typing.Union[WinrmProvisionerConnection, typing.Dict[builtins.str, typing.Any]]]] = None,
        count: typing.Optional[typing.Union[jsii.Number, TerraformCount]] = None,
        depends_on: typing.Optional[typing.Sequence[ITerraformDependable]] = None,
        for_each: typing.Optional[ITerraformIterator] = None,
        lifecycle: typing.Optional[typing.Union[TerraformResourceLifecycle, typing.Dict[builtins.str, typing.Any]]] = None,
        provider: typing.Optional[TerraformProvider] = None,
        provisioners: typing.Optional[typing.Sequence[typing.Union[typing.Union[FileProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[LocalExecProvisioner, typing.Dict[builtins.str, typing.Any]], typing.Union[RemoteExecProvisioner, typing.Dict[builtins.str, typing.Any]]]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param terraform_resource_type: 
        :param terraform_generator_metadata: 
        :param connection: 
        :param count: 
        :param depends_on: 
        :param for_each: 
        :param lifecycle: 
        :param provider: 
        :param provisioners: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__852ac3a4bed0c9c782da43ce8201dd3a299a1e860bf7ee5df6eb071d031429b1)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        config = TerraformResourceConfig(
            terraform_resource_type=terraform_resource_type,
            terraform_generator_metadata=terraform_generator_metadata,
            connection=connection,
            count=count,
            depends_on=depends_on,
            for_each=for_each,
            lifecycle=lifecycle,
            provider=provider,
            provisioners=provisioners,
        )

        jsii.create(self.__class__, self, [scope, id, config])

    @jsii.member(jsii_name="isTerraformDataSource")
    @builtins.classmethod
    def is_terraform_data_source(cls, x: typing.Any) -> builtins.bool:
        '''
        :param x: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cbcf07e02ac49f273dee8889d630907b86a9a5a7523f930bcf86e74b1668e4b6)
            check_type(argname="argument x", value=x, expected_type=type_hints["x"])
        return typing.cast(builtins.bool, jsii.sinvoke(cls, "isTerraformDataSource", [x]))

    @jsii.member(jsii_name="getAnyMapAttribute")
    def get_any_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c3c87464d43408207db46fc7dbee93b707f3ff49e3d42a647886349e0be078a0)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "getAnyMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getBooleanAttribute")
    def get_boolean_attribute(self, terraform_attribute: builtins.str) -> IResolvable:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__abd35b8b67311d86c17724d0ae68dc659839b9f28ef2027090a8945d9aa08b9c)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(IResolvable, jsii.invoke(self, "getBooleanAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getBooleanMapAttribute")
    def get_boolean_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, builtins.bool]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__774801e38be37ab870bf5774fb888564da0674b63b0176dc26ae0fc8584ca745)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, builtins.bool], jsii.invoke(self, "getBooleanMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getListAttribute")
    def get_list_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.List[builtins.str]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__af3fb310803c80c16f61ad8b6260b4925e4dec364507c1040a3ddc1f9f421b41)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.List[builtins.str], jsii.invoke(self, "getListAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getNumberAttribute")
    def get_number_attribute(self, terraform_attribute: builtins.str) -> jsii.Number:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f0f7e63e7c836a18bf8d555a07103933d8fd18c8236976011d583625f1964977)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(jsii.Number, jsii.invoke(self, "getNumberAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getNumberListAttribute")
    def get_number_list_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.List[jsii.Number]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__84ca9bd9a69f870201fd1383e8f6b4c30979aeddbace0f47d1b61f328308b6e2)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.List[jsii.Number], jsii.invoke(self, "getNumberListAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getNumberMapAttribute")
    def get_number_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, jsii.Number]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f869f9a68ece5f5fbc4036c710a761a70d72cc40e72a4c81a6009669e7cd04fb)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, jsii.Number], jsii.invoke(self, "getNumberMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getStringAttribute")
    def get_string_attribute(self, terraform_attribute: builtins.str) -> builtins.str:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0e1a157591a0f424c54eadaf08ab7410969d43eeb7194a4889a8bde34cbe99e3)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(builtins.str, jsii.invoke(self, "getStringAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="getStringMapAttribute")
    def get_string_map_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d7f1cbe4e1f4317ee046c2e8e36d7e81e31dd7e03f67d26b32377bf535af0b5e)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.invoke(self, "getStringMapAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="interpolationForAttribute")
    def interpolation_for_attribute(
        self,
        terraform_attribute: builtins.str,
    ) -> IResolvable:
        '''
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8833bf3996dd379165e8ccb6eff9aa3bd78b490634257e163450c3a233d7226c)
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        return typing.cast(IResolvable, jsii.invoke(self, "interpolationForAttribute", [terraform_attribute]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.member(jsii_name="toMetadata")
    def to_metadata(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toMetadata", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''(experimental) Adds this resource to the terraform JSON output.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))

    @builtins.property
    @jsii.member(jsii_name="terraformMetaArguments")
    def terraform_meta_arguments(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.get(self, "terraformMetaArguments"))

    @builtins.property
    @jsii.member(jsii_name="terraformResourceType")
    def terraform_resource_type(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformResourceType"))

    @builtins.property
    @jsii.member(jsii_name="terraformGeneratorMetadata")
    def terraform_generator_metadata(
        self,
    ) -> typing.Optional[TerraformProviderGeneratorMetadata]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[TerraformProviderGeneratorMetadata], jsii.get(self, "terraformGeneratorMetadata"))

    @builtins.property
    @jsii.member(jsii_name="count")
    def count(self) -> typing.Optional[typing.Union[jsii.Number, TerraformCount]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.Union[jsii.Number, TerraformCount]], jsii.get(self, "count"))

    @count.setter
    def count(
        self,
        value: typing.Optional[typing.Union[jsii.Number, TerraformCount]],
    ) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7a80ee7d4741ec1588d4ae1e6ac35941c41887f1e4039813972f49ce3e378092)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "count", value)

    @builtins.property
    @jsii.member(jsii_name="dependsOn")
    def depends_on(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.List[builtins.str]], jsii.get(self, "dependsOn"))

    @depends_on.setter
    def depends_on(self, value: typing.Optional[typing.List[builtins.str]]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__578bb93b9745e10379bfcad83af78210347ea9a88186f31aca32733a25d7eb47)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "dependsOn", value)

    @builtins.property
    @jsii.member(jsii_name="forEach")
    def for_each(self) -> typing.Optional[ITerraformIterator]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[ITerraformIterator], jsii.get(self, "forEach"))

    @for_each.setter
    def for_each(self, value: typing.Optional[ITerraformIterator]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__848fc78175850069ae14bbe28cf92b52d40932302c17afd25f6e1abff89ee6d9)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "forEach", value)

    @builtins.property
    @jsii.member(jsii_name="lifecycle")
    def lifecycle(self) -> typing.Optional[TerraformResourceLifecycle]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[TerraformResourceLifecycle], jsii.get(self, "lifecycle"))

    @lifecycle.setter
    def lifecycle(self, value: typing.Optional[TerraformResourceLifecycle]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__512617d2b8cbdcbcbc76a30db73c33fb968a9d872a9d216d8e7e5e5d4c380228)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "lifecycle", value)

    @builtins.property
    @jsii.member(jsii_name="provider")
    def provider(self) -> typing.Optional[TerraformProvider]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[TerraformProvider], jsii.get(self, "provider"))

    @provider.setter
    def provider(self, value: typing.Optional[TerraformProvider]) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2ff2224bce54ef14b6649b048ee22480ae934f33810e681f6ad854ce4f8e8f95)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "provider", value)


class TerraformHclModule(
    TerraformModule,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.TerraformHclModule",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        variables: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        source: builtins.str,
        version: typing.Optional[builtins.str] = None,
        depends_on: typing.Optional[typing.Sequence[ITerraformDependable]] = None,
        for_each: typing.Optional[ITerraformIterator] = None,
        providers: typing.Optional[typing.Sequence[typing.Union[TerraformProvider, typing.Union[TerraformModuleProvider, typing.Dict[builtins.str, typing.Any]]]]] = None,
        skip_asset_creation_from_local_modules: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param variables: 
        :param source: 
        :param version: 
        :param depends_on: 
        :param for_each: 
        :param providers: 
        :param skip_asset_creation_from_local_modules: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4b64ba0f0731300367cb6ba0b659aaff33baac57d169f6b2429035aa21f13b52)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        options = TerraformHclModuleConfig(
            variables=variables,
            source=source,
            version=version,
            depends_on=depends_on,
            for_each=for_each,
            providers=providers,
            skip_asset_creation_from_local_modules=skip_asset_creation_from_local_modules,
        )

        jsii.create(self.__class__, self, [scope, id, options])

    @jsii.member(jsii_name="get")
    def get(self, output: builtins.str) -> typing.Any:
        '''
        :param output: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c38b78a0b3a8b458707c17ab2ecc1aabf3075ef537ba31d00b7472c2b2f1994c)
            check_type(argname="argument output", value=output, expected_type=type_hints["output"])
        return typing.cast(typing.Any, jsii.invoke(self, "get", [output]))

    @jsii.member(jsii_name="getBoolean")
    def get_boolean(self, output: builtins.str) -> IResolvable:
        '''
        :param output: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__991c8039b20c7c1aed4f26054a891906d99fb8cdd71772eb84385ae478ba1735)
            check_type(argname="argument output", value=output, expected_type=type_hints["output"])
        return typing.cast(IResolvable, jsii.invoke(self, "getBoolean", [output]))

    @jsii.member(jsii_name="getList")
    def get_list(self, output: builtins.str) -> typing.List[builtins.str]:
        '''
        :param output: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d242546eb28071c4360c284902cee526062f69c964a92f8280042d5e252b28a8)
            check_type(argname="argument output", value=output, expected_type=type_hints["output"])
        return typing.cast(typing.List[builtins.str], jsii.invoke(self, "getList", [output]))

    @jsii.member(jsii_name="getNumber")
    def get_number(self, output: builtins.str) -> jsii.Number:
        '''
        :param output: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__aaba423db882455df75d38a15a153ac3518f155a13f50b8841a8bdb6373b0acf)
            check_type(argname="argument output", value=output, expected_type=type_hints["output"])
        return typing.cast(jsii.Number, jsii.invoke(self, "getNumber", [output]))

    @jsii.member(jsii_name="set")
    def set(self, variable: builtins.str, value: typing.Any) -> None:
        '''
        :param variable: -
        :param value: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__63d90eb047a475b766505effa9ab7377e5ddb3958733d97d612c472d53af0e81)
            check_type(argname="argument variable", value=variable, expected_type=type_hints["variable"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        return typing.cast(None, jsii.invoke(self, "set", [variable, value]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @builtins.property
    @jsii.member(jsii_name="variables")
    def variables(self) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], jsii.get(self, "variables"))


@jsii.data_type(
    jsii_type="cdktf.TerraformModuleConfig",
    jsii_struct_bases=[TerraformModuleUserConfig],
    name_mapping={
        "depends_on": "dependsOn",
        "for_each": "forEach",
        "providers": "providers",
        "skip_asset_creation_from_local_modules": "skipAssetCreationFromLocalModules",
        "source": "source",
        "version": "version",
    },
)
class TerraformModuleConfig(TerraformModuleUserConfig):
    def __init__(
        self,
        *,
        depends_on: typing.Optional[typing.Sequence[ITerraformDependable]] = None,
        for_each: typing.Optional[ITerraformIterator] = None,
        providers: typing.Optional[typing.Sequence[typing.Union[TerraformProvider, typing.Union[TerraformModuleProvider, typing.Dict[builtins.str, typing.Any]]]]] = None,
        skip_asset_creation_from_local_modules: typing.Optional[builtins.bool] = None,
        source: builtins.str,
        version: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param depends_on: 
        :param for_each: 
        :param providers: 
        :param skip_asset_creation_from_local_modules: 
        :param source: 
        :param version: 

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__72f4dd0ca57f0bcf7fa1491fe352cd1fd19fc118a8bd2c3683a13cfcb7f7e94f)
            check_type(argname="argument depends_on", value=depends_on, expected_type=type_hints["depends_on"])
            check_type(argname="argument for_each", value=for_each, expected_type=type_hints["for_each"])
            check_type(argname="argument providers", value=providers, expected_type=type_hints["providers"])
            check_type(argname="argument skip_asset_creation_from_local_modules", value=skip_asset_creation_from_local_modules, expected_type=type_hints["skip_asset_creation_from_local_modules"])
            check_type(argname="argument source", value=source, expected_type=type_hints["source"])
            check_type(argname="argument version", value=version, expected_type=type_hints["version"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "source": source,
        }
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if for_each is not None:
            self._values["for_each"] = for_each
        if providers is not None:
            self._values["providers"] = providers
        if skip_asset_creation_from_local_modules is not None:
            self._values["skip_asset_creation_from_local_modules"] = skip_asset_creation_from_local_modules
        if version is not None:
            self._values["version"] = version

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[ITerraformDependable]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("depends_on")
        return typing.cast(typing.Optional[typing.List[ITerraformDependable]], result)

    @builtins.property
    def for_each(self) -> typing.Optional[ITerraformIterator]:
        '''
        :stability: experimental
        '''
        result = self._values.get("for_each")
        return typing.cast(typing.Optional[ITerraformIterator], result)

    @builtins.property
    def providers(
        self,
    ) -> typing.Optional[typing.List[typing.Union[TerraformProvider, TerraformModuleProvider]]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("providers")
        return typing.cast(typing.Optional[typing.List[typing.Union[TerraformProvider, TerraformModuleProvider]]], result)

    @builtins.property
    def skip_asset_creation_from_local_modules(self) -> typing.Optional[builtins.bool]:
        '''
        :stability: experimental
        '''
        result = self._values.get("skip_asset_creation_from_local_modules")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def source(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("source")
        assert result is not None, "Required property 'source' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def version(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("version")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "TerraformModuleConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AnyListMap(ComplexMap, metaclass=jsii.JSIIMeta, jsii_type="cdktf.AnyListMap"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__06cc1df6d93f89658e1fd0eb91d749e3d334106197adc0321fc9a9996c636ee6)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="get")
    def get(self, key: builtins.str) -> IResolvable:
        '''
        :param key: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3dfe62ed5d6446458e56c0c9d0bde5ea2a014393c5298e74cdb5bd0bcecd38dc)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(IResolvable, jsii.invoke(self, "get", [key]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7ad91655e4bbfacbd18af25390b1339d7e945a26f4a0e045c965872b4acfa90e)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1e5235d76c3137eee879c5ac3045b4f0d774af8d4de0ab4273656c36391b9512)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)


class ArtifactoryBackend(
    TerraformBackend,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.ArtifactoryBackend",
):
    '''
    :deprecated: CDK for Terraform no longer supports the artifactory backend. Terraform deprecated artifactory in v1.2.3 and removed it in v1.3.

    :stability: deprecated
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        *,
        password: builtins.str,
        repo: builtins.str,
        subpath: builtins.str,
        url: builtins.str,
        username: builtins.str,
    ) -> None:
        '''
        :param scope: -
        :param password: (deprecated) (Required) - The password.
        :param repo: (deprecated) (Required) - The repository name.
        :param subpath: (deprecated) (Required) - Path within the repository.
        :param url: (deprecated) (Required) - The URL. Note that this is the base url to artifactory not the full repo and subpath.
        :param username: (deprecated) (Required) - The username.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b69afcfb7fcf783a7461e549827ae6347601930234deaed28e73942611e946f9)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        props = ArtifactoryBackendConfig(
            password=password, repo=repo, subpath=subpath, url=url, username=username
        )

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="getRemoteStateDataSource")
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        _from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(deprecated) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param _from_stack: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7b4c85db6f5d8c3119fa9e2464a4820c67868af39df894a240428709b361e03d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument _from_stack", value=_from_stack, expected_type=type_hints["_from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "getRemoteStateDataSource", [scope, name, _from_stack]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: deprecated
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))


class AzurermBackend(
    TerraformBackend,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.AzurermBackend",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        *,
        container_name: builtins.str,
        key: builtins.str,
        storage_account_name: builtins.str,
        access_key: typing.Optional[builtins.str] = None,
        client_certificate_password: typing.Optional[builtins.str] = None,
        client_certificate_path: typing.Optional[builtins.str] = None,
        client_id: typing.Optional[builtins.str] = None,
        client_secret: typing.Optional[builtins.str] = None,
        endpoint: typing.Optional[builtins.str] = None,
        environment: typing.Optional[builtins.str] = None,
        msi_endpoint: typing.Optional[builtins.str] = None,
        oidc_request_token: typing.Optional[builtins.str] = None,
        oidc_request_url: typing.Optional[builtins.str] = None,
        resource_group_name: typing.Optional[builtins.str] = None,
        sas_token: typing.Optional[builtins.str] = None,
        snapshot: typing.Optional[builtins.bool] = None,
        subscription_id: typing.Optional[builtins.str] = None,
        tenant_id: typing.Optional[builtins.str] = None,
        use_azuread_auth: typing.Optional[builtins.bool] = None,
        use_microsoft_graph: typing.Optional[builtins.bool] = None,
        use_msi: typing.Optional[builtins.bool] = None,
        use_oidc: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param scope: -
        :param container_name: (experimental) (Required) The Name of the Storage Container within the Storage Account.
        :param key: (experimental) (Required) The name of the Blob used to retrieve/store Terraform's State file inside the Storage Container.
        :param storage_account_name: (experimental) (Required) The Name of the Storage Account.
        :param access_key: (experimental) access_key - (Optional) The Access Key used to access the Blob Storage Account. This can also be sourced from the ARM_ACCESS_KEY environment variable.
        :param client_certificate_password: (experimental) (Optional) The password associated with the Client Certificate specified in client_certificate_path. This can also be sourced from the ARM_CLIENT_CERTIFICATE_PASSWORD environment variable.
        :param client_certificate_path: (experimental) (Optional) The path to the PFX file used as the Client Certificate when authenticating as a Service Principal. This can also be sourced from the ARM_CLIENT_CERTIFICATE_PATH environment variable.
        :param client_id: (experimental) (Optional) The Client ID of the Service Principal. This can also be sourced from the ARM_CLIENT_ID environment variable.
        :param client_secret: (experimental) (Optional) The Client Secret of the Service Principal. This can also be sourced from the ARM_CLIENT_SECRET environment variable.
        :param endpoint: (experimental) (Optional) The Custom Endpoint for Azure Resource Manager. This can also be sourced from the ARM_ENDPOINT environment variable. NOTE: An endpoint should only be configured when using Azure Stack.
        :param environment: (experimental) (Optional) The Azure Environment which should be used. This can also be sourced from the ARM_ENVIRONMENT environment variable. Possible values are public, china, german, stack and usgovernment. Defaults to public.
        :param msi_endpoint: (experimental) (Optional) The path to a custom Managed Service Identity endpoint which is automatically determined if not specified. This can also be sourced from the ARM_MSI_ENDPOINT environment variable.
        :param oidc_request_token: (experimental) (Optional) The bearer token for the request to the OIDC provider. This can also be sourced from the ARM_OIDC_REQUEST_TOKEN or ACTIONS_ID_TOKEN_REQUEST_TOKEN environment variables.
        :param oidc_request_url: (experimental) (Optional) The URL for the OIDC provider from which to request an ID token. This can also be sourced from the ARM_OIDC_REQUEST_URL or ACTIONS_ID_TOKEN_REQUEST_URL environment variables.
        :param resource_group_name: (experimental) (Required) The Name of the Resource Group in which the Storage Account exists.
        :param sas_token: (experimental) (Optional) The SAS Token used to access the Blob Storage Account. This can also be sourced from the ARM_SAS_TOKEN environment variable.
        :param snapshot: (experimental) (Optional) Should the Blob used to store the Terraform Statefile be snapshotted before use? Defaults to false. This value can also be sourced from the ARM_SNAPSHOT environment variable.
        :param subscription_id: (experimental) (Optional) The Subscription ID in which the Storage Account exists. This can also be sourced from the ARM_SUBSCRIPTION_ID environment variable.
        :param tenant_id: (experimental) (Optional) The Tenant ID in which the Subscription exists. This can also be sourced from the ARM_TENANT_ID environment variable.
        :param use_azuread_auth: (experimental) (Optional) Should AzureAD Authentication be used to access the Blob Storage Account. This can also be sourced from the ARM_USE_AZUREAD environment variable. Note: When using AzureAD for Authentication to Storage you also need to ensure the Storage Blob Data Owner role is assigned.
        :param use_microsoft_graph: (experimental) (Optional) Should MSAL be used for authentication instead of ADAL, and should Microsoft Graph be used instead of Azure Active Directory Graph? Defaults to true. Note: In Terraform 1.2 the Azure Backend uses MSAL (and Microsoft Graph) rather than ADAL (and Azure Active Directory Graph) for authentication by default - you can disable this by setting use_microsoft_graph to false. This setting will be removed in Terraform 1.3, due to Microsoft's deprecation of ADAL.
        :param use_msi: (experimental) (Optional) Should Managed Service Identity authentication be used? This can also be sourced from the ARM_USE_MSI environment variable.
        :param use_oidc: (experimental) (Optional) Should OIDC authentication be used? This can also be sourced from the ARM_USE_OIDC environment variable. Note: When using OIDC for authentication, use_microsoft_graph must be set to true (which is the default).

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__b90b6161c6cc76005a2fc2d83ec73d5dab5fa50084ad9b5bd0531cd24e0d9a71)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        props = AzurermBackendConfig(
            container_name=container_name,
            key=key,
            storage_account_name=storage_account_name,
            access_key=access_key,
            client_certificate_password=client_certificate_password,
            client_certificate_path=client_certificate_path,
            client_id=client_id,
            client_secret=client_secret,
            endpoint=endpoint,
            environment=environment,
            msi_endpoint=msi_endpoint,
            oidc_request_token=oidc_request_token,
            oidc_request_url=oidc_request_url,
            resource_group_name=resource_group_name,
            sas_token=sas_token,
            snapshot=snapshot,
            subscription_id=subscription_id,
            tenant_id=tenant_id,
            use_azuread_auth=use_azuread_auth,
            use_microsoft_graph=use_microsoft_graph,
            use_msi=use_msi,
            use_oidc=use_oidc,
        )

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="getRemoteStateDataSource")
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        _from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(experimental) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param _from_stack: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e7bfe3c2b7195d7082cbb99996b229133dc817160ce3712f4a036773e45a7e2b)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument _from_stack", value=_from_stack, expected_type=type_hints["_from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "getRemoteStateDataSource", [scope, name, _from_stack]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))


class BooleanList(ComplexList, metaclass=jsii.JSIIMeta, jsii_type="cdktf.BooleanList"):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
        wraps_set: builtins.bool,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -
        :param wraps_set: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__221cf3d8a34f7571e53323ea34ca262ed884eb0b767bff934460ee3d2767d473)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
            check_type(argname="argument wraps_set", value=wraps_set, expected_type=type_hints["wraps_set"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute, wraps_set])

    @jsii.member(jsii_name="get")
    def get(self, index: jsii.Number) -> IResolvable:
        '''
        :param index: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__f93c0538210b51b4350e22fa403a54f8f4256b543d632701531dcbd180b73026)
            check_type(argname="argument index", value=index, expected_type=type_hints["index"])
        return typing.cast(IResolvable, jsii.invoke(self, "get", [index]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7c365c5471b8974de0f6df23f8f1c19d43bb91da895ee0280a585ace52aa7309)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__813daa4440a908c16aebc557c79e0b31959504ac3dc16492cd18311bbc800249)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)

    @builtins.property
    @jsii.member(jsii_name="wrapsSet")
    def _wraps_set(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "wrapsSet"))

    @_wraps_set.setter
    def _wraps_set(self, value: builtins.bool) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__84be449422b9b1114f75d1aeaa35232702b2c4f59b6b046c5be7fcd46e154fb6)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "wrapsSet", value)


class BooleanListMap(
    ComplexMap,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.BooleanListMap",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        terraform_resource: IInterpolatingParent,
        terraform_attribute: builtins.str,
    ) -> None:
        '''
        :param terraform_resource: -
        :param terraform_attribute: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8edc8e9982bb0653c2336c6149df99c3a90bea3d343cb3b3c53205ff7619457a)
            check_type(argname="argument terraform_resource", value=terraform_resource, expected_type=type_hints["terraform_resource"])
            check_type(argname="argument terraform_attribute", value=terraform_attribute, expected_type=type_hints["terraform_attribute"])
        jsii.create(self.__class__, self, [terraform_resource, terraform_attribute])

    @jsii.member(jsii_name="get")
    def get(self, key: builtins.str) -> IResolvable:
        '''
        :param key: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__753555ee56702d79fe484937a62b63f19f616540b5ed77ac51054b1e2af1caad)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
        return typing.cast(IResolvable, jsii.invoke(self, "get", [key]))

    @builtins.property
    @jsii.member(jsii_name="terraformAttribute")
    def _terraform_attribute(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "terraformAttribute"))

    @_terraform_attribute.setter
    def _terraform_attribute(self, value: builtins.str) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__555ae8aeddfe2a1ec4332ea8ddd2fafe5cfc1ca7734265a62e677abad58ccb2b)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformAttribute", value)

    @builtins.property
    @jsii.member(jsii_name="terraformResource")
    def _terraform_resource(self) -> IInterpolatingParent:
        '''
        :stability: experimental
        '''
        return typing.cast(IInterpolatingParent, jsii.get(self, "terraformResource"))

    @_terraform_resource.setter
    def _terraform_resource(self, value: IInterpolatingParent) -> None:
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3ff465c85fb99b9874b2166971dbd6a3b3b836b1255af13f578ae64d7abe6820)
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        jsii.set(self, "terraformResource", value)


class CloudBackend(
    TerraformBackend,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.CloudBackend",
):
    '''(experimental) The Cloud Backend synthesizes a {@link https://developer.hashicorp.com/terraform/cli/cloud/settings#the-cloud-block cloud block}. The cloud block is a nested block within the top-level terraform settings block. It specifies which Terraform Cloud workspaces to use for the current working directory. The cloud block only affects Terraform CLI's behavior. When Terraform Cloud uses a configuration that contains a cloud block - for example, when a workspace is configured to use a VCS provider directly - it ignores the block and behaves according to its own workspace settings.

    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        *,
        organization: builtins.str,
        workspaces: typing.Union[NamedCloudWorkspace, TaggedCloudWorkspaces],
        hostname: typing.Optional[builtins.str] = None,
        token: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param organization: (experimental) The name of the organization containing the workspace(s) the current configuration should use.
        :param workspaces: (experimental) A nested block that specifies which remote Terraform Cloud workspaces to use for the current configuration. The workspaces block must contain exactly one of the following arguments, each denoting a strategy for how workspaces should be mapped:
        :param hostname: (experimental) The hostname of a Terraform Enterprise installation, if using Terraform Enterprise. Default: app.terraform.io
        :param token: (experimental) The token used to authenticate with Terraform Cloud. We recommend omitting the token from the configuration, and instead using terraform login or manually configuring credentials in the CLI config file.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__93a4033dd2fa814eff8c120a0b36df585b366ba5690d0ea8158948ae43478626)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        props = CloudBackendConfig(
            organization=organization,
            workspaces=workspaces,
            hostname=hostname,
            token=token,
        )

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="getRemoteStateDataSource")
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        _from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(experimental) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param _from_stack: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ab9599e8c855f5116276150459ca5d982de60e52d665fc25b4a06b05e90c7fcf)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument _from_stack", value=_from_stack, expected_type=type_hints["_from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "getRemoteStateDataSource", [scope, name, _from_stack]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))

    @jsii.member(jsii_name="toMetadata")
    def to_metadata(self) -> typing.Any:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toMetadata", []))

    @jsii.member(jsii_name="toTerraform")
    def to_terraform(self) -> typing.Any:
        '''(experimental) Adds this resource to the terraform JSON output.

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "toTerraform", []))


class ConsulBackend(
    TerraformBackend,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.ConsulBackend",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        *,
        access_token: builtins.str,
        path: builtins.str,
        address: typing.Optional[builtins.str] = None,
        ca_file: typing.Optional[builtins.str] = None,
        cert_file: typing.Optional[builtins.str] = None,
        datacenter: typing.Optional[builtins.str] = None,
        gzip: typing.Optional[builtins.bool] = None,
        http_auth: typing.Optional[builtins.str] = None,
        key_file: typing.Optional[builtins.str] = None,
        lock: typing.Optional[builtins.bool] = None,
        scheme: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param access_token: (experimental) (Required) Access token.
        :param path: (experimental) (Required) Path in the Consul KV store.
        :param address: (experimental) (Optional) DNS name and port of your Consul endpoint specified in the format dnsname:port. Defaults to the local agent HTTP listener.
        :param ca_file: (experimental) (Optional) A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param cert_file: (experimental) (Optional) A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file.
        :param datacenter: (experimental) (Optional) The datacenter to use. Defaults to that of the agent.
        :param gzip: (experimental) (Optional) true to compress the state data using gzip, or false (the default) to leave it uncompressed.
        :param http_auth: (experimental) (Optional) HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either user or user:pass.
        :param key_file: (experimental) (Optional) A path to a PEM-encoded private key, required if cert_file is specified.
        :param lock: (experimental) (Optional) false to disable locking. This defaults to true, but will require session permissions with Consul and at least kv write permissions on $path/.lock to perform locking.
        :param scheme: (experimental) (Optional) Specifies what protocol to use when talking to the given address,either http or https. SSL support can also be triggered by setting then environment variable CONSUL_HTTP_SSL to true.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8aeeb49f8df5835b323d9dd988645ab759c0ecdf38856b4308342d050c259bae)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        props = ConsulBackendConfig(
            access_token=access_token,
            path=path,
            address=address,
            ca_file=ca_file,
            cert_file=cert_file,
            datacenter=datacenter,
            gzip=gzip,
            http_auth=http_auth,
            key_file=key_file,
            lock=lock,
            scheme=scheme,
        )

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="getRemoteStateDataSource")
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        _from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(experimental) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param _from_stack: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__96fceb6b449442d8ec652420f2ab681c60a0b82dd4629903d2deb046ba57f18e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument _from_stack", value=_from_stack, expected_type=type_hints["_from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "getRemoteStateDataSource", [scope, name, _from_stack]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))


class CosBackend(
    TerraformBackend,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.CosBackend",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        *,
        bucket: builtins.str,
        acl: typing.Optional[builtins.str] = None,
        encrypt: typing.Optional[builtins.bool] = None,
        key: typing.Optional[builtins.str] = None,
        prefix: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        secret_id: typing.Optional[builtins.str] = None,
        secret_key: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param bucket: (experimental) (Required) The name of the COS bucket. You shall manually create it first.
        :param acl: (experimental) (Optional) Object ACL to be applied to the state file, allows private and public-read. Defaults to private.
        :param encrypt: (experimental) (Optional) Whether to enable server side encryption of the state file. If it is true, COS will use 'AES256' encryption algorithm to encrypt state file.
        :param key: (experimental) (Optional) The path for saving the state file in bucket. Defaults to terraform.tfstate.
        :param prefix: (experimental) (Optional) The directory for saving the state file in bucket. Default to "env:".
        :param region: (experimental) (Optional) The region of the COS bucket. It supports environment variables TENCENTCLOUD_REGION.
        :param secret_id: (experimental) (Optional) Secret id of Tencent Cloud. It supports environment variables TENCENTCLOUD_SECRET_ID.
        :param secret_key: (experimental) (Optional) Secret key of Tencent Cloud. It supports environment variables TENCENTCLOUD_SECRET_KEY.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__026cc6545fae88e8ec74ac3845fbf01f2abb03784fe720277c575dd3f73bb5ed)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        props = CosBackendConfig(
            bucket=bucket,
            acl=acl,
            encrypt=encrypt,
            key=key,
            prefix=prefix,
            region=region,
            secret_id=secret_id,
            secret_key=secret_key,
        )

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="getRemoteStateDataSource")
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        _from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(experimental) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param _from_stack: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__c2ea829ead141c91eb857d1b7704e8d63db8aa2fe8e1e21a06445310097314e0)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument _from_stack", value=_from_stack, expected_type=type_hints["_from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "getRemoteStateDataSource", [scope, name, _from_stack]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))


class EtcdBackend(
    TerraformBackend,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.EtcdBackend",
):
    '''
    :deprecated: CDK for Terraform no longer supports the etcd backend. Terraform deprecated etcd in v1.2.3 and removed it in v1.3.

    :stability: deprecated
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        *,
        endpoints: builtins.str,
        path: builtins.str,
        password: typing.Optional[builtins.str] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param endpoints: (deprecated) (Required) A space-separated list of the etcd endpoints.
        :param path: (deprecated) (Required) The path where to store the state.
        :param password: (deprecated) (Optional) The password.
        :param username: (deprecated) (Optional) The username.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__919b03dde8d1ab229e6a3499a03732bed27daed712b8bf67bb5b1978b8c7cb40)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        props = EtcdBackendConfig(
            endpoints=endpoints, path=path, password=password, username=username
        )

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="getRemoteStateDataSource")
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        _from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(deprecated) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param _from_stack: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4f6b410714312ec523076e970d09dbe3fa59cf3ad0890301a33653d4d43a8120)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument _from_stack", value=_from_stack, expected_type=type_hints["_from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "getRemoteStateDataSource", [scope, name, _from_stack]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: deprecated
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))


class EtcdV3Backend(
    TerraformBackend,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.EtcdV3Backend",
):
    '''
    :deprecated: CDK for Terraform no longer supports the etcdv3 backend. Terraform deprecated etcdv3 in v1.2.3 and removed it in v1.3.

    :stability: deprecated
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        *,
        endpoints: typing.Sequence[builtins.str],
        cacert_path: typing.Optional[builtins.str] = None,
        cert_path: typing.Optional[builtins.str] = None,
        key_path: typing.Optional[builtins.str] = None,
        lock: typing.Optional[builtins.bool] = None,
        password: typing.Optional[builtins.str] = None,
        prefix: typing.Optional[builtins.str] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param endpoints: (deprecated) (Required) The list of 'etcd' endpoints which to connect to.
        :param cacert_path: (deprecated) (Optional) The path to a PEM-encoded CA bundle with which to verify certificates of TLS-enabled etcd servers.
        :param cert_path: (deprecated) (Optional) The path to a PEM-encoded certificate to provide to etcd for secure client identification.
        :param key_path: (deprecated) (Optional) The path to a PEM-encoded key to provide to etcd for secure client identification.
        :param lock: (deprecated) (Optional) Whether to lock state access. Defaults to true.
        :param password: (deprecated) (Optional) Password used to connect to the etcd cluster.
        :param prefix: (deprecated) (Optional) An optional prefix to be added to keys when to storing state in etcd. Defaults to "".
        :param username: (deprecated) (Optional) Username used to connect to the etcd cluster.

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cd59bae28652f26d73aa5f3560fdf5dd3e18c06f8b3d75b7a04efc5f9c0dcae7)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        props = EtcdV3BackendConfig(
            endpoints=endpoints,
            cacert_path=cacert_path,
            cert_path=cert_path,
            key_path=key_path,
            lock=lock,
            password=password,
            prefix=prefix,
            username=username,
        )

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="getRemoteStateDataSource")
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        _from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(deprecated) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param _from_stack: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7237c63c65f5026511c06dc97c08b7d8eaf3c44fba928ac27f70252e792ffe87)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument _from_stack", value=_from_stack, expected_type=type_hints["_from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "getRemoteStateDataSource", [scope, name, _from_stack]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: deprecated
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))


class GcsBackend(
    TerraformBackend,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.GcsBackend",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        *,
        bucket: builtins.str,
        access_token: typing.Optional[builtins.str] = None,
        credentials: typing.Optional[builtins.str] = None,
        encryption_key: typing.Optional[builtins.str] = None,
        impersonate_service_account: typing.Optional[builtins.str] = None,
        impersonate_service_account_delegates: typing.Optional[typing.Sequence[builtins.str]] = None,
        prefix: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param bucket: (experimental) (Required) The name of the GCS bucket. This name must be globally unique.
        :param access_token: (experimental) (Optional) A temporary [OAuth 2.0 access token] obtained from the Google Authorization server, i.e. the Authorization: Bearer token used to authenticate HTTP requests to GCP APIs. This is an alternative to credentials. If both are specified, access_token will be used over the credentials field.
        :param credentials: (experimental) (Optional) Local path to Google Cloud Platform account credentials in JSON format. If unset, Google Application Default Credentials are used. The provided credentials must have Storage Object Admin role on the bucket. Warning: if using the Google Cloud Platform provider as well, it will also pick up the GOOGLE_CREDENTIALS environment variable.
        :param encryption_key: (experimental) (Optional) A 32 byte base64 encoded 'customer supplied encryption key' used to encrypt all state.
        :param impersonate_service_account: (experimental) (Optional) The service account to impersonate for accessing the State Bucket. You must have roles/iam.serviceAccountTokenCreator role on that account for the impersonation to succeed. If you are using a delegation chain, you can specify that using the impersonate_service_account_delegates field. Alternatively, this can be specified using the GOOGLE_IMPERSONATE_SERVICE_ACCOUNT environment variable.
        :param impersonate_service_account_delegates: (experimental) (Optional) The delegation chain for an impersonating a service account.
        :param prefix: (experimental) (Optional) GCS prefix inside the bucket. Named states for workspaces are stored in an object called /.tfstate.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__50d60812a190bd6b04d7b41ed5952e8e716abf027c9a7b676cde6ff5c060b3b6)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        props = GcsBackendConfig(
            bucket=bucket,
            access_token=access_token,
            credentials=credentials,
            encryption_key=encryption_key,
            impersonate_service_account=impersonate_service_account,
            impersonate_service_account_delegates=impersonate_service_account_delegates,
            prefix=prefix,
        )

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="getRemoteStateDataSource")
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        _from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(experimental) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param _from_stack: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3b4e4584213e8eb915f377a91aa2cd2d99080ce4f2d9d7d378274617cd39d000)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument _from_stack", value=_from_stack, expected_type=type_hints["_from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "getRemoteStateDataSource", [scope, name, _from_stack]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))


class HttpBackend(
    TerraformBackend,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.HttpBackend",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        *,
        address: builtins.str,
        lock_address: typing.Optional[builtins.str] = None,
        lock_method: typing.Optional[builtins.str] = None,
        password: typing.Optional[builtins.str] = None,
        retry_max: typing.Optional[jsii.Number] = None,
        retry_wait_max: typing.Optional[jsii.Number] = None,
        retry_wait_min: typing.Optional[jsii.Number] = None,
        skip_cert_verification: typing.Optional[builtins.bool] = None,
        unlock_address: typing.Optional[builtins.str] = None,
        unlock_method: typing.Optional[builtins.str] = None,
        update_method: typing.Optional[builtins.str] = None,
        username: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param address: (experimental) (Required) The address of the REST endpoint.
        :param lock_address: (experimental) (Optional) The address of the lock REST endpoint. Defaults to disabled.
        :param lock_method: (experimental) (Optional) The HTTP method to use when locking. Defaults to LOCK.
        :param password: (experimental) (Optional) The password for HTTP basic authentication.
        :param retry_max: (experimental) (Optional) The number of HTTP request retries. Defaults to 2.
        :param retry_wait_max: (experimental) (Optional) The maximum time in seconds to wait between HTTP request attempts. Defaults to 30.
        :param retry_wait_min: (experimental) (Optional) The minimum time in seconds to wait between HTTP request attempts. Defaults to 1.
        :param skip_cert_verification: (experimental) (Optional) Whether to skip TLS verification. Defaults to false.
        :param unlock_address: (experimental) (Optional) The address of the unlock REST endpoint. Defaults to disabled.
        :param unlock_method: (experimental) (Optional) The HTTP method to use when unlocking. Defaults to UNLOCK.
        :param update_method: (experimental) (Optional) HTTP method to use when updating state. Defaults to POST.
        :param username: (experimental) (Optional) The username for HTTP basic authentication.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5a578141b0c9f33c1c4e8090a6eb3767ed89b4e883c4681f54a5aea68229f1da)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        props = HttpBackendConfig(
            address=address,
            lock_address=lock_address,
            lock_method=lock_method,
            password=password,
            retry_max=retry_max,
            retry_wait_max=retry_wait_max,
            retry_wait_min=retry_wait_min,
            skip_cert_verification=skip_cert_verification,
            unlock_address=unlock_address,
            unlock_method=unlock_method,
            update_method=update_method,
            username=username,
        )

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="getRemoteStateDataSource")
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        _from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(experimental) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param _from_stack: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__19c161930f88831fc8a27e3f5dc0b881286cf92ce593928c94934b64982de11d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument _from_stack", value=_from_stack, expected_type=type_hints["_from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "getRemoteStateDataSource", [scope, name, _from_stack]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))


class LocalBackend(
    TerraformBackend,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.LocalBackend",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        *,
        path: typing.Optional[builtins.str] = None,
        workspace_dir: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param path: (experimental) Path where the state file is stored. Default: - defaults to terraform.${stackId}.tfstate
        :param workspace_dir: (experimental) (Optional) The path to non-default workspaces.

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d5dd6279f9e2b2e81277662d01d74cb286255c78ddca37d7ee43069137028517)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        props = LocalBackendConfig(path=path, workspace_dir=workspace_dir)

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="getRemoteStateDataSource")
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(experimental) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param from_stack: -

        :stability: experimental
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8ae95b672acc5b1d8e3b06b94304fa992cc83c1d26cff3ca7689644ef745643b)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument from_stack", value=from_stack, expected_type=type_hints["from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "getRemoteStateDataSource", [scope, name, from_stack]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))


class MantaBackend(
    TerraformBackend,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.MantaBackend",
):
    '''
    :deprecated: CDK for Terraform no longer supports the manta backend. Terraform deprecated manta in v1.2.3 and removed it in v1.3.

    :stability: deprecated
    '''

    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        *,
        account: builtins.str,
        key_id: builtins.str,
        path: builtins.str,
        insecure_skip_tls_verify: typing.Optional[builtins.bool] = None,
        key_material: typing.Optional[builtins.str] = None,
        object_name: typing.Optional[builtins.str] = None,
        url: typing.Optional[builtins.str] = None,
        user: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param account: 
        :param key_id: 
        :param path: 
        :param insecure_skip_tls_verify: 
        :param key_material: 
        :param object_name: 
        :param url: 
        :param user: 

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1bfb00cce0a2620798c8f46d3433cc7829e2c11f1ef60791f2aeb18de4c709af)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
        props = MantaBackendConfig(
            account=account,
            key_id=key_id,
            path=path,
            insecure_skip_tls_verify=insecure_skip_tls_verify,
            key_material=key_material,
            object_name=object_name,
            url=url,
            user=user,
        )

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="getRemoteStateDataSource")
    def get_remote_state_data_source(
        self,
        scope: _constructs_77d1e7e8.Construct,
        name: builtins.str,
        _from_stack: builtins.str,
    ) -> TerraformRemoteState:
        '''(deprecated) Creates a TerraformRemoteState resource that accesses this backend.

        :param scope: -
        :param name: -
        :param _from_stack: -

        :stability: deprecated
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c72a6f4e228306cc9d483ea9fdc62f8b4bbbed70cb6622c92529b71163c03f8)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument _from_stack", value=_from_stack, expected_type=type_hints["_from_stack"])
        return typing.cast(TerraformRemoteState, jsii.invoke(self, "getRemoteStateDataSource", [scope, name, _from_stack]))

    @jsii.member(jsii_name="synthesizeAttributes")
    def _synthesize_attributes(self) -> typing.Mapping[builtins.str, typing.Any]:
        '''
        :stability: deprecated
        '''
        return typing.cast(typing.Mapping[builtins.str, typing.Any], jsii.invoke(self, "synthesizeAttributes", []))


class OssBackend(
    TerraformBackend,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdktf.OssBackend",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: _constructs_77d