__all__ = [
    "Curl",
    "AsyncCurl",
    "CurlMime",
    "CurlError",
    "CurlInfo",
    "CurlOpt",
    "CurlMOpt",
    "CurlECode",
    "CurlHttpVersion",
    "CurlSslVersion",
    "CurlWsFlag",
    "config_warnings",
    "ffi",
    "lib",
]

import _cffi_backend  # noqa: F401  # required by _wrapper

from .__version__ import __curl_version__, __description__, __title__, __version__  # noqa: F401

# This line includes _wrapper.so into the wheel
from ._wrapper import ffi, lib
from .aio import AsyncCurl
from .const import (
    CurlECode,
    CurlHttpVersion,
    CurlInfo,
    CurlMOpt,
    CurlOpt,
    CurlSslVersion,
    CurlWsFlag,
)
from .curl import Curl, CurlError, CurlMime
from .utils import config_warnings

config_warnings(on=False)
