# MD009 - Remove trailing spaces

## What this rule does

Removes unnecessary spaces at the end of lines to keep your Markdown clean and consistent.

## Why this matters

- **Clean diffs**: Trailing spaces create noisy changes in version control
- **Parser compatibility**: Some Markdown tools have issues with trailing whitespace
- **Professional quality**: Clean files without hidden characters look more polished
- **File size**: Removing unnecessary spaces reduces file size (slightly but it adds up!)

## Examples

### ✅ Correct

```markdown
This line ends cleanly
No extra spaces here
Perfect formatting
```

### ❌ Incorrect

<!-- rumdl-disable MD009 -->

```markdown
This line has trailing spaces  
Extra spaces at the end 
Why are these spaces here?   
```

<!-- rumdl-enable MD009 -->

### 🔧 Fixed

```markdown
This line ends cleanly
Extra spaces removed
Clean and tidy now
```

## Configuration

```yaml
MD009:
  br_spaces: 2      # Number of spaces for hard line breaks (default: 2)
  strict: false     # Remove all trailing spaces, even line breaks (default: false)
```

## Automatic fixes

This rule automatically removes trailing spaces from the end of lines. When `strict` is false, it preserves exactly 2 spaces (or your configured `br_spaces`) for intentional hard line breaks.

## Learn more

- [Line breaks in Markdown](https://www.markdownguide.org/basic-syntax/#line-breaks) - When trailing spaces are actually useful
- [CommonMark specification](https://spec.commonmark.org/0.31.2/#hard-line-breaks) - Technical details about line breaks

## Related rules

- [MD010](md010.md) - Use spaces instead of tabs
- [MD047](md047.md) - End files with a single newline
