# MD010 - Use spaces instead of tabs

## What this rule does

Replaces tab characters with spaces to ensure consistent indentation across all editors and platforms.

## Why this matters

- **Consistency**: Tabs display differently in different editors (2, 4, or 8 spaces wide)
- **Team collaboration**: Mixed tabs and spaces create confusing indentation and merge conflicts
- **Tool compatibility**: Many Markdown tools and platforms expect spaces for proper formatting
- **Readability**: Consistent spacing makes documents easier to read and maintain

## Examples

### ✅ Correct

```markdown
* Shopping list
  * Fruits
    * Apples
    * Bananas
  * Vegetables
    * Carrots
    * Broccoli

    Remember to check for freshness!
```

### ❌ Incorrect

<!-- rumdl-disable MD010 -->

```markdown
* Shopping list
	* Fruits
		* Apples
		* Bananas
	* Vegetables
		* Carrots
		* Broccoli

	Remember to check for freshness!
```

<!-- rumdl-enable MD010 -->

### 🔧 Fixed

```markdown
* Shopping list
    * Fruits
        * Apples
        * Bananas
    * Vegetables
        * Carrots
        * Broccoli

    Remember to check for freshness!
```

## Configuration

```yaml
MD010:
  code_blocks: true                     # Check for tabs in code blocks (default: true)
  spaces_per_tab: 4                     # Number of spaces to replace each tab with (default: 4)
  ignore_code_languages: []             # List of code languages to ignore (default: [])
```

### Configuration options explained

- `code_blocks`: Whether to check for tabs inside code blocks
- `spaces_per_tab`: How many spaces to use when replacing each tab character
- `ignore_code_languages`: List of code block languages where tabs are allowed (useful for languages like Makefile where tabs are required)

### Example with ignored languages

```yaml
MD010:
  code_blocks: true
  spaces_per_tab: 4
  ignore_code_languages:
    - makefile
    - make
    - Makefile
    - go.mod
```

With this configuration, tabs will be allowed in code blocks marked with these languages:

````markdown
```makefile
# Tabs are required in Makefiles
target:
	command with tab
```

```python
# Tabs will be replaced with spaces here
def function():
	return value
```
````

## Automatic fixes

This rule automatically replaces each tab character with the configured number of spaces (default: 4). This ensures your document looks the same in every editor.

## Learn more

- [Tabs vs Spaces](https://www.markdownguide.org/basic-syntax/#tabs) - Why spaces are preferred in Markdown
- [CommonMark specification](https://spec.commonmark.org/0.31.2/#tabs) - Technical details about tab handling

## Related rules

- [MD009](md009.md) - Remove trailing spaces
- [MD007](md007.md) - Keep list indentation consistent
- [MD005](md005.md) - Keep list indentation consistent
