# MD026 - Keep headings clean and professional

## What this rule does

Removes unnecessary punctuation from the end of headings, while intelligently allowing question marks, exclamation points, and colons when they make sense.

## Why this matters

- **Professional appearance**: Clean headings look more polished and professional
- **Better readability**: Unnecessary punctuation can distract readers
- **Consistent style**: Maintains a uniform look throughout your document
- **Navigation clarity**: Clean headings work better in tables of contents and outlines

## Examples

### ✅ Correct

```markdown
# Introduction

## FAQ: Frequently Asked Questions

### What is Markdown?

#### Important!

##### Step 1: Setup
```

### ❌ Incorrect

<!-- rumdl-disable MD026 -->

```markdown
# This is a sentence.

## Random heading;

### This seems wrong,
```

<!-- rumdl-enable MD026 -->

### 🔧 Fixed

```markdown
# This is a sentence

## Random heading

### This seems wrong
```

## Configuration

```yaml
MD026:
  punctuation: ".,;" # Characters to remove from heading endings (default: ".,;")
```

## Automatic fixes

This rule will:
- Remove periods, commas, and semicolons from heading endings
- Preserve question marks for questions ("What is Markdown?")
- Keep exclamation points for emphasis ("Important!")
- Allow colons in categorical headings ("Step 1: Setup", "FAQ: Common Questions")

## Learn more

- [CommonMark Spec: ATX headings](https://spec.commonmark.org/0.31.2/#atx-headings)
- [CommonMark Spec: Setext headings](https://spec.commonmark.org/0.31.2/#setext-headings)

## Related rules

- [MD001 - Keep heading levels organized](md001.md)
- [MD003 - Use consistent heading styles](md003.md)
- [MD025 - Keep your document organized with one main title](md025.md)
