# MD036 - Use real headings, not just bold text

## What this rule does

Detects when bold or italic text is used as a standalone heading and converts it to proper heading syntax.

## Why this matters

- **Better document structure**: Real headings create a proper outline that tools can understand
- **Improved accessibility**: Screen readers rely on heading tags to navigate documents
- **Enables navigation**: Proper headings allow table of contents generation and quick jumping
- **Cleaner formatting**: Headings have consistent styling across different viewers

## Examples

<!-- rumdl-disable MD036 -->

### ✅ Correct

Using proper heading syntax:

```markdown
# Main Title

## Section Heading

This paragraph contains **bold text** and *italic text* inline.

**Table of Contents**  <!-- Allowed exception -->
```

### ❌ Incorrect

Using emphasis as headings:

```markdown
**This looks like a heading**

*Another section title*

***Important Section***

**Configuration:**
```

### 🔧 Fixed

Converted to proper headings:

```markdown
## This looks like a heading

# Another section title

### Important Section

## Configuration
```

<!-- rumdl-enable MD036 -->

## Configuration

```yaml
MD036:
  punctuation: ".,;:!?"  # Characters to remove from heading ends
```

### Options

- `punctuation`: String of punctuation marks to remove when converting (default: `".,;:!?"`)
  - Set to `""` to keep all punctuation
  - Customize to remove only specific marks

## Automatic fixes

This rule will:
- Convert standalone bold/italic lines to proper headings
- Remove trailing punctuation based on your configuration
- Choose appropriate heading level (## for bold, # for italic)
- Preserve common labels like "Table of Contents" as-is

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings)
- [Web Content Accessibility Guidelines (WCAG) on headings](https://www.w3.org/WAI/WCAG21/Understanding/info-and-relationships.html)

## Related rules

- [MD001 - Heading increment](md001.md) - Ensure heading levels increase properly
- [MD003 - Heading style](md003.md) - Keep heading formats consistent
- [MD018 - No missing space in ATX heading](md018.md) - Ensure proper heading spacing
