# MD042 - Avoid Empty Links

## What this rule does

Detects links that are missing either their text or URL, ensuring all links are complete and functional.

## Why this matters

- **User frustration**: Clicking empty links leads nowhere and confuses readers
- **Accessibility issues**: Screen readers can't describe links without text
- **Professional quality**: Empty links look like mistakes or unfinished work
- **SEO impact**: Search engines penalize broken or empty links

## Examples

### ✅ Correct

```markdown
[Visit our website](https://example.com)

[Download the guide](downloads/guide.pdf)

Check out the [documentation][docs]

[docs]: https://docs.example.com
```

### ❌ Incorrect  

```markdown
[](https://example.com)         <!-- Missing link text -->

[Click here]()                  <!-- Missing URL -->

[ ](https://example.com)        <!-- Only spaces as text -->

[Visit our website]()           <!-- Forgot to add URL -->
```

### 🔧 Fixed

```markdown
[Link](https://example.com)     <!-- Added generic text -->

[Click here](#)                 <!-- Added placeholder URL -->

[Link](https://example.com)     <!-- Replaced spaces with text -->

[Visit our website](#)          <!-- Added placeholder URL -->
```

## Configuration

This rule has no configuration options.

## Automatic fixes

When enabled, this rule will:
- Add generic text "Link" for empty link text
- Add placeholder "#" for empty URLs
- Replace these placeholders with meaningful content after fixing

## Special cases

- Image links (starting with `!`) are not checked by this rule
- Reference-style links are checked for both parts
- Links with only whitespace are considered empty

## Learn more

- [CommonMark specification for links](https://spec.commonmark.org/0.31.2/#links)
- [Writing meaningful link text](https://www.w3.org/WAI/WCAG21/Understanding/link-purpose-in-context.html)

## Related rules

- [MD034](md034.md) - Format bare URLs properly
- [MD039](md039.md) - Remove spaces inside link text
- [MD051](md051.md) - Ensure link fragments are valid
