# MD055 - Keep table formatting consistent

## What this rule does

Ensures all rows in your tables use the same style for leading and trailing pipe characters (|).

## Why this matters

- **Visual consistency**: Mixed pipe styles make tables look messy and unprofessional
- **Easier editing**: Consistent formatting makes it easier to add or modify table rows
- **Better alignment**: Uniform pipe placement helps maintain column alignment
- **Parser compatibility**: Some Markdown parsers require specific pipe styles

## Examples

<!-- rumdl-disable MD055 -->

### ✅ Correct (with leading and trailing pipes)

```markdown
| Name     | Role      | Department |
| -------- | --------- | ---------- |
| Alice    | Manager   | Sales      |
| Bob      | Developer | IT         |
```

### ✅ Correct (without leading and trailing pipes)

```markdown
Name     | Role      | Department
-------- | --------- | ----------
Alice    | Manager   | Sales
Bob      | Developer | IT
```

### ❌ Incorrect (mixed styles)

```markdown
| Name     | Role      | Department |
| -------- | --------- | ---------- |
Alice    | Manager   | Sales
| Bob      | Developer | IT         |
```

### 🔧 Fixed

```markdown
| Name     | Role      | Department |
| -------- | --------- | ---------- |
| Alice    | Manager   | Sales      |
| Bob      | Developer | IT         |
```

<!-- rumdl-enable MD055 -->

## Configuration

```yaml
MD055:
  style: "consistent"  # Options: see below
```

### Style options

- **`consistent`** (default): Match the style of the first table row
- **`leading_and_trailing`**: Require pipes at start and end: `| cell |`
- **`leading_only`**: Require pipes only at start: `| cell`
- **`trailing_only`**: Require pipes only at end: `cell |`
- **`no_leading_or_trailing`**: No pipes at start or end: `cell`

## Automatic fixes

This rule can automatically fix issues by:

- Adding missing leading pipes when required
- Adding missing trailing pipes when required
- Removing extra pipes when not allowed
- Making all rows match the configured style

## Learn more

- [Markdown Guide: Tables](https://www.markdownguide.org/extended-syntax/#tables)
- [GitHub Flavored Markdown: Tables](https://github.github.com/gfm/#tables-extension-)

## Related rules

- [MD056 - Keep table column count consistent](md056.md)
- [MD058 - Add blank lines around tables](md058.md)
