# MD057 - Check that file links work

## What this rule does

Verifies that relative links to other files in your documentation actually point to files that exist.

## Why this matters

- **Prevents frustration**: Broken links waste readers' time and damage trust
- **Maintains quality**: Working links show your documentation is well-maintained
- **Aids navigation**: Readers can confidently explore your documentation
- **Catches typos**: Common mistakes in file paths are caught early

## Examples

<!-- rumdl-disable MD057 MD031 MD040 -->

### ✅ Correct

```markdown
[Installation Guide](install.md)          <!-- File exists -->
[Contributing](../CONTRIBUTING.md)        <!-- File exists -->
[GitHub Repo](https://github.com/org/repo) <!-- External URL -->
[Email Us](mailto:help@example.com)       <!-- Email link -->
[Jump to Section](#configuration)         <!-- Same-file anchor -->
```

### ❌ Incorrect

```markdown
[Missing Doc](does-not-exist.md)           <!-- File doesn't exist -->
[Bad Path](../missing/guide.md)            <!-- Path doesn't exist -->
[Typo in Name](READNE.md)                 <!-- Should be README.md -->
[Wrong Extension](setup.markdown)          <!-- File is setup.md -->
```

### 🔧 Fixed

This rule cannot automatically fix broken links because it can't know which file you intended to link to. You must manually:

1. Correct the file path
2. Create the missing file
3. Or remove the broken link

<!-- rumdl-enable MD057 MD031 MD040 -->

## Configuration

This rule has no configuration options - it's either enabled or disabled.

```yaml
MD057: true
```

## Automatic fixes

This rule does not provide automatic fixes. Broken links must be corrected manually by:

- Fixing typos in file names
- Updating paths after moving files
- Creating missing documentation files
- Removing links to deleted files

## Learn more

- [Markdown Guide: Links](https://www.markdownguide.org/basic-syntax/#links)
- [Writing good documentation](https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/)

## Related rules

- [MD051 - Fix broken link fragments](md051.md)
- [MD042 - Ensure links have content](md042.md)
- [MD034 - Format bare URLs properly](md034.md)
