<p align="center">
  <img alt="lgtm-logo" width="150" src="./assets/lgtm-large.png">
</p>

# lgtm-ai

![Python Version](https://img.shields.io/badge/python-3.12%20|%203.13-blue?logo=python&logoColor=yellow)
![Build Status](https://github.com/elementsinteractive/lgtm-ai/actions/workflows/test.yml/badge.svg)
[![Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json)](https://github.com/astral-sh/ruff)
[![PyPI version](https://img.shields.io/pypi/v/lgtm-ai)](https://pypi.org/project/lgtm-ai/)
[![License](https://img.shields.io/github/license/elementsinteractive/lgtm-ai)](LICENSE)

---

lgtm-ai is your AI-powered code review companion. It generates code reviews using your favorite LLMs and helps human reviewers with detailed, context-aware reviewer guides. Supports GitHub, GitLab, and major AI models including GPT-4, Claude, Gemini, and more.

**Table of Contents**
- [Quick Usage](#quick-usage)
  - [Review](#review)
  - [Reviewer Guide](#reviewer-guide)
- [Installation](#installation)
- [How it works](#how-it-works)
  - [Review scores and comment categories](#review-scores-and-comment-categories)
  - [Supported Code Repository Services](#supported-code-repository-services)
  - [Supported AI models](#supported-ai-models)
    - [OpenAI](#openai)
    - [Google Gemini](#google-gemini)
    - [Anthropic's Claude](#anthropics-claude)
    - [Mistral AI](#mistral-ai)
    - [DeepSeek](#deepseek)
    - [Local models](#local-models)
  - [CI/CD Integration](#cicd-integration)
  - [Configuration](#configuration)
    - [Configuration file](#configuration-file)
- [Contributing](#contributing)
  - [Running the project](#running-the-project)
  - [Managing requirements](#managing-requirements)
  - [Commit messages](#commit-messages)
- [Contributors ✨](#contributors-)


## Quick Usage

### Review

```sh
 lgtm review --pr-url "https://gitlab.com/your-repo/-/merge-requests/42" \
             --ai-api-key $OPENAI_API_KEY \
             --git-api-key $GITLAB_TOKEN \
             --model gpt-4.1 \
             --publish
```

This will generate a **review** like this one:

<img src="./assets/review.png" alt="lgtm-review" height="250"/>
<br/>
<img src="./assets/review-comment.png" alt="lgtm-review-comment" height="250"/>


### Reviewer Guide

```sh
 lgtm guide --pr-url "https://gitlab.com/your-repo/-/merge-requests/42" \
             --ai-api-key $OPENAI_API_KEY \
             --git-api-key $GITLAB_TOKEN \
             --model gpt-4.1 \
             --publish
```

This will generate a **reviewer guide** like this one:

<img src="./assets/reviewer-guide.png" alt="lgtm-review-guide" height="250"/>

## Installation

```sh
pip install lgtm-ai
```

Or you can use the official Docker image:

```sh
docker pull elementsinteractive/lgtm-ai
```

## How it works

lgtm reads the given pull request and feeds it to several AI agents to generate a code review or a reviewer guide. The philosophy of lgtm is to keep the models out of the picture and totally configurable, so that you can choose which model to use based on pricing, security, data privacy, or whatever is important to you.

If instructed (with the option `--publish`), lgtm will publish the review or guide to the pull request page as comments.

### Review scores and comment categories

Reviews generated by lgtm will be assigned a **score**, using the following scale:

| Score |  Description |
| ------ | --- |
| LGTM  👍 |  The PR is generally ready to be merged. |
| Nitpicks  🤓 |  There are some minor issues, but the PR is almost ready to be merged. |
| Needs Work  🔧 |  There are some issues with the PR, and it is not ready to be merged. The approach is generally good, the fundamental structure is there, but there are some issues that need to be fixed. |
| Needs a Lot of Work 🚨 |  Issues are major, overarching, and/or numerous. However, the approach taken is not necessarily wrong. |
| Abandon ❌  |  The approach taken is wrong, and the author needs to start from scratch. The PR is not ready to be merged as is at all. |

For each review, lgtm may create several inline comments, pointing out specific issues within the PR. These comments belong to a **category** and have a **severity**. You can configure which categories you want lgtm to take a look at (see the [configuration section below](./README.md#configuration-file)). The available categories are:

| Category | Description |
| -------  | ----------- | 
| Correctness 🎯 | Does the code behave as intended? Identifies logical errors, bugs, incorrect algorithms, broken functionality, or deviations from requirements. |
| Quality ✨ | Is the code clean, readable, and maintainable? Evaluates naming, structure, modularity, and adherence to clean code principles (e.g., SOLID, DRY, KISS). |
| Testing 🧪 | Are there sufficient and appropriate tests? Includes checking for meaningful test coverage, especially for edge cases and critical paths. Are tests isolated, reliable, and aligned with the behavior being verified? |
| Security 🔒 | Does the code follow secure programming practices? Looks for common vulnerabilities such as injection attacks, insecure data handling, improper access control, hardcoded credentials, or lack of input validation. |

There are three available severities for comments:

- LOW 🔵
- MEDIUM 🟡
- HIGH 🔴

### Supported Code Repository Services

lgtm aims to work with as many services as possible, and that includes remote repository providers. At the moment, lgtm supports:

- [GitLab](https://gitlab.com) (only gitlab.com, not self-hosted)
- [GitHub](https://github.com)

lgtm will autodetect the url of the pull request passed to `--pr-url` automatically.

### Supported AI models

lgtm supports several AI models so you can hook up your preferred LLM to perform reviews for you.

This is the full list of supported models:

#### OpenAI

Check out the OpenAI platform page to see [all available models provided by OpenAI](https://platform.openai.com/docs/overview).

To use OpenAI LLMs, you need to provide lgtm with an API Key, which can be generated in the [OpenAI platform page for your project, or your user](https://platform.openai.com/api-keys).


<details>

<summary>Supported OpenAI models</summary>

These are the main supported models, though the CLI may support additional ones due to the use of [pydantic-ai](https://ai.pydantic.dev).

| Model name |
| -------- |
| gpt-5 |
| gpt-5-mini |
| gpt-4.1 |
| gpt-4.1-mini |
| gpt-4.1-nano |
| gpt-4o * |
| gpt-4o-mini |
| o4-mini |
| o3-mini |
| o3 |
| o1-preview |
| o1-mini |
| o1 |
| gpt-4-turbo |
| gpt-4 |
| gpt-3.5-turbo |
| chatgpt-4o-latest |

</details>

#### Google Gemini

Check out the [Gemini developer docs](https://ai.google.dev/gemini-api/docs/models) to see all models provided by Google.

To use Gemini LLMs, you need to provide lgtm an API Key, which can be generated [here](https://aistudio.google.com/apikey). 

These are the main supported models, though the CLI may support additional ones due to the use of [pydantic-ai](https://ai.pydantic.dev). Gemini timestamps models, so be sure to always use the latest model of each family, if possible.


For Gemini models exclusively, you can provide a wildcard at the end of the model name and lgtm will attempt to select the latest model (e.g., `gemini-2.5-pro*`)


<details>

<summary>Supported Google's Gemini models</summary>


| Model name |
| ----------- |
| gemini-2.5-pro |
| gemini-2.5-pro-preview-06-05 |
| gemini-2.5-pro-preview-05-06 |
| gemini-2.5-flash |
| gemini-2.0-pro-exp-02-05 |
| gemini-2.0-flash |
| gemini-1.5-pro |
| gemini-1.5-flash |

</details>

#### Anthropic's Claude

Check out [Anthropic documentation](https://docs.anthropic.com/en/docs/about-claude/models/all-models) to see which models they provide. lgtm works with a subset of Claude models. To use Anthropic LLMs, you need to provide lgtm with an API Key, which can be generated from the [Anthropic Console](https://console.anthropic.com/dashboard).

<details>

<summary>Supported Anthropic models</summary>

These are the main supported models, though the CLI may support additional ones due to the use of [pydantic-ai](https://ai.pydantic.dev).

| Model name |
| ---------------------------- |
| claude-sonnet-4-0 |
| claude-3-7-sonnet-latest |
| claude-3-5-sonnet-latest |
| claude-3-5-haiku-latest |
| claude-3-opus-latest |

</details>

#### Mistral AI

Check out the [Mistral documentation](https://docs.mistral.ai/getting-started/models/models_overview/) to see all models provided by Mistral.

To use Mistral LLMs, you need to provide lgtm with an API Key, which can be generated from Mistral's [Le Platforme](https://console.mistral.ai/api-keys).

<details>

<summary>Supported Mistral AI models</summary>

These are the main supported models, though the CLI may support additional ones due to the use of [pydantic-ai](https://ai.pydantic.dev).

| Model name |
| ------------------ |
| mistral-large-latest |
| mistral-small |
| codestrallatest |

</details>

#### DeepSeek

Check out the [DeepSeek documentation](https://api-docs.deepseek.com/quick_start/pricing) to see all models provided by DeepSeek.

At the moment, lgtm only supports DeepSeek from `https://api.deepseek.com`: other providers and custom URLs are not supported. However, this is in our roadmap!

To get an API key for DeepSeek, create one at [DeepSeek Platform](https://platform.deepseek.com/usage).

<details>

<summary>Supported DeepSeek models</summary>

| Model name |
| ----------- |
| deepseek-chat |
| deepseek-reasoner |

</details>

#### Local models

You can run lgtm against a model available at a custom url (say, models running with [ollama](https://ollama.com) at http://localhost:11434/v1). These models need to be compatible with OpenAI. In that case, you need to pass the option `--model-url` (and you can choose to skip the option `--ai-api-token`). Check out the [pydantic-ai documentation](https://ai.pydantic.dev/models/openai/#openai-responses-api) to see more information about how lgtm interacts with these models.

```sh
lgtm review \
  --pr-url https://github.com/group/repo/pull/1 \
  --model llama3.2 \
  --model-url http://localhost:11434/v1 \
  ...
```

### CI/CD Integration

lgtm is meant to be integrated into your CI/CD pipeline, so that PR authors can choose to request reviews by running the necessary pipeline step.

For GitLab, you can use this .gitlab-ci.yml step as inspiration:

```yaml
lgtm-review:
  image:
    name: docker.io/elementsinteractive/lgtm-ai
    entrypoint: [""]
  stage: ai-review
  needs: []
  rules:
   - if: $CI_MERGE_REQUEST_ID
  when: manual
  script:
    - lgtm review --pr-url ${MR_URL} --git-api-key ${LGTM_GIT_API_KEY} --ai-api-key ${LGTM_AI_API_KEY} -v
  variables:
    MR_URL: "${CI_PROJECT_URL}/-/merge_requests/${CI_MERGE_REQUEST_IID}"
```

For GitHub, you can use the official LGTM AI GitHub Action:

```yaml
- name: AI Code Review
  uses: elementsinteractive/lgtm-ai@v1
  with:
    ai-api-key: ${{ secrets.AI_API_KEY }}
    git-api-key: ${{ secrets.GITHUB_TOKEN }}
    model: 'gpt-5'
    pr-number: ${{ github.event.issue.number }}
```

You can also check out this repo's [lgtm workflow](./.github/workflows/lgtm.yml) for a complete example with comment triggers (`/lgtm review`).

### Configuration

You can customize how lgtm works by passing cli arguments to it on invocation, or by using the *lgtm configuration file*. 

#### Configuration file

lgtm uses a `.toml` file to configure how it works. It will autodetect a `lgtm.toml` file in the current directory, or you can pass a specific file path with the CLI option `--config <path>`. These are the available options at the moment:

- **technologies**: You can specify, as a list of free strings, which technologies lgtm specializes in. This can be helpful for directing the reviewer towards specific technologies. By default, lgtm won't assume any technology and will just review the PR considering itself an "expert" in it.
- **categories**: lgtm will, by default, evaluate several areas of the given PR (`Quality`, `Correctness`, `Testing`, and `Security`). You can choose any subset of these (e.g.: if you are only interested in `Correctness`, you can configure `categories` so that lgtm does not evaluate the other missing areas).
- **model**: Choose which AI model you want lgtm to use.
- **model_url**: When not using one of the specific supported models from the providers mentioned above, you can pass a custom url where the model is deployed.
- **exclude**: Instruct lgtm to ignore certain files. This is important to reduce noise in reviews, but also to reduce the amount of tokens used for each review (and to avoid running into token limits). You can specify file patterns (`exclude = ["*.md", "package-lock.json"]`)
- **output_format**: Format of the terminal output of lgtm. Can be `pretty` (default), `json`, and `markdown`.
- **silent**: Do not print the review in the terminal.
- **publish**: If `true`, it will post the review as comments on the PR page.
- **ai_api_key**: API key to call the selected AI model. Can be given as a CLI argument, or as an environment variable (`LGTM_AI_API_KEY`).
- **git_api_key**: API key to post the review in the source system of the PR. Can be given as a CLI argument, or as an environment variable (`LGTM_GIT_API_KEY`). This is required to not be empty if using a non-local model.
- **ai_retries**: How many times to retry calls to the LLM when they do not succeed. By default, this is set to 1 (no retries at all).
- **ai_input_tokens_limit**: Set a limit on the input tokens sent to the LLM in total. Default is 500,000. To disable the limit, you can pass the string `"no-limit"`.
- **additional_context**: TOML array of extra context to send to the LLM. It supports setting the context directly in the `context` field, passing a relative file path so that lgtm downloads it from the repository, or passing any URL from which to download the context. Each element of the array must contain `prompt`, and either `context` (directly injecting context) or `file_url` (for directing lgtm to download it from there).

**Example `lgtm.toml`:**

```toml
technologies = ["Django", "Python"]
categories = ["Correctness", "Quality", "Testing", "Security"]
exclude = ["*.md"]
model = "gpt-4.1"
silent = false
publish = true
ai_retries = 1
ai_input_tokens_limit = 30000

[[additional_context]]
prompt = "These are the development guidelines for the team, ensure the PR follows them"
file_url = "https://my.domain.com/dev-guidelines.md"

[[additional_context]]
prompt = "CI pipeline for the repo. Do not report issues that this pipeline would otherwise catch"
file_url = ".github/workflows/pr.yml"

[[additional_context]]
prompt = "Consider these points when making your review"
context = '''
- We avoid using libraries and rely mostly on the stdlib.
- We follow the newest syntax available for Python (3.13).
'''
```

Alternatively, lgtm also supports [pyproject.toml](https://packaging.python.org/en/latest/guides/writing-pyproject-toml/) files, you just need to nest the options inside `[tool.lgtm]`.

When it comes to preference for selecting options, lgtm follows this preference order:

  `CLI options` > `lgtm.toml` > `pyproject.toml`


## Contributing

### Running the project

This project uses [`just`](https://github.com/casey/just) recipes to do all the basic operations (testing the package, formatting the code, etc.).

Installation: 

```sh
brew install just
# or
snap install --edge --classic just
```

It requires [poetry](https://python-poetry.org/docs/#installation).

These are the available commands for the justfile:

```
Available recipes:
    help                        # Shows list of recipes.
    venv                        # Generate the virtual environment.
    clean                       # Cleans all artifacts generated while running this project, including the virtualenv.
    test *test-args=''          # Runs the tests with the specified arguments (any path or pytest argument).
    t *test-args=''             # alias for `test`
    test-all                    # Runs all tests including coverage report.
    format                      # Format all code in the project.
    lint                        # Lint all code in the project.
    pre-commit *precommit-args  # Runs pre-commit with the given arguments (defaults to install).
    spellcheck *codespell-args  # Spellchecks your markdown files.
    lint-commit                 # Lints commit messages according to conventional commit rules.
```

To run the tests of this package, simply run:

```sh
# All tests
just t

# A single test
just t tests/test_dummy.py

# Pass arguments to pytest like this
just t -k test_dummy -vv
```

### Managing requirements

`poetry` is the tool we use for managing requirements in this project. The generated virtual environment is kept within the directory of the project (in a directory named `.venv`), thanks to the option `POETRY_VIRTUALENVS_IN_PROJECT=1`. Refer to the [poetry documentation](https://python-poetry.org/docs/cli/) to see the list of available commands.

As a short summary:

- Add a dependency:

        poetry add foo-bar

- Remove a dependency:

        poetry remove foo-bar

- Update a dependency (within constraints set in `pyproject.toml`):

        poetry update foo-bar

- Update the lockfile with the contents of `pyproject.toml` (for instance, when getting a conflict after a rebase):

        poetry lock

- Check if `pyproject.toml` is in sync with `poetry.lock`:

        poetry lock --check

### Commit messages

In this project we enforce [conventional commits](https://www.conventionalcommits.org) guidelines for commit messages. The usage of [commitizen](https://commitizen-tools.github.io/commitizen/) is recommended, but not required. Story numbers (JIRA, etc.) must go in the scope section of the commit message. Example message:

```
feat(#<issue-number>): add new feature x
```

Merge requests must be approved before they can be merged to the `main` branch, and all the steps in the `ci` pipeline must pass.

This project includes an optional pre-commit configuration. Note that all necessary checks are always executed in the ci pipeline, but
configuring pre-commit to execute some of them can be beneficial to reduce late errors. To do so, simply execute the following just recipe:

```sh
just pre-commit
```

Feel free to create [GitHub Issues](https://github.com/elementsinteractive/lgtm-ai/issues) for any feature request, bug, or suggestion!

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/scastlara"><img src="https://avatars.githubusercontent.com/u/7606872?v=4?s=50" width="50px;" alt="Sergio Castillo"/><br /><sub><b>Sergio Castillo</b></sub></a><br /><a href="https://github.com/elementsinteractive/lgtm-ai/commits?author=scastlara" title="Code">💻</a> <a href="#design-scastlara" title="Design">🎨</a> <a href="#ideas-scastlara" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-scastlara" title="Maintenance">🚧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jbozanowski"><img src="https://avatars.githubusercontent.com/u/114900?v=4?s=50" width="50px;" alt="Jakub Bożanowski"/><br /><sub><b>Jakub Bożanowski</b></sub></a><br /><a href="https://github.com/elementsinteractive/lgtm-ai/commits?author=jbozanowski" title="Code">💻</a> <a href="#ideas-jbozanowski" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-jbozanowski" title="Maintenance">🚧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sacha-c"><img src="https://avatars.githubusercontent.com/u/3247529?v=4?s=50" width="50px;" alt="Sacha Brouté"/><br /><sub><b>Sacha Brouté</b></sub></a><br /><a href="https://github.com/elementsinteractive/lgtm-ai/commits?author=sacha-c" title="Code">💻</a> <a href="#ideas-sacha-c" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sdn4z"><img src="https://avatars.githubusercontent.com/u/13658011?v=4?s=50" width="50px;" alt="Daniel"/><br /><sub><b>Daniel</b></sub></a><br /><a href="#ideas-sdn4z" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Rooni"><img src="https://avatars.githubusercontent.com/u/916242?v=4?s=50" width="50px;" alt="Rooni"/><br /><sub><b>Rooni</b></sub></a><br /><a href="https://github.com/elementsinteractive/lgtm-ai/commits?author=Rooni" title="Code">💻</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!