# -*- coding: utf-8 -*-
"""P2-1 Find-S.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1f8yD_lr15trt6SrY0k7GkzBGPc-iHKDR
"""

import pandas as pd
import numpy as np

data = pd.read_csv('/content/lab1.csv')
data

concepts = np.array(data)[:,:-1]
concepts

target = np.array(data)[:,-1]
target

def train(con,tar):
	for i,val in enumerate(tar):
		if val == 'yes':
			specific_h = con[i].copy()
			break
	for i,val in enumerate(con):
		if tar[i] == 'yes':
			for x in range(len(specific_h)):
				if val[x] != specific_h[x]:
					specific_h[x] = '?'
				else:
					pass
	return specific_h

print(train(concepts,target))

# my code

# ✅ Improved FIND-S Algorithm Implementation

import pandas as pd
import numpy as np

# Load dataset
data = pd.read_csv(r"/content/lab1.csv")

# Display the data
print("Dataset:\n", data, "\n")

# Separate features (concepts) and target
concepts = data.iloc[:, :-1].values
target = data.iloc[:, -1].values

# FIND-S algorithm definition
def find_s(concepts, target):
    # Step 1: Initialize specific hypothesis with the first positive example
    specific_h = None
    for i, val in enumerate(target):
        if val.lower() == 'yes':
            specific_h = concepts[i].copy()
            break

    # Step 2: Generalize only when necessary
    for i, val in enumerate(target):
        if val.lower() == 'yes':
            for j in range(len(specific_h)):
                if concepts[i][j] != specific_h[j]:
                    specific_h[j] = '?'

    return specific_h

# Train the model
final_hypothesis = find_s(concepts, target)

# Display results
print("✅ Final Specific Hypothesis:\n", final_hypothesis)

