# -*- coding: utf-8 -*-
"""P3-2-Logistic Regression algorithm.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1jJpY0R35HT2AXPM9yNTJwX6JqW5Q6Zta
"""

import pandas as pd
from matplotlib import pyplot as plt
df = pd.read_csv("/content/insurance_data.csv")
df.head()
plt.scatter(df.Age,df.have_insurance,marker='+',color='red')
plt.show()
from sklearn.model_selection import train_test_split
X_train, X_test, Y_train, Y_test = train_test_split(df[['Age']],df.have_insurance,test_size=0.1)
from sklearn.linear_model import LogisticRegression
model = LogisticRegression()
model.fit(X_train, Y_train)#Training the model
model.predict(X_test)#Prediction on the test set
model.score(X_test,Y_test)#Calculating the accuracy
model.predict_proba(X_test)#Predicting the probabilities

#my coode

import pandas as pd
import matplotlib.pyplot as plt
from sklearn.model_selection import train_test_split
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import confusion_matrix, classification_report, accuracy_score

# Load dataset
df = pd.read_csv(r'/content/insurance_data.csv')

# Display first few rows
print("Dataset Preview:\n", df.head())

# Visualize the data
plt.figure(figsize=(8, 5))
plt.scatter(df['Age'], df['have_insurance'], marker='+', color='red')
plt.title('Insurance Data Distribution')
plt.xlabel('Age')
plt.ylabel('Has Insurance (0 = No, 1 = Yes)')
plt.grid(True)
plt.show()

# Split data into train and test
X_train, X_test, y_train, y_test = train_test_split(
    df[['Age']], df['have_insurance'], test_size=0.2, random_state=42
)

# Train Logistic Regression model
model = LogisticRegression()
model.fit(X_train, y_train)

# Predictions
y_pred = model.predict(X_test)
y_prob = model.predict_proba(X_test)[:, 1]

# Model evaluation
accuracy = accuracy_score(y_test, y_pred)
print(f"✅ Model Accuracy: {accuracy:.4f}\n")

print("🔹 Classification Report:\n", classification_report(y_test, y_pred))
print("🔹 Confusion Matrix:\n", confusion_matrix(y_test, y_pred))

# Plot logistic curve
plt.figure(figsize=(8, 5))
plt.scatter(df['Age'], df['have_insurance'], color='blue', label='Actual Data')
X_range = pd.DataFrame({'Age': range(int(df['Age'].min()), int(df['Age'].max()))})
plt.plot(X_range, model.predict_proba(X_range)[:, 1], color='red', label='Logistic Curve')
plt.title('Logistic Regression Fit')
plt.xlabel('Age')
plt.ylabel('Probability of Having Insurance')
plt.legend()
plt.grid(True)
plt.show()

