# -*- coding: utf-8 -*-
"""P5-2-k-Nearest Neighbour algorithm.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/11ueW4m9D1Cgcs82q8_mtcg4Vgh5Qb0zi
"""

import pandas as pd
import numpy as np
from matplotlib import pyplot as plt
from sklearn.neighbors import KNeighborsClassifier
from sklearn import preprocessing
from sklearn.model_selection import train_test_split
iris= pd.read_csv('/content/iris.csv') # Import the iris.csv dataset
iris.head() #Display the iris dataset
iris.shape #Display the dimensions of the iris dataset
iris['variety'].value_counts()#Dislay the no of instances belonging to every value of the dependent variable
iris.columns #Display the column_headers of the iris dataset
iris.values #Display the values of the dataset
X=iris.iloc[:,:4] #Define the independent variable vector X
X.head()#Display X
y=iris.iloc[:,-1] #Define the dependent variable y
y.head()#Display y
X=preprocessing.StandardScaler().fit_transform(X)#Preprocess the data to achieve a mean of 0 and standard deviation of 1
X[0:4] #Display the preprocessed data
X_train, X_test, Y_train, Y_test = train_test_split(X,y,test_size=0.3) #Create the training set and the testing set
Y_test.shape #Display the dimensions of Y_test
knnmodel=KNeighborsClassifier(n_neighbors=3) #Build the KNN model for k=3
knnmodel.fit(X_train,Y_train) #Train the KNN Model
Y_pred = knnmodel.predict(X_test) #Use the KNN model for predicting the class of the test set
Y_pred #Display the result of prediction

#Calculate the accuracy of the model
from sklearn.metrics import accuracy_score
accuracy_score(Y_test,Y_pred)

#Constructing the confusion matrix
from sklearn.metrics import confusion_matrix
cm=confusion_matrix(Y_test.values,Y_pred)
cm

#Visualization of the output

cm1=pd.DataFrame(data=cm,index=['Setosa','Versicolor','Virginica'],columns=['Setosa','Versicolor','Virginica'])
cm1
pred_output=pd.DataFrame(data=[Y_test.values,Y_pred],index=['Y_test','Y_pred'])
pred_output.transpose()

# Import necessary libraries
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
from sklearn.neighbors import KNeighborsClassifier
from sklearn.preprocessing import StandardScaler
from sklearn.model_selection import train_test_split
from sklearn.metrics import accuracy_score, confusion_matrix, ConfusionMatrixDisplay

# Load the dataset
iris = pd.read_csv(r"/content/iris.csv")

# Display basic information
print("Dataset Head:\n", iris.head())
print("\nShape of dataset:", iris.shape)
print("\nClass distribution:\n", iris['variety'].value_counts())

# Split data into features and target
X = iris.iloc[:, :-1]   # Independent variables
y = iris.iloc[:, -1]    # Target variable

# Standardize the features
scaler = StandardScaler()
X_scaled = scaler.fit_transform(X)

# Split into train and test sets
X_train, X_test, y_train, y_test = train_test_split(X_scaled, y, test_size=0.3, random_state=42, stratify=y)

# Build and train the KNN model
knn_model = KNeighborsClassifier(n_neighbors=3)
knn_model.fit(X_train, y_train)

# Make predictions
y_pred = knn_model.predict(X_test)

# Calculate model accuracy
accuracy = accuracy_score(y_test, y_pred)
print("\nModel Accuracy: {:.2f}%".format(accuracy * 100))

# Construct the confusion matrix
cm = confusion_matrix(y_test, y_pred)
cm_df = pd.DataFrame(cm, index=iris['variety'].unique(), columns=iris['variety'].unique())
print("\nConfusion Matrix:\n", cm_df)

# Visualize confusion matrix
disp = ConfusionMatrixDisplay(confusion_matrix=cm, display_labels=iris['variety'].unique())
disp.plot(cmap='Blues')
plt.title("Confusion Matrix - KNN Classifier")
plt.show()

# Combine predictions and actual values for comparison
pred_output = pd.DataFrame({'Actual': y_test.values, 'Predicted': y_pred})
print("\nPrediction Results:\n", pred_output.head(10))

