# -*- coding: utf-8 -*-
"""P8-1 Gaussian Naive Bayes .ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1hPQd9ZfvblikDc3KJosyOf3atsItL260
"""

import numpy as np
import pandas as pd

#Import dataset
from sklearn import datasets

#Load dataset
wine = datasets.load_wine()
print(wine)

#print the names of the 13 features

print ("Features: ", wine.feature_names)

#print the label type of wine

print ("Labels: ", wine.target_names)

X=pd.DataFrame(wine['data'])
print(X.head())

#Checking the dimensions of the dataset
print(wine.data.shape)

#print the wine labels (0:Class_0, 1:class_2, 2:class_2)
y=print (wine.target)

from sklearn.model_selection import train_test_split
X_train, X_test, y_train, y_test = train_test_split(wine.data, wine.target, test_size=0.30,random_state=109)

#Import Gaussian Naive Bayes model
from sklearn.naive_bayes import GaussianNB

#Create a Gaussian Classifier
gnb = GaussianNB()

#Train the model using the training sets
gnb.fit(X_train, y_train)

#Predict the response for test dataset
y_pred = gnb.predict(X_test)
print(y_pred)

#Import scikit-learn metrics module for accuracy calculation
from sklearn import metrics

# Model Accuracy
print("Accuracy:",metrics.accuracy_score(y_test, y_pred))

#confusion matrix
from sklearn.metrics import  confusion_matrix
cm=np.array(confusion_matrix(y_test,y_pred))
cm

# Simple Gaussian Naive Bayes Example using Wine Dataset


#my code+++++++++++++

from sklearn.datasets import load_wine
from sklearn.model_selection import train_test_split
from sklearn.naive_bayes import GaussianNB
from sklearn.metrics import accuracy_score, confusion_matrix

# Load dataset
wine = load_wine()

# Features and labels
X = wine.data
y = wine.target

# Split the data into training and testing sets
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.3, random_state=42)

# Create and train the model
model = GaussianNB()
model.fit(X_train, y_train)

# Predict on test data
y_pred = model.predict(X_test)

# Print results
print("Feature names:", wine.feature_names)
print("Target names:", wine.target_names)
print("\nPredicted labels:", y_pred)
print("Accuracy:", accuracy_score(y_test, y_pred))
print("Confusion Matrix:\n", confusion_matrix(y_test, y_pred))

