# -*- coding: utf-8 -*-
"""P-1_test and train.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/14lT2R6bt-YH_7p_1kdPFnVQ3YIIiaBLJ
"""

#Design a simple machine learning model to train the training instances and test the same
import pandas as pd
import matplotlib.pyplot as plt
df = pd.read_csv("/content/Cars.csv") #Read data
df.head()

plt.scatter(df['Milage'],df['Sell Price']) #Plot to compare Milage(Independant variable) with Sell Price(Dependant variable)
plt.show()
plt.scatter(df['Age'],df['Sell Price'])#Plot to compare Age(Independant variable) with Sell Price(Dependant variable)
plt.show()
X = df[['Milage','Age']] #Determine X
Y = df['Sell Price']    # Determine Y
X #Display X
Y #Display Y
from sklearn.model_selection import train_test_split
X_train, X_test, Y_train, Y_test = train_test_split(X,Y,test_size=0.2)#Create a training set and testing set
len(X_train)
len(X_test)
from sklearn.linear_model import LinearRegression
clf = LinearRegression()
clf.fit(X_train,Y_train) # Train the model
clf.predict(X_test) # Use the rained model to predict the testing set
clf.score(X_test,Y_test) #Calculate the accuracy

# my coode

# Importing necessary libraries
import pandas as pd
import matplotlib.pyplot as plt
from sklearn.model_selection import train_test_split
from sklearn.linear_model import LinearRegression
from sklearn.metrics import r2_score, mean_absolute_error, mean_squared_error

# Load dataset
df = pd.read_csv(r"/content/Cars.csv")  # Use raw string for Windows path
print("✅ Data Loaded Successfully!")
print(df.head())

# Data visualization
plt.figure(figsize=(10,4))
plt.subplot(1,2,1)
plt.scatter(df['Milage'], df['Sell Price'], color='blue')
plt.title('Milage vs Sell Price')
plt.xlabel('Milage')
plt.ylabel('Sell Price')

plt.subplot(1,2,2)
plt.scatter(df['Age'], df['Sell Price'], color='green')
plt.title('Age vs Sell Price')
plt.xlabel('Age')
plt.ylabel('Sell Price')

plt.tight_layout()
plt.show()

# Features (X) and Target (Y)
X = df[['Milage', 'Age']]
Y = df['Sell Price']

# Splitting data into training and testing sets (80% train, 20% test)
X_train, X_test, Y_train, Y_test = train_test_split(X, Y, test_size=0.2, random_state=42)

# Create and train the Linear Regression model
model = LinearRegression()
model.fit(X_train, Y_train)

# Predict the test set results
Y_pred = model.predict(X_test)

# Evaluate the model
r2 = r2_score(Y_test, Y_pred)
mae = mean_absolute_error(Y_test, Y_pred)
mse = mean_squared_error(Y_test, Y_pred)

# Display metrics
print("\n📊 Model Evaluation Metrics:")
print(f"R² Score (Accuracy): {r2:.4f}")
print(f"Mean Absolute Error: {mae:.2f}")
print(f"Mean Squared Error: {mse:.2f}")

# Compare actual vs predicted values visually
plt.figure(figsize=(6,4))
plt.scatter(Y_test, Y_pred, color='purple')
plt.xlabel('Actual Sell Price')
plt.ylabel('Predicted Sell Price')
plt.title('Actual vs Predicted Sell Price')
plt.grid(True)
plt.show()

