#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim: nu:ai:ts=4:sw=4

#
#  Copyright (C) 2024 Joseph Areeda <joseph.areeda@ligo.org>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
""""""

__author__ = 'joseph areeda'
__email__ = 'joseph.areeda@ligo.org'

import logging
from pathlib import Path

from omicron_gap.pyomicron_log import CondorLog


def test_condor_log():
    logger = logging.getLogger('CondorLog')
    logger.setLevel(logging.DEBUG)

    wd = Path.cwd()
    test_log_files = ['omicron.log']
    for test_log_file in test_log_files:
        omilog_path = wd / '..' / 'testData' / test_log_file
        if omilog_path.exists():
            omilog = CondorLog(omilog_path, logger=logger)
            assert omilog is not None
    pass
