# Configuration file for the Sphinx documentation builder.
#
# For the full list of built-in configuration values, see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Project information -----------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#project-information
from pytroll_watchers.version import version

project = "pytroll-watchers"
copyright = "2024, Martin Raspaud"
author = "Martin Raspaud"
release = version

# -- General configuration ---------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#general-configuration

extensions = ["sphinx.ext.napoleon", "sphinx.ext.autodoc", "sphinx.ext.intersphinx"]
autodoc_mock_imports = ["watchdog", "minio", "posttroll", "pytest", "trollsift", "universal_path",
                        "freezegun", "responses", "oauthlib", "requests_oauthlib", "defusedxml", "redis",
                        "s3fs"]

templates_path = ["_templates"]
exclude_patterns = []



# -- Options for HTML output -------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-html-output

html_theme = "alabaster"
html_static_path = ["_static"]

# intersphinx
intersphinx_mapping = {
    "posttroll": ("https://posttroll.readthedocs.io/en/latest/", None),
    "redis": ("https://redis.readthedocs.io/en/latest/", None),
}
