# Finance Banking Agent Template

A lightweight banking conversational agent template for the fictional **Fenlo Bank** that handles account management, card services, and money transfers.

## 🚀 What's Included

This template provides a banking assistant with:
- **Account Management**: Balance checking and statement downloads
- **Card Services**: Card activation, blocking, replacement, and listing  
- **Money Transfers**: Account-to-account transfers and third-party payments
- **Contact Management**: Add, list, and remove trusted contacts
- **Bill Management**: Bill payment reminders and scheduling
- **Banking Knowledge**: FAQ system with Fenlo Bank documentation

## 📁 Directory Structure

```
├── actions/         # Custom Python logic for banking operations
├── data/            # Banking conversation flows and training data
├── domain/          # Banking agent configuration
├── db/              # Mock JSON database for testing
├── docs/            # Fenlo Bank knowledge base and FAQ documents
├── prompts/         # LLM prompts for enhanced banking responses
└── config.yml       # Training pipeline configuration
```

