# -*- coding: utf-8 -*-
# Generated by Django 1.9.13 on 2017-04-05 11:47
from __future__ import unicode_literals

from django.db import migrations, models

import enterprise.models
import enterprise.validators


class Migration(migrations.Migration):

    dependencies = [
        ('enterprise', '0015_auto_20170130_0003'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='enterprisecustomeruser',
            options={'verbose_name': 'Enterprise Customer Learner', 'verbose_name_plural': 'Enterprise Customer Learners'},
        ),
        migrations.AlterField(
            model_name='enrollmentnotificationemailtemplate',
            name='html_template',
            field=models.TextField(blank=True, help_text='Fill in a standard Django template that, when rendered, produces the email you want sent to newly-enrolled Enterprise Customer learners. The following variables may be available:\n<ul><li>user_name: A human-readable name for the person being emailed. Be sure to handle the case where this is not defined, as it may be missing in some cases. It may also be a username, if the learner hasn\'t configured their "real" name in the system.</li>    <li>organization_name: The name of the organization sponsoring the enrollment.</li>    <li>enrolled_in: Details of the course or program that was enrolled in. It may contain:    <ul><li>name: The name of the enrollable item (e.g., "Demo Course").</li>        <li>url: A link to the homepage of the enrolled-in item.</li>        <li>branding: A custom branding name for the enrolled-in item. For example, the branding of a MicroMasters program would be "MicroMasters".</li>     <li>start: The date the enrolled-in item becomes available. Render this to text using the Django `date` template filter (see <a href="https://docs.djangoproject.com/en/1.8/ref/templates/builtins/#date">the Django documentation</a>).</li><li>type: Whether the enrolled-in item is a course, a program, or something else.</li></ul></ul>'),
        ),
        migrations.AlterField(
            model_name='enrollmentnotificationemailtemplate',
            name='plaintext_template',
            field=models.TextField(blank=True, help_text='Fill in a standard Django template that, when rendered, produces the email you want sent to newly-enrolled Enterprise Customer learners. The following variables may be available:\n<ul><li>user_name: A human-readable name for the person being emailed. Be sure to handle the case where this is not defined, as it may be missing in some cases. It may also be a username, if the learner hasn\'t configured their "real" name in the system.</li>    <li>organization_name: The name of the organization sponsoring the enrollment.</li>    <li>enrolled_in: Details of the course or program that was enrolled in. It may contain:    <ul><li>name: The name of the enrollable item (e.g., "Demo Course").</li>        <li>url: A link to the homepage of the enrolled-in item.</li>        <li>branding: A custom branding name for the enrolled-in item. For example, the branding of a MicroMasters program would be "MicroMasters".</li>     <li>start: The date the enrolled-in item becomes available. Render this to text using the Django `date` template filter (see <a href="https://docs.djangoproject.com/en/1.8/ref/templates/builtins/#date">the Django documentation</a>).</li><li>type: Whether the enrolled-in item is a course, a program, or something else.</li></ul></ul>'),
        ),
        migrations.AlterField(
            model_name='enrollmentnotificationemailtemplate',
            name='subject_line',
            field=models.CharField(blank=True, help_text='Enter a string that can be used to generate a dynamic subject line for notification emails. The placeholder {course_name} will be replaced with the name of the course or program that was enrolled in.', max_length=100),
        ),
        migrations.AlterField(
            model_name='enterprisecourseenrollment',
            name='course_id',
            field=models.CharField(help_text='The ID of the course in which the learner was enrolled.', max_length=255),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_data_sharing_consent',
            field=models.BooleanField(default=False, help_text='Specifies whether data sharing consent is enabled or disabled for learners signing in through this enterprise customer. If disabled, consent will not be requested, and eligible data will not be shared.'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enforce_data_sharing_consent',
            field=models.CharField(choices=[('optional', 'Optional'), ('at_login', 'At Login'), ('at_enrollment', 'At Enrollment')], default='optional', help_text='Specifies whether data sharing consent is optional, is required at login, or is required at enrollment.', max_length=25),
        ),
        migrations.AlterField(
            model_name='enterprisecustomerbrandingconfiguration',
            name='logo',
            field=models.ImageField(blank=True, help_text='Logo images must be in .png format.', max_length=255, null=True, upload_to=enterprise.models.logo_path, validators=[enterprise.validators.validate_image_extension, enterprise.validators.validate_image_size]),
        ),
        migrations.AlterField(
            model_name='historicalenrollmentnotificationemailtemplate',
            name='html_template',
            field=models.TextField(blank=True, help_text='Fill in a standard Django template that, when rendered, produces the email you want sent to newly-enrolled Enterprise Customer learners. The following variables may be available:\n<ul><li>user_name: A human-readable name for the person being emailed. Be sure to handle the case where this is not defined, as it may be missing in some cases. It may also be a username, if the learner hasn\'t configured their "real" name in the system.</li>    <li>organization_name: The name of the organization sponsoring the enrollment.</li>    <li>enrolled_in: Details of the course or program that was enrolled in. It may contain:    <ul><li>name: The name of the enrollable item (e.g., "Demo Course").</li>        <li>url: A link to the homepage of the enrolled-in item.</li>        <li>branding: A custom branding name for the enrolled-in item. For example, the branding of a MicroMasters program would be "MicroMasters".</li>     <li>start: The date the enrolled-in item becomes available. Render this to text using the Django `date` template filter (see <a href="https://docs.djangoproject.com/en/1.8/ref/templates/builtins/#date">the Django documentation</a>).</li><li>type: Whether the enrolled-in item is a course, a program, or something else.</li></ul></ul>'),
        ),
        migrations.AlterField(
            model_name='historicalenrollmentnotificationemailtemplate',
            name='plaintext_template',
            field=models.TextField(blank=True, help_text='Fill in a standard Django template that, when rendered, produces the email you want sent to newly-enrolled Enterprise Customer learners. The following variables may be available:\n<ul><li>user_name: A human-readable name for the person being emailed. Be sure to handle the case where this is not defined, as it may be missing in some cases. It may also be a username, if the learner hasn\'t configured their "real" name in the system.</li>    <li>organization_name: The name of the organization sponsoring the enrollment.</li>    <li>enrolled_in: Details of the course or program that was enrolled in. It may contain:    <ul><li>name: The name of the enrollable item (e.g., "Demo Course").</li>        <li>url: A link to the homepage of the enrolled-in item.</li>        <li>branding: A custom branding name for the enrolled-in item. For example, the branding of a MicroMasters program would be "MicroMasters".</li>     <li>start: The date the enrolled-in item becomes available. Render this to text using the Django `date` template filter (see <a href="https://docs.djangoproject.com/en/1.8/ref/templates/builtins/#date">the Django documentation</a>).</li><li>type: Whether the enrolled-in item is a course, a program, or something else.</li></ul></ul>'),
        ),
        migrations.AlterField(
            model_name='historicalenrollmentnotificationemailtemplate',
            name='subject_line',
            field=models.CharField(blank=True, help_text='Enter a string that can be used to generate a dynamic subject line for notification emails. The placeholder {course_name} will be replaced with the name of the course or program that was enrolled in.', max_length=100),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecourseenrollment',
            name='course_id',
            field=models.CharField(help_text='The ID of the course in which the learner was enrolled.', max_length=255),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_data_sharing_consent',
            field=models.BooleanField(default=False, help_text='Specifies whether data sharing consent is enabled or disabled for learners signing in through this enterprise customer. If disabled, consent will not be requested, and eligible data will not be shared.'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enforce_data_sharing_consent',
            field=models.CharField(choices=[('optional', 'Optional'), ('at_login', 'At Login'), ('at_enrollment', 'At Enrollment')], default='optional', help_text='Specifies whether data sharing consent is optional, is required at login, or is required at enrollment.', max_length=25),
        ),
        migrations.AlterField(
            model_name='historicaluserdatasharingconsentaudit',
            name='state',
            field=models.CharField(choices=[('not_set', 'Not set'), ('enabled', 'Enabled'), ('disabled', 'Disabled')], default='not_set', help_text='Stores whether the learner linked to this model has consented to have their information shared with the linked EnterpriseCustomer.', max_length=8),
        ),
        migrations.AlterField(
            model_name='userdatasharingconsentaudit',
            name='state',
            field=models.CharField(choices=[('not_set', 'Not set'), ('enabled', 'Enabled'), ('disabled', 'Disabled')], default='not_set', help_text='Stores whether the learner linked to this model has consented to have their information shared with the linked EnterpriseCustomer.', max_length=8),
        ),
    ]
