import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataHelmTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Kubernetes api versions used for Capabilities.APIVersions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#api_versions DataHelmTemplate#api_versions}
     *
     * @stability stable
     */
    readonly apiVersions?: string[];
    /**
     * If set, installation process purges chart on fail. The wait flag will be set automatically if atomic is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#atomic DataHelmTemplate#atomic}
     *
     * @stability stable
     */
    readonly atomic?: boolean | cdktf.IResolvable;
    /**
     * Chart name to be installed. A path may be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#chart DataHelmTemplate#chart}
     *
     * @stability stable
     */
    readonly chart: string;
    /**
     * Create the namespace if it does not exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#create_namespace DataHelmTemplate#create_namespace}
     *
     * @stability stable
     */
    readonly createNamespace?: boolean | cdktf.IResolvable;
    /**
     * Run helm dependency update before installing the chart.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#dependency_update DataHelmTemplate#dependency_update}
     *
     * @stability stable
     */
    readonly dependencyUpdate?: boolean | cdktf.IResolvable;
    /**
     * Add a custom description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#description DataHelmTemplate#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Use chart development versions, too. Equivalent to version '>0.0.0-0'. If `version` is set, this is ignored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#devel DataHelmTemplate#devel}
     *
     * @stability stable
     */
    readonly devel?: boolean | cdktf.IResolvable;
    /**
     * If set, the installation process will not validate rendered templates against the Kubernetes OpenAPI Schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#disable_openapi_validation DataHelmTemplate#disable_openapi_validation}
     *
     * @stability stable
     */
    readonly disableOpenapiValidation?: boolean | cdktf.IResolvable;
    /**
     * Prevent hooks from running.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#disable_webhooks DataHelmTemplate#disable_webhooks}
     *
     * @stability stable
     */
    readonly disableWebhooks?: boolean | cdktf.IResolvable;
    /**
     * Include CRDs in the templated output.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#include_crds DataHelmTemplate#include_crds}
     *
     * @stability stable
     */
    readonly includeCrds?: boolean | cdktf.IResolvable;
    /**
     * Set .Release.IsUpgrade instead of .Release.IsInstall.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#is_upgrade DataHelmTemplate#is_upgrade}
     *
     * @stability stable
     */
    readonly isUpgrade?: boolean | cdktf.IResolvable;
    /**
     * Location of public keys used for verification. Used only if `verify` is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#keyring DataHelmTemplate#keyring}
     *
     * @stability stable
     */
    readonly keyring?: string;
    /**
     * Concatenated rendered chart templates. This corresponds to the output of the `helm template` command.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#manifest DataHelmTemplate#manifest}
     *
     * @stability stable
     */
    readonly manifest?: string;
    /**
     * Map of rendered chart templates indexed by the template name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#manifests DataHelmTemplate#manifests}
     *
     * @stability stable
     */
    readonly manifests?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Release name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#name DataHelmTemplate#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Namespace to install the release into.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#namespace DataHelmTemplate#namespace}
     *
     * @stability stable
     */
    readonly namespace?: string;
    /**
     * Rendered notes if the chart contains a `NOTES.txt`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#notes DataHelmTemplate#notes}
     *
     * @stability stable
     */
    readonly notes?: string;
    /**
     * If set, render subchart notes along with the parent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#render_subchart_notes DataHelmTemplate#render_subchart_notes}
     *
     * @stability stable
     */
    readonly renderSubchartNotes?: boolean | cdktf.IResolvable;
    /**
     * Re-use the given name, even if that name is already used. This is unsafe in production.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#replace DataHelmTemplate#replace}
     *
     * @stability stable
     */
    readonly replace?: boolean | cdktf.IResolvable;
    /**
     * Repository where to locate the requested chart. If is a URL the chart is installed without installing the repository.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#repository DataHelmTemplate#repository}
     *
     * @stability stable
     */
    readonly repository?: string;
    /**
     * The Repositories CA File.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#repository_ca_file DataHelmTemplate#repository_ca_file}
     *
     * @stability stable
     */
    readonly repositoryCaFile?: string;
    /**
     * The repositories cert file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#repository_cert_file DataHelmTemplate#repository_cert_file}
     *
     * @stability stable
     */
    readonly repositoryCertFile?: string;
    /**
     * The repositories cert key file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#repository_key_file DataHelmTemplate#repository_key_file}
     *
     * @stability stable
     */
    readonly repositoryKeyFile?: string;
    /**
     * Password for HTTP basic authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#repository_password DataHelmTemplate#repository_password}
     *
     * @stability stable
     */
    readonly repositoryPassword?: string;
    /**
     * Username for HTTP basic authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#repository_username DataHelmTemplate#repository_username}
     *
     * @stability stable
     */
    readonly repositoryUsername?: string;
    /**
     * When upgrading, reset the values to the ones built into the chart.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#reset_values DataHelmTemplate#reset_values}
     *
     * @stability stable
     */
    readonly resetValues?: boolean | cdktf.IResolvable;
    /**
     * When upgrading, reuse the last release's values and merge in any overrides. If 'reset_values' is specified, this is ignored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#reuse_values DataHelmTemplate#reuse_values}
     *
     * @stability stable
     */
    readonly reuseValues?: boolean | cdktf.IResolvable;
    /**
     * Only show manifests rendered from the given templates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#show_only DataHelmTemplate#show_only}
     *
     * @stability stable
     */
    readonly showOnly?: string[];
    /**
     * If set, no CRDs will be installed. By default, CRDs are installed if not already present.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#skip_crds DataHelmTemplate#skip_crds}
     *
     * @stability stable
     */
    readonly skipCrds?: boolean | cdktf.IResolvable;
    /**
     * If set, tests will not be rendered. By default, tests are rendered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#skip_tests DataHelmTemplate#skip_tests}
     *
     * @stability stable
     */
    readonly skipTests?: boolean | cdktf.IResolvable;
    /**
     * Time in seconds to wait for any individual kubernetes operation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#timeout DataHelmTemplate#timeout}
     *
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * Validate your manifests against the Kubernetes cluster you are currently pointing at.
     *
     * This is the same validation performed on an install
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#validate DataHelmTemplate#validate}
     *
     * @stability stable
     */
    readonly validate?: boolean | cdktf.IResolvable;
    /**
     * List of values in raw yaml format to pass to helm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#values DataHelmTemplate#values}
     *
     * @stability stable
     */
    readonly values?: string[];
    /**
     * Verify the package before installing it.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#verify DataHelmTemplate#verify}
     *
     * @stability stable
     */
    readonly verify?: boolean | cdktf.IResolvable;
    /**
     * Specify the exact chart version to install. If this is not specified, the latest version is installed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#version DataHelmTemplate#version}
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * Will wait until all resources are in a ready state before marking the release as successful.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#wait DataHelmTemplate#wait}
     *
     * @stability stable
     */
    readonly wait?: boolean | cdktf.IResolvable;
    /**
     * postrender block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#postrender DataHelmTemplate#postrender}
     *
     * @stability stable
     */
    readonly postrender?: DataHelmTemplatePostrender;
    /**
     * set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#set DataHelmTemplate#set}
     *
     * @stability stable
     */
    readonly set?: DataHelmTemplateSet[];
    /**
     * set_sensitive block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#set_sensitive DataHelmTemplate#set_sensitive}
     *
     * @stability stable
     */
    readonly setSensitive?: DataHelmTemplateSetSensitive[];
    /**
     * set_string block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#set_string DataHelmTemplate#set_string}
     *
     * @stability stable
     */
    readonly setString?: DataHelmTemplateSetString[];
}
/**
 * @stability stable
 */
export interface DataHelmTemplatePostrender {
    /**
     * The command binary path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#binary_path DataHelmTemplate#binary_path}
     *
     * @stability stable
     */
    readonly binaryPath: string;
}
export declare function dataHelmTemplatePostrenderToTerraform(struct?: DataHelmTemplatePostrenderOutputReference | DataHelmTemplatePostrender): any;
/**
 * @stability stable
 */
export declare class DataHelmTemplatePostrenderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataHelmTemplatePostrender | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataHelmTemplatePostrender | undefined);
    private _binaryPath?;
    /**
     * @stability stable
     */
    get binaryPath(): string;
    /**
     * @stability stable
     */
    set binaryPath(value: string);
    /**
     * @stability stable
     */
    get binaryPathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataHelmTemplateSet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#name DataHelmTemplate#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#type DataHelmTemplate#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#value DataHelmTemplate#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function dataHelmTemplateSetToTerraform(struct?: DataHelmTemplateSet): any;
/**
 * @stability stable
 */
export interface DataHelmTemplateSetSensitive {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#name DataHelmTemplate#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#type DataHelmTemplate#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#value DataHelmTemplate#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function dataHelmTemplateSetSensitiveToTerraform(struct?: DataHelmTemplateSetSensitive): any;
/**
 * @stability stable
 */
export interface DataHelmTemplateSetString {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#name DataHelmTemplate#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/helm/d/template.html#value DataHelmTemplate#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function dataHelmTemplateSetStringToTerraform(struct?: DataHelmTemplateSetString): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/helm/d/template.html helm_template}.
 *
 * @stability stable
 */
export declare class DataHelmTemplate extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/helm/d/template.html helm_template} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataHelmTemplateConfig);
    private _apiVersions?;
    /**
     * @stability stable
     */
    get apiVersions(): string[];
    /**
     * @stability stable
     */
    set apiVersions(value: string[]);
    /**
     * @stability stable
     */
    resetApiVersions(): void;
    /**
     * @stability stable
     */
    get apiVersionsInput(): string[] | undefined;
    private _atomic?;
    /**
     * @stability stable
     */
    get atomic(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set atomic(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAtomic(): void;
    /**
     * @stability stable
     */
    get atomicInput(): boolean | cdktf.IResolvable | undefined;
    private _chart?;
    /**
     * @stability stable
     */
    get chart(): string;
    /**
     * @stability stable
     */
    set chart(value: string);
    /**
     * @stability stable
     */
    get chartInput(): string | undefined;
    private _createNamespace?;
    /**
     * @stability stable
     */
    get createNamespace(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set createNamespace(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCreateNamespace(): void;
    /**
     * @stability stable
     */
    get createNamespaceInput(): boolean | cdktf.IResolvable | undefined;
    private _dependencyUpdate?;
    /**
     * @stability stable
     */
    get dependencyUpdate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dependencyUpdate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDependencyUpdate(): void;
    /**
     * @stability stable
     */
    get dependencyUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _devel?;
    /**
     * @stability stable
     */
    get devel(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set devel(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDevel(): void;
    /**
     * @stability stable
     */
    get develInput(): boolean | cdktf.IResolvable | undefined;
    private _disableOpenapiValidation?;
    /**
     * @stability stable
     */
    get disableOpenapiValidation(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableOpenapiValidation(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableOpenapiValidation(): void;
    /**
     * @stability stable
     */
    get disableOpenapiValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _disableWebhooks?;
    /**
     * @stability stable
     */
    get disableWebhooks(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableWebhooks(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableWebhooks(): void;
    /**
     * @stability stable
     */
    get disableWebhooksInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _includeCrds?;
    /**
     * @stability stable
     */
    get includeCrds(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set includeCrds(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIncludeCrds(): void;
    /**
     * @stability stable
     */
    get includeCrdsInput(): boolean | cdktf.IResolvable | undefined;
    private _isUpgrade?;
    /**
     * @stability stable
     */
    get isUpgrade(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isUpgrade(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsUpgrade(): void;
    /**
     * @stability stable
     */
    get isUpgradeInput(): boolean | cdktf.IResolvable | undefined;
    private _keyring?;
    /**
     * @stability stable
     */
    get keyring(): string;
    /**
     * @stability stable
     */
    set keyring(value: string);
    /**
     * @stability stable
     */
    resetKeyring(): void;
    /**
     * @stability stable
     */
    get keyringInput(): string | undefined;
    private _manifest?;
    /**
     * @stability stable
     */
    get manifest(): string;
    /**
     * @stability stable
     */
    set manifest(value: string);
    /**
     * @stability stable
     */
    resetManifest(): void;
    /**
     * @stability stable
     */
    get manifestInput(): string | undefined;
    private _manifests?;
    /**
     * @stability stable
     */
    get manifests(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set manifests(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetManifests(): void;
    /**
     * @stability stable
     */
    get manifestsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespace?;
    /**
     * @stability stable
     */
    get namespace(): string;
    /**
     * @stability stable
     */
    set namespace(value: string);
    /**
     * @stability stable
     */
    resetNamespace(): void;
    /**
     * @stability stable
     */
    get namespaceInput(): string | undefined;
    private _notes?;
    /**
     * @stability stable
     */
    get notes(): string;
    /**
     * @stability stable
     */
    set notes(value: string);
    /**
     * @stability stable
     */
    resetNotes(): void;
    /**
     * @stability stable
     */
    get notesInput(): string | undefined;
    private _renderSubchartNotes?;
    /**
     * @stability stable
     */
    get renderSubchartNotes(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set renderSubchartNotes(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRenderSubchartNotes(): void;
    /**
     * @stability stable
     */
    get renderSubchartNotesInput(): boolean | cdktf.IResolvable | undefined;
    private _replace?;
    /**
     * @stability stable
     */
    get replace(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set replace(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReplace(): void;
    /**
     * @stability stable
     */
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
    private _repository?;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    resetRepository(): void;
    /**
     * @stability stable
     */
    get repositoryInput(): string | undefined;
    private _repositoryCaFile?;
    /**
     * @stability stable
     */
    get repositoryCaFile(): string;
    /**
     * @stability stable
     */
    set repositoryCaFile(value: string);
    /**
     * @stability stable
     */
    resetRepositoryCaFile(): void;
    /**
     * @stability stable
     */
    get repositoryCaFileInput(): string | undefined;
    private _repositoryCertFile?;
    /**
     * @stability stable
     */
    get repositoryCertFile(): string;
    /**
     * @stability stable
     */
    set repositoryCertFile(value: string);
    /**
     * @stability stable
     */
    resetRepositoryCertFile(): void;
    /**
     * @stability stable
     */
    get repositoryCertFileInput(): string | undefined;
    private _repositoryKeyFile?;
    /**
     * @stability stable
     */
    get repositoryKeyFile(): string;
    /**
     * @stability stable
     */
    set repositoryKeyFile(value: string);
    /**
     * @stability stable
     */
    resetRepositoryKeyFile(): void;
    /**
     * @stability stable
     */
    get repositoryKeyFileInput(): string | undefined;
    private _repositoryPassword?;
    /**
     * @stability stable
     */
    get repositoryPassword(): string;
    /**
     * @stability stable
     */
    set repositoryPassword(value: string);
    /**
     * @stability stable
     */
    resetRepositoryPassword(): void;
    /**
     * @stability stable
     */
    get repositoryPasswordInput(): string | undefined;
    private _repositoryUsername?;
    /**
     * @stability stable
     */
    get repositoryUsername(): string;
    /**
     * @stability stable
     */
    set repositoryUsername(value: string);
    /**
     * @stability stable
     */
    resetRepositoryUsername(): void;
    /**
     * @stability stable
     */
    get repositoryUsernameInput(): string | undefined;
    private _resetValues?;
    /**
     * @stability stable
     */
    get resetValues(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set resetValues(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetResetValues(): void;
    /**
     * @stability stable
     */
    get resetValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _reuseValues?;
    /**
     * @stability stable
     */
    get reuseValues(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set reuseValues(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReuseValues(): void;
    /**
     * @stability stable
     */
    get reuseValuesInput(): boolean | cdktf.IResolvable | undefined;
    private _showOnly?;
    /**
     * @stability stable
     */
    get showOnly(): string[];
    /**
     * @stability stable
     */
    set showOnly(value: string[]);
    /**
     * @stability stable
     */
    resetShowOnly(): void;
    /**
     * @stability stable
     */
    get showOnlyInput(): string[] | undefined;
    private _skipCrds?;
    /**
     * @stability stable
     */
    get skipCrds(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipCrds(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipCrds(): void;
    /**
     * @stability stable
     */
    get skipCrdsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipTests?;
    /**
     * @stability stable
     */
    get skipTests(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipTests(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipTests(): void;
    /**
     * @stability stable
     */
    get skipTestsInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): number;
    /**
     * @stability stable
     */
    set timeout(value: number);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): number | undefined;
    private _validate?;
    /**
     * @stability stable
     */
    get validate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set validate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetValidate(): void;
    /**
     * @stability stable
     */
    get validateInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    resetTfValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
    private _verify?;
    /**
     * @stability stable
     */
    get verify(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set verify(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVerify(): void;
    /**
     * @stability stable
     */
    get verifyInput(): boolean | cdktf.IResolvable | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _wait?;
    /**
     * @stability stable
     */
    get wait(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set wait(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWait(): void;
    /**
     * @stability stable
     */
    get waitInput(): boolean | cdktf.IResolvable | undefined;
    private _postrender;
    /**
     * @stability stable
     */
    get postrender(): DataHelmTemplatePostrenderOutputReference;
    /**
     * @stability stable
     */
    putPostrender(value: DataHelmTemplatePostrender): void;
    /**
     * @stability stable
     */
    resetPostrender(): void;
    /**
     * @stability stable
     */
    get postrenderInput(): DataHelmTemplatePostrender | undefined;
    private _set?;
    /**
     * @stability stable
     */
    get set(): DataHelmTemplateSet[];
    /**
     * @stability stable
     */
    set set(value: DataHelmTemplateSet[]);
    /**
     * @stability stable
     */
    resetSet(): void;
    /**
     * @stability stable
     */
    get setInput(): DataHelmTemplateSet[] | undefined;
    private _setSensitive?;
    /**
     * @stability stable
     */
    get setSensitive(): DataHelmTemplateSetSensitive[];
    /**
     * @stability stable
     */
    set setSensitive(value: DataHelmTemplateSetSensitive[]);
    /**
     * @stability stable
     */
    resetSetSensitive(): void;
    /**
     * @stability stable
     */
    get setSensitiveInput(): DataHelmTemplateSetSensitive[] | undefined;
    private _setString?;
    /**
     * @stability stable
     */
    get setString(): DataHelmTemplateSetString[];
    /**
     * @stability stable
     */
    set setString(value: DataHelmTemplateSetString[]);
    /**
     * @stability stable
     */
    resetSetString(): void;
    /**
     * @stability stable
     */
    get setStringInput(): DataHelmTemplateSetString[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
