# Generated by Django 4.2.15 on 2024-09-04 23:15

from django.db import migrations, models
from django.utils.crypto import get_random_string

import openedx_learning.lib.fields


def generate_keys(apps, schema_editor):
    """
    Generates a random strings to initialize the key field where NULL.
    """
    length = 50
    Collection = apps.get_model("oel_collections", "Collection")
    for collection in Collection.objects.filter(key=None):
        # Keep generating keys until we get a unique one
        key = get_random_string(length)
        while Collection.objects.filter(key=key).exists():
            key = get_random_string(length)

        collection.key = key
        collection.save()


class Migration(migrations.Migration):

    dependencies = [
        ('oel_collections', '0003_collection_entities'),
    ]

    operations = [
        # 1. Temporarily add this field with null=True, blank=True
        migrations.AddField(
            model_name='collection',
            name='key',
            field=openedx_learning.lib.fields.MultiCollationCharField(
                db_collations={'mysql': 'utf8mb4_bin', 'sqlite': 'BINARY'},
                db_column='_key', max_length=500, null=True, blank=True),
            preserve_default=False,
        ),
        # 2. Populate the null keys
        migrations.RunPython(generate_keys),
        # 3. Add null=False, blank=False to disallow NULL values
        migrations.AlterField(
            model_name='collection',
            name='key',
            field=openedx_learning.lib.fields.MultiCollationCharField(
                db_collations={'mysql': 'utf8mb4_bin', 'sqlite': 'BINARY'},
                db_column='_key', max_length=500, null=False, blank=False),
            preserve_default=False,
        ),
        # 4. Enforce unique constraint
        migrations.AddConstraint(
            model_name='collection',
            constraint=models.UniqueConstraint(fields=('learning_package', 'key'), name='oel_coll_uniq_lp_key'),
        ),
    ]
