# Generated by Django 3.2.23 on 2024-02-06 03:23

import uuid

import django.db.models.deletion
from django.db import migrations, models

import openedx_learning.lib.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('oel_contents', '0001_initial'),
        ('oel_publishing', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Component',
            fields=[
                ('publishable_entity', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='oel_publishing.publishableentity')),
                ('local_key', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_bin', 'sqlite': 'BINARY'}, max_length=500)),
            ],
            options={
                'verbose_name': 'Component',
                'verbose_name_plural': 'Components',
            },
        ),
        migrations.CreateModel(
            name='ComponentType',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('namespace', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_bin', 'sqlite': 'BINARY'}, max_length=100)),
                ('name', openedx_learning.lib.fields.MultiCollationCharField(blank=True, db_collations={'mysql': 'utf8mb4_bin', 'sqlite': 'BINARY'}, max_length=100)),
            ],
        ),
        migrations.CreateModel(
            name='ComponentVersion',
            fields=[
                ('publishable_entity_version', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='oel_publishing.publishableentityversion')),
                ('component', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='versions', to='oel_components.component')),
            ],
            options={
                'verbose_name': 'Component Version',
                'verbose_name_plural': 'Component Versions',
            },
        ),
        migrations.CreateModel(
            name='ComponentVersionContent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True, verbose_name='UUID')),
                ('key', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_bin', 'sqlite': 'BINARY'}, max_length=500)),
                ('learner_downloadable', models.BooleanField(default=False)),
                ('component_version', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oel_components.componentversion')),
                ('content', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to='oel_contents.content')),
            ],
        ),
        migrations.AddField(
            model_name='componentversion',
            name='contents',
            field=models.ManyToManyField(related_name='component_versions', through='oel_components.ComponentVersionContent', to='oel_contents.Content'),
        ),
        migrations.AddField(
            model_name='component',
            name='component_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='oel_components.componenttype'),
        ),
        migrations.AddField(
            model_name='component',
            name='learning_package',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oel_publishing.learningpackage'),
        ),
        migrations.AddIndex(
            model_name='componentversioncontent',
            index=models.Index(fields=['content', 'component_version'], name='oel_cvcontent_c_cv'),
        ),
        migrations.AddIndex(
            model_name='componentversioncontent',
            index=models.Index(fields=['component_version', 'content'], name='oel_cvcontent_cv_d'),
        ),
        migrations.AddConstraint(
            model_name='componentversioncontent',
            constraint=models.UniqueConstraint(fields=('component_version', 'key'), name='oel_cvcontent_uniq_cv_key'),
        ),
        migrations.AddIndex(
            model_name='component',
            index=models.Index(fields=['component_type', 'local_key'], name='oel_component_idx_ct_lk'),
        ),
        migrations.AddConstraint(
            model_name='component',
            constraint=models.UniqueConstraint(fields=('learning_package', 'component_type', 'local_key'), name='oel_component_uniq_lc_ct_lk'),
        ),
    ]
