# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, List, Union, Iterable, Optional
from typing_extensions import Required, Annotated, TypeAlias, TypedDict

from ..._utils import PropertyInfo

__all__ = [
    "DataStreamParams",
    "Config",
    "ConfigLlmData",
    "ConfigLlmDataPrompt",
    "ConfigTabularClassificationData",
    "ConfigTabularRegressionData",
    "ConfigTextClassificationData",
]


class DataStreamParams(TypedDict, total=False):
    config: Required[Config]
    """Configuration for the data stream.

    Depends on your **Openlayer project task type**.
    """

    rows: Required[Iterable[Dict[str, object]]]
    """A list of inference data points with inputs and outputs"""


class ConfigLlmDataPrompt(TypedDict, total=False):
    content: str
    """Content of the prompt."""

    role: str
    """Role of the prompt."""


class ConfigLlmData(TypedDict, total=False):
    output_column_name: Required[Annotated[str, PropertyInfo(alias="outputColumnName")]]
    """Name of the column with the model outputs."""

    context_column_name: Annotated[str, PropertyInfo(alias="contextColumnName")]
    """Name of the column with the context retrieved.

    Applies to RAG use cases. Providing the context enables RAG-specific metrics.
    """

    cost_column_name: Annotated[str, PropertyInfo(alias="costColumnName")]
    """Name of the column with the cost associated with each row."""

    ground_truth_column_name: Annotated[str, PropertyInfo(alias="groundTruthColumnName")]
    """Name of the column with the ground truths."""

    inference_id_column_name: Annotated[str, PropertyInfo(alias="inferenceIdColumnName")]
    """Name of the column with the inference ids.

    This is useful if you want to update rows at a later point in time. If not
    provided, a unique id is generated by Openlayer.
    """

    input_variable_names: Annotated[List[str], PropertyInfo(alias="inputVariableNames")]
    """Array of input variable names. Each input variable should be a dataset column."""

    latency_column_name: Annotated[str, PropertyInfo(alias="latencyColumnName")]
    """Name of the column with the latencies."""

    metadata: object
    """Object with metadata."""

    num_of_token_column_name: Annotated[Optional[str], PropertyInfo(alias="numOfTokenColumnName")]
    """Name of the column with the total number of tokens."""

    prompt: Iterable[ConfigLlmDataPrompt]
    """Prompt for the LLM."""

    question_column_name: Annotated[str, PropertyInfo(alias="questionColumnName")]
    """Name of the column with the questions.

    Applies to RAG use cases. Providing the question enables RAG-specific metrics.
    """

    timestamp_column_name: Annotated[str, PropertyInfo(alias="timestampColumnName")]
    """Name of the column with the timestamps.

    Timestamps must be in UNIX sec format. If not provided, the upload timestamp is
    used.
    """


class ConfigTabularClassificationData(TypedDict, total=False):
    class_names: Required[Annotated[List[str], PropertyInfo(alias="classNames")]]
    """List of class names indexed by label integer in the dataset.

    E.g. ["Retained", "Exited"] when 0, 1 are in your label column.
    """

    categorical_feature_names: Annotated[List[str], PropertyInfo(alias="categoricalFeatureNames")]
    """Array with the names of all categorical features in the dataset.

    E.g. ["Age", "Geography"].
    """

    feature_names: Annotated[List[str], PropertyInfo(alias="featureNames")]
    """Array with all input feature names."""

    inference_id_column_name: Annotated[str, PropertyInfo(alias="inferenceIdColumnName")]
    """Name of the column with the inference ids.

    This is useful if you want to update rows at a later point in time. If not
    provided, a unique id is generated by Openlayer.
    """

    label_column_name: Annotated[str, PropertyInfo(alias="labelColumnName")]
    """Name of the column with the labels.

    The data in this column must be **zero-indexed integers**, matching the list
    provided in `classNames`.
    """

    latency_column_name: Annotated[str, PropertyInfo(alias="latencyColumnName")]
    """Name of the column with the latencies."""

    metadata: object
    """Object with metadata."""

    predictions_column_name: Annotated[str, PropertyInfo(alias="predictionsColumnName")]
    """Name of the column with the model's predictions as **zero-indexed integers**."""

    prediction_scores_column_name: Annotated[str, PropertyInfo(alias="predictionScoresColumnName")]
    """
    Name of the column with the model's predictions as **lists of class
    probabilities**.
    """

    timestamp_column_name: Annotated[str, PropertyInfo(alias="timestampColumnName")]
    """Name of the column with the timestamps.

    Timestamps must be in UNIX sec format. If not provided, the upload timestamp is
    used.
    """


class ConfigTabularRegressionData(TypedDict, total=False):
    categorical_feature_names: Annotated[List[str], PropertyInfo(alias="categoricalFeatureNames")]
    """Array with the names of all categorical features in the dataset.

    E.g. ["Gender", "Geography"].
    """

    feature_names: Annotated[List[str], PropertyInfo(alias="featureNames")]
    """Array with all input feature names."""

    inference_id_column_name: Annotated[str, PropertyInfo(alias="inferenceIdColumnName")]
    """Name of the column with the inference ids.

    This is useful if you want to update rows at a later point in time. If not
    provided, a unique id is generated by Openlayer.
    """

    latency_column_name: Annotated[str, PropertyInfo(alias="latencyColumnName")]
    """Name of the column with the latencies."""

    metadata: object
    """Object with metadata."""

    predictions_column_name: Annotated[str, PropertyInfo(alias="predictionsColumnName")]
    """Name of the column with the model's predictions."""

    target_column_name: Annotated[str, PropertyInfo(alias="targetColumnName")]
    """Name of the column with the targets (ground truth values)."""

    timestamp_column_name: Annotated[str, PropertyInfo(alias="timestampColumnName")]
    """Name of the column with the timestamps.

    Timestamps must be in UNIX sec format. If not provided, the upload timestamp is
    used.
    """


class ConfigTextClassificationData(TypedDict, total=False):
    class_names: Required[Annotated[List[str], PropertyInfo(alias="classNames")]]
    """List of class names indexed by label integer in the dataset.

    E.g. ["Retained", "Exited"] when 0, 1 are in your label column.
    """

    inference_id_column_name: Annotated[str, PropertyInfo(alias="inferenceIdColumnName")]
    """Name of the column with the inference ids.

    This is useful if you want to update rows at a later point in time. If not
    provided, a unique id is generated by Openlayer.
    """

    label_column_name: Annotated[str, PropertyInfo(alias="labelColumnName")]
    """Name of the column with the labels.

    The data in this column must be **zero-indexed integers**, matching the list
    provided in `classNames`.
    """

    latency_column_name: Annotated[str, PropertyInfo(alias="latencyColumnName")]
    """Name of the column with the latencies."""

    metadata: object
    """Object with metadata."""

    predictions_column_name: Annotated[str, PropertyInfo(alias="predictionsColumnName")]
    """Name of the column with the model's predictions as **zero-indexed integers**."""

    prediction_scores_column_name: Annotated[str, PropertyInfo(alias="predictionScoresColumnName")]
    """
    Name of the column with the model's predictions as **lists of class
    probabilities**.
    """

    text_column_name: Annotated[str, PropertyInfo(alias="textColumnName")]
    """Name of the column with the text data."""

    timestamp_column_name: Annotated[str, PropertyInfo(alias="timestampColumnName")]
    """Name of the column with the timestamps.

    Timestamps must be in UNIX sec format. If not provided, the upload timestamp is
    used.
    """


Config: TypeAlias = Union[
    ConfigLlmData, ConfigTabularClassificationData, ConfigTabularRegressionData, ConfigTextClassificationData
]
