import unittest

from shap_enhanced.tools import comparison, evaluation, timer


class TestTools(unittest.TestCase):
    def test_timer_module_exists(self):
        # Basic test to ensure timer module can be imported
        self.assertTrue(hasattr(timer, "__name__"))

    def test_comparison_module_exists(self):
        # Basic test to ensure comparison module can be imported
        self.assertTrue(hasattr(comparison, "__name__"))

    def test_evaluation_module_exists(self):
        # Basic test to ensure evaluation module can be imported
        self.assertTrue(hasattr(evaluation, "__name__"))

    def test_timer_basic_functionality(self):
        # Test if timer has basic timing functionality
        if hasattr(timer, "Timer"):
            timer_obj = timer.Timer()
            self.assertIsNotNone(timer_obj)

    def test_comparison_basic_functionality(self):
        # Test if comparison module has basic functions
        self.assertIsNotNone(comparison)

    def test_evaluation_basic_functionality(self):
        # Test if evaluation module has basic functions
        self.assertIsNotNone(evaluation)


if __name__ == "__main__":
    unittest.main()
